/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.zipfileaccessor;

import com.ibm.archiveaccessor.filestore.FileBucketAccessor;
import com.ibm.archiveaccessor.filestore.Folder;
import com.ibm.archiveaccessor.filestore.PackagedFileBucketAccessor;
import com.ibm.archiveaccessor.filestore.ZipFile;
import com.ibm.archiveaccessor.zipfileaccessor.ZipFileAccessorException;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipException;

public class ZipFileAccessor
extends PackagedFileBucketAccessor {
    private static final String ZipExtention = ".zip";
    private boolean useCompressCopy = true;
    private ZipFile file;

    public ZipFileAccessor() {
        this.file = new ZipFile();
        this.file.setFileName(this.properArchiveName(this.getArchiveName()));
        super.setName(this.properArchiveName(this.getArchiveName()));
        this.setClosed(false);
    }

    public ZipFileAccessor(String aFileName) throws ZipFileAccessorException {
        this._open(this.properArchiveName(aFileName));
    }

    private void _open(String aFileName) throws ZipFileAccessorException {
        if (!super.checkName(aFileName)) {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
        }
        if (!this.checkName(aFileName)) {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("4"));
        }
        try {
            this.file = new ZipFile(aFileName);
        }
        catch (ZipException e) {
            throw new ZipFileAccessorException(e.getMessage());
        }
        catch (IOException e) {
            throw new ZipFileAccessorException(e.getMessage());
        }
        this.setClosed(false);
        this.setArchiveName(aFileName);
    }

    public void setArchiveName(String aName) throws IllegalArgumentException {
        String name = this.properArchiveName(aName);
        this.file.setFileName(name);
        super.setName(name);
    }

    public String getArchiveName() {
        return super.getName();
    }

    public void setUseCompression(boolean aSwitch) {
        boolean old = this.file.isUseCompression();
        if (aSwitch != old) {
            this.file.setUseCompression(aSwitch);
            this.propertyChange.firePropertyChange("useCompression", new Boolean(old), new Boolean(aSwitch));
        }
    }

    public boolean isUseCompression() {
        return this.file.isUseCompression();
    }

    public void open(String aFileName) throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            this.close();
        }
        this._open(this.properArchiveName(aFileName));
        this.restoreProperties();
    }

    public void create() throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            this.close();
        }
        this.file = new ZipFile();
        this.restoreProperties();
        this.setClosed(false);
        String dir = this.properDirectory(this.getDefaultDirectory());
        if (dir != null || !dir.equals("")) {
            this.add();
        }
    }

    public void create(String aFileName) throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            this.close();
        }
        if (!super.checkName(aFileName)) {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
        }
        if (!this.checkName(aFileName)) {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("4"));
        }
        try {
            this.file = new ZipFile(aFileName);
            this.setClosed(false);
            this.restoreProperties();
        }
        catch (ZipException e) {
            throw new ZipFileAccessorException(e.getMessage());
        }
        catch (IOException e) {
            throw new ZipFileAccessorException(e.getMessage());
        }
        if (this.isAutomaticSave()) {
            this.save();
        } else {
            this.setSaved(false);
        }
    }

    public void close() throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            if (!this.checkSaved()) {
                if (!super.checkName(this.getArchiveName())) {
                    throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
                }
                this.save();
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
        this.setDefaults();
    }

    public void add() throws ZipFileAccessorException {
        String dir = this.properDirectory(this.getDefaultDirectory());
        if (!this.checkClosed()) {
            if (dir == null) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (dir.equals("")) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (!super.checkDirectory(dir)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("10"));
            }
            try {
                Folder folder = new Folder(dir);
                Enumeration names = folder.resources();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String nameInArc = name.substring(dir.length() + 1);
                    if (this.file.exists(nameInArc)) {
                        this.replace(nameInArc);
                        continue;
                    }
                    this.file.putFile(name, nameInArc);
                }
                if (this.isAutomaticSave()) {
                    this.save();
                }
                this.setSaved(false);
            }
            catch (IOException e) {
                throw new ZipFileAccessorException(e.getMessage());
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void add(String aName) throws ZipFileAccessorException {
        String dir = this.properDirectory(this.getDefaultDirectory());
        if (!this.checkClosed()) {
            int l;
            if (!super.checkName(aName)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            File f = new File(aName = aName.replace('/', File.separatorChar));
            String name = !f.isAbsolute() ? ((l = dir.length()) == 1 ? (dir.equals(PackagedFileBucketAccessor.RootDir) ? String.valueOf(dir) + aName : (dir.equals(".") ? String.valueOf(dir) + File.separator + aName : aName)) : (l != 0 ? String.valueOf(dir) + File.separator + aName : aName)) : aName;
            f = new File(name);
            if (!f.isDirectory()) {
                if (!this.checkName(name)) {
                    throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
                }
                String arcName = aName;
                char c = arcName.charAt(1);
                if (c == ':') {
                    arcName = arcName.substring(2);
                }
                if ((c = arcName.charAt(0)) == File.separatorChar) {
                    arcName = arcName.substring(1);
                }
                arcName = arcName.replace('\\', '/');
                try {
                    if (this.file.exists(arcName)) {
                        this.replace(arcName);
                    }
                    this.file.putFile(name, arcName);
                }
                catch (IOException e) {
                    throw new ZipFileAccessorException(e.getMessage());
                }
            } else {
                try {
                    f = new File(aName);
                    String dirName = !f.isAbsolute() ? (dir.length() == 1 ? String.valueOf(dir) + aName : String.valueOf(dir) + File.separator + aName) : aName;
                    Folder folder = new Folder(dirName);
                    Enumeration names = folder.resources();
                    while (names.hasMoreElements()) {
                        name = (String)names.nextElement();
                        String arcName = name.substring(dir.length());
                        char c = arcName.charAt(1);
                        if (c == ':') {
                            arcName = arcName.substring(2);
                        }
                        if ((c = arcName.charAt(0)) == File.separatorChar) {
                            arcName = arcName.substring(1);
                        }
                        if (this.file.exists(arcName)) {
                            this.replace(arcName);
                            continue;
                        }
                        this.file.putFile(name, arcName);
                    }
                }
                catch (IOException e) {
                    throw new ZipFileAccessorException(e.getMessage());
                }
            }
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void replace(String aFileName) throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String dir = this.properDirectory(this.getDefaultDirectory());
            String nameD = String.valueOf(dir) + File.separatorChar + aFileName;
            if (!this.checkName(nameD)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            try {
                String name = aFileName.replace('\\', '/');
                if (!this.file.exists(name)) {
                    throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
                }
                this.file.remove(name);
                this.file.putFile(nameD, name);
                if (this.isAutomaticSave()) {
                    this.save();
                }
                this.setSaved(false);
            }
            catch (IOException e) {
                throw new ZipFileAccessorException(e.getMessage());
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void remove(String aFileName) throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String name = aFileName.replace('\\', '/');
            if (!this.file.exists(name)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            this.file.remove(name);
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void clear() throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            this.file.clear();
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void extract() throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            String dir = this.properDirectory(this.getDefaultDirectory());
            if (dir == null) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (dir.equals("")) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (!super.checkDirectory(dir)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("10"));
            }
            try {
                String[] names = this.contents();
                Folder folder = new Folder();
                int i = 0;
                int j = names.length;
                while (i < j) {
                    String name = names[i];
                    byte[] data = this.file.get(name);
                    name = name.replace('/', File.separatorChar);
                    name = String.valueOf(dir) + File.separatorChar + name;
                    if (name.endsWith(File.separator)) {
                        folder.makeSubFolder(name);
                    } else {
                        folder.writeFile(name, data);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new ZipFileAccessorException(e.getMessage());
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void extract(String aFileName) throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String dir = this.properDirectory(this.getDefaultDirectory());
            if (dir == null) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (dir.equals("")) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (!super.checkDirectory(dir)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("10"));
            }
            try {
                Folder folder = new Folder();
                String name = aFileName.replace('\\', '/');
                byte[] data = this.file.get(name);
                if (this.file.exists(name)) {
                    name = String.valueOf(dir) + File.separator + aFileName;
                    if ((name = name.replace('/', File.separatorChar)).endsWith(File.separator)) {
                        folder.makeSubFolder(name);
                    }
                    folder.writeFile(name, data);
                }
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            catch (IOException e) {
                throw new ZipFileAccessorException(e.getMessage());
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void rename(String anOldName, String aNewName) throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(anOldName)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            if (!super.checkName(aNewName)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String name = anOldName.replace('\\', '/');
            if (!this.file.exists(name)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            byte[] data = this.file.get(name);
            this.file.remove(name);
            this.file.put(aNewName, data);
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public boolean exists(String aFileName) throws ZipFileAccessorException {
        boolean ok = false;
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
        ok = this.file.exists(aFileName);
        return ok;
    }

    public String[] contents() throws ZipFileAccessorException {
        String[] arr = null;
        if (!this.checkClosed()) {
            int count = this.file.size();
            arr = new String[count];
            Enumeration e = this.file.resources();
            int i = 0;
            while (e.hasMoreElements()) {
                arr[i] = (String)e.nextElement();
                ++i;
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
        return arr;
    }

    public Enumeration contentsAsEnumeration() throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            return this.file.resources();
        }
        throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
    }

    public void save() throws ZipFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(this.getArchiveName())) {
                throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            try {
                this.file.save();
                this.setSaved(true);
            }
            catch (ZipException e) {
                throw new ZipFileAccessorException(e.getMessage());
            }
            catch (IOException e) {
                throw new ZipFileAccessorException(e.getMessage());
            }
        } else {
            throw new ZipFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void saveAs(String aFileName) throws ZipFileAccessorException {
        this.setArchiveName(aFileName);
        this.save();
    }

    public synchronized Object clone() {
        ZipFileAccessor object = new ZipFileAccessor();
        if (this.file != null) {
            object.file = (ZipFile)this.file.clone();
        }
        object.propertyChange = new PropertyChangeSupport(object);
        object.setArchiveName(this.getArchiveName());
        object.setAutomaticSave(this.isAutomaticSave());
        object.setDefaultDirectory(this.getDefaultDirectory());
        object.setClosed(this.checkClosed());
        object.setSaved(this.checkSaved());
        return object;
    }

    protected boolean checkName(String aName) {
        File file = null;
        boolean ok = true;
        try {
            file = new File(aName);
        }
        catch (NullPointerException nullPointerException) {
            ok = false;
        }
        if (ok && !file.exists()) {
            ok = false;
        }
        return ok;
    }

    protected void setDefaults() {
        super.setDefaults();
        this.storeProperties();
        this.file = null;
    }

    private String properArchiveName(String aFileName) {
        String name = aFileName;
        if (name.indexOf(ZipExtention) == -1) {
            name = String.valueOf(name) + ZipExtention;
        }
        return name;
    }

    private void storeProperties() {
        this.useCompressCopy = this.file.isUseCompression();
    }

    private void restoreProperties() {
        this.file.setUseCompression(this.useCompressCopy);
        this.file.setFileName(this.getArchiveName());
    }
}

