/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.jarfileaccessor;

import com.ibm.archiveaccessor.filestore.FileBucketAccessor;
import com.ibm.archiveaccessor.filestore.Folder;
import com.ibm.archiveaccessor.filestore.JarFile;
import com.ibm.archiveaccessor.filestore.Manifest;
import com.ibm.archiveaccessor.filestore.PackagedFileBucketAccessor;
import com.ibm.archiveaccessor.filestore.Reads;
import com.ibm.archiveaccessor.jarfileaccessor.JarFileAccessorException;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipException;

public class JarFileAccessor
extends PackagedFileBucketAccessor {
    private static final String JarExtention = ".jar";
    private boolean useCompressCopy = true;
    private boolean createManifestCopy = true;
    private JarFile file;
    protected boolean includeManifest = false;

    public JarFileAccessor() {
        this.file = new JarFile();
        this.file.setFileName(this.properArchiveName(this.getArchiveName()));
        super.setName(this.properArchiveName(this.getArchiveName()));
        this.setClosed(false);
    }

    public JarFileAccessor(String aFileName) throws JarFileAccessorException {
        this._open(this.properArchiveName(aFileName));
    }

    private void _open(String aFileName) throws JarFileAccessorException {
        if (!super.checkName(aFileName)) {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
        }
        if (!this.checkName(aFileName)) {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("4"));
        }
        try {
            this.file = new JarFile(aFileName);
        }
        catch (ZipException e) {
            throw new JarFileAccessorException(e.getMessage());
        }
        catch (IOException e) {
            throw new JarFileAccessorException(e.getMessage());
        }
        this.setClosed(false);
        this.setArchiveName(aFileName);
    }

    public void setArchiveName(String aName) throws IllegalArgumentException {
        String name = this.properArchiveName(aName);
        this.file.setFileName(name);
        super.setName(name);
    }

    public String getArchiveName() {
        return super.getName();
    }

    public void setUseCompression(boolean aSwitch) {
        boolean old = this.file.isUseCompression();
        if (aSwitch != old) {
            this.file.setUseCompression(aSwitch);
            this.propertyChange.firePropertyChange("useCompression", new Boolean(old), new Boolean(aSwitch));
        }
    }

    public boolean isUseCompression() {
        return this.file.isUseCompression();
    }

    public void setCreateManifest(boolean aSwitch) {
        boolean old = this.file.isCreateManifest();
        if (aSwitch != old) {
            this.file.setCreateManifest(aSwitch);
            this.propertyChange.firePropertyChange("createManifest", new Boolean(old), new Boolean(aSwitch));
        }
    }

    public boolean isCreateManifest() {
        return this.file.isCreateManifest();
    }

    public void setIncludeManifest(boolean aSwitch) {
        boolean old = this.isIncludeManifest();
        if (aSwitch != old) {
            this.includeManifest = aSwitch;
            this.propertyChange.firePropertyChange("includeManifest", new Boolean(old), new Boolean(aSwitch));
        }
    }

    public boolean isIncludeManifest() {
        return this.includeManifest;
    }

    public void open(String aFileName) throws JarFileAccessorException {
        if (!this.checkClosed()) {
            this.close();
        }
        this._open(this.properArchiveName(aFileName));
        this.restoreProperties();
    }

    public void create() throws JarFileAccessorException {
        if (!this.checkClosed()) {
            this.close();
        }
        this.file = new JarFile();
        this.restoreProperties();
        this.setClosed(false);
        String dir = this.properDirectory(this.getDefaultDirectory());
        if (dir != null || !dir.equals("")) {
            this.add();
        }
    }

    public void create(String aFileName) throws JarFileAccessorException {
        if (!this.checkClosed()) {
            this.close();
        }
        if (!super.checkName(aFileName)) {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
        }
        if (!this.checkName(aFileName)) {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("4"));
        }
        try {
            this.file = new JarFile(aFileName);
            this.setClosed(false);
            this.restoreProperties();
        }
        catch (ZipException e) {
            throw new JarFileAccessorException(e.getMessage());
        }
        catch (IOException e) {
            throw new JarFileAccessorException(e.getMessage());
        }
        if (this.isAutomaticSave()) {
            this.save();
        } else {
            this.setSaved(false);
        }
    }

    public void close() throws JarFileAccessorException {
        if (!this.checkClosed()) {
            if (!this.checkSaved()) {
                if (!super.checkName(this.getArchiveName())) {
                    throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
                }
                this.save();
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
        this.setDefaults();
    }

    public void add() throws JarFileAccessorException {
        if (!this.checkClosed()) {
            Manifest manifest = null;
            String dir = this.properDirectory(this.getDefaultDirectory());
            if (dir == null) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (dir.equals("")) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (!super.checkDirectory(dir)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("10"));
            }
            try {
                Folder folder = new Folder(dir);
                Enumeration names = folder.resources();
                while (names.hasMoreElements()) {
                    String nameInArc;
                    String name = (String)names.nextElement();
                    if ((name = name.replace('\\', '/')).indexOf(this.file.getManifestName()) != -1 && this.file.size() == 0 && this.isCreateManifest() && this.isIncludeManifest()) {
                        manifest = new Manifest(Reads.read(new FileInputStream(name)));
                    }
                    if (this.file.exists(nameInArc = name.substring(dir.length() + 1))) {
                        this.replace(nameInArc);
                        continue;
                    }
                    this.file.putFile(name, nameInArc);
                }
                if (this.file.size() == 0 && this.isCreateManifest() && this.isIncludeManifest()) {
                    this.file.setManifest(manifest);
                }
                if (this.isAutomaticSave()) {
                    this.save();
                }
                this.setSaved(false);
            }
            catch (IOException e) {
                throw new JarFileAccessorException(e.getMessage());
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void add(String aName) throws JarFileAccessorException {
        String dir = this.properDirectory(this.getDefaultDirectory());
        if (!this.checkClosed()) {
            int l;
            if (!super.checkName(aName)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            File f = new File(aName = aName.replace('/', File.separatorChar));
            String name = !f.isAbsolute() ? ((l = dir.length()) == 1 ? (dir.equals(PackagedFileBucketAccessor.RootDir) ? String.valueOf(dir) + aName : (dir.equals(".") ? String.valueOf(dir) + File.separator + aName : aName)) : (l != 0 ? String.valueOf(dir) + File.separator + aName : aName)) : aName;
            f = new File(name);
            if (!f.isDirectory()) {
                if (!this.checkName(name)) {
                    throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
                }
                String arcName = aName;
                char c = arcName.charAt(1);
                if (c == ':') {
                    arcName = arcName.substring(2);
                }
                if ((c = arcName.charAt(0)) == File.separatorChar) {
                    arcName = arcName.substring(1);
                }
                arcName = arcName.replace('\\', '/');
                try {
                    if (this.file.exists(arcName)) {
                        this.replace(arcName);
                    }
                    this.file.putFile(name, arcName);
                }
                catch (IOException e) {
                    throw new JarFileAccessorException(e.getMessage());
                }
            } else {
                try {
                    f = new File(aName);
                    String dirName = !f.isAbsolute() ? (dir.length() == 1 ? String.valueOf(dir) + aName : String.valueOf(dir) + File.separator + aName) : aName;
                    Folder folder = new Folder(dirName);
                    Enumeration names = folder.resources();
                    while (names.hasMoreElements()) {
                        name = (String)names.nextElement();
                        String arcName = name.substring(dir.length());
                        char c = arcName.charAt(1);
                        if (c == ':') {
                            arcName = arcName.substring(2);
                        }
                        if ((c = arcName.charAt(0)) == File.separatorChar) {
                            arcName = arcName.substring(1);
                        }
                        if (this.file.exists(arcName)) {
                            this.replace(arcName);
                            continue;
                        }
                        this.file.putFile(name, arcName);
                    }
                }
                catch (IOException e) {
                    throw new JarFileAccessorException(e.getMessage());
                }
            }
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void replace(String aFileName) throws JarFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String dir = this.properDirectory(this.getDefaultDirectory());
            String nameD = String.valueOf(dir) + File.separatorChar + aFileName;
            if (!this.checkName(nameD)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            try {
                String name = aFileName.replace('\\', '/');
                if (!this.file.exists(name)) {
                    throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
                }
                this.file.remove(name);
                this.file.putFile(nameD, name);
                if (this.isAutomaticSave()) {
                    this.save();
                }
                this.setSaved(false);
            }
            catch (IOException e) {
                throw new JarFileAccessorException(e.getMessage());
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void remove(String aFileName) throws JarFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String name = aFileName.replace('\\', '/');
            if (!this.file.exists(name)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            this.file.remove(name);
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void clear() throws JarFileAccessorException {
        if (!this.checkClosed()) {
            this.file.clear();
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void extract() throws JarFileAccessorException {
        if (!this.checkClosed()) {
            String dir = this.properDirectory(this.getDefaultDirectory());
            if (dir == null) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (dir.equals("")) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (!super.checkDirectory(dir)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("10"));
            }
            try {
                String[] names = this.contents();
                Folder folder = new Folder();
                int i = 0;
                int j = names.length;
                while (i < j) {
                    String name = names[i];
                    byte[] data = this.file.get(name);
                    name = name.replace('/', File.separatorChar);
                    name = String.valueOf(dir) + File.separatorChar + name;
                    if (name.endsWith(File.separator)) {
                        folder.makeSubFolder(name);
                    } else {
                        folder.writeFile(name, data);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new JarFileAccessorException(e.getMessage());
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void extract(String aFileName) throws JarFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String dir = this.properDirectory(this.getDefaultDirectory());
            if (dir == null) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (dir.equals("")) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("9"));
            }
            if (!super.checkDirectory(dir)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("10"));
            }
            try {
                Folder folder = new Folder();
                String name = aFileName.replace('\\', '/');
                byte[] data = this.file.get(name);
                if (this.file.exists(name)) {
                    name = String.valueOf(dir) + File.separatorChar + aFileName;
                    if ((name = name.replace('/', File.separatorChar)).endsWith(File.separator)) {
                        folder.makeSubFolder(name);
                    }
                    folder.writeFile(name, data);
                }
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            catch (IOException e) {
                throw new JarFileAccessorException(e.getMessage());
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void rename(String anOldName, String aNewName) throws JarFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(anOldName)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            if (!super.checkName(aNewName)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            String name = anOldName.replace('\\', '/');
            if (!this.file.exists(name)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("8"));
            }
            byte[] data = this.file.get(name);
            this.file.remove(name);
            this.file.put(aNewName, data);
            if (this.isAutomaticSave()) {
                this.save();
            } else {
                this.setSaved(false);
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public boolean exists(String aFileName) throws JarFileAccessorException {
        boolean ok = false;
        if (!this.checkClosed()) {
            if (!super.checkName(aFileName)) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
        ok = this.file.exists(aFileName);
        return ok;
    }

    public String[] contents() throws JarFileAccessorException {
        String[] arr = null;
        if (!this.checkClosed()) {
            int count = this.file.size();
            arr = new String[count];
            Enumeration e = this.file.resources();
            int i = 0;
            while (e.hasMoreElements()) {
                arr[i] = (String)e.nextElement();
                ++i;
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
        return arr;
    }

    public Enumeration contentsAsEnumeration() throws JarFileAccessorException {
        if (!this.checkClosed()) {
            return this.file.resources();
        }
        throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
    }

    public void save() throws JarFileAccessorException {
        if (!this.checkClosed()) {
            if (!super.checkName(this.getArchiveName())) {
                throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("6"));
            }
            try {
                this.file.save();
                this.setSaved(true);
            }
            catch (ZipException e) {
                throw new JarFileAccessorException(e.getMessage());
            }
            catch (IOException e) {
                throw new JarFileAccessorException(e.getMessage());
            }
        } else {
            throw new JarFileAccessorException(FileBucketAccessor.getExceptionMessage("7"));
        }
    }

    public void saveAs(String aFileName) throws JarFileAccessorException {
        this.setArchiveName(aFileName);
        this.save();
    }

    public synchronized Object clone() {
        JarFileAccessor object = new JarFileAccessor();
        if (this.file != null) {
            object.file = (JarFile)this.file.clone();
        }
        object.propertyChange = new PropertyChangeSupport(object);
        object.setArchiveName(this.getArchiveName());
        object.setAutomaticSave(this.isAutomaticSave());
        object.setDefaultDirectory(this.getDefaultDirectory());
        object.setClosed(this.checkClosed());
        object.setSaved(this.checkSaved());
        return object;
    }

    protected boolean checkName(String aName) {
        File file = null;
        boolean ok = true;
        try {
            file = new File(aName);
        }
        catch (NullPointerException nullPointerException) {
            ok = false;
        }
        if (ok && !file.exists()) {
            ok = false;
        }
        return ok;
    }

    protected void setDefaults() {
        super.setDefaults();
        this.storeProperties();
        this.file = null;
    }

    private String properArchiveName(String aFileName) {
        String name = aFileName;
        if (name.indexOf(JarExtention) == -1) {
            name = String.valueOf(name) + JarExtention;
        }
        return name;
    }

    private void storeProperties() {
        this.useCompressCopy = this.file.isUseCompression();
        this.createManifestCopy = this.file.isCreateManifest();
    }

    private void restoreProperties() {
        this.file.setUseCompression(this.useCompressCopy);
        this.file.setCreateManifest(this.createManifestCopy);
        this.file.setFileName(this.getArchiveName());
    }
}

