/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.Reads;
import com.ibm.archiveaccessor.filestore.ZipBucket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipException;

public class ZipFile
extends ZipBucket {
    protected String fileName = "";

    public ZipFile() {
    }

    public ZipFile(String pfileName) throws IOException, ZipException {
        super(new FileInputStream(pfileName));
        this.fileName = pfileName;
    }

    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void saveAs(String pfileName) throws IOException, ZipException {
        this.fileName = pfileName;
        this.zip(new FileOutputStream(pfileName));
    }

    public void save() throws IOException, ZipException {
        this.saveAs(this.fileName);
    }

    public void putFile(String pfileName) throws IOException {
        this.putFile(pfileName, pfileName);
    }

    public void putFile(String pfileName, String as) throws IOException {
        File file = new File(pfileName);
        long modified = file.lastModified();
        FileInputStream is = new FileInputStream(file);
        String name = as.replace('\\', '/');
        byte[] value = Reads.read(is);
        this.put(name, value, modified);
        ((InputStream)is).close();
    }

    public synchronized Object clone() {
        ZipFile f = new ZipFile();
        f.pairs = (Vector)this.pairs.clone();
        f.useCompression = this.useCompression;
        f.fileName = this.fileName;
        return f;
    }
}

