/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.Entry;
import com.ibm.archiveaccessor.filestore.EnumNames;
import com.ibm.archiveaccessor.filestore.Reads;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipBucket
implements Cloneable,
Serializable {
    public static final String empty = "";
    protected Vector pairs = new Vector();
    protected transient Hashtable table = null;
    protected boolean useCompression = true;

    public ZipBucket() {
    }

    public ZipBucket(InputStream is) throws IOException, ZipException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String name = ze.getName();
            if (!ze.isDirectory()) {
                byte[] d = Reads.read(zis);
                CRC32 crc = new CRC32();
                crc.update(d);
                if (ze.getCrc() != crc.getValue()) {
                    throw new ZipException("Bad CRC");
                }
                this.put(name, d, ze.getTime());
            }
            zis.closeEntry();
            ze = zis.getNextEntry();
        }
        zis.close();
    }

    public synchronized void zip(OutputStream os) throws IOException, ZipException {
        ZipOutputStream zos = new ZipOutputStream(os);
        if (!this.isUseCompression()) {
            zos.setMethod(0);
        }
        int s = this.pairs.size();
        if (this.size() != 0) {
            int i = 0;
            while (i < s) {
                Object o = this.pairs.elementAt(i);
                if (!empty.equals(o)) {
                    Entry entry = (Entry)o;
                    ZipEntry ze = new ZipEntry(entry.key);
                    ze.setTime(entry.modified);
                    zos.putNextEntry(ze);
                    byte[] d = entry.value;
                    CRC32 crc = new CRC32();
                    crc.update(d);
                    ze.setCrc(crc.getValue());
                    zos.write(d, 0, d.length);
                    zos.closeEntry();
                }
                ++i;
            }
            zos.finish();
            zos.close();
        } else {
            os.flush();
            os.close();
        }
    }

    public synchronized Object clone() {
        ZipBucket b = new ZipBucket();
        b.pairs = (Vector)this.pairs.clone();
        b.useCompression = this.useCompression;
        return b;
    }

    synchronized void restore() {
        this.table = new Hashtable();
        int s = this.pairs.size();
        int i = 0;
        while (i < s) {
            Object o = this.pairs.elementAt(i);
            if (empty.equals(o)) {
                this.pairs.setElementAt(empty, i);
            } else {
                Integer ndx = new Integer(i);
                Entry pair = (Entry)o;
                this.table.put(pair.key.toUpperCase(), ndx);
            }
            ++i;
        }
    }

    public synchronized boolean exists(String name) {
        if (this.table == null) {
            return false;
        }
        Integer ndx = (Integer)this.table.get(name.toUpperCase());
        return ndx != null;
    }

    public synchronized void clear() {
        this.pairs = new Vector();
        this.table = null;
    }

    public synchronized byte[] get(String name) {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if ((ndx = (Integer)this.table.get(name.toUpperCase())) == null) {
            return null;
        }
        Entry entry = (Entry)this.pairs.elementAt(ndx);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public synchronized long modified(String name) {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if ((ndx = (Integer)this.table.get(name.toUpperCase())) == null) {
            return 0L;
        }
        Entry entry = (Entry)this.pairs.elementAt(ndx);
        if (entry == null) {
            return 0L;
        }
        return entry.modified;
    }

    public void put(String name, byte[] value) {
        this.put(name, value, System.currentTimeMillis());
    }

    synchronized void put(String name, byte[] value, long tim) {
        if (this.table == null) {
            this.restore();
        }
        Entry pair = new Entry(name, value, tim);
        int s = this.pairs.size();
        Object obj = null;
        int found = -1;
        int elem = 0;
        while (elem < s) {
            obj = this.pairs.elementAt(elem);
            if (empty.equals(obj)) {
                found = elem;
            } else {
                Entry p = obj;
                if (name.equals(p.key)) break;
            }
            ++elem;
        }
        if (elem == s) {
            if (found == -1) {
                this.pairs.addElement(pair);
            } else {
                elem = found;
                this.pairs.setElementAt(pair, elem);
            }
        } else {
            this.pairs.setElementAt(pair, elem);
        }
        Integer ndx = new Integer(elem);
        this.table.put(name.toUpperCase(), ndx);
    }

    public Enumeration resources() {
        return new EnumNames(this);
    }

    public synchronized void remove(String name) {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if ((ndx = (Integer)this.table.get(name.toUpperCase())) == null) {
            return;
        }
        this.pairs.setElementAt(empty, ndx);
        this.table.remove(name.toUpperCase());
    }

    public synchronized int size() {
        if (this.table == null) {
            return 0;
        }
        return this.table.size();
    }

    public synchronized void setUseCompression(boolean aSwitch) {
        this.useCompression = aSwitch;
    }

    public synchronized boolean isUseCompression() {
        return this.useCompression;
    }
}

