/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.FileBucketAccessor;
import com.ibm.archiveaccessor.filestore.FileBucketAccessorException;
import java.io.File;

public abstract class PackagedFileBucketAccessor
extends FileBucketAccessor {
    protected static final String RootDir = File.separator;
    protected static final String CurrentDir = ".";
    protected String defaultDirectory = System.getProperty("user.dir");

    public abstract void add() throws FileBucketAccessorException;

    public abstract void extract() throws FileBucketAccessorException;

    public abstract void extract(String var1) throws FileBucketAccessorException;

    public void setDefaultDirectory(String aDirectory) throws IllegalArgumentException {
        if (aDirectory == null) {
            throw new IllegalArgumentException(FileBucketAccessor.getExceptionMessage("2"));
        }
        if (!aDirectory.equals(this.defaultDirectory)) {
            String old = this.defaultDirectory;
            this.defaultDirectory = aDirectory;
            this.propertyChange.firePropertyChange("defaultDirectory", old, aDirectory);
        }
    }

    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    protected boolean checkDirectory(String aDirectory) {
        File dir = null;
        boolean ok = true;
        try {
            dir = new File(aDirectory);
        }
        catch (NullPointerException nullPointerException) {
            ok = false;
        }
        if (ok && !dir.isDirectory()) {
            ok = false;
        }
        return ok;
    }

    protected String properDirectory(String aDir) {
        String name = aDir;
        if (name != null && !name.equals("")) {
            char c;
            int len = name.length();
            name = name.replace('\\', File.separatorChar);
            name = name.replace('/', File.separatorChar);
            if (len != 1 && (c = name.charAt(len - 1)) == File.separatorChar) {
                name = name.substring(0, len - 1);
            }
        }
        return name;
    }

    protected void setDefaults() {
        super.setDefaults();
    }
}

