/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.Base64;
import com.ibm.archiveaccessor.filestore.Pair;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class ManifestSection
implements Serializable,
Cloneable {
    private Vector pairs = new Vector();

    public ManifestSection() {
    }

    public ManifestSection(String id) {
        this.pairs.addElement(new Pair("Name", id.replace('\\', '/')));
    }

    public ManifestSection(String[] header) {
        int l = header.length;
        String lastName = null;
        String lastValue = null;
        int i = 0;
        while (i < l) {
            String current = header[i];
            if (current.startsWith(" ")) {
                if (lastName != null) {
                    lastValue = String.valueOf(lastValue) + current.substring(1);
                    this.add(lastName, lastValue);
                }
            } else {
                int colon = current.indexOf(": ");
                if (colon > 0) {
                    lastName = current.substring(0, colon);
                    lastValue = current.substring(colon + 2);
                    this.add(lastName, lastValue);
                }
            }
            ++i;
        }
    }

    public synchronized Object clone() {
        return new ManifestSection(this.get());
    }

    public synchronized boolean equals(Object o) {
        return this.get("Name").equals(((ManifestSection)o).get("Name"));
    }

    public synchronized int hashCode() {
        int h = 0;
        int i = 0;
        int position = 0;
        int length = this.pairs.size();
        int skip = 1;
        if (length >= 16) {
            skip = length / 16;
        }
        while (i < length) {
            Pair pair = (Pair)this.pairs.elementAt(i);
            if (pair != null) {
                h ^= pair.hashCode() / (position % 16 + 1);
            }
            ++position;
            i += skip;
        }
        return h;
    }

    public synchronized void remove(String name) {
        this.pairs.removeElement(new Pair(name, ""));
    }

    public synchronized void add(String name, String value) {
        Pair pair = new Pair(name, value);
        this.pairs.removeElement(pair);
        this.pairs.addElement(pair);
    }

    public synchronized String get(String name) {
        int s = this.pairs.size();
        int i = 0;
        while (i < s) {
            Pair pair = (Pair)this.pairs.elementAt(i);
            if (name.equals(pair.name)) {
                return pair.value;
            }
            ++i;
        }
        return null;
    }

    public synchronized String[] get() {
        int s = this.pairs.size();
        Vector<String> e = new Vector<String>();
        int i = 0;
        while (i < s) {
            String ln = ((Pair)this.pairs.elementAt(i)).header();
            while (ln.length() > 72) {
                e.addElement(ln.substring(0, 72));
                ln = " " + ln.substring(72);
            }
            e.addElement(ln);
            ++i;
        }
        s = e.size();
        Object[] rv = new String[s];
        e.copyInto(rv);
        return rv;
    }

    public static String base64Hash(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] hash = md.digest(data);
        return new String(Base64.binToAsc(hash));
    }

    public void addHash(byte[] data) {
        try {
            this.add("Hash-Algorithms", "MD5 SHA ");
            this.add("MD5-Hash", ManifestSection.base64Hash("MD5", data));
            this.add("SHA-Hash", ManifestSection.base64Hash("SHA", data));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    public boolean validate(byte[] data) throws NoSuchAlgorithmException {
        String algorithm;
        String hash = this.get("SHA-Hash");
        if (hash != null) {
            algorithm = "SHA";
        } else {
            hash = this.get("MD5-Hash");
            if (hash != null) {
                algorithm = "MD5";
            } else {
                return false;
            }
        }
        return hash.equals(ManifestSection.base64Hash(algorithm, data));
    }
}

