/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.ManifestSection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Manifest
implements Serializable,
Cloneable {
    private Vector sections = new Vector();

    public Manifest() {
    }

    public Manifest(String[] txt) {
        this.establish(txt);
    }

    public Manifest(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            InputStreamReader isr = new InputStreamReader(bais);
            BufferedReader br = new BufferedReader(isr);
            Vector<String> ln = new Vector<String>();
            String s = br.readLine();
            while (s != null) {
                ln.addElement(s);
                s = br.readLine();
            }
            int l = ln.size();
            Object[] sa = new String[l];
            ln.copyInto(sa);
            this.establish((String[])sa);
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    private void establish(String[] txt) {
        int l = txt.length;
        int i = 0;
        while (i < l && txt[i].length() > 0) {
            ++i;
        }
        while (i < l && txt[i].length() == 0) {
            ++i;
        }
        while (i < l) {
            Vector<String> lnv = new Vector<String>();
            while (i < l && txt[i].length() > 0) {
                lnv.addElement(txt[i]);
                ++i;
            }
            int s = lnv.size();
            Object[] ln = new String[s];
            lnv.copyInto(ln);
            this.sections.addElement(new ManifestSection((String[])ln));
            while (i < l && txt[i].length() == 0) {
                ++i;
            }
        }
    }

    public synchronized Object clone() {
        return new Manifest(this.get());
    }

    public synchronized void clear() {
        this.sections = new Vector();
    }

    public synchronized String[] get() {
        Vector<String> lnv = new Vector<String>();
        lnv.addElement("Manifest-Version: 1.0");
        lnv.addElement("");
        int s = this.sections.size();
        int i = 0;
        while (i < s) {
            ManifestSection ms = (ManifestSection)this.sections.elementAt(i);
            String[] ln = ms.get();
            int t = ln.length;
            int j = 0;
            while (j < t) {
                lnv.addElement(ln[j]);
                ++j;
            }
            lnv.addElement("");
            ++i;
        }
        Object[] rv = new String[lnv.size()];
        lnv.copyInto(rv);
        return rv;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(baos);
            BufferedWriter bw = new BufferedWriter(osw);
            String[] sa = this.get();
            int l = sa.length;
            int i = 0;
            while (i < l) {
                bw.write(sa[i], 0, sa[i].length());
                bw.newLine();
                ++i;
            }
            bw.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    public synchronized ManifestSection get(String name) {
        int s = this.sections.size();
        int i = 0;
        while (i < s) {
            ManifestSection ms = (ManifestSection)this.sections.elementAt(i);
            if (name.equals(ms.get("Name"))) {
                return (ManifestSection)this.sections.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public synchronized ManifestSection force(String name) {
        ManifestSection ms = this.get(name);
        if (ms != null) {
            return ms;
        }
        ms = new ManifestSection(name);
        this.add(ms);
        return ms;
    }

    public synchronized void remove(String name) {
        ManifestSection ms = new ManifestSection(name);
        this.sections.removeElement(ms);
    }

    public synchronized void add(ManifestSection ms) {
        String name = ms.get("Name");
        if (name.startsWith("META-INF/") || name.startsWith("/META-INF/")) {
            return;
        }
        this.sections.removeElement(ms);
        this.sections.addElement(ms);
    }

    public Enumeration sections() {
        return this.sections.elements();
    }
}

