/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.JarBucket;
import com.ibm.archiveaccessor.filestore.Manifest;
import com.ibm.archiveaccessor.filestore.Reads;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipException;

public class JarFile
extends JarBucket {
    protected String fileName = "";

    public JarFile() {
    }

    public JarFile(String pfileName) throws IOException, ZipException {
        super(new FileInputStream(pfileName));
        this.fileName = pfileName;
    }

    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void saveAs(String pfileName) throws IOException, ZipException {
        this.fileName = pfileName;
        this.jar(new FileOutputStream(pfileName));
    }

    public void save() throws IOException, ZipException {
        this.saveAs(this.fileName);
    }

    public void putFile(String pfileName) throws IOException {
        this.putFile(pfileName, pfileName);
    }

    public void putFile(String pfileName, String as) throws IOException {
        File file = new File(pfileName);
        long modified = file.lastModified();
        FileInputStream is = new FileInputStream(file);
        String name = as.replace('\\', '/');
        byte[] value = Reads.read(is);
        this.put(name, value, modified);
        if (this.isCreateManifest() && !name.equals("META-INF/MANIFEST.MF")) {
            this.manifest.force(name).addHash(value);
        }
        ((InputStream)is).close();
    }

    public synchronized Object clone() {
        JarFile f = new JarFile();
        f.pairs = (Vector)this.pairs.clone();
        if (this.isCreateManifest()) {
            f.manifest = (Manifest)this.manifest.clone();
        }
        f.useCompression = this.useCompression;
        f.fileName = this.fileName;
        return f;
    }
}

