/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.JarBucket;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;

class JarClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private JarBucket bucket;

    public JarClassLoader(JarBucket aBucket) {
        this.bucket = aBucket;
    }

    public synchronized Class loadClass(String name, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.classes.get(name);
        if (result != null) {
            if (resolveIt) {
                this.resolveClass(result);
            }
            return result;
        }
        try {
            result = super.findSystemClass(name);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] classData;
            String fileName;
            if (this.bucket != JarBucket.common) {
                fileName = String.valueOf(name.replace('.', '/')) + ".class";
                if (this.bucket.isCreateManifest() && this.bucket.manifest.force(fileName).get("External") != null) {
                    try {
                        if (JarBucket.common.table == null) {
                            JarBucket.common.restore();
                        }
                        if ((result = (Class<?>)JarBucket.common.jcl.classes.get(name)) == null) {
                            byte[] bytes = this.bucket.get(fileName);
                            if (bytes == null) {
                                throw new ClassNotFoundException();
                            }
                            JarBucket.common.put(fileName, bytes, this.bucket.modified(fileName));
                            result = JarBucket.common.jcl.loadClass(name, false);
                        }
                        if (resolveIt) {
                            this.resolveClass(result);
                        }
                        return result;
                    }
                    catch (ClassNotFoundException classNotFoundException2) {}
                }
            }
            if ((classData = this.bucket.get(fileName = String.valueOf(name.replace('.', '/')) + ".class")) == null) {
                throw new ClassNotFoundException();
            }
            result = this.defineClass(name, classData, 0, classData.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            this.classes.put(name, result);
            if (resolveIt) {
                this.resolveClass(result);
            }
            return result;
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = ClassLoader.getSystemResourceAsStream(name);
        if (is != null) {
            return is;
        }
        byte[] buffer = this.bucket.get(name);
        if (buffer == null) {
            return null;
        }
        return new ByteArrayInputStream(buffer);
    }
}

