/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.Entry;
import com.ibm.archiveaccessor.filestore.JarClassLoader;
import com.ibm.archiveaccessor.filestore.Manifest;
import com.ibm.archiveaccessor.filestore.Reads;
import com.ibm.archiveaccessor.filestore.ZipBucket;
import java.beans.Beans;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class JarBucket
extends ZipBucket {
    protected static final JarBucket common = new JarBucket();
    protected static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    protected Manifest manifest;
    transient JarClassLoader jcl;
    protected boolean createManifest = true;

    public JarBucket() {
        if (this.isCreateManifest()) {
            this.manifest = new Manifest();
        }
    }

    public JarBucket(InputStream is) throws IOException, ZipException {
        this.pairs = new Vector();
        this.table = null;
        if (this.isCreateManifest()) {
            this.manifest = new Manifest();
        }
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String name = ze.getName();
            if (!ze.isDirectory()) {
                byte[] d = Reads.read(zis);
                CRC32 crc = new CRC32();
                crc.update(d);
                if (ze.getCrc() != crc.getValue()) {
                    throw new ZipException("Bad CRC");
                }
                this.put(name, d, ze.getTime());
            }
            zis.closeEntry();
            ze = zis.getNextEntry();
        }
        zis.close();
    }

    public synchronized void jar(OutputStream os) throws IOException, ZipException {
        if (this.isCreateManifest()) {
            this.put(MANIFEST_NAME, this.manifest.getBytes());
        }
        this.zip(os);
    }

    public synchronized Object clone() {
        JarBucket b = new JarBucket();
        b.pairs = (Vector)this.pairs.clone();
        if (this.isCreateManifest()) {
            b.manifest = (Manifest)this.manifest.clone();
        }
        b.useCompression = this.useCompression;
        return b;
    }

    synchronized void restore() {
        this.jcl = new JarClassLoader(this);
        super.restore();
    }

    public Object getObject(String name) throws IOException, ClassNotFoundException {
        if (this.table == null) {
            this.restore();
        }
        return Beans.instantiate(this.jcl, name);
    }

    public synchronized byte[] get(String name) {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if (this.isCreateManifest() && name.equals(MANIFEST_NAME)) {
            this.put(MANIFEST_NAME, this.manifest.getBytes());
        }
        if ((ndx = (Integer)this.table.get(name.toUpperCase())) == null) {
            return null;
        }
        Entry entry = (Entry)this.pairs.elementAt(ndx);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public synchronized void putObject(String name, Object obj) throws IOException {
        name = String.valueOf(name.replace('.', '/')) + ".ser";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        this.put(name, baos.toByteArray());
    }

    public void put(String name, byte[] value) {
        super.put(name, value);
        if (!name.equals(MANIFEST_NAME) && this.isCreateManifest()) {
            this.manifest.force(name).addHash(value);
        }
    }

    synchronized void put(String name, byte[] value, long tim) {
        super.put(name, value, tim);
        if (this.isCreateManifest() && name.equals(MANIFEST_NAME)) {
            this.manifest = new Manifest(value);
        }
    }

    public synchronized void remove(String name) {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if (this.isCreateManifest()) {
            this.manifest.remove(name);
        }
        if ((ndx = (Integer)this.table.get(name.toUpperCase())) == null) {
            return;
        }
        this.pairs.setElementAt("", ndx);
        this.table.remove(name.toUpperCase());
    }

    public synchronized void clear() {
        this.manifest.clear();
        super.clear();
    }

    public synchronized void setManifest(Manifest aManifest) {
        if (this.isCreateManifest()) {
            this.manifest = aManifest;
        }
    }

    public synchronized Manifest getManifest() {
        return this.manifest;
    }

    public synchronized void setCreateManifest(boolean aSwitch) {
        this.createManifest = aSwitch;
    }

    public synchronized boolean isCreateManifest() {
        return this.createManifest;
    }

    public String getManifestName() {
        return MANIFEST_NAME;
    }
}

