/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.BucketEntry;
import com.ibm.archiveaccessor.filestore.FilenameFilter;
import com.ibm.archiveaccessor.filestore.FolderEnumeration;
import com.ibm.archiveaccessor.filestore.Reads;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FolderBucket
implements Cloneable,
Serializable {
    protected static final String empty = "";
    protected Vector pairs;
    protected transient Hashtable table;

    public FolderBucket() {
        this.pairs = new Vector();
        this.table = null;
    }

    public FolderBucket(String aFolder) throws IOException, SecurityException {
        this.open(aFolder);
    }

    public FolderBucket(String aFolder, String aFilter) throws IOException, SecurityException {
        this.pairs = new Vector();
        this.table = null;
        File file = new File(aFolder);
        if (file.isDirectory()) {
            this.read(file, aFilter);
        }
    }

    public void open(String aFolder) {
        this.pairs = new Vector();
        this.table = null;
        File file = new File(aFolder);
        if (file.isDirectory()) {
            this.read(file);
        }
    }

    private void read(File aFolder) {
        String[] names = aFolder.list();
        String path = aFolder.getPath();
        int i = 0;
        int j = names.length;
        while (i < j) {
            String name = String.valueOf(path) + System.getProperty("file.separator") + names[i];
            File file = new File(name);
            if (file.isDirectory()) {
                this.read(file);
            } else {
                this.put(name, file.lastModified());
            }
            ++i;
        }
    }

    private void read(File aFolder, String aFilter) {
        File file;
        String name;
        String[] names = aFolder.list(new FilenameFilter(aFilter));
        String[] allNames = aFolder.list();
        String path = aFolder.getPath();
        int i = 0;
        int j = names.length;
        while (i < j) {
            name = String.valueOf(path) + System.getProperty("file.separator") + names[i];
            file = new File(name);
            this.put(name, file.lastModified());
            ++i;
        }
        i = 0;
        j = allNames.length;
        while (i < j) {
            name = String.valueOf(path) + System.getProperty("file.separator") + allNames[i];
            file = new File(name);
            if (file.isDirectory()) {
                this.read(file, aFilter);
            }
            ++i;
        }
    }

    public synchronized Object clone() {
        FolderBucket b = new FolderBucket();
        b.pairs = (Vector)this.pairs.clone();
        return b;
    }

    synchronized void restore() {
        this.table = new Hashtable();
        int s = this.pairs.size();
        int i = 0;
        while (i < s) {
            Object o = this.pairs.elementAt(i);
            if (empty.equals(o)) {
                this.pairs.setElementAt(empty, i);
            } else {
                Integer ndx = new Integer(i);
                BucketEntry pair = (BucketEntry)o;
                this.table.put(pair.key, ndx);
            }
            ++i;
        }
    }

    public synchronized byte[] get(String name) throws IOException {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if ((ndx = (Integer)this.table.get(name)) == null) {
            return null;
        }
        byte[] data = Reads.read(new FileInputStream(name));
        return data;
    }

    public synchronized long modified(String aName) {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if ((ndx = (Integer)this.table.get(aName)) == null) {
            return 0L;
        }
        BucketEntry entry = (BucketEntry)this.pairs.elementAt(ndx);
        if (entry == null) {
            return 0L;
        }
        return entry.modified;
    }

    public synchronized void put(String aName, long aTime) {
        if (this.table == null) {
            this.restore();
        }
        BucketEntry pair = new BucketEntry(aName, aTime);
        int s = this.pairs.size();
        Object obj = null;
        int found = -1;
        int elem = 0;
        while (elem < s) {
            obj = this.pairs.elementAt(elem);
            if (empty.equals(obj)) {
                found = elem;
            } else {
                BucketEntry p = obj;
                if (aName.equals(p.key)) break;
            }
            ++elem;
        }
        if (elem == s) {
            if (found == -1) {
                this.pairs.addElement(pair);
            } else {
                elem = found;
                this.pairs.setElementAt(pair, elem);
            }
        } else {
            this.pairs.setElementAt(pair, elem);
        }
        Integer ndx = new Integer(elem);
        this.table.put(aName, ndx);
    }

    public Enumeration resources() {
        return new FolderEnumeration(this);
    }

    public synchronized void remove(String aName) {
        Integer ndx;
        if (this.table == null) {
            this.restore();
        }
        if ((ndx = (Integer)this.table.get(aName)) == null) {
            return;
        }
        this.pairs.setElementAt(empty, ndx);
        this.table.remove(aName);
    }

    public synchronized int size() {
        return this.pairs.size();
    }
}

