/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.FolderBucket;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class Folder
extends FolderBucket {
    protected String name;

    public Folder() {
    }

    public Folder(String aName) throws IOException, SecurityException {
        super(aName);
        this.setName(aName);
    }

    public Folder(String aName, String aFilter) throws IOException, SecurityException {
        super(aName, aFilter);
        this.setName(aName);
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void open(String aName) {
        super.open(aName);
        this.setName(aName);
    }

    public void rename(String aNewName) throws IOException {
        File folder = new File(this.getName());
        folder.renameTo(new File(aNewName));
        this.setName(aNewName);
    }

    public void putFileName(String aFileName) {
        File file = new File(aFileName);
        long modified = file.lastModified();
        this.put(aFileName, modified);
    }

    public void writeFile(String aFileName, byte[] aData) throws IOException {
        File file = new File(aFileName);
        File dir = new File(file.getParent());
        if (!dir.exists()) {
            this.makeSubFolder(file.getParent());
        }
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(aData);
        stream.close();
    }

    public void makeSubFolder(String aSubFolderName) {
        File file = new File(aSubFolderName);
        if (file.exists()) {
            return;
        }
        this.makeSubFolder(file.getParent());
        file.mkdir();
    }
}

