/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.archiveaccessor.filestore;

import com.ibm.archiveaccessor.filestore.FileBucketAccessorException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class FileBucketAccessor
implements Cloneable,
Serializable {
    protected static final String EmptyString = "";
    protected static final String Untitled = "untitled";
    private static final String PropertyFile = "com.ibm.archiveaccessor.filestore.AccessorResources";
    protected String name = "untitled";
    private String previousName = "";
    protected boolean automaticSave = true;
    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected static transient ResourceBundle properties = null;
    protected boolean saved = true;
    protected boolean closed = true;

    public FileBucketAccessor() {
        this.loadProperties();
    }

    public void setName(String aName) throws IllegalArgumentException {
        if (aName == null) {
            throw new IllegalArgumentException(FileBucketAccessor.getExceptionMessage("1"));
        }
        if (!aName.equals(this.name)) {
            String old = this.name;
            this.name = aName;
            this.previousName = old;
            this.propertyChange.firePropertyChange("name", old, aName);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setAutomaticSave(boolean aSwitch) {
        if (aSwitch != this.automaticSave) {
            boolean old = this.automaticSave;
            this.automaticSave = aSwitch;
            this.propertyChange.firePropertyChange("automaticSave", new Boolean(old), new Boolean(aSwitch));
        }
    }

    public boolean isAutomaticSave() {
        return this.automaticSave;
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) throws IllegalArgumentException {
        if (aListener == null) {
            throw new IllegalArgumentException();
        }
        this.propertyChange.addPropertyChangeListener(aListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) throws IllegalArgumentException {
        if (aListener == null) {
            throw new IllegalArgumentException();
        }
        this.propertyChange.removePropertyChangeListener(aListener);
    }

    public abstract void open(String var1) throws FileBucketAccessorException;

    public abstract void create() throws FileBucketAccessorException;

    public abstract void create(String var1) throws FileBucketAccessorException;

    public abstract void close() throws FileBucketAccessorException;

    public abstract void add(String var1) throws FileBucketAccessorException;

    public abstract void replace(String var1) throws FileBucketAccessorException;

    public abstract void remove(String var1) throws FileBucketAccessorException;

    public abstract void clear() throws FileBucketAccessorException;

    public abstract void rename(String var1, String var2) throws FileBucketAccessorException;

    public abstract boolean exists(String var1) throws FileBucketAccessorException;

    public abstract String[] contents() throws FileBucketAccessorException;

    public abstract Enumeration contentsAsEnumeration() throws FileBucketAccessorException;

    public abstract void save() throws FileBucketAccessorException;

    public void saveAs(String aName) throws FileBucketAccessorException {
        this.setName(aName);
        this.save();
    }

    private void readObject(ObjectInputStream aStream) throws IOException {
        try {
            aStream.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        this.loadProperties();
    }

    private void loadProperties() {
        try {
            properties = ResourceBundle.getBundle(PropertyFile, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.err.println("Resource bundle com.ibm.archiveaccessor.filestore.AccessorResources is not found");
            throw e;
        }
    }

    public static String getExceptionMessage(String anId) {
        String msg;
        block2: {
            msg = EmptyString;
            if (properties == null) break block2;
            try {
                msg = properties.getString(anId);
            }
            catch (MissingResourceException missingResourceException) {
                msg = EmptyString;
            }
        }
        return msg;
    }

    protected boolean checkName(String aName) {
        boolean ok = true;
        if (aName == null) {
            ok = false;
        }
        if (aName.length() == 0) {
            ok = false;
        }
        return ok;
    }

    protected boolean nameWasChanged() {
        boolean ok = true;
        if (this.name.equals(this.previousName)) {
            ok = false;
        }
        return ok;
    }

    protected boolean checkClosed() {
        return this.closed;
    }

    protected void setClosed(boolean aSwitch) {
        this.closed = aSwitch;
    }

    protected boolean checkSaved() {
        return this.saved;
    }

    protected void setSaved(boolean aSwitch) {
        this.saved = aSwitch;
    }

    protected void setDefaults() {
        this.setSaved(true);
        this.setClosed(true);
    }
}

