/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.conversation.base;

import com.ibm.conversation.CpState;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.CpStateTransition;
import com.ibm.conversation.MessageDescription;
import com.ibm.conversation.base.BasicMessageDescription;
import com.ibm.conversation.base.XmlParsingUtils;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CpXmlParser {
    private static final String CPXML_VERSION = "2.0";
    private static final String CPXML_SCHEMA_URI = "http://www.research.ibm.com/convsupport/ConversationPolicy2.0.xsd";
    private static final String CHILD = "Child";
    private static final String CHILD_RETURN = "ChildReturn";
    private static final String CHILD_RETURN_TRANSITION = "ChildReturnTransition";
    private static final String CP_NAME = "Name";
    private static final String ENCODING = "Encoding";
    private static final String INITIAL_STATE = "IniStateName";
    private static final String LOAD_CHILD = "LoadChild";
    private static final String MESSAGE = "Message";
    private static final String PARENT = "Parent";
    private static final String POLICY = "Policy";
    private static final String RETURN = "Return";
    private static final String ROLE = "Role";
    private static final String ROLEMAP_ELEMENT = "RolemapElement";
    private static final String SCHEMA = "Schema";
    private static final String SEND_MESSAGE_TRANSITION = "SendMessageTransition";
    private static final String SENDER = "Sender";
    private static final String STATE = "State";
    private static final String STATE_ID = "StateId";
    private static final String TARGET = "Target";
    private static final String TIMEOUT = "Timeout";
    private static final String TIMEOUT_TRANSITION = "TimeoutTransition";
    private static final String TRANSITION_NAME = "TransitionName";
    private boolean setValidation = false;
    private boolean setNameSpaces = true;
    private boolean setDeferredDOM = true;
    private String docUri = null;
    private Document document = null;

    public String getCpXmlSchemaUri() {
        return CPXML_SCHEMA_URI;
    }

    public String getCpXmlVersion() {
        return CPXML_VERSION;
    }

    public void loadDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        this.docUri = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(this.setDeferredDOM);
        documentBuilderFactory.setValidating(this.setValidation);
        documentBuilderFactory.setNamespaceAware(this.setNameSpaces);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(this.docUri);
    }

    public void initCpStateMachine(CpStateMachine cpStateMachine) {
        if (this.document != null) {
            cpStateMachine.clear();
            this.initCpName(cpStateMachine);
            this.initRoles(cpStateMachine);
            this.initInitialStateName(cpStateMachine);
            this.initStates(cpStateMachine);
        }
    }

    private boolean initCpName(CpStateMachine cpStateMachine) {
        boolean bl = false;
        Element element = (Element)this.document.getElementsByTagName(CP_NAME).item(0);
        if (element != null) {
            String string = XmlParsingUtils.getLeafText(element);
            cpStateMachine.setPolicyName(string);
            bl = true;
        }
        return bl;
    }

    private void initRoles(CpStateMachine cpStateMachine) {
        NodeList nodeList = this.document.getElementsByTagName(ROLE);
        int n = nodeList.getLength();
        String string = null;
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            string = XmlParsingUtils.getLeafText(element);
            cpStateMachine.addRole(string);
        }
    }

    private void initInitialStateName(CpStateMachine cpStateMachine) {
        Element element = (Element)this.document.getElementsByTagName(INITIAL_STATE).item(0);
        String string = XmlParsingUtils.getLeafText(element);
        cpStateMachine.setInitialStateName(string);
    }

    private void initStates(CpStateMachine cpStateMachine) {
        NodeList nodeList = this.document.getElementsByTagName(STATE);
        Element element = null;
        CpState cpState = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            element = (Element)nodeList.item(i);
            int n2 = CpXmlParser.getStateTypeFromElement(element);
            cpState = cpStateMachine.newState(n2);
            this.initState(element, cpState, cpStateMachine);
            cpStateMachine.addState(cpState);
        }
    }

    private static int getStateTypeFromElement(Element element) {
        int n = 0;
        NodeList nodeList = element.getElementsByTagName(LOAD_CHILD);
        n = nodeList.getLength() > 0 ? 2 : ((nodeList = element.getElementsByTagName(RETURN)).getLength() > 0 ? 3 : 1);
        return n;
    }

    private void initState(Element element, CpState cpState, CpStateMachine cpStateMachine) {
        Object object;
        Element element2;
        this.initStateName(element, cpState);
        this.initTimeout(element, cpState);
        NodeList nodeList = element.getElementsByTagName(TIMEOUT_TRANSITION);
        int n = nodeList.getLength();
        if (n > 0) {
            element2 = (Element)nodeList.item(0);
            object = cpStateMachine.newTransition(3);
            this.initTimeoutTransition(element2, (CpStateTransition)object);
            object.setSourceName(cpState.getName());
            cpState.addTransition((CpStateTransition)object);
        }
        if (cpState.getType() == 2) {
            nodeList = element.getElementsByTagName(LOAD_CHILD);
            if (nodeList.getLength() > 0) {
                element2 = (Element)nodeList.item(0);
                this.initChildPolicyData(element2, cpState);
            }
            nodeList = element.getElementsByTagName(CHILD_RETURN_TRANSITION);
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                object = (Element)nodeList.item(i);
                CpStateTransition cpStateTransition = cpStateMachine.newTransition(2);
                this.initChildReturnTransition((Element)object, cpStateTransition);
                cpStateTransition.setSourceName(cpState.getName());
                cpState.addTransition(cpStateTransition);
            }
        } else if (cpState.getType() == 3) {
            this.initReturnCode(element, cpState);
        } else {
            nodeList = element.getElementsByTagName(SEND_MESSAGE_TRANSITION);
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                object = (Element)nodeList.item(i);
                CpStateTransition cpStateTransition = cpStateMachine.newTransition(1);
                this.initSendMessageTransition((Element)object, cpStateTransition);
                cpStateTransition.setSourceName(cpState.getName());
                cpState.addTransition(cpStateTransition);
            }
        }
    }

    private void initStateName(Element element, CpState cpState) {
        String string = element.getAttribute(STATE_ID);
        cpState.setName(string);
    }

    private void initTimeout(Element element, CpState cpState) {
        NodeList nodeList = element.getElementsByTagName(TIMEOUT);
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string = XmlParsingUtils.getLeafText(element2);
            long l = XmlParsingUtils.millisFromDuration(string);
            cpState.setTimeoutInMillis(l);
        }
    }

    private void initReturnCode(Element element, CpState cpState) {
        NodeList nodeList = element.getElementsByTagName(RETURN);
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        String string = nodeList2.item(0).getNodeValue();
        cpState.setReturnCode(string);
    }

    private void initChildPolicyData(Element element, CpState cpState) {
        NodeList nodeList = element.getElementsByTagName(POLICY).item(0).getChildNodes();
        cpState.setChildPolicyName(nodeList.item(0).getNodeValue());
        nodeList = element.getElementsByTagName(ROLEMAP_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            Element element3 = (Element)element2.getElementsByTagName(PARENT).item(0);
            String string = XmlParsingUtils.getLeafText(element3);
            Element element4 = (Element)element2.getElementsByTagName(CHILD).item(0);
            String string2 = XmlParsingUtils.getLeafText(element4);
            cpState.setChildPolicyRole(string, string2);
        }
    }

    private void initTimeoutTransition(Element element, CpStateTransition cpStateTransition) {
        this.initTransitionName(element, cpStateTransition);
        this.initTarget(element, cpStateTransition);
    }

    private void initChildReturnTransition(Element element, CpStateTransition cpStateTransition) {
        this.initTransitionName(element, cpStateTransition);
        this.initTarget(element, cpStateTransition);
        this.initChildReturnCode(element, cpStateTransition);
        String string = cpStateTransition.getName();
        if (string == null || string.length() == 0) {
            cpStateTransition.setName(cpStateTransition.getChildReturn());
        }
    }

    private void initSendMessageTransition(Element element, CpStateTransition cpStateTransition) {
        this.initTransitionName(element, cpStateTransition);
        this.initTarget(element, cpStateTransition);
        this.initSender(element, cpStateTransition);
        this.initMessage(element, cpStateTransition);
    }

    private void initTransitionName(Element element, CpStateTransition cpStateTransition) {
        String string = element.getAttribute(TRANSITION_NAME);
        cpStateTransition.setName(string);
    }

    private void initTarget(Element element, CpStateTransition cpStateTransition) {
        Element element2 = (Element)element.getElementsByTagName(TARGET).item(0);
        String string = XmlParsingUtils.getLeafText(element2);
        cpStateTransition.setTargetName(string);
    }

    private void initSender(Element element, CpStateTransition cpStateTransition) {
        Element element2 = (Element)element.getElementsByTagName(SENDER).item(0);
        String string = XmlParsingUtils.getLeafText(element2);
        cpStateTransition.setSenderRole(string);
    }

    private void initChildReturnCode(Element element, CpStateTransition cpStateTransition) {
        Element element2 = (Element)element.getElementsByTagName(CHILD_RETURN).item(0);
        String string = XmlParsingUtils.getLeafText(element2);
        cpStateTransition.setChildReturn(string);
    }

    private void initMessage(Element element, CpStateTransition cpStateTransition) {
        Object object;
        NodeList nodeList = element.getElementsByTagName(MESSAGE);
        Element element2 = (Element)nodeList.item(0);
        String string = null;
        String string2 = null;
        if (element2 != null) {
            object = element2.getElementsByTagName(ENCODING);
            Element element3 = (Element)object.item(0);
            string = XmlParsingUtils.getLeafText(element3);
            object = element2.getElementsByTagName(SCHEMA);
            Element element4 = (Element)object.item(0);
            string2 = XmlParsingUtils.getLeafText(element4);
        }
        object = new BasicMessageDescription(string, string2);
        cpStateTransition.setMessageDescription((MessageDescription)object);
    }
}

