/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.conversation.base;

import com.ibm.conversation.CpState;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.CpStateTransition;
import com.ibm.conversation.MessageDescription;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class BasicCpStateMachineWriter {
    private BasicCpStateMachineWriter() {
    }

    public static String stringForm(CpStateMachine cpStateMachine) {
        StringWriter stringWriter = new StringWriter();
        try {
            BasicCpStateMachineWriter.writeStateMachine(stringWriter, "", cpStateMachine);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringWriter.toString();
    }

    public static void writeStateMachine(Writer writer, String string, CpStateMachine cpStateMachine) throws IOException {
        writer.write(string + "policyName = " + cpStateMachine.getPolicyName() + "\n");
        writer.write(string + "roles:\n");
        Iterator iterator = cpStateMachine.getRoles().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            writer.write(string + "    " + string2 + "\n");
        }
        writer.write(string + "initialState = " + cpStateMachine.getInitialStateName() + "\n");
        Iterator iterator2 = cpStateMachine.getStates().iterator();
        CpState cpState = null;
        while (iterator2.hasNext()) {
            cpState = (CpState)iterator2.next();
            writer.write(string + "state:\n");
            BasicCpStateMachineWriter.writeState(writer, string + "    ", cpState, cpStateMachine.getRoles());
        }
    }

    public static void writeState(Writer writer, String string, CpState cpState, Collection collection) throws IOException {
        Object object;
        Iterator iterator;
        if (cpState == null) {
            writer.write("(null state)");
            return;
        }
        writer.write(string + "stateName = " + cpState.getName() + "\n");
        writer.write(string + "stateType = " + cpState.getTypeString() + "\n");
        writer.write(string + "timeout = " + cpState.getTimeoutInMillis() + "\n");
        if (cpState.getType() == 2) {
            writer.write(string + "childPolicy = " + cpState.getChildPolicyName() + "\n");
            iterator = collection.iterator();
            object = null;
            writer.write(string + "rolemap:\n");
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                writer.write(string + "    " + (String)object + " -> " + cpState.getChildPolicyRole((String)object) + "\n");
            }
        }
        if (cpState.getType() == 3) {
            writer.write(string + "returnCode = " + cpState.getReturnCode() + "\n");
        } else {
            iterator = cpState.getTransitions().iterator();
            object = null;
            while (iterator.hasNext()) {
                object = (CpStateTransition)iterator.next();
                writer.write(string + "transition:\n");
                BasicCpStateMachineWriter.writeStateTransition(writer, string + "    ", (CpStateTransition)object);
            }
        }
    }

    public static void writeStateTransition(Writer writer, String string, CpStateTransition cpStateTransition) throws IOException {
        if (cpStateTransition == null) {
            writer.write(string + "(null transition)");
            return;
        }
        writer.write(string + "transitionName = " + cpStateTransition.getName() + "\n");
        writer.write(string + "transitionType = " + cpStateTransition.getTypeString() + "\n");
        writer.write(string + "sourceName = " + cpStateTransition.getSourceName() + "\n");
        writer.write(string + "targetName = " + cpStateTransition.getTargetName() + "\n");
        if (cpStateTransition.getType() == 1) {
            writer.write(string + "sender = " + cpStateTransition.getSenderRole() + "\n");
            writer.write(string + "messageDescription:\n");
            BasicCpStateMachineWriter.writeMessageDescription(writer, string + "    ", cpStateTransition.getMessageDescription());
        } else if (cpStateTransition.getType() == 2) {
            writer.write(string + "childReturn = " + cpStateTransition.getChildReturn() + "\n");
        }
    }

    public static void writeMessageDescription(Writer writer, String string, MessageDescription messageDescription) throws IOException {
        if (messageDescription == null) {
            writer.write(string + "(null MessageDescription)");
            return;
        }
        writer.write(string + "contentType = " + messageDescription.getContentType() + "\n");
        writer.write(string + "schema = " + messageDescription.getSchema() + "\n");
    }
}

