/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.conversation.base;

import com.ibm.conversation.CpState;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.CpStateTransition;
import com.ibm.conversation.base.BasicCpState;
import com.ibm.conversation.base.BasicCpStateMachineWriter;
import com.ibm.conversation.base.BasicCpStateTransition;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class BasicCpStateMachine
implements CpStateMachine {
    private String policyName = null;
    private Vector roles = new Vector();
    private String initialStateName = null;
    private HashMap states = new HashMap();

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String string) {
        this.policyName = string;
    }

    public Collection getRoles() {
        return this.roles;
    }

    public boolean hasRole(String string) {
        for (int i = 0; i < this.roles.size(); ++i) {
            if (!this.roles.elementAt(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addRole(String string) {
        if (string != null && !this.hasRole(string)) {
            this.roles.add(string);
        }
    }

    public CpState getInitialState() {
        return (CpState)this.states.get(this.initialStateName);
    }

    public String getInitialStateName() {
        return this.initialStateName;
    }

    public void setInitialStateName(String string) {
        this.initialStateName = string;
    }

    public int getNumStates() {
        return this.states.size();
    }

    public Collection getDecisionLogicCallbackNames(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.states.values().iterator();
        CpState cpState = null;
        while (iterator.hasNext()) {
            Collection collection;
            cpState = (CpState)iterator.next();
            if (cpState.hasTransitionWithSender(string)) {
                hashSet.add(cpState.getName());
            }
            if ((collection = cpState.getTransitions()) == null) continue;
            Iterator iterator2 = collection.iterator();
            CpStateTransition cpStateTransition = null;
            while (iterator2.hasNext()) {
                cpStateTransition = (CpStateTransition)iterator2.next();
                if (cpStateTransition.getType() != 1 || cpStateTransition.getSenderRole().equals(string)) continue;
                hashSet.add(cpStateTransition.getTargetName());
            }
        }
        return hashSet;
    }

    public Collection getStates() {
        return this.states.values();
    }

    public boolean hasState(String string) {
        return this.states.containsKey(string);
    }

    public CpState getState(String string) {
        return (CpState)this.states.get(string);
    }

    public void addState(CpState cpState) {
        this.states.put(cpState.getName(), cpState);
    }

    public CpStateTransition getTransition(String string, String string2) {
        CpState cpState = this.getState(string);
        if (cpState == null) {
            return null;
        }
        return cpState.getTransition(string2);
    }

    public void clear() {
        this.roles.clear();
        this.initialStateName = null;
        this.states.clear();
    }

    public CpState newState(int n) {
        return new BasicCpState(n);
    }

    public CpStateTransition newTransition(int n) {
        return new BasicCpStateTransition(n);
    }

    public String toString() {
        return BasicCpStateMachineWriter.stringForm(this);
    }
}

