/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.conversation.base;

import com.ibm.conversation.CpState;
import com.ibm.conversation.CpStateTransition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class BasicCpState
implements CpState {
    private int type = 0;
    private String name = null;
    private long timeout = 0L;
    private HashMap transitions = null;
    private String childPolicyName = null;
    private HashMap childPolicyRoleMap = null;
    private String returnCode = null;

    public BasicCpState(int n) {
        if (n == 1) {
            this.type = n;
            this.transitions = new HashMap();
        } else if (n == 2) {
            this.type = n;
            this.transitions = new HashMap();
            this.childPolicyRoleMap = new HashMap();
        } else if (n == 3) {
            this.type = n;
        }
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return CpState.TYPE_STRINGS[this.type];
    }

    public int getTypeFromString(String string) {
        int n = 0;
        if (CpState.TYPE_STRINGS[1].equals(string)) {
            n = 1;
        } else if (CpState.TYPE_STRINGS[2].equals(string)) {
            n = 2;
        } else if (CpState.TYPE_STRINGS[3].equals(string)) {
            n = 3;
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getTimeoutInMillis() {
        return this.timeout;
    }

    public void setTimeoutInMillis(long l) {
        if (l >= 0L) {
            this.timeout = l;
        }
    }

    public int getNumTransitions() {
        if (this.transitions == null) {
            return 0;
        }
        return this.transitions.size();
    }

    public Collection getTransitions() {
        if (this.transitions == null) {
            return null;
        }
        return this.transitions.values();
    }

    public Collection getTransitionsWithSender(String string) {
        Vector<CpStateTransition> vector = new Vector<CpStateTransition>();
        Iterator iterator = this.transitions.values().iterator();
        CpStateTransition cpStateTransition = null;
        while (iterator.hasNext()) {
            cpStateTransition = (CpStateTransition)iterator.next();
            if (cpStateTransition.getType() != 1 || !cpStateTransition.getSenderRole().equals(string)) continue;
            vector.add(cpStateTransition);
        }
        return vector;
    }

    public CpStateTransition getTransition(String string) {
        if (this.transitions == null) {
            return null;
        }
        return (CpStateTransition)this.transitions.get(string);
    }

    public boolean addTransition(CpStateTransition cpStateTransition) {
        boolean bl = true;
        if (bl) {
            cpStateTransition.setSourceName(this.getName());
            this.transitions.put(cpStateTransition.getName(), cpStateTransition);
        }
        return bl;
    }

    public boolean hasTransitionWithSender(String string) {
        if (this.transitions != null) {
            Iterator iterator = this.transitions.values().iterator();
            CpStateTransition cpStateTransition = null;
            while (iterator.hasNext()) {
                cpStateTransition = (CpStateTransition)iterator.next();
                if (cpStateTransition.getType() != 1 || !cpStateTransition.getSenderRole().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String getChildPolicyName() {
        return this.childPolicyName;
    }

    public boolean setChildPolicyName(String string) {
        this.childPolicyName = string;
        return this.type == 2;
    }

    public String getChildPolicyRole(String string) {
        if (this.childPolicyRoleMap == null) {
            return null;
        }
        return (String)this.childPolicyRoleMap.get(string);
    }

    public boolean setChildPolicyRole(String string, String string2) {
        if (this.childPolicyRoleMap != null) {
            this.childPolicyRoleMap.put(string, string2);
        }
        return this.type == 2;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public boolean setReturnCode(String string) {
        this.returnCode = string;
        return this.type == 3;
    }
}

