/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.conversation.base;

import com.ibm.conversation.ConversationContext;
import com.ibm.conversation.ConversationPolicyHandler;
import java.util.Stack;

public class BasicCpHandlerStack
implements ConversationContext {
    private Stack stack = new Stack();

    public int getNumPolicyLevels() {
        return this.stack.size();
    }

    public int getActivePolicyLevel() {
        return this.stack.size() - 1;
    }

    public String getActivePolicyName() {
        ConversationPolicyHandler conversationPolicyHandler = this.getActivePolicyHandler();
        if (conversationPolicyHandler == null) {
            return null;
        }
        return conversationPolicyHandler.getPolicyName();
    }

    public String getActiveSelfRole() {
        ConversationPolicyHandler conversationPolicyHandler = this.getActivePolicyHandler();
        if (conversationPolicyHandler == null) {
            return null;
        }
        return conversationPolicyHandler.getSelfRole();
    }

    public String getActiveStateName() {
        ConversationPolicyHandler conversationPolicyHandler = this.getActivePolicyHandler();
        if (conversationPolicyHandler == null) {
            return null;
        }
        return conversationPolicyHandler.getCurrentStateName();
    }

    public String getPolicyNameAt(int n) {
        ConversationPolicyHandler conversationPolicyHandler = this.getConversationPolicyHandlerAt(n);
        if (conversationPolicyHandler == null) {
            return null;
        }
        return conversationPolicyHandler.getPolicyName();
    }

    public String getSelfRoleAt(int n) {
        ConversationPolicyHandler conversationPolicyHandler = this.getConversationPolicyHandlerAt(n);
        if (conversationPolicyHandler == null) {
            return null;
        }
        return conversationPolicyHandler.getSelfRole();
    }

    public String getStateNameAt(int n) {
        ConversationPolicyHandler conversationPolicyHandler = this.getConversationPolicyHandlerAt(n);
        if (conversationPolicyHandler == null) {
            return null;
        }
        return conversationPolicyHandler.getCurrentStateName();
    }

    public ConversationPolicyHandler getActivePolicyHandler() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return (ConversationPolicyHandler)this.stack.peek();
    }

    public ConversationPolicyHandler getConversationPolicyHandlerAt(int n) {
        return (ConversationPolicyHandler)this.stack.elementAt(n);
    }

    public void push(ConversationPolicyHandler conversationPolicyHandler) {
        this.stack.push(conversationPolicyHandler);
    }

    public ConversationPolicyHandler pop() {
        return (ConversationPolicyHandler)this.stack.pop();
    }

    public void clear() {
        this.stack.clear();
    }

    public String prettyString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getNumPolicyLevels();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("Level " + i + ": ");
            stringBuffer.append("policy=" + this.getPolicyNameAt(i) + " ");
            stringBuffer.append("role=" + this.getSelfRoleAt(i) + " ");
            stringBuffer.append("state=" + this.getStateNameAt(i) + " ");
            if (i >= n - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.prettyString("\n\t");
    }
}

