/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.AbleBean;
import com.ibm.able.conversation.AbleOwned;
import com.ibm.conversation.MessageDescription;
import com.ibm.conversation.MessageTransform;
import com.ibm.conversation.MessageTransformFactory;
import java.util.Iterator;
import java.util.Vector;

public class AbleMessageTransformFactory
extends AbleOwned
implements MessageTransformFactory {
    private Vector transforms = new Vector();
    private MessageTransform defaultTransform = null;

    public AbleMessageTransformFactory() {
    }

    public AbleMessageTransformFactory(AbleBean ableBean) {
        super(ableBean);
    }

    public MessageTransform getDefaultTransform() {
        return this.defaultTransform;
    }

    public void setDefaultTransform(MessageTransform messageTransform) {
        this.defaultTransform = messageTransform;
    }

    public void addTransform(MessageDescription messageDescription, Class clazz) {
        this.transforms.add(new TransformTableEntry(messageDescription, clazz));
    }

    public void removeTransform(MessageDescription messageDescription) {
        TransformTableEntry transformTableEntry = this.findFirstMatch(messageDescription);
        if (transformTableEntry != null) {
            this.transforms.remove(transformTableEntry);
        }
    }

    public void clear() {
        this.transforms.clear();
    }

    private TransformTableEntry findFirstMatch(MessageDescription messageDescription) {
        Iterator iterator = this.transforms.iterator();
        while (iterator.hasNext()) {
            TransformTableEntry transformTableEntry = (TransformTableEntry)iterator.next();
            if (!transformTableEntry.desc.matches(messageDescription)) continue;
            return transformTableEntry;
        }
        return null;
    }

    public MessageTransform getTransform(MessageDescription messageDescription) {
        MessageTransform messageTransform = null;
        TransformTableEntry transformTableEntry = this.findFirstMatch(messageDescription);
        if (transformTableEntry != null) {
            try {
                messageTransform = (MessageTransform)transformTableEntry.transformClass.newInstance();
                if (!messageTransform.configureFor(messageDescription)) {
                    messageTransform = null;
                }
            }
            catch (Exception exception) {
                messageTransform = null;
                this.logException("getTransform", exception);
            }
        }
        if (messageTransform == null) {
            messageTransform = this.defaultTransform;
        }
        return messageTransform;
    }

    private class TransformTableEntry {
        public MessageDescription desc = null;
        public Class transformClass = null;

        TransformTableEntry(MessageDescription messageDescription, Class clazz) {
            this.desc = messageDescription;
            this.transformClass = clazz;
        }
    }
}

