/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.conversation.AbleOwned;
import com.ibm.conversation.ConversationPolicyListener;
import com.ibm.conversation.CpState;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.CpStateMachineHandler;
import com.ibm.conversation.CpStateTransition;
import com.ibm.conversation.MessageDescription;
import com.ibm.conversation.MessageTransform;
import com.ibm.conversation.MessageTransformFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class AbleCpStateMachineHandler
extends AbleOwned
implements CpStateMachineHandler,
Serializable {
    protected static final long serialVersionUID = 2003053000100500101L;
    public static final String CURRENT_STATE_PROPERTY = "CurrentState";
    private String currentStateName = null;
    private String selfRole = null;
    private transient CpStateMachine stateMachine = null;
    private transient MessageTransformFactory transformFactory = null;
    private transient ConversationPolicyListener outputListener = null;
    private transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public AbleCpStateMachineHandler() {
    }

    public AbleCpStateMachineHandler(AbleBean ableBean) {
        super(ableBean);
    }

    public AbleCpStateMachineHandler(CpStateMachine cpStateMachine, String string) {
        this.init(cpStateMachine, string);
    }

    public AbleCpStateMachineHandler(AbleBean ableBean, CpStateMachine cpStateMachine, String string) {
        super(ableBean);
        this.init(cpStateMachine, string);
    }

    public void init(CpStateMachine cpStateMachine, String string) {
        if (cpStateMachine != null && string != null && !cpStateMachine.getRoles().contains(string)) {
            String string2 = this.selfRole;
            String string3 = this.stateMachine == null ? null : this.stateMachine.getPolicyName();
            String string4 = cpStateMachine.getPolicyName();
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_Conv_StateMachineInitError", (Object[])new Object[]{string2, string3, string4, string}));
        }
        this.stateMachine = cpStateMachine;
        this.selfRole = string;
        this.currentStateName = this.stateMachine == null ? null : this.stateMachine.getInitialStateName();
    }

    public CpStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public CpState getCurrentState() {
        return this.stateMachine.getState(this.currentStateName);
    }

    public String getCurrentStateName() {
        return this.currentStateName;
    }

    public boolean isDecisionState() {
        CpState cpState = this.stateMachine.getState(this.currentStateName);
        if (cpState != null) {
            return this.isDecisionState(cpState);
        }
        return false;
    }

    public String getPolicyName() {
        if (this.stateMachine == null) {
            return null;
        }
        return this.stateMachine.getPolicyName();
    }

    public String getSelfRole() {
        return this.selfRole;
    }

    public Collection getDecisionLogicCallbackNames(String string) {
        return this.stateMachine.getDecisionLogicCallbackNames(string);
    }

    public Collection getRoles() {
        return this.stateMachine.getRoles();
    }

    public MessageTransformFactory getMessageTransformFactory() {
        return this.transformFactory;
    }

    public void setMessageTransformFactory(MessageTransformFactory messageTransformFactory) {
        this.transformFactory = messageTransformFactory;
    }

    public ConversationPolicyListener getOutputListener() {
        return this.outputListener;
    }

    public void setOutputListener(ConversationPolicyListener conversationPolicyListener) {
        this.outputListener = conversationPolicyListener;
    }

    public void start() {
        String string;
        this.validateConfiguration();
        this.currentStateName = string = this.stateMachine.getInitialStateName();
        if (this.isDecisionState()) {
            this.outputListener.decisionPoint(this.currentStateName, null);
        }
    }

    public boolean processMessage(Object object) {
        CpState cpState = this.stateMachine.getState(this.currentStateName);
        Iterator iterator = cpState.getTransitions().iterator();
        CpStateTransition cpStateTransition = null;
        String string = null;
        MessageDescription messageDescription = null;
        MessageTransform messageTransform = null;
        while (iterator.hasNext()) {
            cpStateTransition = (CpStateTransition)iterator.next();
            if (cpStateTransition.getType() != 1 || (string = cpStateTransition.getSenderRole()).equals(this.getSelfRole())) continue;
            messageDescription = cpStateTransition.getMessageDescription();
            if (!(messageTransform != null && messageTransform.configureFor(messageDescription) || (messageTransform = this.transformFactory.getTransform(messageDescription)) == null)) {
                messageTransform.setMessage(object);
            }
            if (messageTransform == null || !messageTransform.parseAndValidate()) continue;
            String string2 = cpStateTransition.getTargetName();
            CpState cpState2 = this.stateMachine.getState(string2);
            if (this.isDecisionState(cpState2)) {
                this.outputListener.decisionPoint(string2, messageTransform.getDecisionArgs());
            } else {
                this.outputListener.inboundData(string2, messageTransform.getDecisionArgs());
            }
            this.changeState(cpState2);
            return true;
        }
        this.outputListener.unexpectedMessage(object);
        return false;
    }

    public boolean processDecision(String string, Object[] objectArray) {
        MessageDescription messageDescription;
        MessageTransform messageTransform;
        CpState cpState = this.stateMachine.getState(this.currentStateName);
        CpStateTransition cpStateTransition = cpState.getTransition(string);
        if (cpStateTransition != null && cpStateTransition.getType() == 1 && cpStateTransition.getSenderRole().equals(this.getSelfRole()) && (messageTransform = this.transformFactory.getTransform(messageDescription = cpStateTransition.getMessageDescription())) != null) {
            messageTransform.setDecisionArgs(objectArray);
            if (messageTransform.formAndValidate()) {
                this.outputListener.outboundMessage(messageTransform.getMessage());
                String string2 = cpStateTransition.getTargetName();
                CpState cpState2 = this.stateMachine.getState(string2);
                if (this.isDecisionState(cpState2)) {
                    this.outputListener.decisionPoint(string2, null);
                }
                this.changeState(cpState2);
                return true;
            }
        }
        return false;
    }

    public boolean childReturn(String string) {
        CpState cpState = this.stateMachine.getState(this.currentStateName);
        Iterator iterator = cpState.getTransitions().iterator();
        CpStateTransition cpStateTransition = null;
        while (iterator.hasNext()) {
            cpStateTransition = (CpStateTransition)iterator.next();
            if (cpStateTransition.getType() != 2 || !cpStateTransition.getChildReturn().equals(string)) continue;
            String string2 = cpStateTransition.getTargetName();
            CpState cpState2 = this.stateMachine.getState(string2);
            if (this.isDecisionState(cpState2)) {
                this.outputListener.decisionPoint(string2, null);
            }
            this.changeState(cpState2);
            return true;
        }
        return false;
    }

    public boolean timerExpired(String string) {
        if (!string.equals(this.currentStateName)) {
            return false;
        }
        CpState cpState = this.stateMachine.getState(this.currentStateName);
        Iterator iterator = cpState.getTransitions().iterator();
        CpStateTransition cpStateTransition = null;
        while (iterator.hasNext()) {
            cpStateTransition = (CpStateTransition)iterator.next();
            if (cpStateTransition.getType() != 3) continue;
            String string2 = cpStateTransition.getTargetName();
            CpState cpState2 = this.stateMachine.getState(string2);
            if (this.isDecisionState(cpState2)) {
                this.outputListener.decisionPoint(string2, null);
            } else {
                this.outputListener.timeout(string2);
            }
            this.changeState(cpState2);
            return true;
        }
        return false;
    }

    protected boolean isDecisionState(CpState cpState) {
        return cpState.getType() == 1 && cpState.hasTransitionWithSender(this.getSelfRole());
    }

    protected void changeState(CpState cpState) {
        String string;
        if (cpState.getType() == 2) {
            string = cpState.getChildPolicyName();
            String string2 = cpState.getChildPolicyRole(this.getSelfRole());
            this.outputListener.cpLoad(string, string2);
        } else if (cpState.getType() == 3) {
            string = cpState.getReturnCode();
            this.outputListener.cpDone(string);
        }
        if (cpState.getTimeoutInMillis() > 0L) {
            this.outputListener.setTimer(cpState.getTimeoutInMillis(), cpState.getName());
        }
        string = this.currentStateName;
        this.currentStateName = cpState.getName();
        this.propertySupport.firePropertyChange(CURRENT_STATE_PROPERTY, string, this.currentStateName);
    }

    protected void validateConfiguration() {
        if (this.stateMachine == null) {
            throw new IllegalStateException("State machine is null");
        }
        if (this.selfRole == null) {
            throw new IllegalStateException("Self role is null");
        }
        if (!this.stateMachine.hasRole(this.selfRole)) {
            throw new IllegalStateException("Self role \"" + this.selfRole + "\" is not a valid role");
        }
        if (this.currentStateName == null) {
            throw new IllegalStateException("Current state is null");
        }
        if (!this.stateMachine.hasState(this.currentStateName)) {
            throw new IllegalStateException("Current state \"" + this.currentStateName + "\" is not a valid state name");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertySupport.firePropertyChange(propertyChangeEvent);
    }

    public String contextString() {
        return new String("policy=" + this.getPolicyName() + " role=" + this.getSelfRole() + " state=" + this.getCurrentStateName());
    }
}

