/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.AbleBean;
import com.ibm.able.conversation.AbleCpStateMachineHandler;
import com.ibm.able.conversation.AbleOwned;
import com.ibm.able.conversation.FilterByExtension;
import com.ibm.conversation.ConversationPolicyHandler;
import com.ibm.conversation.ConversationPolicyHandlerFactory;
import com.ibm.conversation.CpStateMachine;
import com.ibm.conversation.base.BasicCpStateMachine;
import com.ibm.conversation.base.CpXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class AbleConversationPolicyHandlerFactory
extends AbleOwned
implements ConversationPolicyHandlerFactory {
    public static final String STATE_MACHINE = "StateMachine";
    public static final String CP_PATH_NAME = "CpPathName";
    public static final String LAYOUT_PATH_NAME = "LayoutPathName";
    private static final String DEFAULT_REPOSITORY_PATH = ".";
    private static final String CP_FILE_EXTENSION = "xml";
    private static final String LAYOUT_FILE_EXTENSION = "glf";
    private String repositoryPathName = ".";
    private Hashtable propertySheets = null;

    public AbleConversationPolicyHandlerFactory() {
        this.propertySheets = new Hashtable();
    }

    public AbleConversationPolicyHandlerFactory(AbleBean ableBean) {
        super(ableBean);
        this.propertySheets = new Hashtable();
    }

    public AbleConversationPolicyHandlerFactory(String string) {
        this.repositoryPathName = string;
        this.propertySheets = new Hashtable();
    }

    public AbleConversationPolicyHandlerFactory(AbleBean ableBean, String string) {
        super(ableBean);
        this.repositoryPathName = string;
        this.propertySheets = new Hashtable();
    }

    public String getRepositoryPathName() {
        return this.repositoryPathName;
    }

    public void setRepositoryPathName(String string) {
        this.repositoryPathName = string;
        this.init();
    }

    public Set getPolicyNames() {
        return this.propertySheets.keySet();
    }

    public Collection getRoles(String string) {
        CpStateMachine cpStateMachine = (CpStateMachine)this.getProperty(string, STATE_MACHINE);
        if (cpStateMachine == null) {
            return null;
        }
        return cpStateMachine.getRoles();
    }

    public boolean isPolicySupported(String string, String string2) {
        Collection collection = this.getRoles(string);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            String string3 = null;
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (!string3.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public Properties getPropertySheet(String string) {
        return (Properties)this.propertySheets.get(string);
    }

    public Object getProperty(String string, String string2) {
        Properties properties = this.getPropertySheet(string);
        if (properties == null) {
            return null;
        }
        return properties.get(string2);
    }

    public String getLayoutFile(String string) {
        return (String)this.getProperty(string, LAYOUT_PATH_NAME);
    }

    protected Properties findOrCreatePropertySheet(String string) {
        Properties properties = null;
        if (this.propertySheets.containsKey(string)) {
            properties = (Properties)this.propertySheets.get(string);
        } else {
            properties = new Properties();
            this.propertySheets.put(string, properties);
        }
        return properties;
    }

    public String getPartnerRole(String string, String string2) {
        Collection collection = this.getRoles(string);
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (string3.equals(string2)) continue;
            return string3;
        }
        return null;
    }

    public void init() {
        boolean bl = true;
        String string = null;
        File file = null;
        if (this.repositoryPathName == null) {
            string = "CP repository path is null.";
            bl = false;
        }
        if (bl) {
            file = new File(this.repositoryPathName);
            if (!file.exists()) {
                string = "CP repository \"" + this.repositoryPathName + "\" doesn't exist";
                bl = false;
            } else if (!file.isDirectory()) {
                string = "CP repository \"" + this.repositoryPathName + "\" isn't a directory";
                bl = false;
            } else if (!file.canRead()) {
                string = "CP repository \"" + this.repositoryPathName + "\" is unreadable";
                bl = false;
            }
        }
        if (!bl) {
            String string2 = "Can't initialize: ";
            this.logMessage(4L, "init", string2 + string);
            return;
        }
        File[] fileArray = file.listFiles(new FilterByExtension(CP_FILE_EXTENSION));
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || !fileArray[i].canRead()) continue;
            this.addConversationPolicy(fileArray[i].getAbsolutePath());
        }
        File[] fileArray2 = file.listFiles(new FilterByExtension(LAYOUT_FILE_EXTENSION));
        for (int i = 0; i < fileArray2.length; ++i) {
            if (!fileArray2[i].isFile() || !fileArray2[i].canRead()) continue;
            this.addConversationPolicyLayout(fileArray2[i].getAbsolutePath());
        }
    }

    public ConversationPolicyHandler getPolicyHandler(String string, String string2) {
        Properties properties = this.getPropertySheet(string);
        if (properties == null) {
            String string3 = "Unknown policy name \"" + string + "\". Known CP names={" + this.listCpNames() + "}";
            this.logMessage(2L, "getPolicyHandler", string3);
            return null;
        }
        CpStateMachine cpStateMachine = (CpStateMachine)properties.get(STATE_MACHINE);
        if (cpStateMachine == null) {
            String string4 = "Null state machine for CP " + string;
            this.logMessage(2L, "getPolicyHandler", string4);
            return null;
        }
        AbleCpStateMachineHandler ableCpStateMachineHandler = new AbleCpStateMachineHandler(this.getAbleOwner(), cpStateMachine, string2);
        return ableCpStateMachineHandler;
    }

    protected void addConversationPolicy(String string) {
        BasicCpStateMachine basicCpStateMachine = new BasicCpStateMachine();
        CpXmlParser cpXmlParser = new CpXmlParser();
        try {
            cpXmlParser.loadDocument(string);
            cpXmlParser.initCpStateMachine(basicCpStateMachine);
            String string2 = basicCpStateMachine.getPolicyName();
            if (string2 != null) {
                Properties properties = this.findOrCreatePropertySheet(string2);
                properties.put(CP_PATH_NAME, string);
                properties.put(STATE_MACHINE, basicCpStateMachine);
            }
        }
        catch (Exception exception) {
            this.logException("addConversationPolicy", exception);
        }
    }

    protected void addConversationPolicyLayout(String string) {
        try {
            File file = new File(string);
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            String string2 = properties.getProperty("POLICYNAME");
            if (string2 == null) {
                this.logMessage(2L, "addConversationPolicyLayout", "No policy name in layout file \"" + file.getAbsolutePath() + "\"");
            } else {
                Properties properties2 = this.findOrCreatePropertySheet(string2);
                properties2.put(LAYOUT_PATH_NAME, string);
            }
        }
        catch (Exception exception) {
            this.logException("addConversationPolicyLayout", exception);
        }
    }

    private String listCpNames() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getPolicyNames().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

