/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.conversation.AbleConversation;
import com.ibm.able.conversation.AbleConversationPolicyHandlerFactory;
import com.ibm.able.conversation.AbleMessageTransformFactory;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationContext;
import com.ibm.conversation.ConversationManager;
import com.ibm.conversation.ConversationMetaData;
import com.ibm.conversation.ConversationPolicyHandlerFactory;
import com.ibm.conversation.DecisionLogicAdapter;
import com.ibm.conversation.MessageSystemAdapter;
import com.ibm.conversation.MessageTransformFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class AbleConversationManager
extends AbleObject
implements ConversationManager {
    public static final String NEW_CONVERSATION_PROPERTY = "NewConversation";
    public static final String CONVERSATION_COMPLETED_PROPERTY = "ConversationCompleted";
    public static final String CP_LAYOUT_LOADED_PROPERTY = "CpLayoutLoaded";
    private int cycleCount = 0;
    private MessageSystemAdapter defaultMessageSystem = null;
    private DecisionLogicAdapter defaultDecisionLogic = null;
    private AbleConversationPolicyHandlerFactory cphFactory = null;
    private AbleMessageTransformFactory messageTransformFactory = null;
    private String setupPolicyName = null;
    private String setupInitiatorRole = null;
    private String setupResponderRole = null;
    private Hashtable activeConversations = null;
    private HashSet completedConversations = null;
    private int conversationCounter = 0;

    public AbleConversationManager() throws AbleException {
        this.createLocalInstanceVariables();
    }

    public AbleConversationManager(String string) throws AbleException {
        super(string);
        this.createLocalInstanceVariables();
    }

    public AbleConversationManager(String string, String string2) throws AbleException {
        super(string, string2);
        this.createLocalInstanceVariables();
    }

    private void createLocalInstanceVariables() {
        this.activeConversations = new Hashtable();
        this.completedConversations = new HashSet();
        this.cphFactory = new AbleConversationPolicyHandlerFactory((AbleBean)this);
        this.messageTransformFactory = new AbleMessageTransformFactory((AbleBean)this);
    }

    public int getNumConversations() {
        return this.activeConversations.size();
    }

    public Set getConversationIds() {
        return this.activeConversations.keySet();
    }

    public ConversationMetaData getMetaData(String string) {
        Conversation conversation = this.getConversation(string);
        if (conversation == null) {
            return null;
        }
        return conversation.getMetaData();
    }

    public ConversationContext getContext(String string) {
        Conversation conversation = this.getConversation(string);
        if (conversation == null) {
            return null;
        }
        return conversation.getContext();
    }

    public String getInitialPolicyName() {
        return this.setupPolicyName;
    }

    public String getInitiatorRole() {
        return this.setupInitiatorRole;
    }

    public String getResponderRole() {
        return this.setupResponderRole;
    }

    public void setInitialPolicy(String string, String string2, String string3) {
        this.setupPolicyName = string;
        this.setupInitiatorRole = string2;
        this.setupResponderRole = string3;
    }

    public Conversation getConversation(String string) {
        return (Conversation)this.activeConversations.get(string);
    }

    public boolean isConversationCompleted(String string) {
        return this.completedConversations.contains(string);
    }

    public MessageTransformFactory getMessageTransformFactory() {
        return this.messageTransformFactory;
    }

    public ConversationPolicyHandlerFactory getConversationPolicyHandlerFactory() {
        return this.cphFactory;
    }

    public void setMessageSystemAdapter(MessageSystemAdapter messageSystemAdapter) {
        this.defaultMessageSystem = messageSystemAdapter;
    }

    public void setDecisionLogicAdapter(DecisionLogicAdapter decisionLogicAdapter) {
        this.defaultDecisionLogic = decisionLogicAdapter;
    }

    public String getConversationPolicyRepositoryPath() {
        return this.cphFactory.getRepositoryPathName();
    }

    public void setConversationPolicyRepositoryPath(String string) {
        this.cphFactory.setRepositoryPathName(string);
    }

    public String getPolicyLayoutFile(String string) {
        return this.cphFactory.getLayoutFile(string);
    }

    protected String createConversationId() {
        String string = null;
        boolean bl = false;
        while (!bl) {
            string = "" + this.conversationCounter;
            ++this.conversationCounter;
            if (this.activeConversations.containsKey(string)) continue;
            bl = true;
        }
        return string;
    }

    public synchronized Conversation newConversation(ConversationMetaData conversationMetaData, boolean bl) {
        String string = this.createConversationId();
        AbleConversation ableConversation = new AbleConversation(this, string);
        conversationMetaData.setSelfConversationId(string);
        ableConversation.setMetaData(conversationMetaData);
        ableConversation.setConversationPolicyHandlerFactory(this.cphFactory);
        ableConversation.setDecisionLogicAdapter(this.defaultDecisionLogic);
        ableConversation.setMessageSystemAdapter(this.defaultMessageSystem);
        ableConversation.setMessageTransformFactory(this.messageTransformFactory);
        String string2 = null;
        string2 = bl ? this.setupInitiatorRole : this.setupResponderRole;
        if (this.setupPolicyName != null && string2 != null) {
            ableConversation.setRootPolicy(this.setupPolicyName, string2);
        }
        this.activeConversations.put(string, ableConversation);
        this.firePropertyChange(NEW_CONVERSATION_PROPERTY, null, string);
        return ableConversation;
    }

    public synchronized void closeConversation(String string) {
        AbleConversation ableConversation = (AbleConversation)this.activeConversations.get(string);
        if (ableConversation != null) {
            ableConversation.dispatchOutputs();
            this.activeConversations.remove(string);
            this.completedConversations.add(string);
            this.firePropertyChange(CONVERSATION_COMPLETED_PROPERTY, null, string);
        }
    }

    public synchronized void process() throws AbleException {
        super.process();
        Iterator iterator = this.activeConversations.values().iterator();
        AbleConversation ableConversation = null;
        while (iterator.hasNext()) {
            ableConversation = (AbleConversation)iterator.next();
            ableConversation.dispatchOutputs();
        }
        ++this.cycleCount;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.chgSupport;
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }
}

