/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.Able;
import com.ibm.able.conversation.AbleConversationManager;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationContext;
import com.ibm.conversation.ConversationException;
import com.ibm.conversation.ConversationMetaData;
import com.ibm.conversation.ConversationPolicyHandler;
import com.ibm.conversation.ConversationPolicyHandlerFactory;
import com.ibm.conversation.ConversationPolicyListener;
import com.ibm.conversation.DecisionDataHandle;
import com.ibm.conversation.DecisionLogicAdapter;
import com.ibm.conversation.MessageHandle;
import com.ibm.conversation.MessageSystemAdapter;
import com.ibm.conversation.MessageTransformFactory;
import com.ibm.conversation.base.BasicCpHandlerStack;
import com.ibm.conversation.base.BasicDecisionDataHandle;
import com.ibm.conversation.base.BasicMessageHandle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;

public class AbleConversation
implements Conversation {
    public static final String CHILD_CP_DONE_PROPERTY = "ChildCpDone";
    public static final String CHILD_CP_LOADED_PROPERTY = "ChildCpLoaded";
    AbleConversationManager conversationManager = null;
    private String convId = null;
    ConversationMetaData metaData = null;
    private DecisionLogicAdapter decisionLogic = null;
    private MessageSystemAdapter messageSystem = null;
    private MessageTransformFactory transformFactory = null;
    private ConversationPolicyHandlerFactory cphFactory = null;
    private String rootPolicyName = null;
    private String rootPolicyRole = null;
    private static int cycleCounter = 0;
    private boolean started = false;
    BasicCpHandlerStack policyHandlers = null;
    private LinkedList pendingOutputEvents = null;
    private PropertyChangeSupport propertySupport = null;
    private ConversationPolicyListener outputListener = null;

    public AbleConversation(AbleConversationManager ableConversationManager, String string) {
        this.conversationManager = ableConversationManager;
        this.convId = string;
        this.policyHandlers = new BasicCpHandlerStack();
        this.pendingOutputEvents = new LinkedList();
        this.propertySupport = new PropertyChangeSupport(this);
        this.outputListener = new OutputListener();
    }

    public String getConversationId() {
        return this.convId;
    }

    public void setMetaData(ConversationMetaData conversationMetaData) {
        this.metaData = conversationMetaData;
        if (this.convId != null) {
            this.metaData.setSelfConversationId(this.convId);
        } else {
            this.convId = this.metaData.getSelfConversationId();
        }
    }

    public ConversationMetaData getMetaData() {
        return this.metaData;
    }

    public ConversationContext getContext() {
        return this.policyHandlers;
    }

    public void setRootPolicy(String string, String string2) {
        this.rootPolicyName = string;
        this.rootPolicyRole = string2;
    }

    public String getRootPolicyName() {
        return this.rootPolicyName;
    }

    public String getRootPolicyRole() {
        return this.rootPolicyRole;
    }

    public String getActivePolicyName() {
        return this.policyHandlers.getActivePolicyName();
    }

    public String getActivePolicyRole() {
        return this.policyHandlers.getActiveSelfRole();
    }

    public ConversationPolicyHandler getConversationPolicyHandlerAt(int n) {
        return this.policyHandlers.getConversationPolicyHandlerAt(n);
    }

    public ConversationPolicyHandler getActivePolicyHandler() {
        return this.policyHandlers.getActivePolicyHandler();
    }

    public void setMessageTransformFactory(MessageTransformFactory messageTransformFactory) {
        this.transformFactory = messageTransformFactory;
    }

    public void setConversationPolicyHandlerFactory(ConversationPolicyHandlerFactory conversationPolicyHandlerFactory) {
        this.cphFactory = conversationPolicyHandlerFactory;
    }

    public DecisionLogicAdapter getDecisionLogicAdapter() {
        return this.decisionLogic;
    }

    public void setDecisionLogicAdapter(DecisionLogicAdapter decisionLogicAdapter) {
        this.decisionLogic = decisionLogicAdapter;
    }

    public MessageSystemAdapter getMessageSystemAdapter() {
        return this.messageSystem;
    }

    public void setMessageSystemAdapter(MessageSystemAdapter messageSystemAdapter) {
        this.messageSystem = messageSystemAdapter;
    }

    public void start() {
        this.policyHandlers.clear();
        this.loadPolicy(this.rootPolicyName, this.rootPolicyRole);
        if (this.started) {
            this.printDebug("reset(): Warning: conversation is already started!");
        }
        this.started = true;
        ConversationPolicyHandler conversationPolicyHandler = this.getActivePolicyHandler();
        conversationPolicyHandler.start();
    }

    protected void loadPolicy(String string, String string2) {
        ConversationPolicyHandler conversationPolicyHandler = this.cphFactory.getPolicyHandler(string, string2);
        if (conversationPolicyHandler != null) {
            conversationPolicyHandler.setOutputListener(this.outputListener);
            conversationPolicyHandler.setMessageTransformFactory(this.transformFactory);
            this.policyHandlers.push(conversationPolicyHandler);
            this.firePropertyChange(new PropertyChangeEvent(this, CHILD_CP_LOADED_PROPERTY, null, this.getConversationId()));
        }
    }

    protected void popPolicy(String string) {
        if (this.policyHandlers.getNumPolicyLevels() < 1) {
            return;
        }
        this.policyHandlers.pop();
        ConversationPolicyHandler conversationPolicyHandler = this.policyHandlers.getActivePolicyHandler();
        if (conversationPolicyHandler == null) {
            this.conversationManager.closeConversation(this.metaData.getSelfConversationId());
        } else {
            conversationPolicyHandler.childReturn(string);
        }
        this.firePropertyChange(new PropertyChangeEvent(this, CHILD_CP_DONE_PROPERTY, null, this.getConversationId()));
    }

    public synchronized void processMessage(MessageHandle messageHandle) throws ConversationException {
        ConversationPolicyHandler conversationPolicyHandler = this.policyHandlers.getActivePolicyHandler();
        if (conversationPolicyHandler == null) {
            throw new ConversationException("No policy handler");
        }
        conversationPolicyHandler.processMessage(messageHandle.getMessage());
    }

    public synchronized void processDecision(DecisionDataHandle decisionDataHandle) throws ConversationException {
        ConversationPolicyHandler conversationPolicyHandler = this.policyHandlers.getActivePolicyHandler();
        if (conversationPolicyHandler == null) {
            throw new ConversationException("No policy handler");
        }
        boolean bl = conversationPolicyHandler.processDecision(decisionDataHandle.getName(), decisionDataHandle.getArgs());
        if (!bl) {
            throw new ConversationException(Able.NlsMsg((String)"Ex_Conv_NoSuchOutboundTransition", (Object[])new Object[]{decisionDataHandle}));
        }
    }

    public void dispatchOutputs() {
        String string = "dispatchOutputs[" + cycleCounter++ + "]: ";
        LinkedList linkedList = this.getPendingOutputEvents();
        if (linkedList.size() > 0) {
            OutputEvent outputEvent = null;
            int n = 0;
            while (linkedList.size() > 0) {
                ++n;
                outputEvent = (OutputEvent)linkedList.removeFirst();
                int n2 = outputEvent.getType();
                if (n2 == 1) {
                    this.decisionLogic.decisionPoint(this, outputEvent.getDecisionDataHandle());
                    continue;
                }
                if (n2 == 2) {
                    this.decisionLogic.inboundData(this, outputEvent.getDecisionDataHandle());
                    continue;
                }
                if (n2 == 3) {
                    this.decisionLogic.unexpectedMessage(this, outputEvent.getMessageHandle());
                    continue;
                }
                if (n2 == 4) {
                    this.decisionLogic.timeout(this, outputEvent.getString());
                    continue;
                }
                if (n2 == 5) {
                    this.popPolicy(outputEvent.getString());
                    continue;
                }
                if (n2 == 6) {
                    this.messageSystem.sendMessage(this, outputEvent.getMessageHandle());
                    continue;
                }
                if (n2 == 7) {
                    this.loadPolicy(outputEvent.getString(), outputEvent.getString2());
                    continue;
                }
                this.printDebug(string + "unknown event type " + n2);
            }
        }
    }

    protected final synchronized void addPendingOutputEvent(OutputEvent outputEvent) {
        this.pendingOutputEvents.addLast(outputEvent);
    }

    private final synchronized LinkedList getPendingOutputEvents() {
        LinkedList linkedList = this.pendingOutputEvents;
        this.pendingOutputEvents = new LinkedList();
        return linkedList;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertySupport.firePropertyChange(propertyChangeEvent);
    }

    void printDebug(String string) {
        this.conversationManager.getLogger().text(1L, string);
    }

    private class OutputEvent {
        static final int NO_TYPE = 0;
        static final int DECISION_POINT = 1;
        static final int INBOUND_DATA = 2;
        static final int UNEXPECTED_MESSAGE = 3;
        static final int TIMEOUT = 4;
        static final int CP_DONE = 5;
        static final int OUTBOUND_MESSAGE = 6;
        static final int LOAD_POLICY = 7;
        private int type = 0;
        private DecisionDataHandle ddh = null;
        private MessageHandle mh = null;
        private String str = null;
        private String str2 = null;

        OutputEvent(int n, DecisionDataHandle decisionDataHandle) {
            this.type = n;
            this.ddh = decisionDataHandle;
        }

        OutputEvent(int n, MessageHandle messageHandle) {
            this.type = n;
            this.mh = messageHandle;
        }

        OutputEvent(int n, MessageHandle messageHandle, String string) {
            this.type = n;
            this.mh = messageHandle;
            this.str = string;
        }

        OutputEvent(int n, DecisionDataHandle decisionDataHandle, String string) {
            this.type = n;
            this.ddh = decisionDataHandle;
            this.str = string;
        }

        OutputEvent(int n, String string) {
            this.type = n;
            this.str = string;
        }

        OutputEvent(int n, String string, String string2) {
            this.type = n;
            this.str = string;
            this.str2 = string;
        }

        public int getType() {
            return this.type;
        }

        public String getString() {
            return this.str;
        }

        public String getString2() {
            return this.str2;
        }

        public MessageHandle getMessageHandle() {
            return this.mh;
        }

        public DecisionDataHandle getDecisionDataHandle() {
            return this.ddh;
        }
    }

    private class OutputListener
    implements ConversationPolicyListener {
        OutputListener() {
        }

        public void decisionPoint(String string, Object[] objectArray) {
            BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string, objectArray);
            OutputEvent outputEvent = new OutputEvent(1, basicDecisionDataHandle);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }

        public void decisionPoint(String string) {
            BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string, null);
            OutputEvent outputEvent = new OutputEvent(1, basicDecisionDataHandle);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }

        public void inboundData(String string, Object[] objectArray) {
            BasicDecisionDataHandle basicDecisionDataHandle = new BasicDecisionDataHandle(string, objectArray);
            OutputEvent outputEvent = new OutputEvent(2, basicDecisionDataHandle);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }

        public void outboundMessage(Object object) {
            BasicMessageHandle basicMessageHandle = new BasicMessageHandle(object);
            OutputEvent outputEvent = new OutputEvent(6, basicMessageHandle);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }

        public void cpDone(String string) {
            OutputEvent outputEvent = new OutputEvent(5, string);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }

        public void cpLoad(String string, String string2) {
            OutputEvent outputEvent = new OutputEvent(7, string, string2);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }

        public void timeout(String string) {
            OutputEvent outputEvent = new OutputEvent(4, string);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }

        public void setTimer(long l, String string) {
            StateTimer stateTimer = new StateTimer(string, l);
            stateTimer.start();
        }

        public void unexpectedMessage(Object object) {
            BasicMessageHandle basicMessageHandle = new BasicMessageHandle(object);
            OutputEvent outputEvent = new OutputEvent(3, basicMessageHandle, null);
            AbleConversation.this.addPendingOutputEvent(outputEvent);
        }
    }

    private class StateTimer
    extends Thread {
        String stateName = null;
        long timeoutValue = 0L;

        StateTimer(String string, long l) {
            this.stateName = string;
            this.timeoutValue = l;
        }

        public void run() {
            if (this.timeoutValue > 0L) {
                try {
                    StateTimer.sleep(this.timeoutValue);
                    ConversationPolicyHandler conversationPolicyHandler = AbleConversation.this.policyHandlers.getActivePolicyHandler();
                    conversationPolicyHandler.timerExpired(this.stateName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

