/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.petrinet;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.beans.petrinet.AblePetriNet;
import com.ibm.able.beans.petrinet.AblePetriNode;
import com.ibm.able.data.AbleExpression;
import com.ibm.able.data.AbleGenericLiteral;
import com.ibm.able.data.AbleLiteral;
import com.ibm.able.data.AbleVariable;
import com.ibm.able.rules.AbleConsequentClause;
import com.ibm.able.rules.AbleIfThenElseRule;
import com.ibm.able.rules.AbleInferenceEngine;
import java.io.Serializable;
import java.util.Vector;

public class AblePetriPlace
extends AblePetriNode
implements Serializable {
    static final long serialVersionUID = 2005020100000000001L;
    protected Vector myColorSets;
    protected AbleExpression myInitializationExpr;
    protected String myExpressionText = "";
    protected Vector myCurrentMarking;
    protected Vector myTokens = new Vector();
    protected AblePetriNet myPetriNet = null;

    public AblePetriPlace() throws AbleException {
        super("Place");
    }

    public AblePetriPlace(String string) throws AbleException {
        super(string);
    }

    public void setCurrentMarking(Vector vector) {
        this.myCurrentMarking = vector;
    }

    public Vector getCurrentMarking() {
        return this.myCurrentMarking;
    }

    public void setInitializationExpression(AbleExpression ableExpression) {
        this.myInitializationExpr = ableExpression;
    }

    public AbleExpression getInitializationExpression() {
        return this.myInitializationExpr;
    }

    public void setColorSets(Vector vector) {
        this.myColorSets = vector;
    }

    public Vector getColorSets() {
        return this.myColorSets;
    }

    public void setTokens(Vector vector) {
        this.myTokens = vector;
    }

    public Vector getTokens() {
        return this.myTokens;
    }

    public synchronized int getNumTokens() {
        return this.myTokens.size();
    }

    public synchronized void addToken(Object object) {
        this.myTokens.add(object);
        try {
            this.dataChanged(this);
            this.chgSupport.firePropertyChange("numtokens", null, this.myTokens);
        }
        catch (AbleException ableException) {
            // empty catch block
        }
    }

    public synchronized void addTokens(Vector vector) {
        this.myTokens.addAll(vector);
        this.chgSupport.firePropertyChange("numtokens", null, this.myTokens);
    }

    public synchronized void removeToken(Object object) {
        this.myTokens.remove(object);
        try {
            this.dataChanged(this);
            this.chgSupport.firePropertyChange("numtokens", null, this.myTokens);
        }
        catch (AbleException ableException) {
            // empty catch block
        }
    }

    public synchronized Vector removeNTokens(int n) {
        Vector vector = new Vector();
        for (int i = 0; i < n; ++i) {
            vector.add(this.myTokens.remove(0));
            try {
                this.dataChanged(this);
                this.chgSupport.firePropertyChange("numtokens", null, this.myTokens);
                continue;
            }
            catch (AbleException ableException) {
                // empty catch block
            }
        }
        return vector;
    }

    public void init() throws AbleException {
        AbleIfThenElseRule ableIfThenElseRule;
        Vector vector = new Vector();
        if (this.parent instanceof AblePetriNet) {
            this.myPetriNet = (AblePetriNet)this.parent;
        }
        this.myTokens.clear();
        AbleVariable ableVariable = this.myPetriNet.getVariable("tokens");
        if (ableVariable != null) {
            ableVariable.setValue((AbleLiteral)new AbleGenericLiteral(vector));
        }
        if ((ableIfThenElseRule = (AbleIfThenElseRule)this.myPetriNet.getRule(this.name)) != null) {
            this.fireRule(ableIfThenElseRule);
            this.myTokens = (Vector)ableVariable.getGenericValue();
            System.out.println("Initialize marking for Place " + this.getName() + " with " + this.myTokens.size() + "tokens.");
        }
        try {
            this.dataChanged(this);
            this.chgSupport.firePropertyChange("numtokens", null, this.myTokens);
        }
        catch (AbleException ableException) {
            // empty catch block
        }
    }

    private void fireRule(AbleIfThenElseRule ableIfThenElseRule) throws AbleException {
        Vector vector = ableIfThenElseRule.getThenClauses();
        AbleInferenceEngine ableInferenceEngine = this.myPetriNet.getInferenceEngine();
        for (int i = 0; i < vector.size(); ++i) {
            AbleConsequentClause ableConsequentClause = (AbleConsequentClause)vector.get(i);
            if (ableConsequentClause == null) continue;
            ableInferenceEngine.evalConsequentClause(ableConsequentClause);
        }
    }

    public String getExpressionText() {
        return this.myExpressionText;
    }

    public void setExpressionText(String string) {
        this.myExpressionText = string;
    }

    public String toString() {
        return this.name + " Place contains " + this.myTokens.size() + " tokens." + Able.LS;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

