/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.decisiontree;

import com.ibm.able.beans.decisiontree.Data;
import java.io.Serializable;

public class Discretize
implements Serializable {
    static final long serialVersionUID = 2000100100000000001L;
    Data data;
    float[][] intervalsReal;
    short[] sizeIntervalsReal;

    public Discretize(Data data) {
        this.data = data;
        if (this.data.noReals > 0) {
            this.intervalsReal = new float[this.data.noReals][];
            this.sizeIntervalsReal = new short[this.data.noReals];
        }
    }

    public short[] discretizeOneExample(short[] sArray, short n, float[] fArray, short s) {
        int n2;
        short[] sArray2 = new short[this.data.noFeats];
        for (n2 = 0; n2 < n; ++n2) {
            sArray2[n2] = sArray[n2];
        }
        int n3 = n;
        for (n2 = 0; n2 < s; ++n2) {
            int n4;
            float f = fArray[n2];
            for (n4 = 1; n4 < this.sizeIntervalsReal[n2]; ++n4) {
                if (!(f < this.intervalsReal[n2][n4])) continue;
                sArray2[n3 + n2] = (short)(n4 - 1);
                break;
            }
            if (n4 != this.sizeIntervalsReal[n2]) continue;
            sArray2[n3 + n2] = (short)(n4 - 1);
        }
        return sArray2;
    }

    public void createFixedIntervals(short n) {
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        this.extendNominals(this.data, (short)n);
        for (int i = 0; i < this.data.noReals; ++i) {
            int n2;
            float f3;
            int n3;
            this.intervalsReal[i] = new float[n + 1];
            this.sizeIntervalsReal[i] = (short)(n + 1);
            for (n3 = 0; n3 < this.data.noTrainExamples; ++n3) {
                f3 = this.data.valsTrainReal[n3][i];
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            float f4 = (f2 - f) / (float)n;
            for (int j = 0; j < n; ++j) {
                float f5 = f + f4 * (float)j;
                float f6 = f5 + f4;
                this.intervalsReal[i][j] = f5;
                if (j == n - 1) {
                    this.intervalsReal[i][j + 1] = f6;
                }
                String string = new String("[" + f5 + "," + f6 + "]");
                this.data.namesValsNominal[this.data.noNominals + i][j] = new String(string);
            }
            for (n3 = 0; n3 < this.data.noTrainExamples; ++n3) {
                f3 = this.data.valsTrainReal[n3][i];
                n2 = new Float((f3 - f) / f4).intValue();
                if (n2 == n) {
                    --n2;
                }
                this.data.valsTrainNominal[n3][this.data.noNominals + i] = (short)n2;
            }
            for (n3 = 0; n3 < this.data.noTestExamples; ++n3) {
                f3 = this.data.valsTestReal[n3][i];
                n2 = new Float((f3 - f) / f4).intValue();
                if (n2 >= n) {
                    n2 = n - 1;
                }
                this.data.valsTestNominal[n3][this.data.noNominals + i] = (short)n2;
            }
        }
        this.data.noNominals = this.data.noFeats;
    }

    protected void extendNominals(Data data, short n) {
        int n2;
        int n3;
        short[] sArray = new short[data.noFeats];
        String[] stringArray = new String[data.noFeats];
        String[][] stringArrayArray = new String[data.noFeats][];
        for (n3 = 0; n3 < data.noNominals; ++n3) {
            sArray[n3] = data.countNominal[n3];
            stringArray[n3] = data.namesNominal[n3];
            stringArrayArray[n3] = data.namesValsNominal[n3];
        }
        for (n3 = 0; n3 < data.noReals; ++n3) {
            sArray[data.noNominals + n3] = n;
            stringArray[data.noNominals + n3] = data.namesReal[n3];
            stringArrayArray[data.noNominals + n3] = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArrayArray[data.noNominals + n3][i] = null;
            }
        }
        data.countNominal = sArray;
        data.namesNominal = stringArray;
        data.namesValsNominal = stringArrayArray;
        short[][] sArray2 = new short[data.noTrainExamples][data.noFeats];
        short[][] sArray3 = new short[data.noTestExamples][data.noFeats];
        for (n3 = 0; n3 < data.noTrainExamples; ++n3) {
            for (n2 = 0; n2 < data.noNominals; ++n2) {
                sArray2[n3][n2] = data.valsTrainNominal[n3][n2];
            }
        }
        for (n3 = 0; n3 < data.noTestExamples; ++n3) {
            for (n2 = 0; n2 < data.noNominals; ++n2) {
                sArray3[n3][n2] = data.valsTestNominal[n3][n2];
            }
        }
        data.valsTrainNominal = sArray2;
        data.valsTestNominal = sArray3;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 2000.";
    }
}

