/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.decisiontree;

import com.ibm.able.AbleException;
import com.ibm.able.beans.decisiontree.FunctionsOnStream;
import com.ibm.able.data.AbleDataException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;

public class Data
implements Serializable {
    static final long serialVersionUID = 2000100100000000001L;
    static final short MAX_CLASSES = 100;
    static final short MAX_FEATURES = 200;
    static final short MAX_FEATVALS = 50;
    char[] typeFeat;
    int noTrainExamples = 0;
    int noTestExamples = 0;
    short noClasses = 0;
    short noFeats = 0;
    short noNominals = 0;
    short noReals = 0;
    String[] namesClass;
    String[] namesNominal;
    String[] namesReal;
    short[] countNominal;
    String[][] namesValsNominal;
    short[] valsTrainClass;
    short[][] valsTrainNominal;
    float[][] valsTrainReal;
    short[] valsTestClass;
    short[][] valsTestNominal;
    float[][] valsTestReal;

    public void allocateSpace() {
        this.typeFeat = new char[200];
        this.namesClass = new String[100];
        this.namesNominal = new String[200];
        this.namesReal = new String[200];
        this.countNominal = new short[50];
    }

    public void setTypeFeat(char[] cArray) {
        this.typeFeat = cArray;
    }

    public void setNoTrainExamples(int n) {
        this.noTrainExamples = n;
    }

    public void setNoTestExamples(int n) {
        this.noTestExamples = n;
    }

    public void setNoClasses(short s) {
        this.noClasses = s;
    }

    public void setNoFeats(short s) {
        this.noFeats = s;
    }

    public void setNoNominals(short s) {
        this.noNominals = s;
    }

    public void setNoReals(short s) {
        this.noReals = s;
    }

    public short getNoReals() {
        return this.noReals;
    }

    public void setNamesClass(String[] stringArray) {
        this.namesClass = stringArray;
    }

    public void setNamesNominal(String[] stringArray) {
        this.namesNominal = stringArray;
    }

    public void setNamesReal(String[] stringArray) {
        this.namesReal = stringArray;
    }

    public void setCountNominal(short[] sArray) {
        this.countNominal = sArray;
    }

    public void setNamesValsNominal(String[][] stringArray) {
        this.namesValsNominal = stringArray;
    }

    public void setValsTrainClass(short[] sArray) {
        this.valsTrainClass = sArray;
    }

    public void setValsTrainNominal(short[][] sArray) {
        this.valsTrainNominal = sArray;
    }

    public void setValsTrainReal(float[][] fArray) {
        this.valsTrainReal = fArray;
    }

    public void setValsTestClass(short[] sArray) {
        this.valsTestClass = sArray;
    }

    public void setValsTestNominal(short[][] sArray) {
        this.valsTestNominal = sArray;
    }

    public void setValsTestReal(float[][] fArray) {
        this.valsTestReal = fArray;
    }

    public void readInfo(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[((InputStream)fileInputStream).available()];
            ((InputStream)fileInputStream).read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.readClassNames(byteArrayInputStream);
            this.readFeatNames(byteArrayInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            System.out.println("\nError: Can't open file: " + string);
        }
    }

    protected void readClassNames(ByteArrayInputStream byteArrayInputStream) {
        FunctionsOnStream functionsOnStream = new FunctionsOnStream();
        String string = functionsOnStream.readNextSymbol(byteArrayInputStream);
        while (!string.equals("END")) {
            short s = this.noClasses;
            this.noClasses = (short)(s + 1);
            this.namesClass[s] = new String(string);
            string = functionsOnStream.readNextSymbol(byteArrayInputStream);
            if (string.equals(".")) break;
            if (!string.equals(",")) {
                // empty if block
            }
            string = functionsOnStream.readNextSymbol(byteArrayInputStream);
        }
        if (string.equals("END")) {
            // empty if block
        }
        if (this.noClasses == 0) {
            // empty if block
        }
    }

    protected void readFeatNames(ByteArrayInputStream byteArrayInputStream) throws AbleDataException {
        FunctionsOnStream functionsOnStream = new FunctionsOnStream();
        String string = functionsOnStream.readNextSymbol(byteArrayInputStream);
        while (!string.equals("END")) {
            String string2 = functionsOnStream.readNextSymbol(byteArrayInputStream);
            if (!string2.equals(":")) {
                // empty if block
            }
            if ((string2 = functionsOnStream.readNextSymbol(byteArrayInputStream)).equals("continuous")) {
                short s = this.noFeats;
                this.noFeats = (short)(s + 1);
                this.typeFeat[s] = 99;
                short s2 = this.noReals;
                this.noReals = (short)(s2 + 1);
                this.namesReal[s2] = new String(string);
            } else if (string2.equals("discrete")) {
                short s = this.noFeats;
                this.noFeats = (short)(s + 1);
                this.typeFeat[s] = 100;
                this.namesNominal[this.noNominals] = new String(string);
                string2 = functionsOnStream.readNextSymbol(byteArrayInputStream);
                try {
                    this.countNominal[this.noNominals] = (short)Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AbleDataException(numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                }
                this.noNominals = (short)(this.noNominals + 1);
            } else if (string2.equals("output")) {
                short s = this.noFeats;
                this.noFeats = (short)(s + 1);
                this.typeFeat[s] = 111;
            }
            string2 = functionsOnStream.readNextSymbol(byteArrayInputStream);
            if (!string2.equals(".")) {
                // empty if block
            }
            string = functionsOnStream.readNextSymbol(byteArrayInputStream);
        }
    }

    public void readExamples(String string, String string2) throws AbleException {
        FunctionsOnStream functionsOnStream = new FunctionsOnStream();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[((InputStream)fileInputStream).available()];
            ((InputStream)fileInputStream).read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (string2.equals("train")) {
                this.noTrainExamples = functionsOnStream.countNoLines(byteArrayInputStream);
                if (this.noReals > 0) {
                    this.valsTrainReal = new float[this.noTrainExamples][this.noReals];
                }
                if (this.noNominals > 0) {
                    this.valsTrainNominal = new short[this.noTrainExamples][this.noNominals];
                }
                this.valsTrainClass = new short[this.noTrainExamples];
                this.namesValsNominal = new String[this.noNominals][];
                for (int i = 0; i < this.noNominals; ++i) {
                    this.namesValsNominal[i] = new String[this.countNominal[i]];
                    for (int j = 0; j < this.countNominal[i]; ++j) {
                        this.namesValsNominal[i][j] = null;
                    }
                }
                this.readVectors(byteArrayInputStream, this.valsTrainReal, this.valsTrainNominal, this.valsTrainClass);
            } else if (string2.equals("test")) {
                this.noTestExamples = functionsOnStream.countNoLines(byteArrayInputStream);
                if (this.noReals > 0) {
                    this.valsTestReal = new float[this.noTestExamples][this.noReals];
                }
                if (this.noNominals > 0) {
                    this.valsTestNominal = new short[this.noTestExamples][this.noNominals];
                }
                this.valsTestClass = new short[this.noTestExamples];
                this.readVectors(byteArrayInputStream, this.valsTestReal, this.valsTestNominal, this.valsTestClass);
            }
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected void readVectors(ByteArrayInputStream byteArrayInputStream, float[][] fArray, short[][] sArray, short[] sArray2) {
        FunctionsOnStream functionsOnStream = new FunctionsOnStream();
        functionsOnStream.delimDot = false;
        int n = 0;
        String string = functionsOnStream.readNextSymbol(byteArrayInputStream);
        while (!string.equals("END")) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.noFeats + 1; ++i) {
                switch (this.typeFeat[i]) {
                    case 'c': {
                        fArray[n][n2] = new Float(string).floatValue();
                        ++n2;
                        break;
                    }
                    case 'd': {
                        int n4;
                        for (n4 = 0; n4 < this.countNominal[n3]; ++n4) {
                            if (this.namesValsNominal[n3][n4] == null) {
                                this.namesValsNominal[n3][n4] = new String(string);
                                break;
                            }
                            if (this.namesValsNominal[n3][n4].equals(string)) break;
                        }
                        if (n4 == this.countNominal[n3]) {
                            // empty if block
                        }
                        sArray[n][n3++] = (short)n4;
                        break;
                    }
                    case 'o': {
                        int n4;
                        for (n4 = 0; n4 < this.noClasses; ++n4) {
                            if (!this.namesClass[n4].equals(string)) continue;
                            sArray2[n++] = (short)n4;
                            break;
                        }
                        if (n4 != this.noClasses) break;
                    }
                }
                if (i > this.noFeats || !(string = functionsOnStream.readNextSymbol(byteArrayInputStream)).equals(",")) {
                    // empty if block
                }
                if (!(string = functionsOnStream.readNextSymbol(byteArrayInputStream)).equals("END")) continue;
            }
            string = functionsOnStream.readNextSymbol(byteArrayInputStream);
        }
    }

    public void print() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.noClasses; ++n2) {
            System.out.println("Class[" + n2 + "]: " + this.namesClass[n2]);
        }
        for (n2 = 0; n2 < this.noFeats; ++n2) {
            System.out.println("typeFeat[" + n2 + "]: " + this.typeFeat[n2]);
        }
        for (n2 = 0; n2 < this.noNominals; ++n2) {
            System.out.println("namesNominal[" + n2 + "]: " + this.namesNominal[n2]);
        }
        for (n2 = 0; n2 < this.noNominals; ++n2) {
            System.out.println("countNominal[" + n2 + "]: " + this.countNominal[n2]);
        }
        for (n2 = 0; n2 < this.noNominals; ++n2) {
            for (int i = 0; i < this.countNominal[n2]; ++i) {
                System.out.println("namesValsNominal[" + n2 + "][" + i + "]: " + this.namesValsNominal[n2][i]);
            }
        }
        for (n2 = 0; n2 < this.noReals; ++n2) {
            System.out.println("namesReal[" + n2 + "]: " + this.namesReal[n2]);
        }
        for (n2 = 0; n2 < this.noTrainExamples; ++n2) {
            for (n = 0; n < this.noNominals; ++n) {
                System.out.println("NominalTrain[" + n2 + "][" + n + "]: " + this.valsTrainNominal[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.noTrainExamples; ++n2) {
            for (n = 0; n < this.noReals; ++n) {
                System.out.println("RealTrain[" + n2 + "][" + n + "]: " + this.valsTrainReal[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.noTrainExamples; ++n2) {
            System.out.println("ClassesTrain[" + n2 + "]: " + this.valsTrainClass[n2]);
        }
        for (n2 = 0; n2 < this.noTestExamples; ++n2) {
            for (n = 0; n < this.noNominals; ++n) {
                System.out.println("NominalTest[" + n2 + "][" + n + "]: " + this.valsTestNominal[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.noTestExamples; ++n2) {
            for (n = 0; n < this.noReals; ++n) {
                System.out.println("RealTest[" + n2 + "][" + n + "]: " + this.valsTestReal[n2][n]);
            }
        }
        for (n2 = 0; n2 < this.noTestExamples; ++n2) {
            System.out.println("ClassesTest[" + n2 + "]: " + this.valsTestClass[n2]);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 2000.";
    }
}

