/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.bayes;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import java.io.Serializable;

public class NaiveBayes
implements Serializable {
    protected static final long serialVersionUID = 9068131746004741757L;
    private int nClasses;
    private int nFeatures;
    private int[] nFValues;
    private double[] eqSampleSize;
    private double totalEQSS;
    private double[][][] CPT;
    private double[] classPriors;
    double avgL;
    double avgLL;
    double accuracy;
    int[][] confusionMatrix;
    private double[] classProb;

    public NaiveBayes() {
        this.nFeatures = 0;
        this.nClasses = 0;
        this.nFValues = null;
        this.eqSampleSize = null;
        this.totalEQSS = 0.0;
        this.CPT = null;
        this.classPriors = null;
        this.classProb = null;
        this.avgL = 0.0;
        this.avgLL = 0.0;
        this.accuracy = 0.0;
        this.confusionMatrix = null;
    }

    public NaiveBayes(int n, int n2, int[] nArray, double d, double[] dArray, double[][][] dArray2) throws AbleException {
        this.initializeNB(n, n2, nArray, d, dArray, dArray2);
    }

    public void initializeNB(int n, int n2, int[] nArray, double d, double[] dArray, double[][][] dArray2) throws AbleException {
        this.setNClasses(n);
        this.setNFeatures(n2, nArray);
        this.avgL = 0.0;
        this.avgLL = 0.0;
        this.accuracy = 0.0;
        this.confusionMatrix = new int[this.nClasses][this.nClasses];
        this.setCPT(dArray2);
        this.setClassPriors(dArray);
        this.classProb = (double[])this.classPriors.clone();
        this.eqSampleSize = new double[this.nClasses];
        this.totalEQSS = d;
        if (d < 1.0) {
            this.totalEQSS = 1.0;
        }
        for (int i = 0; i < n; ++i) {
            this.eqSampleSize[i] = this.totalEQSS * this.classPriors[i];
        }
    }

    public int getNClasses() {
        return this.nClasses;
    }

    public int getNFeatures() {
        return this.nFeatures;
    }

    public int[] getNFValues() {
        return this.nFValues;
    }

    public double[] getEqSampleSize() {
        return this.eqSampleSize;
    }

    public double[][][] getCPT() {
        return this.CPT;
    }

    public double[] getClassPriors() {
        return this.classPriors;
    }

    public double getAvgLikelihood() {
        return this.avgL;
    }

    public double getAvgLogLikelihood() {
        return this.avgLL;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double[] getClassProb() {
        return this.classProb;
    }

    public int[][] getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public void setNClasses(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_BeanNBIllegalClassLabelCount", (Object[])new Object[]{Integer.toString(n)}));
        }
        this.nClasses = n;
    }

    public void setNFeatures(int n, int[] nArray) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_BeanNBIllegalFeatureCount", (Object[])new Object[]{Integer.toString(n)}));
        }
        if (nArray.length != n) {
            throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_BeanNBFeatureValuesMismatch", (Object[])new Object[]{Integer.toString(n), Integer.toString(nArray.length)}));
        }
        this.nFeatures = n;
        this.nFValues = (int[])nArray.clone();
    }

    public void setCPT(double[][][] dArray) throws AbleException {
        try {
            if (this.nClasses <= 0) {
                throw new AbleException(Able.NlsMsg((String)"Ex_BeanNBIllegalClassLabelCount", (Object[])new Object[]{Integer.toString(this.nClasses)}));
            }
            if (this.nFeatures <= 0) {
                throw new AbleException(Able.NlsMsg((String)"Ex_BeanNBIllegalFeatureCount", (Object[])new Object[]{Integer.toString(this.nFeatures)}));
            }
            this.CPT = new double[this.nClasses][this.nFeatures][];
            for (int i = 0; i < this.nClasses; ++i) {
                for (int j = 0; j < this.nFeatures; ++j) {
                    int n;
                    double d;
                    if (this.nFValues[j] < 1) {
                        throw new AbleException(Able.NlsMsg((String)"Ex_BeanNBIllegalFeatureValueCount", (Object[])new Object[]{Integer.toString(this.nFValues[j]), Integer.toString(j)}));
                    }
                    this.CPT[i][j] = new double[this.nFValues[j]];
                    if (dArray == null) {
                        d = 1.0 / (double)this.nFValues[j];
                        for (n = 0; n < this.nFValues[j]; ++n) {
                            this.CPT[i][j][n] = d;
                        }
                        continue;
                    }
                    d = 0.0;
                    for (n = 0; n < this.nFValues[j]; ++n) {
                        d += dArray[i][j][n];
                    }
                    for (n = 0; n < this.nFValues[j]; ++n) {
                        this.CPT[i][j][n] = dArray[i][j][n];
                        if (d == 1.0) continue;
                        double[] dArray2 = this.CPT[i][j];
                        int n2 = n;
                        dArray2[n2] = dArray2[n2] / d;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("NaiveBayes.setCPT() exception:" + exception.toString());
        }
    }

    public void setClassPriors(double[] dArray) {
        try {
            this.classPriors = new double[this.nClasses];
            if (dArray == null) {
                double d = 1.0 / (double)this.nClasses;
                for (int i = 0; i < this.nClasses; ++i) {
                    this.classPriors[i] = d;
                }
            } else {
                int n;
                double d = 0.0;
                for (n = 0; n < this.nClasses; ++n) {
                    d += dArray[n];
                }
                for (n = 0; n < this.nClasses; ++n) {
                    this.classPriors[n] = dArray[n];
                    if (d == 1.0) continue;
                    int n2 = n;
                    this.classPriors[n2] = this.classPriors[n2] / d;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("NaiveBayes.setClassPriors() exception:" + exception.toString());
        }
    }

    public void buildHypothesis(int[][] nArray, int[] nArray2, int n, int n2, int n3, int[] nArray3) {
        try {
            int n4;
            int n5;
            int n6;
            if (nArray.length < n) {
                throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_BeanNBIllegalInstanceCount", (Object[])new Object[]{Integer.toString(nArray.length), Integer.toString(n)}));
            }
            if (this.nClasses == 0) {
                this.initializeNB(n2, n3, nArray3, 1.0, null, null);
            }
            int[] nArray4 = new int[this.nClasses];
            for (n6 = 0; n6 < this.nClasses; ++n6) {
                nArray4[n6] = 0;
            }
            int[][][] nArray5 = new int[this.nClasses][this.nFeatures][];
            for (n6 = 0; n6 < this.nClasses; ++n6) {
                for (n5 = 0; n5 < this.nFeatures; ++n5) {
                    nArray5[n6][n5] = new int[this.nFValues[n5]];
                    for (n4 = 0; n4 < this.nFValues[n5]; ++n4) {
                        nArray5[n6][n5][n4] = 0;
                    }
                }
            }
            for (n6 = 0; n6 < n; ++n6) {
                int n7 = nArray2[n6];
                if (n7 < 0 || n7 >= this.nClasses) {
                    throw new Exception("Incorrect class label" + n7 + " of instance " + n6);
                }
                int n8 = n7;
                nArray4[n8] = nArray4[n8] + 1;
                for (n5 = 0; n5 < this.nFeatures; ++n5) {
                    n4 = nArray[n6][n5];
                    if (n4 < 0 || n4 >= this.nFValues[n5]) {
                        throw new Exception("Incorrect value v=" + n4 + " of feature " + n5 + " in instance " + n7);
                    }
                    int[] nArray6 = nArray5[n7][n5];
                    int n9 = n4;
                    nArray6[n9] = nArray6[n9] + 1;
                }
            }
            double d = 0.0;
            int n10 = 0;
            for (n6 = 0; n6 < this.nClasses; ++n6) {
                this.classPriors[n6] = ((double)nArray4[n6] + this.totalEQSS * this.classPriors[n6]) / ((double)n + this.totalEQSS);
                d += this.classPriors[n6];
                n10 += nArray4[n6];
            }
            for (n6 = 0; n6 < this.nClasses; ++n6) {
                for (n5 = 0; n5 < this.nFeatures; ++n5) {
                    for (n4 = 0; n4 < this.nFValues[n5]; ++n4) {
                        this.CPT[n6][n5][n4] = ((double)nArray5[n6][n5][n4] + this.eqSampleSize[n6] * this.CPT[n6][n5][n4]) / ((double)nArray4[n6] + this.eqSampleSize[n6]);
                    }
                }
            }
            this.totalEQSS += (double)n;
            for (n6 = 0; n6 < this.nClasses; ++n6) {
                int n11 = n6;
                this.eqSampleSize[n11] = this.eqSampleSize[n11] + (double)nArray4[n6];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("NaiveBayes.buildHypothesis() exception: " + arrayIndexOutOfBoundsException.toString());
        }
        catch (Exception exception) {
            System.out.println("NaiveBayes.buildHypothesis() exception: " + exception.toString());
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
    }

    public double classify(int[][] nArray, int[] nArray2, int n, boolean[] blArray) {
        int n2;
        this.avgL = 0.0;
        this.avgLL = 0.0;
        this.accuracy = 0.0;
        for (n2 = 0; n2 < this.nClasses; ++n2) {
            for (int i = 0; i < this.nClasses; ++i) {
                this.confusionMatrix[n2][i] = 0;
            }
        }
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = this.classifyExample(nArray[n2], blArray);
            if (n4 == nArray2[n2]) {
                ++n3;
            }
            int[] nArray3 = this.confusionMatrix[nArray2[n2]];
            int n5 = n4;
            nArray3[n5] = nArray3[n5] + 1;
            this.avgL += this.likelihood(nArray[n2], n4);
            this.avgLL += Math.log(this.likelihood(nArray[n2], n4));
        }
        this.accuracy = (double)n3 / (double)n;
        this.avgL /= (double)n;
        this.avgLL /= (double)n;
        return this.accuracy;
    }

    public int classifyExample(int[] nArray, boolean[] blArray) {
        this.findClassProbability(nArray, blArray);
        double d = 0.0;
        int n = -1;
        for (int i = 0; i < this.nClasses; ++i) {
            if (!(this.classProb[i] > d)) continue;
            d = this.classProb[i];
            n = i;
        }
        if (n < 0) {
            System.out.println("NaiveBayes.classify: error finding non-zero probability class \n");
        }
        return n;
    }

    public double[] findClassProbability(int[] nArray, boolean[] blArray) {
        try {
            int n;
            for (n = 0; n < this.nClasses; ++n) {
                this.classProb[n] = this.classPriors[n];
                for (int i = 0; i < this.nFeatures; ++i) {
                    if (blArray != null && !blArray[i]) continue;
                    if (nArray[i] < 0 || nArray[i] >= this.nFValues[i]) {
                        throw new Exception("incorrect value of feature " + i);
                    }
                    int n2 = n;
                    this.classProb[n2] = this.classProb[n2] * this.CPT[n][i][nArray[i]];
                }
            }
            double d = 0.0;
            for (n = 0; n < this.nClasses; ++n) {
                d += this.classProb[n];
            }
            n = 0;
            while (n < this.nClasses) {
                int n3 = n++;
                this.classProb[n3] = this.classProb[n3] / d;
            }
            return this.classProb;
        }
        catch (Exception exception) {
            System.out.println("NaiveBayes.findClassProbabilty exception: " + exception.toString() + "\n");
            return this.classProb;
        }
    }

    public double likelihood(int[] nArray, int n) throws IllegalArgumentException {
        double d = 1.0;
        try {
            if (n < 0 || n >= this.nClasses) {
                throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_BeanNBIllegalClassLabel", (Object[])new Object[]{Integer.toString(n), Integer.toString(this.nClasses)}));
            }
            for (int i = 0; i < this.nFeatures; ++i) {
                if (nArray[i] < 0 || nArray[i] >= this.nFValues[i]) {
                    throw new IllegalArgumentException(Able.NlsMsg((String)"Ex_BeanNBIllegalInstanceLikelihood", (Object[])new Object[]{Integer.toString(nArray[i]), Integer.toString(this.nFValues[i])}));
                }
                d *= this.CPT[n][i][nArray[i]];
            }
        }
        catch (Exception exception) {
            System.out.println("NaiveBayes.likelihood exception: " + exception.toString() + "\n");
        }
        return d;
    }
}

