/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.bayes;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.beans.AbleBackPropagation;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.filter.AbleFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class AbleNaiveBayesClassifierAgent
extends AbleDefaultAgent
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    protected String dataFileName;
    protected String testDataFileName;
    protected int bufferSize = 0;
    protected int maxNumPasses = 100;
    protected int desiredPercentCorrect = 100;
    protected int desiredPercentIncorrect = 0;
    protected String netArch = "0 0 0";
    protected AbleImport imp1;
    protected AbleImport imp2;
    protected AbleFilter filt1;
    protected AbleFilter filt2;
    protected AbleBackPropagation net;
    public double avgRMSError = Double.MAX_VALUE;
    public int numPasses = 0;
    protected boolean training = false;
    protected int lastNumPasses = 0;
    protected double userTolerance = 0.1;
    protected double testTolerance = 0.5;
    protected int trainToTestRatio = 10;
    protected boolean trainOK = false;
    protected double[] inNum = null;
    protected double[] outNum = null;
    protected String[] inSym = null;
    protected String[] outSym = null;

    public AbleNaiveBayesClassifierAgent() throws AbleException {
        this("NBClassifierAgent");
    }

    public AbleNaiveBayesClassifierAgent(String string) throws AbleException {
        super(string);
        this.setSleepTime(10L);
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(3);
    }

    public void init() throws AbleException {
        if (this.dataFileName == null || this.dataFileName.equals("")) {
            return;
        }
        try {
            this.removeAllBeans();
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, "init", "Configuring NaiveBayes Classifier Agent " + this.name);
            }
            this.imp1 = new AbleImport();
            this.addBean((AbleBean)this.imp1);
            this.imp1.setBufferSize(this.bufferSize);
            this.imp1.setDataFileName(this.dataFileName);
            this.imp1.init();
            this.imp2 = new AbleImport(Able.NlsMsg((String)"DFLT_NAME_TestImport"));
            this.addBean((AbleBean)this.imp2);
            this.imp2.setBufferSize(this.bufferSize);
            this.imp2.setComputeStatistics(false);
            if (this.testDataFileName != null && this.testDataFileName.length() != 0) {
                this.imp2.setDataFileName(this.testDataFileName);
                this.imp2.init();
            }
            this.net = new AbleBackPropagation();
            this.addBean((AbleBean)this.net);
            this.filt1 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
            this.addBean((AbleBean)this.filt1);
            this.filt2 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
            this.addBean((AbleBean)this.filt2);
            this.net.generateTranslateTemplates(this.filt1, this.filt2, this.imp1.getFieldList());
            int n = this.filt1.getNumInUnits();
            int n2 = this.filt1.getNumOutUnits();
            String string = n + " " + this.netArch + " " + n2;
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, "init", this.name + " agent, network arch = " + string);
            }
            this.net.setNetArchitecture(string);
            this.net.setTolerance(0.3);
            new AbleBufferConnection((AbleBean)this.imp1, (AbleBean)this.filt1);
            new AbleBufferConnection((AbleBean)this.imp2, (AbleBean)this.filt1);
            new AbleBufferConnection((AbleBean)this.filt1, (AbleBean)this.net);
            new AbleBufferConnection((AbleBean)this.net, (AbleBean)this.filt2);
            this.inputBuffer = this.filt1.getInputBuffer();
            this.outputBuffer = this.filt2.getOutputBuffer();
            this.imp1.setDataFlowEnabled(true);
            this.imp2.setDataFlowEnabled(false);
            this.filt1.setDataFlowEnabled(true);
            this.filt2.setDataFlowEnabled(true);
            this.net.setDataFlowEnabled(true);
            this.startEnabledEventProcessing();
        }
        catch (IOException iOException) {
            throw new AbleException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
    }

    public void processTimerEvent() throws AbleException {
        boolean bl = false;
        if (this.training) {
            this.process();
            this.numPasses = (int)this.net.getNetEpoch();
            int n = (int)this.net.getPercentCorrect();
            this.avgRMSError = this.net.getAvgRMSError();
            this.dataChanged(this);
            if (this.net.getNetRecInx() == 0L) {
                int n2 = this.net.getNetMode();
                if (n2 == 0) {
                    this.trainOK = false;
                }
                if (n >= this.desiredPercentCorrect) {
                    if (n2 == 0) {
                        this.trainOK = true;
                    }
                    if (n2 == 1) {
                        bl = true;
                    }
                    if (this.trainOK && bl) {
                        if (Able.TraceLog.isLogging()) {
                            Able.TraceLog.text(524288L, "Training complete");
                        }
                        this.stopTraining();
                    }
                }
                if (this.numPasses >= this.maxNumPasses) {
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(524288L, "Training halted - exceeded maximum number of passes");
                    }
                    this.stopTraining();
                }
                if (this.training) {
                    this.autoTrain(this.numPasses);
                }
            }
        }
    }

    protected void autoTrain(int n) {
        try {
            int n2 = this.net.getNetMode();
            if (this.trainOK && n2 != 1 && n % this.trainToTestRatio == 0) {
                this.setMode(1);
                this.userTolerance = this.net.getTolerance();
                this.net.setTolerance(this.testTolerance);
            } else if (n2 != 0) {
                this.setMode(0);
                this.net.setTolerance(this.userTolerance);
            }
        }
        catch (AbleException ableException) {
            // empty catch block
        }
    }

    public void setDataFileName(String string) {
        this.dataFileName = string;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setTestDataFileName(String string) {
        this.testDataFileName = string;
    }

    public String getTestDataFileName() {
        return this.testDataFileName;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public AbleBackPropagation getNetwork() {
        return this.net;
    }

    public int getNumPasses() {
        return this.numPasses;
    }

    public void setNumPasses(int n) {
    }

    public void setMaxNumPasses(int n) {
        this.maxNumPasses = n;
    }

    public int getMaxNumPasses() {
        return this.maxNumPasses;
    }

    public void setDesiredPercentCorrect(int n) {
        this.desiredPercentCorrect = n;
    }

    public int getDesiredPercentCorrect() {
        return this.desiredPercentCorrect;
    }

    public void setDesiredPercentIncorrect(int n) {
        this.desiredPercentIncorrect = n;
    }

    public int getDesiredPercentIncorrect() {
        return this.desiredPercentIncorrect;
    }

    public double getAvgRMSError() {
        return this.avgRMSError;
    }

    public void setNetArch(String string) {
        this.netArch = string;
    }

    public String getNetArch() {
        return this.netArch;
    }

    public String getNetArchitecture() {
        if (this.net == null) {
            return "0 " + this.netArch + " 0";
        }
        return this.net.getNetArchitecture();
    }

    public void setTrainToTestRatio(int n) {
        this.trainToTestRatio = n;
    }

    public int getTrainToTestRatio() {
        return this.trainToTestRatio;
    }

    public void setTestTolerance(double d) {
        this.testTolerance = d;
    }

    public double getTestTolerance() {
        return this.testTolerance;
    }

    public void setMode(int n) throws AbleException {
        Vector<AbleObject> vector;
        int n2 = this.getState();
        if (n2 == 1026 || n2 == 1020) {
            return;
        }
        if (n == 0) {
            vector = new Vector<AbleObject>();
            vector.addElement(this.imp1);
            vector.addElement(this.imp2);
            vector.addElement(this.filt1);
            vector.addElement(this.net);
            vector.addElement(this.filt2);
            this.setProcessList(vector);
            this.imp1.setDataFlowEnabled(true);
            this.imp2.setDataFlowEnabled(false);
            this.net.setNetMode(0);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, "Switching NaiveBayes classifier agent to TRAIN mode");
            }
        }
        if (n == 1) {
            vector = new Vector();
            vector.addElement(this.imp1);
            vector.addElement(this.imp2);
            vector.addElement(this.filt1);
            vector.addElement(this.net);
            vector.addElement(this.filt2);
            this.setProcessList(vector);
            if (this.imp2.getState() != 1026) {
                this.imp1.setDataFlowEnabled(false);
                this.imp2.setDataFlowEnabled(true);
            }
            this.net.setNetMode(1);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, "Switching NaiveBayes classifier agent to TEST mode");
            }
        }
        if (n == 2) {
            this.imp1.setDataFlowEnabled(false);
            this.imp2.setDataFlowEnabled(false);
            this.net.setNetMode(2);
            this.inputBuffer = this.filt1.getInputBuffer();
            this.outputBuffer = this.filt2.getOutputBuffer();
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, "Switching NaiveBayes classifier agent to RUN mode");
            }
        }
    }

    public int getMode() throws AbleException {
        if (this.net == null) {
            return 0;
        }
        return this.net.getNetMode();
    }

    public boolean isTraining() throws AbleException {
        return this.training;
    }

    public void train() throws AbleException {
        if (this.training) {
            this.training = false;
            this.setMode(1);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(0x100000L, "Training was aborted ");
            }
            return;
        }
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(0x100000L, "Starting training of NaiveBayes Classifier Agent " + this.name);
        }
        this.setMode(0);
        Vector<AbleObject> vector = new Vector<AbleObject>();
        vector.addElement(this.imp1);
        vector.addElement(this.imp2);
        vector.addElement(this.filt1);
        vector.addElement(this.net);
        vector.addElement(this.filt2);
        this.setProcessList(vector);
        this.training = true;
    }

    public void startTraining() throws AbleException {
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(0x100000L, "Training was started: " + this.name);
        }
        this.setTimerEventProcessingEnabled(true);
        this.setDataFlowEnabled(false);
        this.startEnabledEventProcessing();
        boolean bl = this.training;
        this.training = true;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.training));
    }

    public void stopTraining() throws AbleException {
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(0x100000L, "Training was stopped: " + this.name);
        }
        this.setTimerEventProcessingEnabled(false);
        this.setDataFlowEnabled(true);
        boolean bl = this.training;
        this.training = false;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.training));
    }

    public void reset() throws AbleException {
        this.imp1.reset();
        this.imp2.reset();
        this.net.reset();
        this.numPasses = 0;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

