/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;

public class AbleTimeSeriesFilter
extends AbleObject {
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_TimeSeriesFilter");
    protected static final long serialVersionUID = 2001100500100300000L;
    protected double[] inNum = (double[])this.inputBuffer;
    protected double[] outNum = (double[])this.outputBuffer;
    protected double[] tmpNum = null;
    protected int windowSize = 1;
    protected int horizon = 0;
    protected int numInUnits = 0;
    protected int numOutUnits = 0;
    protected int totalTmpUnits = 0;
    protected int totalOutUnits = 0;
    protected int recInx = 0;
    protected boolean loaded = false;

    public AbleTimeSeriesFilter() throws AbleException {
        this(defaultName);
    }

    public AbleTimeSeriesFilter(String string) throws AbleException {
        super(string);
    }

    public void setWindowSize(int n) {
        if (n < 1) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setWindowSize", "WindowSize cannot be set to <" + n + ">; must be at least 1.");
            }
            return;
        }
        this.windowSize = n;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setHorizon(int n) {
        if (n < 0) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setHorizon", "Horizon cannot be set to <" + this.windowSize + ">; must be at least 0.");
            }
            return;
        }
        this.horizon = n;
    }

    public int getHorizon() {
        return this.horizon;
    }

    public void setNumInUnits(int n) {
        this.numInUnits = n;
    }

    public int getNumInUnits() {
        return this.numInUnits;
    }

    public void setNumOutUnits(int n) {
        this.numOutUnits = n;
    }

    public int getNumOutUnits() {
        return this.numOutUnits;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void init() throws AbleException {
        int n = this.numInUnits + this.numOutUnits;
        this.inputBuffer = new double[n];
        this.totalOutUnits = this.windowSize * this.numInUnits + this.numOutUnits;
        this.totalTmpUnits = this.horizon * this.numInUnits;
        this.outputBuffer = new double[this.totalOutUnits];
        this.inNum = (double[])this.inputBuffer;
        this.outNum = (double[])this.outputBuffer;
        this.tmpNum = new double[this.totalTmpUnits];
        this.loaded = false;
        this.recInx = 0;
        this.setState(1021);
        this.setDataFlowEnabled(true);
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "init()", "totalOutUnits = " + this.totalOutUnits);
            this.trace.text(0x100000L, (Object)this, "init()", " totalTmpUnits = " + this.totalTmpUnits);
        }
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        if (this.inputBuffer == null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "process()", "inputBuffer is null!");
            }
        } else {
            this.inNum = (double[])this.inputBuffer;
        }
        int n = this.windowSize * this.numInUnits;
        int n2 = this.numInUnits;
        int n3 = 0;
        while (n2 < n) {
            this.outNum[n3] = this.outNum[n2];
            ++n2;
            ++n3;
        }
        if (this.totalTmpUnits > 0) {
            for (n2 = 0; n2 < this.numInUnits; ++n2) {
                this.outNum[n3++] = this.tmpNum[n2];
            }
            n2 = this.numInUnits;
            n3 = 0;
            while (n2 < this.totalTmpUnits) {
                this.tmpNum[n3] = this.tmpNum[n2];
                ++n2;
                ++n3;
            }
        }
        int n4 = this.numInUnits + this.numOutUnits;
        int n5 = this.totalOutUnits - n4;
        if (this.horizon == 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                this.outNum[n5 + n2] = this.inNum[n2];
            }
        } else {
            n5 = (this.horizon - 1) * this.numInUnits;
            for (n2 = 0; n2 < this.numInUnits; ++n2) {
                this.tmpNum[n5 + n2] = this.inNum[n2];
            }
            n5 = this.windowSize * this.numInUnits;
            for (n2 = 0; n2 < this.numOutUnits; ++n2) {
                this.outNum[n5 + n2] = this.inNum[this.numInUnits + n2];
            }
        }
        ++this.recInx;
        if (this.recInx >= this.windowSize + this.horizon) {
            this.loaded = true;
        }
        this.dataChanged(this.outputBuffer);
    }

    public void reset() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(true);
        if (this.outNum != null) {
            for (int i = 0; i < this.outNum.length; ++i) {
                this.outNum[i] = 0.0;
            }
        }
        this.loaded = false;
        this.recInx = 0;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

