/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleNetwork;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbleTemporalDifferenceLearning
extends AbleNetwork
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_TemporalDifferenceLearning");
    double cumNumBadPat;
    double cumRMSError;
    double cumMaxRMSError;
    double cumMaxError;
    double cumCorrect;
    double cumIncorrect;
    double cumUnknown;
    int firstHid1;
    int firstHid2;
    int firstHid3;
    int firstOut;
    int numContextUnits;
    int numInputs;
    int numHidden1;
    int numHidden2;
    int numHidden3;
    int numOutputs;
    int feedbackType;
    int numUnits;
    int numWeights1;
    int numWeights2;
    int numWeights3;
    int numWeights4;
    int numHidLayers;
    double learnRate = 0.2;
    boolean symmetricActFunction;
    double ActOffset;
    double momentum = 0.5;
    boolean epochUpdate = false;
    double tolerance = 0.0;
    boolean computeSensitivity;
    double decayFactor;
    boolean adaptLearnRate = false;
    boolean explicitErrorMode = false;
    double lambda = 0.5;
    double gamma = 0.0;
    double reinforcement = 0.0;
    double patternType = 0.0;
    double lastRMSError;
    double aveRMSError;
    double lastNumBadOut;
    double badPatRatio;
    double maxRMSError;
    double percentCorrect;
    double percentIncorrect;
    double percentUnknown;
    int unknownFlag;
    double confidence;
    int recsPerUpdate;
    double[] weights1;
    double[] weights2;
    double[] weights3;
    double[] weights4;
    double[] threshold;
    double[] teach;
    double[] error;
    double[] delta;
    double[] unitInput;
    double[] wgtDeltas1;
    double[] wgtDeltas2;
    double[] wgtDeltas3;
    double[] wgtDeltas4;
    double[] thrDeltas;
    double[] wgtDeriv1;
    double[] wgtDeriv2;
    double[] wgtDeriv3;
    double[] wgtDeriv4;
    double[] thrDeriv;
    double[] inputSensitivity;
    double[] cumErrorIndex;
    double[] prevActivations;
    static int lastSign = 0;

    public AbleTemporalDifferenceLearning() throws AbleException {
        super(defaultName);
    }

    public AbleTemporalDifferenceLearning(String string) throws AbleException {
        super(string);
    }

    public AbleTemporalDifferenceLearning(String string, String string2) throws AbleException {
        super(string, string2);
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public int getNumHidden1() {
        return this.numHidden1;
    }

    public int getNumHidden2() {
        return this.numHidden2;
    }

    public int getNumHidden3() {
        return this.numHidden3;
    }

    public int getNumOutputs() {
        return this.numOutputs;
    }

    public int getNumUnits() {
        return this.numUnits;
    }

    public int getNumWeights1() {
        return this.numWeights1;
    }

    public int getNumWeights2() {
        return this.numWeights2;
    }

    public int getNumWeights3() {
        return this.numWeights3;
    }

    public int getNumWeights4() {
        return this.numWeights4;
    }

    public boolean isExplicitErrorMode() {
        return this.explicitErrorMode;
    }

    public void setExplicitErrorMode(boolean bl) {
        this.explicitErrorMode = bl;
    }

    public boolean isAdaptLearnRate() {
        return this.adaptLearnRate;
    }

    public void setAdaptLearnRate(boolean bl) {
        this.adaptLearnRate = bl;
    }

    public boolean isEpochUpdate() {
        return this.epochUpdate;
    }

    public void setEpochUpdate(boolean bl) {
        this.epochUpdate = bl;
    }

    public boolean isSymmetricActFunction() {
        return this.symmetricActFunction;
    }

    public void setSymmetricActFunction(boolean bl) {
        this.symmetricActFunction = bl;
    }

    public int getFeedbackType() {
        return this.feedbackType;
    }

    public double getDecayFactor() {
        return this.decayFactor;
    }

    public void setDecayFactor(double d) {
        this.decayFactor = d;
    }

    public double getAvgRMSError() {
        return this.aveRMSError;
    }

    public double getLastRMSError() {
        return this.lastRMSError;
    }

    public double getMaxRMSError() {
        return this.maxRMSError;
    }

    public double getBadPatRatio() {
        return this.badPatRatio;
    }

    public void setLambda(double d) {
        this.lambda = d;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setGamma(double d) {
        this.gamma = d;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setReinforcement(double d) {
        this.reinforcement = d;
    }

    public double getReinforcement() {
        return this.reinforcement;
    }

    public void setPatternType(double d) {
        this.patternType = d;
    }

    public double getPatternType() {
        return this.patternType;
    }

    public void setLearnRate(double d) {
        double d2 = this.learnRate;
        this.learnRate = d;
        this.chgSupport.firePropertyChange("learnRate", new Double(d2), new Double(d));
    }

    public double getLearnRate() {
        return this.learnRate;
    }

    public void setMomentum(double d) {
        double d2 = this.momentum;
        this.momentum = d;
        this.chgSupport.firePropertyChange("momentum", new Double(d2), new Double(d));
    }

    public double getPercentCorrect() {
        return this.percentCorrect;
    }

    public double getPercentIncorrect() {
        return this.percentIncorrect;
    }

    public double getPercentUnknown() {
        return this.percentUnknown;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public void setTolerance(double d) {
        double d2 = this.tolerance;
        this.tolerance = d;
        this.chgSupport.firePropertyChange("tolerance", new Double(d2), new Double(d));
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public double getAveRMSError() {
        return this.aveRMSError;
    }

    public double[] getActivations() {
        return this.activations;
    }

    public double[] getWeights1() {
        return this.weights1;
    }

    public double[] getWeights2() {
        return this.weights2;
    }

    public double[] getWeights3() {
        return this.weights3;
    }

    public double[] getWeights4() {
        return this.weights4;
    }

    public double[] getWgtDeriv1() {
        return this.wgtDeriv1;
    }

    public double[] getWgtDeriv2() {
        return this.wgtDeriv2;
    }

    public double[] getWgtDeriv3() {
        return this.wgtDeriv3;
    }

    public double[] getWgtDeriv4() {
        return this.wgtDeriv4;
    }

    public double[] getThreshold() {
        return this.threshold;
    }

    public double[] getTeach() {
        return this.teach;
    }

    public double[] getError() {
        return this.error;
    }

    public String getNetArchitecture() {
        return this.netArchitecture;
    }

    double Logistic(double d) {
        if (d > 23.0) {
            return 1.0;
        }
        if (d > -23.0) {
            return 1.0 / (1.0 + Math.exp(-d));
        }
        return 0.0;
    }

    void Fwd_Prop(int n, int n2, int n3, double[] dArray) {
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            double d = this.threshold[i];
            int n5 = n;
            while (n5 < n2) {
                d += this.activations[n5] * dArray[n4];
                ++n5;
                ++n4;
            }
            this.unitInput[i] = d;
            this.activations[i] = this.Logistic(d) - this.ActOffset;
        }
    }

    void calcOutputs() {
        this.ActOffset = !this.symmetricActFunction ? 0.0 : 0.5;
        if (this.numContextUnits > 0) {
            if (this.feedbackType == 1) {
                int n = this.numInputs;
                int n2 = this.firstHid1;
                while (n < this.firstHid1) {
                    this.activations[n] = this.decayFactor * this.activations[n] + this.activations[n2];
                    ++n;
                    ++n2;
                }
            } else {
                int n = this.numInputs;
                int n3 = this.firstOut;
                while (n < this.firstHid1) {
                    this.activations[n] = this.decayFactor * this.activations[n] + this.activations[n3];
                    ++n;
                    ++n3;
                }
            }
        }
        switch (this.numHidLayers) {
            case 0: {
                this.Fwd_Prop(0, this.firstOut, this.numUnits, this.weights4);
                break;
            }
            case 1: {
                this.Fwd_Prop(0, this.firstHid1, this.firstOut, this.weights1);
                this.Fwd_Prop(this.firstHid1, this.firstOut, this.numUnits, this.weights4);
                break;
            }
            case 2: {
                this.Fwd_Prop(0, this.firstHid1, this.firstHid2, this.weights1);
                this.Fwd_Prop(this.firstHid1, this.firstHid2, this.firstOut, this.weights2);
                this.Fwd_Prop(this.firstHid2, this.firstOut, this.numUnits, this.weights4);
                break;
            }
            case 3: {
                this.Fwd_Prop(0, this.firstHid1, this.firstHid2, this.weights1);
                this.Fwd_Prop(this.firstHid1, this.firstHid2, this.firstHid3, this.weights2);
                this.Fwd_Prop(this.firstHid2, this.firstHid3, this.firstOut, this.weights3);
                this.Fwd_Prop(this.firstHid3, this.firstOut, this.numUnits, this.weights4);
            }
        }
    }

    void Calc_Delta(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.delta[i] = this.error[i] * (this.activations[i] + this.ActOffset) * (1.0 - this.activations[i] + this.ActOffset);
        }
    }

    void Back_Prop(int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            int n5 = n;
            while (n5 < n2) {
                dArray2[n4] = this.delta[i] * this.activations[n5] + this.lambda * dArray2[n4];
                int n6 = n5++;
                this.error[n6] = this.error[n6] + dArray[n4] * this.delta[i];
                int n7 = n4;
                dArray3[n7] = dArray3[n7] + dArray2[n4];
                ++n4;
            }
            int n8 = i;
            this.thrDeltas[n8] = this.thrDeltas[n8] + this.delta[i];
        }
    }

    void calcError() {
        if (this.patternType == 1.0) {
            this.reset_WgtDerivs();
        }
        double d = !this.symmetricActFunction ? 0.0 : 0.5;
        for (int i = 0; i < this.firstOut; ++i) {
            this.error[i] = 0.0;
        }
        int n = 0;
        double d2 = 0.0;
        double d3 = 1.0 - d - this.tolerance;
        long l = 0L;
        for (int i = this.firstOut; i < this.numUnits; ++i) {
            if (this.explicitErrorMode) {
                this.error[i] = this.teach[i - this.firstOut];
            } else {
                switch ((int)this.patternType) {
                    case 0: {
                        if (this.gamma == 0.0) {
                            this.error[i] = this.teach[i - this.firstOut] - this.activations[i];
                            break;
                        }
                        this.reinforcement = this.inNum[this.numInputs];
                        double d4 = this.reinforcement + this.gamma * this.teach[i - this.firstOut];
                        if (d4 < 0.0) {
                            d4 = 0.0;
                        }
                        if (d4 > 1.0) {
                            d4 = 1.0;
                        }
                        this.error[i] = d4 - this.activations[i];
                        break;
                    }
                    case 1: {
                        this.error[i] = 0.0;
                        break;
                    }
                    case 2: {
                        this.error[i] = this.teach[i - this.firstOut] - this.activations[i];
                    }
                }
            }
            if (this.activations[i] > d3) {
                ++l;
            }
            d2 += this.error[i] * this.error[i];
            if (Math.abs(this.error[i]) > this.tolerance) {
                ++n;
                continue;
            }
            this.error[i] = 0.0;
        }
        this.lastNumBadOut = n;
        if (n > 0) {
            this.cumNumBadPat += 1.0;
        }
        this.lastRMSError = Math.sqrt(d2 / (double)this.numOutputs);
        this.confidence = 1.0 - this.lastRMSError;
        this.cumRMSError += this.lastRMSError;
        if (this.cumMaxRMSError < this.lastRMSError) {
            this.cumMaxRMSError = this.lastRMSError;
        }
        this.unknownFlag = 0;
        if (l >= 1L) {
            if (n == 0) {
                this.cumCorrect += 1.0;
            } else {
                this.cumIncorrect += 1.0;
            }
        } else {
            this.cumUnknown += 1.0;
            this.unknownFlag = 1;
        }
        if (this.netMode != 2) {
            this.Calc_Delta(this.firstOut, this.numUnits);
            switch (this.numHidLayers) {
                case 0: {
                    this.Back_Prop(0, this.firstOut, this.numUnits, this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                    break;
                }
                case 1: {
                    this.Back_Prop(this.firstHid1, this.firstOut, this.numUnits, this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                    this.Calc_Delta(this.firstHid1, this.firstOut);
                    this.Back_Prop(0, this.firstHid1, this.firstOut, this.weights1, this.wgtDeriv1, this.wgtDeltas1);
                    break;
                }
                case 2: {
                    this.Back_Prop(this.firstHid2, this.firstOut, this.numUnits, this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                    this.Calc_Delta(this.firstHid2, this.firstOut);
                    this.Back_Prop(this.firstHid1, this.firstHid2, this.firstOut, this.weights2, this.wgtDeriv2, this.wgtDeltas2);
                    this.Calc_Delta(this.firstHid1, this.firstHid2);
                    this.Back_Prop(0, this.firstHid1, this.firstHid2, this.weights1, this.wgtDeriv1, this.wgtDeltas1);
                    break;
                }
                case 3: {
                    this.Back_Prop(this.firstHid3, this.firstOut, this.numUnits, this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                    this.Calc_Delta(this.firstHid3, this.firstOut);
                    this.Back_Prop(this.firstHid2, this.firstHid3, this.firstOut, this.weights3, this.wgtDeriv3, this.wgtDeltas3);
                    this.Calc_Delta(this.firstHid2, this.firstHid3);
                    this.Back_Prop(this.firstHid1, this.firstHid2, this.firstHid3, this.weights2, this.wgtDeriv2, this.wgtDeltas2);
                    this.Calc_Delta(this.firstHid1, this.firstHid2);
                    this.Back_Prop(0, this.firstHid1, this.firstHid2, this.weights1, this.wgtDeriv1, this.wgtDeltas1);
                }
            }
            if (this.computeSensitivity) {
                for (int i = 0; i < this.firstHid1; ++i) {
                    int n2 = i;
                    this.cumErrorIndex[n2] = this.cumErrorIndex[n2] + Math.abs(this.error[i]);
                }
            }
        }
    }

    void Bump_Weights(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] + this.learnRate * dArray3[i];
            dArray3[i] = 0.0;
        }
    }

    void Bump_Thresholds(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            int n3 = i;
            this.threshold[n3] = this.threshold[n3] + this.learnRate * this.thrDeltas[i];
            this.thrDeltas[i] = 0.0;
        }
    }

    void adjustWeights() {
        switch (this.numHidLayers) {
            case 0: {
                this.Bump_Weights(this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                this.Bump_Thresholds(this.firstOut, this.numUnits);
                break;
            }
            case 1: {
                this.Bump_Weights(this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                this.Bump_Thresholds(this.firstOut, this.numUnits);
                this.Bump_Weights(this.weights1, this.wgtDeriv1, this.wgtDeltas1);
                this.Bump_Thresholds(this.firstHid1, this.firstOut);
                break;
            }
            case 2: {
                this.Bump_Weights(this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                this.Bump_Thresholds(this.firstOut, this.numUnits);
                this.Bump_Weights(this.weights2, this.wgtDeriv2, this.wgtDeltas2);
                this.Bump_Thresholds(this.firstHid2, this.firstOut);
                this.Bump_Weights(this.weights1, this.wgtDeriv1, this.wgtDeltas1);
                this.Bump_Thresholds(this.firstHid1, this.firstHid2);
                break;
            }
            case 3: {
                this.Bump_Weights(this.weights4, this.wgtDeriv4, this.wgtDeltas4);
                this.Bump_Thresholds(this.firstOut, this.numUnits);
                this.Bump_Weights(this.weights3, this.wgtDeriv3, this.wgtDeltas3);
                this.Bump_Thresholds(this.firstHid3, this.firstOut);
                this.Bump_Weights(this.weights2, this.wgtDeriv2, this.wgtDeltas2);
                this.Bump_Thresholds(this.firstHid2, this.firstHid3);
                this.Bump_Weights(this.weights1, this.wgtDeriv1, this.wgtDeltas1);
                this.Bump_Thresholds(this.firstHid1, this.firstHid2);
                break;
            }
        }
    }

    void reset_WgtDerivs() {
        int n;
        for (n = 0; n < this.wgtDeriv1.length; ++n) {
            this.wgtDeriv1[n] = 0.0;
        }
        for (n = 0; n < this.wgtDeriv2.length; ++n) {
            this.wgtDeriv2[n] = 0.0;
        }
        for (n = 0; n < this.wgtDeriv3.length; ++n) {
            this.wgtDeriv3[n] = 0.0;
        }
        for (n = 0; n < this.wgtDeriv4.length; ++n) {
            this.wgtDeriv4[n] = 0.0;
        }
        for (n = 0; n < this.thrDeriv.length; ++n) {
            this.thrDeriv[n] = 0.0;
        }
    }

    void computeIndices() {
        this.firstHid1 = this.numInputs + this.numContextUnits;
        this.firstHid2 = this.firstHid1 + this.numHidden1;
        this.firstHid3 = this.firstHid2 + this.numHidden2;
        this.firstOut = this.numUnits - this.numOutputs;
    }

    void initialize() {
        int n;
        this.computeIndices();
        this.netRecInx = 0L;
        this.cumRMSError = 0.0;
        this.cumMaxRMSError = 0.0;
        this.cumNumBadPat = 0.0;
        this.cumMaxError = 0.0;
        this.cumCorrect = 0.0;
        this.cumIncorrect = 0.0;
        this.cumUnknown = 0.0;
        this.percentCorrect = 0.0;
        this.percentIncorrect = 0.0;
        this.percentUnknown = 0.0;
        this.unknownFlag = 0;
        for (n = 0; n < this.numWeights1; ++n) {
            this.wgtDeriv1[n] = 0.0;
        }
        for (n = 0; n < this.numWeights2; ++n) {
            this.wgtDeriv2[n] = 0.0;
        }
        for (n = 0; n < this.numWeights3; ++n) {
            this.wgtDeriv3[n] = 0.0;
        }
        for (n = 0; n < this.numWeights4; ++n) {
            this.wgtDeriv4[n] = 0.0;
        }
        for (n = 0; n < this.numUnits; ++n) {
            this.thrDeriv[n] = 0.0;
        }
    }

    void initWeights() {
        double d;
        int n;
        this.netEpoch = 0L;
        this.lastRMSError = 0.0;
        this.lastNumBadOut = 0.0;
        this.aveRMSError = 1.0;
        this.maxRMSError = 1.0;
        this.badPatRatio = 1.0;
        this.cumRMSError = 0.0;
        this.cumMaxRMSError = 0.0;
        this.cumNumBadPat = 0.0;
        this.cumMaxError = 0.0;
        double d2 = 1.0 / Math.sqrt(this.firstHid1);
        double d3 = d2 / 2.0;
        for (n = 0; n < this.numWeights1; ++n) {
            this.weights1[n] = d = d3 - Math.random() * d2;
            this.wgtDeriv1[n] = 0.0;
            this.wgtDeltas1[n] = 0.0;
        }
        d2 = 1.0 / Math.sqrt(this.numHidden1);
        d3 = d2 / 2.0;
        for (n = 0; n < this.numWeights2; ++n) {
            this.weights2[n] = d = d3 - Math.random() * d2;
            this.wgtDeriv2[n] = 0.0;
            this.wgtDeltas2[n] = 0.0;
        }
        d2 = 1.0 / Math.sqrt(this.numHidden2);
        d3 = d2 / 2.0;
        for (n = 0; n < this.numWeights3; ++n) {
            this.weights3[n] = d = d3 - Math.random() * d2;
            this.wgtDeriv3[n] = 0.0;
            this.wgtDeltas3[n] = 0.0;
        }
        switch (this.numHidLayers) {
            case 0: {
                d2 = 1.0 / Math.sqrt(this.firstHid1);
                break;
            }
            case 1: {
                d2 = 1.0 / Math.sqrt(this.numHidden1);
                break;
            }
            case 2: {
                d2 = 1.0 / Math.sqrt(this.numHidden2);
                break;
            }
            case 3: {
                d2 = 1.0 / Math.sqrt(this.numHidden3);
            }
        }
        d3 = d2 / 2.0;
        for (n = 0; n < this.numWeights4; ++n) {
            this.weights4[n] = d = d3 - Math.random() * d2;
            this.wgtDeriv4[n] = 0.0;
            this.wgtDeltas4[n] = 0.0;
        }
        for (n = 0; n < this.numUnits; ++n) {
            this.threshold[n] = 0.0;
            this.thrDeriv[n] = 0.0;
            this.thrDeltas[n] = 0.0;
        }
        for (n = 0; n < this.firstHid1; ++n) {
            this.cumErrorIndex[n] = 0.0;
        }
    }

    public void reset() throws AbleException {
        this.netMode = 0;
        this.initialize();
        this.initWeights();
    }

    public void readInputs() throws AbleException {
        if (this.parent != null) {
            AbleDataSource ableDataSource = ((AbleAgent)this.parent).getDataSource();
            if (ableDataSource != null) {
                this.netStepsPerEpoch = ableDataSource.getNumRecords();
            } else if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "readInputs", "Error: no datasource.");
            }
        }
        this.netRecInx %= this.netStepsPerEpoch;
        int n = 0;
        if (this.inputBuffer == null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "readInputs", "Error: inputBuffer is null!");
            }
        } else {
            this.inNum = (double[])this.inputBuffer;
        }
        for (n = 0; n < this.numInputs; ++n) {
            this.activations[n] = this.inNum[n];
        }
        this.patternType = this.inNum[this.numInputs + this.numOutputs];
        if (this.patternType == 2.0) {
            for (int i = 0; i < this.numOutputs; ++i) {
                this.teach[i] = this.inNum[n++];
                this.outNum[i + this.numOutputs] = this.teach[i];
            }
        }
        ++this.netRecInx;
    }

    public void process() throws AbleException {
        int n;
        this.processBufferConnections();
        this.readInputs();
        if (this.patternType != 2.0) {
            this.calcOutputs();
            for (n = this.firstOut; n < this.numUnits; ++n) {
                this.teach[n - this.firstOut] = this.activations[n];
            }
        }
        if (this.patternType != 1.0) {
            for (n = 0; n < this.numUnits; ++n) {
                double d = this.activations[n];
                this.activations[n] = this.prevActivations[n];
                this.prevActivations[n] = d;
            }
        } else {
            for (n = 0; n < this.numUnits; ++n) {
                this.prevActivations[n] = this.activations[n];
            }
        }
        if (this.netMode != 2) {
            this.calcError();
        }
        n = 0;
        if (this.netRecInx >= this.netStepsPerEpoch) {
            n = 1;
        }
        if (this.netMode == 0) {
            if (!this.epochUpdate) {
                this.adjustWeights();
            } else if (n != 0) {
                this.adjustWeights();
            }
        }
        if (this.netRecInx >= this.netStepsPerEpoch) {
            this.endEpoch();
            this.netRecInx = 0L;
        }
        for (int i = 0; i < this.numOutputs; ++i) {
            this.outNum[i] = this.activations[this.firstOut + i];
        }
        this.dataChanged(this.outputBuffer);
    }

    public void endEpoch() {
        int n = (int)this.netStepsPerEpoch;
        double d = this.aveRMSError;
        if (n > 0) {
            this.aveRMSError = this.cumRMSError / (double)n;
            this.badPatRatio = this.cumNumBadPat / (double)n;
            this.percentCorrect = 100.0 * (this.cumCorrect / (double)n);
            this.percentIncorrect = 100.0 * (this.cumIncorrect / (double)n);
            this.percentUnknown = 100.0 * (this.cumUnknown / (double)n);
        } else {
            this.aveRMSError = 1.0;
            this.badPatRatio = 1.0;
            this.percentCorrect = 0.0;
            this.percentIncorrect = 100.0;
            this.percentUnknown = 0.0;
        }
        this.maxRMSError = this.cumMaxRMSError;
        this.cumRMSError = 0.0;
        this.cumNumBadPat = 0.0;
        this.cumMaxRMSError = 0.0;
        this.cumCorrect = 0.0;
        this.cumIncorrect = 0.0;
        this.cumUnknown = 0.0;
        if (this.netMode == 0) {
            ++this.netEpoch;
            if (this.adaptLearnRate) {
                double d2 = (d - this.aveRMSError) / d;
                if (d2 > 0.0 && d2 < 0.001) {
                    if (lastSign == 1) {
                        this.learnRate *= 1.2;
                    }
                } else if (d2 < 0.0 && lastSign == 0) {
                    this.learnRate *= 0.9;
                }
                int n2 = lastSign = d2 >= 0.0 ? 1 : 0;
                if (this.learnRate < 0.001) {
                    this.learnRate = 0.001;
                }
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, this.netEpoch + ": " + this.aveRMSError + " erate = " + d2 + " ,lrate = " + this.learnRate);
                }
            }
            if (this.computeSensitivity) {
                int n3;
                double d3 = 0.0;
                for (n3 = 0; n3 < this.firstHid1; ++n3) {
                    d3 += this.cumErrorIndex[n3];
                }
                if (d3 == 0.0) {
                    d3 = 1.0;
                }
                for (n3 = 0; n3 < this.firstHid1; ++n3) {
                    this.inputSensitivity[n3] = this.cumErrorIndex[n3] / d3;
                }
            }
        }
    }

    public void changeNetArchitecture(String string) throws AbleException {
    }

    public void createNetwork(int n, int n2, int n3, int n4, int n5, int n6) throws AbleException {
        this.numInputs = n;
        this.numHidden1 = n2;
        this.numHidden2 = n3;
        this.numHidden3 = n4;
        this.numOutputs = n5;
        this.feedbackType = n6;
        if (this.numHidden1 == 0) {
            this.numHidden2 = 0;
        }
        if (this.numHidden2 == 0) {
            this.numHidden3 = 0;
        }
        if (this.feedbackType == 0) {
            this.numContextUnits = 0;
        }
        if (this.feedbackType == 1) {
            this.numContextUnits = this.numHidden1;
        }
        if (this.feedbackType == 2) {
            this.numContextUnits = this.numOutputs;
        }
        this.numUnits = this.numInputs + this.numHidden1 + this.numHidden2 + this.numHidden3 + this.numOutputs + this.numContextUnits;
        this.numHidLayers = 0;
        if (this.numHidden1 > 0) {
            ++this.numHidLayers;
        }
        if (this.numHidden2 > 0) {
            ++this.numHidLayers;
        }
        if (this.numHidden3 > 0) {
            ++this.numHidLayers;
        }
        this.numWeights1 = 0;
        this.numWeights2 = 0;
        this.numWeights3 = 0;
        this.numWeights4 = 0;
        switch (this.numHidLayers) {
            case 0: {
                this.numWeights4 = (this.numInputs + this.numContextUnits) * this.numOutputs;
                break;
            }
            case 1: {
                this.numWeights4 = this.numHidden1 * this.numOutputs;
                this.numWeights1 = (this.numInputs + this.numContextUnits) * this.numHidden1;
                break;
            }
            case 2: {
                this.numWeights4 = this.numHidden2 * this.numOutputs;
                this.numWeights1 = (this.numInputs + this.numContextUnits) * this.numHidden1;
                this.numWeights2 = this.numHidden1 * this.numHidden2;
                break;
            }
            case 3: {
                this.numWeights4 = this.numHidden3 * this.numOutputs;
                this.numWeights1 = (this.numInputs + this.numContextUnits) * this.numHidden1;
                this.numWeights2 = this.numHidden1 * this.numHidden2;
                this.numWeights3 = this.numHidden2 * this.numHidden3;
                break;
            }
        }
        this.learnRate = 0.2;
        this.momentum = 0.5;
        this.tolerance = 0.1;
        this.netMode = 0;
        this.aveRMSError = 1.0;
        this.symmetricActFunction = false;
        this.epochUpdate = false;
        this.maxRMSError = 1.0;
        this.computeSensitivity = false;
        this.percentCorrect = 0.0;
        this.percentIncorrect = 0.0;
        this.percentUnknown = 0.0;
        this.unknownFlag = 0;
        this.decayFactor = 0.0;
        this.adaptLearnRate = false;
        this.explicitErrorMode = false;
        this.confidence = 0.0;
        this.recsPerUpdate = 0;
        this.activations = new double[this.numUnits];
        this.weights1 = new double[this.numWeights1];
        this.weights2 = new double[this.numWeights2];
        this.weights3 = new double[this.numWeights3];
        this.weights4 = new double[this.numWeights4];
        this.threshold = new double[this.numUnits];
        this.teach = new double[this.numOutputs];
        this.error = new double[this.numUnits];
        this.delta = new double[this.numUnits];
        this.unitInput = new double[this.numUnits];
        this.wgtDeltas1 = new double[this.numWeights1];
        this.wgtDeltas2 = new double[this.numWeights2];
        this.wgtDeltas3 = new double[this.numWeights3];
        this.wgtDeltas4 = new double[this.numWeights4];
        this.thrDeltas = new double[this.numUnits];
        this.wgtDeriv1 = new double[this.numWeights1];
        this.wgtDeriv2 = new double[this.numWeights2];
        this.wgtDeriv3 = new double[this.numWeights3];
        this.wgtDeriv4 = new double[this.numWeights4];
        this.thrDeriv = new double[this.numUnits];
        this.prevActivations = new double[this.numUnits];
        this.inputSensitivity = new double[this.numInputs + this.numContextUnits];
        this.cumErrorIndex = new double[this.numInputs + this.numContextUnits];
        this.inNum = new double[this.numInputs + this.numOutputs + 1];
        this.inputBuffer = this.inNum;
        this.outNum = new double[2 * this.numOutputs];
        this.outputBuffer = this.outNum;
        this.reset();
        this.init();
        this.setDataFlowEnabled(true);
    }

    public void setNetArchitecture(String string) throws AbleException {
        String string2 = this.netArchitecture;
        this.netArchitecture = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 5 && this.trace.isLogging()) {
            this.trace.text(262144L, (Object)this, "setNetArchitecture", "Architecture requires at least 5 values");
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        int n6 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
        this.createNetwork(n, n2, n3, n4, n5, n6);
        this.chgSupport.firePropertyChange("netArchitecture", string2, this.netArchitecture);
    }

    public Vector getNetworkGraphicData() {
        Vector<Object> vector = new Vector<Object>();
        Vector<double[]> vector2 = new Vector<double[]>();
        int[] nArray = new int[2 + this.numHidLayers];
        nArray[0] = this.numInputs + this.numContextUnits;
        switch (this.numHidLayers) {
            case 0: {
                nArray[1] = this.numOutputs;
                vector2.addElement(this.weights4);
                break;
            }
            case 1: {
                nArray[1] = this.numHidden1;
                nArray[2] = this.numOutputs;
                vector2.addElement(this.weights1);
                vector2.addElement(this.weights4);
                break;
            }
            case 2: {
                nArray[1] = this.numHidden1;
                nArray[2] = this.numHidden2;
                nArray[3] = this.numOutputs;
                vector2.addElement(this.weights1);
                vector2.addElement(this.weights2);
                vector2.addElement(this.weights4);
                break;
            }
            case 3: {
                nArray[1] = this.numHidden1;
                nArray[2] = this.numHidden2;
                nArray[3] = this.numHidden3;
                nArray[4] = this.numOutputs;
                vector2.addElement(this.weights1);
                vector2.addElement(this.weights2);
                vector2.addElement(this.weights3);
                vector2.addElement(this.weights4);
            }
        }
        vector.addElement(nArray);
        vector.addElement(this.activations);
        vector.addElement(vector2);
        return vector;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

