/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleNetwork;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateTemplateProvider;
import com.ibm.able.data.AbleCategoricalVariable;
import com.ibm.able.data.AbleDataException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbleSelfOrganizingMap
extends AbleNetwork
implements AbleTranslateTemplateProvider,
Serializable {
    static final long serialVersionUID = 2001100100000000001L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_SelfOrganizingMap");
    static final int MAXARRAYSIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_CATEGORY = "undefined";
    private static final String ClusterCategorySuffix = "-categories";
    int numPasses;
    int numInputs;
    int numRows;
    int numCols;
    int numOutputs;
    int numUnits;
    int numWeights;
    double learnRate = 0.1;
    double changeThreshold;
    double beta;
    double conscience;
    int neighborhood;
    double initialLearnRate = 0.1;
    int maxNumEpochs = 25;
    boolean epochUpdate;
    int winner;
    double winnerAct;
    double sigma;
    int winner2;
    double winnerAct2;
    double confidence;
    double[] activations;
    double[] winRate;
    double[] bias;
    double[] weights;
    double[] prototypeInput;
    double[] prototypeInput2;
    int[] distance;
    double[] weightsNum;
    double[] weightsDenom;
    double[] weightsSquaredSum;
    double[] sparse_val;
    int[] sparse_loc;
    int loc;
    int non_zero_entries;
    int field;
    double sparseness;
    int use_sparse;
    double cumDistance;
    String[] clusterLabels;
    String[] clusterCategories;
    AbleCategoricalVariable clusterCategory;

    public AbleSelfOrganizingMap() throws AbleException {
        this(defaultName);
    }

    public AbleSelfOrganizingMap(String string) throws AbleException {
        super(string);
        Vector<String> vector = new Vector<String>();
        vector.add(DEFAULT_CATEGORY);
        this.clusterCategory = new AbleCategoricalVariable(string + ClusterCategorySuffix, vector);
    }

    public AbleSelfOrganizingMap(String string, String string2) throws AbleException {
        super(string, string2);
    }

    public long getRecordIndex() {
        return this.netRecInx;
    }

    public int getNumPasses() {
        return this.numPasses;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getNumOutputs() {
        return this.numOutputs;
    }

    public int getNumUnits() {
        return this.numUnits;
    }

    public int getNumWeights() {
        return this.numWeights;
    }

    public boolean getEpochUpdate() {
        return this.epochUpdate;
    }

    public void setEpochUpdate(boolean bl) {
        this.epochUpdate = bl;
    }

    public int getWinner() {
        return this.winner;
    }

    public int getWinner2() {
        return this.winner2;
    }

    public double getWinnerAct() {
        return this.winnerAct;
    }

    public double getWinnerAct2() {
        return this.winnerAct2;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setLearnRate(double d) {
        double d2 = this.learnRate;
        this.learnRate = d;
        this.chgSupport.firePropertyChange("learnRate", new Double(d2), new Double(d));
    }

    public double getLearnRate() {
        return this.learnRate;
    }

    public void setMaxNumEpochs(int n) {
        this.maxNumEpochs = n;
    }

    public int getMaxNumEpochs() {
        return this.maxNumEpochs;
    }

    public void setConscience(double d) {
        double d2 = this.conscience;
        this.conscience = d;
        this.chgSupport.firePropertyChange("conscience", new Double(d2), new Double(d));
    }

    public double getConscience() {
        return this.conscience;
    }

    public double[] getActivations() {
        return this.activations;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double[] getWinRate() {
        return this.winRate;
    }

    public double[] getPrototypeInput() {
        return this.prototypeInput;
    }

    public double[] getPrototypeInput2() {
        return this.prototypeInput2;
    }

    public double[] getBias() {
        return this.bias;
    }

    public int[] getDistance() {
        return this.distance;
    }

    void updatePandBias() {
        for (int i = 0; i < this.numOutputs; ++i) {
            boolean bl = i == this.winner;
            this.winRate[i] = this.winRate[i] + this.beta * ((double)bl - this.winRate[i]);
            this.bias[i] = this.conscience * (1.0 / (double)this.numOutputs - this.winRate[i]);
        }
    }

    void calcOutputs() {
        int n = this.numInputs;
        int n2 = this.numUnits - 1;
        int n3 = this.numInputs;
        if (this.use_sparse == 0) {
            for (int i = n; i <= n2; ++i) {
                int n4 = (i - n) * n3;
                this.activations[i] = 0.0;
                for (int j = 0; j < n3; ++j) {
                    double d = this.activations[j] - this.weights[n4 + j];
                    int n5 = i;
                    this.activations[n5] = this.activations[n5] + d * d;
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                int n6 = (i - n) * n3;
                if (this.netRecInx == 1L) {
                    this.weightsSquaredSum[i - n] = 0.0;
                    for (int j = 0; j < n3; ++j) {
                        int n7 = i - n;
                        this.weightsSquaredSum[n7] = this.weightsSquaredSum[n7] + this.weights[n6 + j] * this.weights[n6 + j];
                    }
                }
                this.activations[i] = this.weightsSquaredSum[i - n];
                this.loc = 0;
                while (this.loc < this.non_zero_entries) {
                    this.field = this.sparse_loc[this.loc];
                    int n8 = i;
                    this.activations[n8] = this.activations[n8] + this.sparse_val[this.loc] * (this.sparse_val[this.loc] - 2.0 * this.weights[n6 + this.field]);
                    ++this.loc;
                }
            }
        }
    }

    void selectWinner() {
        int n = this.numInputs;
        double d = 10000.0;
        double d2 = 10000.0;
        for (int i = 0; i < this.numOutputs; ++i) {
            if (!(this.activations[i + n] - this.bias[i] < d)) continue;
            d2 = d;
            d = this.activations[i + n];
            this.winner2 = this.winner;
            this.winner = i;
        }
        this.winnerAct = d;
        this.winnerAct2 = d2;
        this.cumDistance += this.winnerAct;
        if (this.conscience > 0.0) {
            this.updatePandBias();
        }
    }

    void computeGaussianParms() {
        double d = this.initialLearnRate;
        double d2 = 0.05;
        double d3 = this.numCols;
        double d4 = 0.2;
        this.learnRate = d * Math.pow(d2 / d, (double)this.netEpoch / (double)this.maxNumEpochs);
        this.sigma = d3 * Math.pow(d4 / d3, (double)this.netEpoch / (double)this.maxNumEpochs);
    }

    void adjustWeightsGaussian() {
        int n = this.numInputs;
        int n2 = this.numOutputs;
        double d = this.learnRate;
        double d2 = this.changeThreshold;
        double d3 = 1.0 / (2.0 * this.sigma * this.sigma);
        int n3 = this.winner;
        if (this.use_sparse == 0) {
            for (int i = 0; i < n2; ++i) {
                int n4;
                double d4 = Math.exp((double)this.distance[n3 * n2 + i] * -1.0 * d3);
                int n5 = i * n;
                double d5 = d * d4;
                if (!(d5 > d2)) continue;
                if (!this.epochUpdate) {
                    for (n4 = 0; n4 < n; ++n4) {
                        int n6 = n5 + n4;
                        this.weights[n6] = this.weights[n6] + d5 * (this.activations[n4] - this.weights[n5 + n4]);
                    }
                    continue;
                }
                int n7 = i;
                this.weightsDenom[n7] = this.weightsDenom[n7] + d5;
                for (n4 = 0; n4 < n; ++n4) {
                    int n8 = n5 + n4;
                    this.weightsNum[n8] = this.weightsNum[n8] + d5 * this.activations[n4];
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                double d6 = Math.exp((double)this.distance[n3 * n2 + i] * -1.0 * d3);
                int n9 = i * n;
                double d7 = d * d6;
                if (!(d7 > d2)) continue;
                if (!this.epochUpdate) {
                    for (int j = 0; j < n; ++j) {
                        int n10 = n9 + j;
                        this.weights[n10] = this.weights[n10] + d7 * (this.activations[j] - this.weights[n9 + j]);
                    }
                    continue;
                }
                int n11 = i;
                this.weightsDenom[n11] = this.weightsDenom[n11] + d7;
                this.loc = 0;
                while (this.loc < this.non_zero_entries) {
                    this.field = this.sparse_loc[this.loc];
                    int n12 = n9 + this.field;
                    this.weightsNum[n12] = this.weightsNum[n12] + d7 * this.sparse_val[this.loc];
                    ++this.loc;
                }
            }
        }
    }

    void computeDistances() {
        int n = this.numOutputs;
        for (int i = 0; i < n; ++i) {
            int n2 = i % this.numCols;
            int n3 = i / this.numCols;
            for (int j = 0; j < this.numOutputs; ++j) {
                int n4 = j % this.numCols;
                int n5 = j / this.numCols;
                this.distance[i * n + j] = (n2 - n4) * (n2 - n4) + (n3 - n5) * (n3 - n5);
            }
        }
    }

    void initWeights() {
        this.netEpoch = 0L;
        for (int i = 0; i < this.numOutputs; ++i) {
            this.bias[i] = 0.0;
            this.winRate[i] = 0.0;
            int n = i * this.numInputs;
            for (int j = 0; j < this.numInputs; ++j) {
                this.weights[n + j] = Math.random() / 5.0 + 0.4;
            }
        }
    }

    public void reset() throws AbleException {
        this.netMode = 0;
        this.netEpoch = 0L;
        this.netRecInx = 0L;
        this.winner = 1;
        this.winner2 = 1;
        this.learnRate = this.initialLearnRate;
        this.initWeights();
        this.initialize();
    }

    public void initialize() throws AbleException {
        this.weightsNum = new double[this.numInputs * this.numOutputs];
        this.weightsDenom = new double[this.numOutputs];
        this.weightsSquaredSum = new double[this.numOutputs];
        this.sparse_val = new double[this.numInputs];
        this.sparse_loc = new int[this.numInputs];
        for (int i = 0; i < this.numOutputs; ++i) {
            this.weightsDenom[i] = 0.0;
            this.weightsSquaredSum[i] = 0.0;
            int n = i * this.numInputs;
            for (int j = 0; j < this.numInputs; ++j) {
                this.weightsNum[n + j] = 0.0;
            }
        }
        this.computeGaussianParms();
        this.computeDistances();
        this.netRecInx = 0L;
        this.cumDistance = 0.0;
    }

    public void endEpoch() {
        this.confidence = this.cumDistance / (double)this.netStepsPerEpoch / Math.sqrt(this.numOutputs);
        this.cumDistance = 0.0;
        if (this.netMode == 0) {
            ++this.netEpoch;
            if (this.netEpoch == 1L) {
                this.sparseness /= (double)((long)this.numInputs * this.netStepsPerEpoch);
                this.use_sparse = this.sparseness > 0.5 ? 0 : 1;
            }
            this.computeGaussianParms();
            if (this.epochUpdate) {
                for (int i = 0; i < this.numOutputs; ++i) {
                    int n = i * this.numInputs;
                    if (this.weightsDenom[i] == 0.0) {
                        this.weightsDenom[i] = 1.0;
                    }
                    for (int j = 0; j < this.numInputs; ++j) {
                        this.weights[n + j] = this.weightsNum[n + j] / this.weightsDenom[i];
                        this.weightsNum[n + j] = 0.0;
                    }
                    this.weightsDenom[i] = 0.0;
                }
            }
            if (this.netEpoch >= (long)this.maxNumEpochs) {
                this.learnRate = 0.0;
                this.netMode = 1;
            }
        }
    }

    public void readInputs() throws AbleException {
        AbleDataSource ableDataSource;
        if (this.parent != null && (ableDataSource = ((AbleAgent)this.parent).getDataSource()) != null) {
            this.netStepsPerEpoch = ableDataSource.getNumRecords();
        }
        this.netRecInx %= this.netStepsPerEpoch;
        if (this.inputBuffer == null) {
            this.logger.message(4L, (Object)this, "readInputs()", "Ex_BeanNullInputBuffer");
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "readInputs()", "Error: AbleSelfOrganizingMap inputBuffer is null!");
            }
        } else {
            this.inNum = (double[])this.inputBuffer;
        }
        this.loc = 0;
        for (int i = 0; i < this.numInputs; ++i) {
            this.activations[i] = this.inNum[i];
            if (this.use_sparse != 1 || this.inNum[i] == 0.0) continue;
            this.sparse_loc[this.loc] = i;
            this.sparse_val[this.loc] = this.inNum[i];
            ++this.loc;
        }
        this.non_zero_entries = this.loc;
        if (this.netEpoch == 0L) {
            this.sparseness += (double)this.non_zero_entries;
        }
        ++this.netRecInx;
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        this.readInputs();
        this.calcOutputs();
        this.selectWinner();
        if (this.netMode == 0) {
            this.adjustWeightsGaussian();
            if (this.netRecInx == this.netStepsPerEpoch) {
                this.endEpoch();
                this.numPasses = (int)this.netEpoch;
                this.netRecInx = 0L;
            }
        }
        this.outNum[0] = this.winner;
        if (this.netMode == 1) {
            for (int i = 0; i < this.numInputs; ++i) {
                this.prototypeInput[i] = this.weights[this.winner * this.numInputs + i];
                this.prototypeInput2[i] = this.weights[this.winner2 * this.numInputs + i];
            }
        }
        this.dataChanged(this.outputBuffer);
    }

    public void generateTranslateTemplates(AbleFilter ableFilter, AbleFilter ableFilter2, Vector vector) throws AbleException {
        AbleFilter.generateTranslateTemplates(ableFilter, ableFilter2, vector);
    }

    public void changeNetArchitecture(String string) throws AbleException {
    }

    public void createNetwork(int n, int n2, int n3) throws AbleException {
        int n4;
        this.numInputs = n;
        this.numRows = n2;
        this.numCols = n3;
        this.numOutputs = this.numRows * this.numCols;
        this.numUnits = this.numInputs + this.numOutputs;
        this.numWeights = this.numInputs * this.numOutputs;
        this.netMode = 0;
        this.numPasses = 0;
        this.sparseness = 0.0;
        this.use_sparse = 1;
        this.learnRate = 0.1;
        this.changeThreshold = 0.001;
        this.beta = 1.0E-4;
        this.conscience = 0.0;
        this.neighborhood = 3;
        this.initialLearnRate = 0.1;
        this.maxNumEpochs = 25;
        this.winner = 0;
        this.winnerAct = 0.0;
        this.sigma = 0.0;
        this.epochUpdate = true;
        this.winner2 = 0;
        this.winnerAct2 = 0.0;
        this.confidence = 0.0;
        this.activations = new double[this.numUnits];
        this.winRate = new double[this.numOutputs];
        this.bias = new double[this.numOutputs];
        this.weights = new double[this.numWeights];
        this.prototypeInput = new double[this.numInputs];
        this.prototypeInput2 = new double[this.numInputs];
        this.distance = new int[this.numOutputs * this.numOutputs];
        this.clusterLabels = new String[this.numOutputs];
        for (n4 = 0; n4 < this.numOutputs; ++n4) {
            this.clusterLabels[n4] = "c" + String.valueOf(n4);
        }
        this.clusterCategories = new String[this.numOutputs];
        for (n4 = 0; n4 < this.numOutputs; ++n4) {
            this.clusterCategories[n4] = DEFAULT_CATEGORY;
        }
        this.inNum = new double[this.numInputs];
        this.inputBuffer = this.inNum;
        this.outNum = new double[1];
        this.outputBuffer = this.outNum;
        this.reset();
        this.init();
        this.setDataFlowEnabled(true);
    }

    public void setNetArchitecture(String string) throws AbleException {
        String string2 = this.netArchitecture = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 3 && this.trace.isLogging()) {
            this.trace.text(262144L, (Object)this, "setNetArchitecture", "Architecture requires at least 3 values");
        }
        this.numInputs = Integer.parseInt(stringTokenizer.nextToken());
        this.numRows = Integer.parseInt(stringTokenizer.nextToken());
        this.numCols = Integer.parseInt(stringTokenizer.nextToken());
        this.createNetwork(this.numInputs, this.numRows, this.numCols);
        this.chgSupport.firePropertyChange("netArchitecture", string2, this.netArchitecture);
    }

    public Vector getNetworkGraphicData() {
        Vector<Object> vector = new Vector<Object>();
        Vector<double[]> vector2 = new Vector<double[]>();
        int[] nArray = new int[]{this.numInputs, this.numOutputs};
        vector2.addElement(this.weights);
        vector.addElement(nArray);
        vector.addElement(this.activations);
        vector.addElement(vector2);
        return vector;
    }

    public String getNetArchitecture() throws AbleException {
        return this.numInputs + " " + this.numRows + " " + this.numCols;
    }

    public String getClusterLabel(int n) {
        return this.clusterLabels[n];
    }

    public void setClusterLabel(int n, String string) {
        this.clusterLabels[n] = string;
    }

    public String[] getClusterLabels() {
        return this.clusterLabels;
    }

    public String getClusterCategory(int n) {
        return this.clusterCategories[n];
    }

    public String getWinnerCategory() {
        return this.getClusterCategory(this.winner);
    }

    public String getWinnerLabel() {
        return this.getClusterLabel(this.winner);
    }

    public void setClusterCategory(int n, String string) throws AbleDataException {
        this.clusterCategories[n] = string;
        this.clusterCategory.addValue(string);
    }

    public String[] getClusterCategories() {
        return this.clusterCategories;
    }

    public Vector getClusterCategoryValues() {
        return this.clusterCategory.getValueList();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

