/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleNetwork;
import com.ibm.able.beans.AbleSelfOrganizingMap;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.beans.filter.AbleTranslateTemplate;
import com.ibm.able.beans.filter.AbleTranslateTemplateProvider;
import com.ibm.able.data.AbleField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbleRadialBasisFunctionNet
extends AbleNetwork
implements AbleTranslateTemplateProvider,
Serializable {
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_RadialBasisFunction");
    static final long serialVersionUID = 1999100100000000001L;
    double cumNumBadPat;
    double cumRMSError;
    double cumMaxRMSError;
    double cumMaxError;
    double cumCorrect;
    double cumIncorrect;
    double cumUnknown;
    int firstHid;
    int firstOut;
    int numContextUnits;
    int numInputs;
    int numHidden;
    int numOutputs;
    static final int feedbackType = 0;
    int numUnits;
    int numWeights;
    int numCenters;
    double learnRate = 0.2;
    boolean symmetricActFunction;
    double ActOffset;
    double momentum = 0.5;
    boolean epochUpdate = false;
    double tolerance = 0.1;
    boolean computeSensitivity;
    double decayFactor;
    boolean adaptLearnRate = false;
    boolean explicitErrorMode = false;
    int basisFunction = 0;
    double allWidths = 2.0;
    boolean normalized = true;
    boolean autoCenter = true;
    int winner = 0;
    double winnerAct = 0.0;
    double lastRMSError;
    double aveRMSError;
    double lastNumBadOut;
    double badPatRatio;
    double maxRMSError;
    double percentCorrect;
    double percentIncorrect;
    double percentUnknown;
    int unknownFlag;
    double confidence;
    int recsPerUpdate;
    AbleSelfOrganizingMap kMapNet = null;
    boolean trainingKMapNet = false;
    int centerWeightPasses = 15;
    double[] weights;
    double[] centers;
    double[] widths;
    double[] weights2;
    double[] weights3;
    double[] weights4;
    double[] threshold;
    double[] teach;
    double[] error;
    double[] delta;
    double[] unitInput;
    double[] wgtDeltas;
    double[] thrDeltas;
    double[] wgtDeriv;
    double[] thrDeriv;
    double[] inputSensitivity;
    double[] cumErrorIndex;
    int[] winRate;
    static int lastSign = 0;

    public AbleRadialBasisFunctionNet() throws AbleException {
        super(defaultName);
    }

    public AbleRadialBasisFunctionNet(String string) throws AbleException {
        super(string);
    }

    public AbleRadialBasisFunctionNet(String string, String string2) throws AbleException {
        super(string, string2);
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public int getNumHidden() {
        return this.numHidden;
    }

    public int getNumOutputs() {
        return this.numOutputs;
    }

    public int getNumUnits() {
        return this.numUnits;
    }

    public int getNumWeights() {
        return this.numWeights;
    }

    public int getNumCenters() {
        return this.numCenters;
    }

    public boolean isExplicitErrorMode() {
        return this.explicitErrorMode;
    }

    public void setExplicitErrorMode(boolean bl) {
        this.explicitErrorMode = bl;
    }

    public boolean isAdaptLearnRate() {
        return this.adaptLearnRate;
    }

    public void setAdaptLearnRate(boolean bl) {
        this.adaptLearnRate = bl;
    }

    public boolean isEpochUpdate() {
        return this.epochUpdate;
    }

    public void setEpochUpdate(boolean bl) {
        this.epochUpdate = bl;
    }

    public boolean isSymmetricActFunction() {
        return this.symmetricActFunction;
    }

    public void setSymmetricActFunction(boolean bl) {
        this.symmetricActFunction = bl;
    }

    public int getFeedbackType() {
        return 0;
    }

    public double getDecayFactor() {
        return this.decayFactor;
    }

    public void setDecayFactor(double d) {
        this.decayFactor = d;
    }

    public double getAvgRMSError() {
        return this.aveRMSError;
    }

    public double getLastRMSError() {
        return this.lastRMSError;
    }

    public double getMaxRMSError() {
        return this.maxRMSError;
    }

    public double getBadPatRatio() {
        return this.badPatRatio;
    }

    public int getCenterWeightPasses() {
        return this.centerWeightPasses;
    }

    public void setCenterWeightPasses(int n) {
        this.centerWeightPasses = n;
    }

    public void setLearnRate(double d) {
        double d2 = this.learnRate;
        this.learnRate = d;
        this.chgSupport.firePropertyChange("learnRate", new Double(d2), new Double(d));
    }

    public double getLearnRate() {
        return this.learnRate;
    }

    public void setMomentum(double d) {
        double d2 = this.momentum;
        this.momentum = d;
        this.chgSupport.firePropertyChange("momentum", new Double(d2), new Double(d));
    }

    public double getPercentCorrect() {
        return this.percentCorrect;
    }

    public double getPercentIncorrect() {
        return this.percentIncorrect;
    }

    public double getPercentUnknown() {
        return this.percentUnknown;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public void setTolerance(double d) {
        double d2 = this.tolerance;
        this.tolerance = d;
        this.chgSupport.firePropertyChange("tolerance", new Double(d2), new Double(d));
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public double getAveRMSError() {
        return this.aveRMSError;
    }

    public double[] getActivations() {
        return this.activations;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double[] getCenters() {
        return this.centers;
    }

    public double[] getWgtDeriv() {
        return this.wgtDeriv;
    }

    public double[] getThreshold() {
        return this.threshold;
    }

    public double[] getTeach() {
        return this.teach;
    }

    public double[] getError() {
        return this.error;
    }

    public void setBasisFunction(int n) {
        this.basisFunction = n;
    }

    public int getBasisFunction() {
        return this.basisFunction;
    }

    public double getAllWidths() {
        return this.allWidths;
    }

    public void setAllWidths(double d) {
        this.allWidths = d;
    }

    public void setNormalized(boolean bl) {
        this.normalized = bl;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public void setAutoCenter(boolean bl) {
        this.autoCenter = bl;
    }

    public boolean getAutoCenter() {
        return this.autoCenter;
    }

    public int getWinner() {
        return this.winner;
    }

    public double getWinnerAct() {
        return this.winnerAct;
    }

    public boolean getTrainingKMapNet() {
        return this.trainingKMapNet;
    }

    public String getNetArchitecture() {
        return this.netArchitecture;
    }

    double Logistic(double d) {
        if (d > 23.0) {
            return 1.0;
        }
        if (d > -23.0) {
            return 1.0 / (1.0 + Math.exp(-d));
        }
        return 0.0;
    }

    double gaussian(double d, double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        return Math.exp(-(d * d) / (2.0 * (d2 * d2)));
    }

    double tPSpline(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        return d * d * Math.log(d);
    }

    double multiQuad(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    void Fwd_Prop(int n, int n2, int n3, double[] dArray) {
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            double d = this.threshold[i];
            int n5 = n;
            while (n5 < n2) {
                d += this.activations[n5] * dArray[n4];
                ++n5;
                ++n4;
            }
            this.unitInput[i] = d;
            this.activations[i] = this.Logistic(d) - this.ActOffset;
        }
    }

    void calcOutputs() {
        this.ActOffset = !this.symmetricActFunction ? 0.0 : 0.5;
        if (this.numContextUnits > 0) {
            int n = this.numInputs;
            int n2 = this.firstOut;
            while (n < this.firstHid) {
                this.activations[n] = this.decayFactor * this.activations[n] + this.activations[n2];
                ++n;
                ++n2;
            }
        }
        for (int i = 0; i < this.numHidden; ++i) {
            double d;
            double d2 = 0.0;
            int n = i * this.numInputs;
            for (int j = 0; j < this.numInputs; ++j) {
                double d3 = this.activations[j] - this.centers[n + j];
                d2 += d3 * d3;
            }
            d2 = Math.sqrt(d2);
            double d4 = this.allWidths == 0.0 ? this.widths[i] : this.allWidths;
            switch (this.basisFunction) {
                case 0: {
                    d = this.gaussian(d2, d4);
                    break;
                }
                case 1: {
                    d = this.tPSpline(d2);
                    break;
                }
                case 2: {
                    d = this.multiQuad(d2, d4);
                    break;
                }
                default: {
                    this.basisFunction = 0;
                    d = this.gaussian(d2, d4);
                }
            }
            this.unitInput[i + this.numInputs] = d2;
            this.activations[i + this.numInputs] = d;
        }
        if (this.normalized) {
            int n;
            double d = 0.0;
            for (n = this.firstHid; n < this.firstOut; ++n) {
                d += this.activations[n];
            }
            if (d == 0.0) {
                d = 1.0;
            }
            for (n = this.firstHid; n < this.firstOut; ++n) {
                this.activations[n] = this.activations[n] / d;
            }
        }
        this.Fwd_Prop(this.firstHid, this.firstOut, this.numUnits, this.weights);
    }

    void Calc_Delta(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.delta[i] = this.error[i] * (this.activations[i] + this.ActOffset) * (1.0 - this.activations[i] + this.ActOffset);
        }
    }

    void Back_Prop(int n, int n2, int n3, double[] dArray, double[] dArray2) {
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            int n5 = n;
            while (n5 < n2) {
                int n6 = n4;
                dArray2[n6] = dArray2[n6] + this.delta[i] * this.activations[n5];
                int n7 = n5++;
                this.error[n7] = this.error[n7] + dArray[n4] * this.delta[i];
                ++n4;
            }
            int n8 = i;
            this.thrDeriv[n8] = this.thrDeriv[n8] + this.delta[i];
        }
    }

    void calcError() {
        int n;
        double d = !this.symmetricActFunction ? 0.0 : 0.5;
        for (int i = 0; i < this.firstOut; ++i) {
            this.error[i] = 0.0;
        }
        int n2 = 0;
        double d2 = 0.0;
        double d3 = 1.0 - d - this.tolerance;
        long l = 0L;
        for (n = this.firstOut; n < this.numUnits; ++n) {
            this.error[n] = this.explicitErrorMode ? this.teach[n - this.firstOut] : this.teach[n - this.firstOut] - this.activations[n];
            if (this.activations[n] > d3) {
                ++l;
            }
            d2 += this.error[n] * this.error[n];
            if (Math.abs(this.error[n]) > this.tolerance) {
                ++n2;
                continue;
            }
            this.error[n] = 0.0;
        }
        this.lastNumBadOut = n2;
        if (n2 > 0) {
            this.cumNumBadPat += 1.0;
        }
        this.lastRMSError = Math.sqrt(d2 / (double)this.numOutputs);
        this.confidence = 1.0 - this.lastRMSError;
        this.cumRMSError += this.lastRMSError;
        if (this.cumMaxRMSError < this.lastRMSError) {
            this.cumMaxRMSError = this.lastRMSError;
        }
        this.unknownFlag = 0;
        if (l >= 1L) {
            if (n2 == 0) {
                this.cumCorrect += 1.0;
            } else {
                this.cumIncorrect += 1.0;
            }
        } else {
            this.cumUnknown += 1.0;
            this.unknownFlag = 1;
        }
        if (this.netMode != 2) {
            this.Calc_Delta(this.firstOut, this.numUnits);
            this.Back_Prop(this.firstHid, this.firstOut, this.numUnits, this.weights, this.wgtDeriv);
            if (this.computeSensitivity) {
                for (n = 0; n < this.firstHid; ++n) {
                    int n3 = n;
                    this.cumErrorIndex[n3] = this.cumErrorIndex[n3] + Math.abs(this.error[n]);
                }
            }
        }
    }

    void Bump_Weights(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = this.learnRate * dArray2[i] + this.momentum * dArray3[i];
            int n = i;
            dArray[n] = dArray[n] + dArray3[i];
            dArray2[i] = 0.0;
        }
    }

    void Bump_Thresholds(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.thrDeltas[i] = this.learnRate * this.thrDeriv[i] + this.momentum * this.thrDeltas[i];
            int n3 = i;
            this.threshold[n3] = this.threshold[n3] + this.thrDeltas[i];
            this.thrDeriv[i] = 0.0;
        }
    }

    void adjustWeights() {
        this.Bump_Weights(this.weights, this.wgtDeriv, this.wgtDeltas);
        this.Bump_Thresholds(this.firstOut, this.numUnits);
    }

    void computeIndices() {
        this.firstHid = this.numInputs + this.numContextUnits;
        this.firstOut = this.numUnits - this.numOutputs;
    }

    void initialize() {
        int n;
        this.computeIndices();
        this.netRecInx = 0L;
        this.cumRMSError = 0.0;
        this.cumMaxRMSError = 0.0;
        this.cumNumBadPat = 0.0;
        this.cumMaxError = 0.0;
        this.cumCorrect = 0.0;
        this.cumIncorrect = 0.0;
        this.cumUnknown = 0.0;
        this.percentCorrect = 0.0;
        this.percentIncorrect = 0.0;
        this.percentUnknown = 0.0;
        this.unknownFlag = 0;
        for (n = 0; n < this.numWeights; ++n) {
            this.wgtDeriv[n] = 0.0;
        }
        for (n = 0; n < this.numUnits; ++n) {
            this.thrDeriv[n] = 0.0;
        }
        for (n = 0; n < this.numHidden; ++n) {
            this.winRate[n] = 0;
        }
    }

    void initWeights() {
        double d;
        int n;
        this.netEpoch = 0L;
        this.lastRMSError = 0.0;
        this.lastNumBadOut = 0.0;
        this.aveRMSError = 1.0;
        this.maxRMSError = 1.0;
        this.badPatRatio = 1.0;
        this.cumRMSError = 0.0;
        this.cumMaxRMSError = 0.0;
        this.cumNumBadPat = 0.0;
        this.cumMaxError = 0.0;
        double d2 = 1.0 / Math.sqrt(this.firstHid);
        double d3 = d2 / 2.0;
        for (n = 0; n < this.numWeights; ++n) {
            this.weights[n] = d = d3 - Math.random() * d2;
            this.wgtDeriv[n] = 0.0;
            this.wgtDeltas[n] = 0.0;
        }
        for (n = 0; n < this.numHidden; ++n) {
            int n2;
            double d4 = 0.0;
            int n3 = n * this.numInputs;
            for (n2 = 0; n2 < this.numInputs; ++n2) {
                d = 0.5 - Math.random();
                d4 += d;
                this.centers[n3 + n2] = d;
            }
            for (n2 = 0; n2 < this.numInputs; ++n2) {
                this.centers[n3 + n2] = this.centers[n3 + n2] / d4;
            }
        }
        for (n = 0; n < this.numUnits; ++n) {
            this.threshold[n] = 0.0;
            this.thrDeriv[n] = 0.0;
            this.thrDeltas[n] = 0.0;
        }
        for (n = 0; n < this.firstHid; ++n) {
            this.cumErrorIndex[n] = 0.0;
        }
        if (this.autoCenter) {
            try {
                this.kMapNet.reset();
            }
            catch (AbleException ableException) {
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, "initWeights", (Throwable)ableException);
                }
                this.logger.text(4L, (Object)this, "initWeights", ableException.getLocalizedMessage());
            }
            this.trainingKMapNet = true;
        } else {
            this.trainingKMapNet = false;
        }
    }

    public void reset() throws AbleException {
        this.netMode = 0;
        this.initialize();
        this.initWeights();
    }

    public void readInputs() throws AbleException {
        if (this.parent != null) {
            AbleDataSource ableDataSource = ((AbleAgent)this.parent).getDataSource();
            if (ableDataSource != null) {
                this.netStepsPerEpoch = ableDataSource.getNumRecords();
                if (this.kMapNet != null) {
                    this.kMapNet.setNetStepsPerEpoch(this.netStepsPerEpoch);
                }
            } else {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "readInputs", "Error: no datasource.");
                }
                this.logger.text(4L, (Object)this, "readInputs", "Error: no datasource.");
            }
        }
        this.netRecInx %= this.netStepsPerEpoch;
        int n = 0;
        if (this.inputBuffer == null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "readInputs", "Error: inputBuffer is null!");
            }
        } else {
            this.inNum = (double[])this.inputBuffer;
        }
        for (n = 0; n < this.numInputs; ++n) {
            this.activations[n] = this.inNum[n];
        }
        for (int i = 0; i < this.numOutputs; ++i) {
            this.teach[i] = this.inNum[n++];
            this.outNum[i + this.numOutputs] = this.teach[i];
        }
        ++this.netRecInx;
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        this.readInputs();
        this.calcOutputs();
        boolean bl = false;
        if (this.netRecInx >= this.netStepsPerEpoch) {
            bl = true;
        }
        if (this.netMode == 0) {
            if (this.trainingKMapNet) {
                this.kMapNet.setInputBuffer(this.inNum);
                this.kMapNet.process();
                this.winner = this.kMapNet.getWinner();
                this.winnerAct = this.kMapNet.getWinnerAct();
            } else {
                this.calcError();
                if (!this.epochUpdate) {
                    this.adjustWeights();
                } else if (bl) {
                    this.adjustWeights();
                }
            }
        }
        if (this.netRecInx >= this.netStepsPerEpoch) {
            this.endEpoch();
            this.netRecInx = 0L;
        }
        for (int i = 0; i < this.numOutputs; ++i) {
            this.outNum[i] = this.activations[this.firstOut + i];
        }
        this.dataChanged(this.outputBuffer);
    }

    public void generateTranslateTemplates(AbleFilter ableFilter, AbleFilter ableFilter2, Vector vector) throws AbleException {
        ArrayList<AbleTranslateTemplate> arrayList = new ArrayList<AbleTranslateTemplate>();
        for (int i = 0; i < vector.size(); ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            ableFilter.addTemplateRec(ableField.getInputTranslateTemplate());
            if (!ableField.getUsageString().equalsIgnoreCase("output")) continue;
            AbleTranslateTemplate ableTranslateTemplate = ableField.getOutputTranslateTemplate();
            ableFilter2.addTemplateRec(ableTranslateTemplate);
            AbleTranslateTemplate ableTranslateTemplate2 = (AbleTranslateTemplate)ableTranslateTemplate.clone();
            ableTranslateTemplate2.setUsage(1);
            ableTranslateTemplate2.setName(ableTranslateTemplate.getName() + "_target");
            arrayList.add(ableTranslateTemplate2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ableFilter2.addTemplateRec((AbleTranslateTemplate)iterator.next());
        }
    }

    public Object[] generateFilters(AbleDataSource ableDataSource) throws AbleException {
        AbleFilter ableFilter = new AbleFilter("GenInFilter");
        AbleFilter ableFilter2 = new AbleFilter("GenOutFilter");
        Vector vector = ableDataSource.getFieldList();
        ArrayList<AbleTranslateTemplate> arrayList = new ArrayList<AbleTranslateTemplate>();
        for (int i = 0; i < vector.size(); ++i) {
            AbleField ableField = (AbleField)vector.elementAt(i);
            ableFilter.addTemplateRec(ableField.getInputTranslateTemplate());
            if (!ableField.getUsageString().equalsIgnoreCase("output")) continue;
            AbleTranslateTemplate ableTranslateTemplate = ableField.getOutputTranslateTemplate();
            ableFilter2.addTemplateRec(ableTranslateTemplate);
            AbleTranslateTemplate ableTranslateTemplate2 = (AbleTranslateTemplate)ableTranslateTemplate.clone();
            ableTranslateTemplate2.setUsage(1);
            ableTranslateTemplate2.setName(ableTranslateTemplate.getName() + "_target");
            arrayList.add(ableTranslateTemplate2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ableFilter2.addTemplateRec((AbleTranslateTemplate)iterator.next());
        }
        return new AbleFilter[]{ableFilter, ableFilter2};
    }

    public void endEpoch() {
        int n = (int)this.netStepsPerEpoch;
        if (this.trainingKMapNet && this.kMapNet.getNetMode() == 1) {
            this.trainingKMapNet = false;
            double[] dArray = this.kMapNet.getWeights();
            if (dArray.length != this.centers.length) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "endEpoch()", "Error in RBF Network - number of KMap weights doesn't match center weights");
                }
            } else {
                if (this.trace.isLogging()) {
                    this.trace.text(0x100000L, (Object)this, "endEpoch()", "RBFNet: Copying KMap weights to RBF center weights");
                }
                for (int i = 0; i < this.centers.length; ++i) {
                    this.centers[i] = dArray[i];
                }
            }
        }
        double d = this.aveRMSError;
        if (n > 0) {
            this.aveRMSError = this.cumRMSError / (double)n;
            this.badPatRatio = this.cumNumBadPat / (double)n;
            this.percentCorrect = 100.0 * (this.cumCorrect / (double)n);
            this.percentIncorrect = 100.0 * (this.cumIncorrect / (double)n);
            this.percentUnknown = 100.0 * (this.cumUnknown / (double)n);
        } else {
            this.aveRMSError = 1.0;
            this.badPatRatio = 1.0;
            this.percentCorrect = 0.0;
            this.percentIncorrect = 100.0;
            this.percentUnknown = 0.0;
        }
        this.maxRMSError = this.cumMaxRMSError;
        this.cumRMSError = 0.0;
        this.cumNumBadPat = 0.0;
        this.cumMaxRMSError = 0.0;
        this.cumCorrect = 0.0;
        this.cumIncorrect = 0.0;
        this.cumUnknown = 0.0;
        if (this.netMode == 0) {
            ++this.netEpoch;
            if (this.adaptLearnRate) {
                double d2 = (d - this.aveRMSError) / d;
                if (d2 > 0.0 && d2 < 0.001) {
                    if (lastSign == 1) {
                        this.learnRate *= 1.2;
                    }
                } else if (d2 < 0.0 && lastSign == 0) {
                    this.learnRate *= 0.9;
                }
                int n2 = lastSign = d2 >= 0.0 ? 1 : 0;
                if (this.learnRate < 0.001) {
                    this.learnRate = 0.001;
                }
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, this.netEpoch + ": " + this.aveRMSError + " erate = " + d2 + " ,lrate = " + this.learnRate);
                }
            }
            if (this.computeSensitivity) {
                int n3;
                double d3 = 0.0;
                for (n3 = 0; n3 < this.firstHid; ++n3) {
                    d3 += this.cumErrorIndex[n3];
                }
                if (d3 == 0.0) {
                    d3 = 1.0;
                }
                for (n3 = 0; n3 < this.firstHid; ++n3) {
                    this.inputSensitivity[n3] = this.cumErrorIndex[n3] / d3;
                }
            }
        }
    }

    public void changeNetArchitecture(String string) throws AbleException {
    }

    public void createNetwork(int n, int n2, int n3) throws AbleException {
        this.numInputs = n;
        this.numHidden = n2;
        this.numOutputs = n3;
        this.numContextUnits = 0;
        this.numUnits = this.numInputs + this.numHidden + this.numOutputs + this.numContextUnits;
        this.numWeights = this.numHidden * this.numOutputs;
        this.numCenters = this.numInputs * this.numHidden;
        this.learnRate = 0.2;
        this.momentum = 0.5;
        this.tolerance = 0.1;
        this.netMode = 0;
        this.aveRMSError = 1.0;
        this.symmetricActFunction = false;
        this.epochUpdate = false;
        this.maxRMSError = 1.0;
        this.computeSensitivity = false;
        this.percentCorrect = 0.0;
        this.percentIncorrect = 0.0;
        this.percentUnknown = 0.0;
        this.unknownFlag = 0;
        this.decayFactor = 0.0;
        this.adaptLearnRate = false;
        this.explicitErrorMode = false;
        this.confidence = 0.0;
        this.recsPerUpdate = 0;
        this.activations = new double[this.numUnits];
        this.weights = new double[this.numWeights];
        this.centers = new double[this.numCenters];
        this.widths = new double[this.numHidden];
        this.threshold = new double[this.numUnits];
        this.teach = new double[this.numOutputs];
        this.error = new double[this.numUnits];
        this.delta = new double[this.numUnits];
        this.unitInput = new double[this.numUnits];
        this.wgtDeltas = new double[this.numWeights];
        this.thrDeltas = new double[this.numUnits];
        this.wgtDeriv = new double[this.numWeights];
        this.thrDeriv = new double[this.numUnits];
        this.inputSensitivity = new double[this.numInputs + this.numContextUnits];
        this.cumErrorIndex = new double[this.numInputs + this.numContextUnits];
        this.winRate = new int[this.numHidden];
        this.inNum = new double[this.numInputs + this.numOutputs];
        this.inputBuffer = this.inNum;
        this.outNum = new double[2 * this.numOutputs];
        this.outputBuffer = this.outNum;
        try {
            this.kMapNet = new AbleSelfOrganizingMap();
            this.kMapNet.setNetArchitecture(this.numInputs + " " + this.numHidden + " " + "1");
            this.kMapNet.setMaxNumEpochs(this.centerWeightPasses);
        }
        catch (AbleException ableException) {
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "createNetwork", (Throwable)ableException);
            }
            this.logger.text(4L, (Object)this, "createNetwork", ableException.getLocalizedMessage());
        }
        this.reset();
        this.init();
        this.setDataFlowEnabled(true);
    }

    public void setNetArchitecture(String string) throws AbleException {
        String string2 = this.netArchitecture;
        this.netArchitecture = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 3 && this.trace.isLogging()) {
            this.trace.text(262144L, (Object)this, "setNetArchitecture", "Architecture requires at least 3 values");
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        this.createNetwork(n, n2, n3);
        this.chgSupport.firePropertyChange("netArchitecture", string2, this.netArchitecture);
    }

    public Vector getNetworkGraphicData() {
        Vector<Object> vector = new Vector<Object>();
        Vector<double[]> vector2 = new Vector<double[]>();
        int[] nArray = new int[]{this.numInputs + this.numContextUnits, this.numHidden, this.numOutputs};
        vector2.addElement(this.centers);
        vector2.addElement(this.weights);
        vector.addElement(nArray);
        vector.addElement(this.activations);
        vector.addElement(vector2);
        return vector;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

