/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleException;
import com.ibm.able.AbleUserDefinedFunction;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class AbleGeneticObject
implements Serializable {
    protected static final long serialVersionUID = 1999100100000000001L;
    protected AbleAgent searchAgent;
    protected AbleAgent evaluationAgent;
    protected Object chromosome;
    protected AbleBean member = null;
    protected String vocabulary = "01";
    protected Class chromosomeType = class$java$lang$String == null ? (class$java$lang$String = AbleGeneticObject.class$("java.lang.String")) : class$java$lang$String;
    protected int chromosomeLength = 10;
    protected double fitness = 0.0;
    protected boolean fitnessComputed = false;
    protected double normalizedFitness = 0.0;
    protected double crossoverRate = 0.65;
    protected double mutationRate = 0.008;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public AbleBean getBean() {
        return this.member;
    }

    public void removeBean() throws AbleException {
        if (this.evaluationAgent != null && this.member != null) {
            this.evaluationAgent.removeBean(this.member);
        }
    }

    public AbleAgent initEvaluationAgent() {
        this.evaluationAgent = null;
        return this.evaluationAgent;
    }

    public void setEvaluationAgent(AbleAgent ableAgent) {
        this.evaluationAgent = ableAgent;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setNormalizedFitness(double d) {
        this.normalizedFitness = d;
    }

    public double getNormalizedFitness() {
        return this.normalizedFitness;
    }

    public double computeFitness() {
        return this.fitness;
    }

    public Object getRandomChromosome() {
        return this.generateRandomChromosome(this.chromosomeLength);
    }

    public void setChromosome(Object object) {
        this.chromosome = object;
        this.initBean();
        this.computeFitness();
    }

    public void initBean() {
    }

    public Object getChromosome() {
        return this.chromosome;
    }

    public int getChromosomeLength() {
        return this.chromosomeLength;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public Class getChromosomeType() {
        return this.chromosomeType;
    }

    public void setCrossoverRate(double d) {
        this.crossoverRate = d;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public void setMutationRate(double d) {
        this.mutationRate = d;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public Object generateRandomChromosome(int n) {
        String string = new String(new char[n]);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n;
        int n3 = this.vocabulary.length();
        for (int i = 0; i < n2; ++i) {
            double d = Math.random();
            int n4 = (int)(d * (double)n3);
            if (n4 == n3) {
                --n4;
            }
            char c = this.vocabulary.charAt(n4);
            stringBuffer.setCharAt(i, c);
        }
        return stringBuffer.toString();
    }

    public Object[] onePointCrossoverAndMutate(Object[] objectArray) {
        double d;
        Object[] objectArray2 = new Object[2];
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        boolean bl = Able.TraceLog.isLogging();
        if (bl) {
            Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossoverAndMutate", "parent1 chromosome = " + string + " " + string.length());
            Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossoverAndMutate", "parent2 chromosome = " + string2 + " " + string2.length());
        }
        if ((d = Math.random()) < this.crossoverRate) {
            String string3 = string;
            String string4 = "";
            String string5 = string2;
            String string6 = "";
            int n = (int)(Math.random() * (double)this.chromosomeLength);
            if (n > 0 && n <= this.chromosomeLength) {
                string3 = string.substring(0, n);
                string4 = string.substring(n, this.chromosomeLength);
                string5 = string2.substring(0, n);
                string6 = string2.substring(n, this.chromosomeLength);
            }
            string = string3 + string6;
            string2 = string5 + string4;
            if (bl) {
                Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossoverAndMutate", "c1 crossover chromosome = " + string + " " + string.length());
                Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossoverAndMutate", "c2 crossover chromosome = " + string2 + " " + string2.length());
            }
        }
        string = this.mutateChromosome(string);
        string2 = this.mutateChromosome(string2);
        objectArray2[0] = string;
        objectArray2[1] = string2;
        return objectArray2;
    }

    public String mutateChromosome(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = this.vocabulary.length();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = Math.random();
            int n3 = 0;
            boolean bl = Able.TraceLog.isLogging();
            if (!(d2 < this.mutationRate)) continue;
            if (bl) {
                Able.TraceLog.text(0x100000L, (Object)this, "mutateChromosome", "mutate bit position = " + i);
            }
            if ((n3 = (int)((d = Math.random()) * (double)n2)) == n2) {
                --n3;
            }
            char c = this.vocabulary.charAt(n3);
            stringBuffer.setCharAt(i, c);
        }
        return stringBuffer.toString();
    }

    public Object[] onePointCrossover(Object[] objectArray) {
        double d;
        Object[] objectArray2 = new Object[2];
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        boolean bl = Able.TraceLog.isLogging();
        if (bl) {
            Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossover", "parent1 chromosome = " + string + " " + string.length());
            Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossover", "parent2 chromosome = " + string2 + " " + string2.length());
        }
        if ((d = Math.random()) < this.crossoverRate) {
            String string3 = string;
            String string4 = "";
            String string5 = string2;
            String string6 = "";
            int n = (int)(Math.random() * (double)this.chromosomeLength);
            if (n > 0 && n <= this.chromosomeLength) {
                string3 = string.substring(0, n);
                string4 = string.substring(n, this.chromosomeLength);
                string5 = string2.substring(0, n);
                string6 = string2.substring(n, this.chromosomeLength);
            }
            string = string3 + string6;
            string2 = string5 + string4;
            if (bl) {
                Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossover(Object[])", "c1 1pt crossover = " + string + " " + string.length());
                Able.TraceLog.text(0x100000L, (Object)this, "onePointCrossover(Object[])", "c2 1pt crossover = " + string2 + " " + string2.length());
            }
        }
        objectArray2[0] = string;
        objectArray2[1] = string2;
        return objectArray2;
    }

    public Object[] twoPointCrossover(Object[] objectArray) {
        double d;
        Object[] objectArray2 = new Object[2];
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        boolean bl = Able.TraceLog.isLogging();
        if (bl) {
            Able.TraceLog.text(0x100000L, (Object)this, "twoPointCrossover(Object[])", "parent1 chromosome = " + string + " " + string.length());
            Able.TraceLog.text(0x100000L, (Object)this, "twoPointCrossover(Object[])", "parent2 chromosome = " + string2 + " " + string2.length());
        }
        if ((d = Math.random()) < this.crossoverRate) {
            String string3 = string;
            String string4 = "";
            String string5 = "";
            String string6 = string2;
            String string7 = "";
            String string8 = "";
            int n = (int)(Math.random() * (double)this.chromosomeLength);
            int n2 = (int)(Math.random() * (double)(this.chromosomeLength - n));
            if (n2 > n) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            if (n2 > 0 && n <= this.chromosomeLength) {
                String string9 = string;
                string3 = string9.substring(0, n2);
                string4 = string9.substring(n2, n);
                string5 = string9.substring(n, this.chromosomeLength);
                string9 = string2;
                string6 = string9.substring(0, n2);
                string7 = string9.substring(n2, n);
                string8 = string9.substring(n, this.chromosomeLength);
            }
            string = string3 + string7 + string5;
            string2 = string6 + string4 + string8;
        }
        objectArray2[0] = string;
        objectArray2[1] = string2;
        return objectArray2;
    }

    public Object[] uniformCrossover(Object[] objectArray) {
        double d;
        Object[] objectArray2 = new Object[2];
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        boolean bl = Able.TraceLog.isLogging();
        if (bl) {
            Able.TraceLog.text(0x100000L, (Object)this, "uniformCrossover(Object[])", "parent1 chromosome = " + string + " " + string.length());
            Able.TraceLog.text(0x100000L, (Object)this, "uniformCrossover(Object[])", "parent2 chromosome = " + string2 + " " + string2.length());
        }
        if ((d = Math.random()) < this.crossoverRate) {
            StringBuffer stringBuffer = new StringBuffer(string);
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                double d2 = Math.random();
                int n2 = (int)(d2 * 2.0);
                if (n2 == 2) {
                    n2 = 1;
                }
                if (n2 == 0) {
                    stringBuffer2.setCharAt(i, stringBuffer.charAt(i));
                    continue;
                }
                stringBuffer.setCharAt(i, stringBuffer2.charAt(i));
            }
            string = stringBuffer.toString();
            string2 = stringBuffer2.toString();
            if (bl) {
                Able.TraceLog.text(0x100000L, (Object)this, "uniformCrossover(Object[])", "c1 uniform crossover  = " + string + " " + string.length());
                Able.TraceLog.text(0x100000L, (Object)this, "uniformCrossover(Object[])", "c2 uniform crossover  = " + string2 + " " + string2.length());
            }
        }
        objectArray2[0] = string;
        objectArray2[1] = string2;
        return objectArray2;
    }

    public Object[] mutate(Object[] objectArray) {
        Object[] objectArray2 = new Object[]{this.mutateChromosome((String)objectArray[0]), this.mutateChromosome((String)objectArray[1])};
        return objectArray2;
    }

    public void registerOperators(AbleAgent ableAgent) {
        this.searchAgent = ableAgent;
        try {
            AbleUserDefinedFunction ableUserDefinedFunction = new AbleUserDefinedFunction("onePointCrossoverAndMutate", (Object)this, "onePointCrossoverAndMutate", new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleGeneticObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object});
            ableAgent.addUserDefinedFunction(ableUserDefinedFunction);
            ableUserDefinedFunction = new AbleUserDefinedFunction("onePointCrossover", (Object)this, "onePointCrossover", new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleGeneticObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object});
            ableAgent.addUserDefinedFunction(ableUserDefinedFunction);
            ableUserDefinedFunction = new AbleUserDefinedFunction("twoPointCrossover", (Object)this, "twoPointCrossover", new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleGeneticObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object});
            ableAgent.addUserDefinedFunction(ableUserDefinedFunction);
            ableUserDefinedFunction = new AbleUserDefinedFunction("uniformCrossover", (Object)this, "uniformCrossover", new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleGeneticObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object});
            ableAgent.addUserDefinedFunction(ableUserDefinedFunction);
            ableUserDefinedFunction = new AbleUserDefinedFunction("mutate", (Object)this, "mutate", new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleGeneticObject.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object});
            ableAgent.addUserDefinedFunction(ableUserDefinedFunction);
        }
        catch (Exception exception) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "registerOperators()", "AbleGeneticObject Error: can't create UserDefinedFunction for operator " + exception.getLocalizedMessage());
                Able.TraceLog.exception(262144L, (Object)this, "registerOperators()", (Throwable)exception);
            }
            Able.MessageLog.text(4L, (Object)this, "registerOperators()", exception.getLocalizedMessage());
        }
    }

    public Hashtable getOperatorFitness() throws AbleException {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        if (this.searchAgent != null) {
            this.searchAgent.getUserDefinedFunctions();
            Hashtable hashtable2 = this.searchAgent.getUserDefinedFunctions();
            Enumeration enumeration = hashtable2.keys();
            Double d = new Double(100.0);
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                AbleUserDefinedFunction ableUserDefinedFunction = (AbleUserDefinedFunction)hashtable2.get(k);
                hashtable.put(ableUserDefinedFunction.getName(), d);
                if (d != 100.0) continue;
                d = new Double(0.0);
            }
        }
        return hashtable;
    }

    public double binaryToInteger(String string) {
        double d = 0.0;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '1') continue;
            d += Math.pow(2.0, n - 1 - i);
        }
        return d;
    }

    public String toString() {
        if (this.chromosomeType == (class$java$lang$String == null ? (class$java$lang$String = AbleGeneticObject.class$("java.lang.String")) : class$java$lang$String)) {
            return this.chromosome + " : " + String.valueOf(this.fitness);
        }
        return String.valueOf(this.fitness);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

