/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleDataSink;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleState;
import com.ibm.able.beans.AbleImport;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class AbleExport
extends AbleObject
implements AbleDataSink,
Serializable {
    static final long serialVersionUID = 2003030100000000002L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_Export");
    protected String dataFileName = null;
    protected int numFieldsPerRecord = 0;
    private String delimiter = (String)AbleImport.DelimiterChars.elementAt(0);
    private transient double[] inNum = null;
    private transient String[] inSym = null;
    private transient FileWriter writer = null;
    protected transient BufferedWriter out = null;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public AbleExport() throws AbleException {
        this(defaultName);
    }

    public AbleExport(String string) throws AbleException {
        super(string == null ? defaultName : string);
    }

    public AbleExport(String string, String string2) throws AbleException {
        this(string);
        this.setDataFileName(string2);
    }

    public void init() throws AbleException {
        try {
            this.open();
        }
        catch (IOException iOException) {
            this.logger.text(4L, (Object)this, "init", iOException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "init", (Throwable)iOException);
            }
            throw new AbleException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        super.init();
    }

    void open() throws IOException {
        if (this.dataFileName == null) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException("dataFileName = null");
            throw fileNotFoundException;
        }
        this.close();
        this.writer = new FileWriter(this.dataFileName, true);
        this.out = new BufferedWriter(this.writer);
        this.setState(1021);
        this.setDataFlowEnabled(true);
    }

    public void setDataFileName(String string) {
        if (this.dataFileName == null || !this.dataFileName.equals(string)) {
            String string2 = this.dataFileName;
            this.close();
            this.dataFileName = string;
            this.chgSupport.firePropertyChange("dataFileName", string2, string);
        }
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setDelimiter(String string) {
        String string2 = this.delimiter;
        if (string != null && string.length() > 0) {
            this.delimiter = string.substring(0, 1);
            this.chgSupport.firePropertyChange("delimiter", string2, string);
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setNumberOfInputs(int n) {
        this.numFieldsPerRecord = n;
    }

    public int getNumberOfInputFields() {
        return this.numFieldsPerRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws AbleException {
        int n;
        Object object;
        if (this.out == null) {
            return;
        }
        if (this.inputBuffer == null) {
            this.inputBuffer = new String[1];
        }
        this.processBufferConnections();
        Class<?> clazz = this.inputBuffer.getClass();
        if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleExport.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            this.inSym = (String[])this.inputBuffer;
            this.numFieldsPerRecord = this.inSym.length;
        } else if (clazz == (array$D == null ? (array$D = AbleExport.class$("[D")) : array$D)) {
            this.inNum = (double[])this.inputBuffer;
            this.numFieldsPerRecord = this.inNum.length;
        } else if (clazz == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleExport.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
            object = (Object[])this.inputBuffer;
            this.inSym = new String[((Object[])object).length];
            for (n = 0; n < ((Object[])object).length; ++n) {
                this.inSym[n] = object[n].toString();
            }
        }
        object = this.out;
        synchronized (object) {
            try {
                if (this.inSym != null) {
                    n = this.inSym.length;
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (n2 != 0) {
                            this.out.write(this.delimiter);
                        }
                        if (this.inSym[i] == null) continue;
                        this.out.write(this.inSym[i]);
                        ++n2;
                    }
                    if (n2 > 0) {
                        this.out.newLine();
                    }
                } else {
                    n = this.inNum.length;
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            this.out.write(this.delimiter);
                        }
                        this.out.write(String.valueOf(this.inNum[i]));
                    }
                    this.out.newLine();
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                this.logger.text(4L, (Object)this, "process", iOException.getLocalizedMessage());
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, "process", (Throwable)iOException);
                }
                throw new AbleException(iOException.getLocalizedMessage(), (Throwable)iOException);
            }
        }
        this.dataChanged(this.inputBuffer);
    }

    public Object process(Object object) throws AbleException {
        if (this.inputBuffer == null) {
            this.inputBuffer = new String[1];
        }
        if (this.outputBuffer == null) {
            this.outputBuffer = new String[1];
        }
        if (object instanceof String) {
            return super.process((Object)new String[]{(String)object});
        }
        return super.process(object);
    }

    public void quitAll() throws AbleException {
        super.quitAll();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.out != null) {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {
                this.logger.text(2L, (Object)this, "close", iOException.getLocalizedMessage());
                if (this.trace.isLogging()) {
                    this.trace.exception(524288L, (Object)this, "close", (Throwable)iOException);
                }
            }
            finally {
                this.setDataFlowEnabled(false);
                this.setState(1026);
            }
        }
    }

    public void flush() throws AbleException {
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                this.logger.text(4L, (Object)this, "flush", iOException.getLocalizedMessage());
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, "flush", (Throwable)iOException);
                }
                throw new AbleException(iOException.getLocalizedMessage(), (Throwable)iOException);
            }
        }
    }

    public void erase() throws AbleException {
        this.close();
        try {
            this.writer = new FileWriter(this.dataFileName, false);
            this.out = new BufferedWriter(this.writer);
            this.setDataFlowEnabled(true);
        }
        catch (IOException iOException) {
            this.logger.message(4L, (Object)this, "erase", iOException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "erase", (Throwable)iOException);
            }
            throw new AbleException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        this.close();
    }

    public void reset() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.init();
    }

    public boolean isReady() throws AbleException {
        if (this.out == null) {
            return false;
        }
        return AbleState.isReady((int)this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (this.out == null) {
            return;
        }
        try {
            Object object = ableEvent.getArgObject();
            String string = null;
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                StringBuffer stringBuffer = new StringBuffer();
                if (object instanceof double[]) {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append(this.delimiter + Array.getDouble(object, i));
                            continue;
                        }
                        stringBuffer.append(Array.getDouble(object, i));
                    }
                } else if (object instanceof Object[]) {
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuffer.append(this.delimiter + objectArray[i]);
                            continue;
                        }
                        stringBuffer.append(objectArray[i]);
                    }
                } else if (this.trace.isLogging()) {
                    this.trace.text(262144L, "Array class " + object.getClass().getName() + " not supported for export.");
                }
                string = stringBuffer.toString();
            } else {
                string = object.toString();
            }
            BufferedWriter bufferedWriter = this.out;
            synchronized (bufferedWriter) {
                this.out.write(string);
                this.out.newLine();
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.logger.text(4L, (Object)this, "processAbleEvent", iOException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "processAbleEvent", (Throwable)iOException);
            }
            throw new AbleException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "processAbleEvent", exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "processAbleEvent", (Throwable)exception);
            }
            if (!(exception instanceof AbleException)) {
                throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
            }
            throw (AbleException)((Object)exception);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.dataFileName = Able.getSerializablePath((String)this.dataFileName);
        objectOutputStream.defaultWriteObject();
        this.dataFileName = Able.getLocalPath((String)this.dataFileName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.dataFileName = Able.getLocalPath((String)this.dataFileName);
        try {
            int n = this.getState();
            if (n == 1021 || n == 1025) {
                this.open();
            }
        }
        catch (IOException iOException) {
            this.setState(1026);
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "readObject", (Throwable)iOException);
            }
            this.logger.text(4L, (Object)this, "readObject", iOException.getLocalizedMessage());
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

