/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.AbleObject;
import com.ibm.able.beans.AbleDataSeries;
import com.ibm.able.beans.AbleDataSeriesHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbleDataTable
extends AbleObject
implements Serializable {
    public static final Class classClass = new Object().getClass().getClass();
    public static final Class classDouble = new Double(0.0).getClass();
    public static final Class classDoubleArray = new double[0].getClass();
    public static final Class classIntArray = new int[0].getClass();
    public static final Class classInteger = new Integer(0).getClass();
    public static final Class classString = new String("").getClass();
    public static final Class classStringArray = new String[0].getClass();
    static String clsNm = "AbleDataTable";
    public static final boolean DEFAULT_CALC_ON_ADD = false;
    public static final String DEFAULT_DELIMITER_STRING = " \t,";
    public static final boolean DEFAULT_HAS_TITLES = true;
    public static final int DEFAULT_HISTORY_SIZE = 10;
    public static final int INVALID_INDEX = -1;
    public static final int MAX_RECORD_SIZE = 4096;
    static final long serialVersionUID = 2002041900000000004L;
    public static final String strUnknown = "Unknown";
    private boolean m_bCalcOnAdd = false;
    private boolean m_bLocked = false;
    private boolean m_bNeedsCalc = true;
    private AbleDataSeries[] m_ColArray;
    private Hashtable m_ColTitles;
    private int m_iCols = 0;
    private int m_iRowCapacity = Integer.MAX_VALUE;
    private int m_iRows = 0;
    public static int DATASERIES_SUCCESS = 0;
    public static int DATASERIES_ERROR_INVALID_ARRAY = -1;
    public static int DATASERIES_ERROR_INCONSISTENT_SIZE = -2;

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    public static AbleDataTable getDataTableFromFile(String string) {
        AbleDataTable ableDataTable = null;
        ableDataTable = new AbleDataTable(string);
        return ableDataTable;
    }

    public static AbleDataTable getDataTableFromFile(String string, Boolean bl, Boolean bl2) {
        AbleDataTable ableDataTable = null;
        if (bl == null) {
            bl = new Boolean(true);
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        ableDataTable = new AbleDataTable(string, (boolean)bl, (boolean)bl2);
        return ableDataTable;
    }

    private static String toLeftPaddedString(int n, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = String.valueOf(n);
        for (int i = n2 - string.length(); i > 0; --i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public AbleDataTable(double d) {
        this.initContents((int)d, false);
    }

    public AbleDataTable(double d, boolean bl) throws RemoteException {
        this.initContents((int)d, bl);
    }

    public AbleDataTable(int n) {
        this.initContents(n, false);
    }

    public AbleDataTable(int n, boolean bl) {
        this.initContents(n, bl);
    }

    public AbleDataTable(String string) {
        this.buildFromFile(string, true, false);
    }

    public AbleDataTable(String string, boolean bl, boolean bl2) {
        this.buildFromFile(string, bl, bl2);
    }

    public AbleDataTable(String[] stringArray, boolean bl, boolean bl2) {
        this.buildFromStringArray(stringArray, bl, bl2);
    }

    public synchronized boolean addColumn(AbleDataSeries ableDataSeries) {
        return this.addColumn(ableDataSeries, ableDataSeries.getName());
    }

    public synchronized boolean addColumn(AbleDataSeries ableDataSeries, String string) {
        Object[] objectArray;
        boolean bl = true;
        if (ableDataSeries == null) {
            bl = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "addColumn(AbleDataSeries colSeries)", "DataSeries passed is null.");
            }
            return bl;
        }
        if (this.m_iRows != 0 && ableDataSeries.getCapacity() != this.m_iRows) {
            bl = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "addColumn(AbleDataSeries colSeries)", "DataSeries passed doesn't have the same number of values for this DataTable. " + ableDataSeries.getCount() + " != " + this.m_iCols);
            }
            return bl;
        }
        if (this.m_ColTitles.get(string) != null) {
            bl = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "addColumn(AbleDataSeries colSeries)", "The name for the DataSeries passed already exists in this DataTable. (\"" + string + "\")");
            }
            return bl;
        }
        Object[] objectArray2 = null;
        objectArray2 = ableDataSeries.getSeriesClass() == AbleDataSeriesHeader.classIntArray ? (objectArray = (int[])ableDataSeries.getDataArray()) : (Object[])(ableDataSeries.getSeriesClass() == AbleDataSeriesHeader.classDoubleArray ? (objectArray = (Object[])((double[])ableDataSeries.getDataArray())) : (objectArray = (Object[])((String[])ableDataSeries.getDataArray())));
        objectArray = new AbleDataSeries[this.m_iCols + 1];
        System.arraycopy(this.m_ColArray, 0, objectArray, 0, this.m_iCols);
        if (this.m_iRows == 0) {
            this.m_iRows = ableDataSeries.getCapacity();
        }
        objectArray[this.m_iCols] = (int)new AbleDataSeries(string, this.m_iRows, this.m_bCalcOnAdd);
        objectArray[this.m_iCols].setDataSeries(objectArray2);
        this.m_ColArray = (AbleDataSeries[])objectArray;
        this.setColumnTitle(this.m_iCols, string);
        ++this.m_iCols;
        return bl;
    }

    public synchronized boolean addRow(Object[] objectArray) {
        boolean bl = true;
        int n = objectArray.length;
        if (n > this.m_iCols) {
            n = this.m_iCols;
        }
        if (n < this.m_iCols) {
            bl = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "addRow(Object[] rowData)", "Row data passed doesn't have enough values for this DataTable. " + objectArray.length + " < " + this.m_iCols);
            }
            return bl;
        }
        int n2 = 0;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                this.m_ColArray[n2].addValue(objectArray[n2]);
            }
            if (this.m_bLocked) {
                if (this.m_iRows < this.m_iRowCapacity) {
                    ++this.m_iRows;
                }
            } else {
                ++this.m_iRows;
            }
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "addRow(Object[] rowData)", "Can't convert " + objectArray[n2] + "(" + objectArray[n2].getClass().toString() + ")" + " to column " + n2 + "(" + this.getColumnClass(n2).toString() + ". Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public boolean addRow(Vector vector) {
        return this.addRow(vector.toArray());
    }

    public synchronized Double append(AbleDataTable ableDataTable) {
        int n;
        double d = 0.0;
        if (this.m_iCols != ableDataTable.getColumnCount()) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "append(AbleDataTable tableToAppend)", "Both tables must have the same number of columns (" + this.m_iCols + "!=" + ableDataTable.getColumnCount() + ").");
            }
            return new Double(d);
        }
        int[] nArray = new int[this.m_iCols];
        String[] stringArray = this.getColumnTitlesByColumn();
        int n2 = 0;
        for (n = 0; n < this.m_iCols; ++n) {
            n2 = ableDataTable.getColumnIndex(stringArray[n]);
            if (n2 == -1) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "append(AbleDataTable tableToAppend)", "Both tables must have same column titles.");
                }
                return new Double(d);
            }
            if (this.getColumnClass(n) != ableDataTable.getColumnClass(n2)) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "append(AbleDataTable tableToAppend)", "Both tables must have same column typtes.");
                }
                return new Double(d);
            }
            nArray[n] = n2;
        }
        n = 0;
        int n3 = this.m_iRows + ableDataTable.getRowCount();
        if (this.m_bLocked) {
            if (n3 > this.m_iRowCapacity) {
                n3 = this.m_iRowCapacity;
            }
        } else {
            for (n = 0; n < this.m_iCols; ++n) {
                this.getDataSeries(n).setCapacity(n3);
            }
        }
        for (n = 0; n < this.m_iCols; ++n) {
            d = this.getDataSeries(n).append(ableDataTable.getDataSeries(nArray[n]));
            if ((int)d == ableDataTable.getRowCount()) continue;
            if (!this.trace.isLogging()) break;
            this.trace.text(262144L, (Object)this, "append(AbleDataTable tableToAppend)", "Column " + n + " only received " + (int)d + " values of expected " + ableDataTable.getRowCount() + " from column " + nArray[n] + " in the passed DataSeries.");
            break;
        }
        this.m_iRows = n3;
        return new Double(d);
    }

    private void buildFromFile(String string, boolean bl, boolean bl2) {
        block11: {
            long l = 0L;
            long l2 = 0L;
            try {
                int n = 0;
                FileInputStream fileInputStream = new FileInputStream(string);
                File file = new File(string);
                l2 = file.length();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                byte[] byArray = new byte[4096];
                byte[] byArray2 = new byte[4096];
                int n2 = 0;
                int n3 = 0;
                while ((n2 = bufferedInputStream.read(byArray, 0, 4096)) != -1) {
                    for (int i = 0; i < n2; ++i) {
                        if (byArray[i] == 13) continue;
                        if (byArray[i] != 10) {
                            byArray2[n3++] = byArray[i];
                            continue;
                        }
                        if (n > 0) {
                            l += (long)n3;
                        }
                        if (this.m_iRows == 10) {
                            int n4 = 10;
                            if (l > 0L) {
                                n4 = (int)(l2 / l) * 10;
                            }
                            for (int j = 0; j < this.m_iCols; ++j) {
                                this.m_ColArray[j].setCapacity(n4);
                                this.m_ColArray[j].setGrowthIncrement(n4 / 10);
                            }
                        }
                        n = this.processRecord(byArray2, n3, n, bl, bl2);
                        n3 = 0;
                    }
                }
                bufferedInputStream.close();
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "buildFromFile(String strFileName, boolean bHasTitles, boolean bCalcOnAdd)", "The system cannot find the file: \"" + string + "\"");
                    this.trace.text(262144L, (Object)this, "buildFromFile(String strFileName, boolean bHasTitles, boolean bCalcOnAdd)", "Please check that you have the correct path and filename.");
                }
            }
            catch (IOException iOException) {
                if (!this.trace.isLogging()) break block11;
                this.trace.text(262144L, (Object)this, "buildFromFile(String strFileName, boolean bHasTitles, boolean bCalcOnAdd)", "Attempting to read file: \"" + string + "\" returned an error:");
                this.trace.text(262144L, (Object)this, "buildFromFile(String strFileName, boolean bHasTitles, boolean bCalcOnAdd)", iOException.getLocalizedMessage());
            }
        }
    }

    private void buildFromStringArray(String[] stringArray, boolean bl, boolean bl2) {
        int n = 0;
        Object[] objectArray = null;
        int n2 = 0;
        for (int i = stringArray.length; n2 < i; ++i) {
            if (++n == 1) {
                if (bl) {
                    String[] stringArray2 = this.parseTitles(stringArray[n2]);
                    this.initContents(stringArray2.length, bl2);
                    this.setColumnTitles(stringArray2);
                } else {
                    objectArray = this.parseFields(stringArray[n2]);
                    if (objectArray != null) {
                        this.initContents(objectArray.length, bl2);
                        this.addRow(objectArray);
                    } else if (this.trace.isLogging()) {
                        this.trace.text(262144L, (Object)this, "buildFromStringArray(String strRecordArray[], boolean bHasTitles, boolean bCalcOnAdd)", "Error on #" + n + ": " + stringArray[i]);
                    }
                }
                for (int j = 0; j < this.m_iCols; ++j) {
                    this.m_ColArray[j].setCapacity(i);
                    this.m_ColArray[j].setGrowthIncrement(i / 10);
                }
                continue;
            }
            objectArray = this.parseFields(stringArray[i]);
            if (objectArray != null) {
                this.addRow(objectArray);
                continue;
            }
            if (!this.trace.isLogging()) continue;
            this.trace.text(262144L, (Object)this, "buildFromStringArray(String strRecordArray[], boolean bHasTitles, boolean bCalcOnAdd)", "Error on #" + n + ": " + stringArray[i]);
        }
    }

    public boolean duplicateColumn(double d, String string) {
        return this.duplicateColumn((int)d, string);
    }

    public synchronized boolean duplicateColumn(int n, String string) {
        boolean bl = true;
        Object[] objectArray = null;
        try {
            Object[] objectArray2;
            objectArray = this.getColumnClass(n) == classInteger ? (objectArray2 = (int[])this.m_ColArray[n].getDataArray()) : (Object[])(this.getColumnClass(n) == classDouble ? (objectArray2 = (Object[])((double[])this.m_ColArray[n].getDataArray())) : (objectArray2 = (Object[])((String[])this.m_ColArray[n].getDataArray())));
            objectArray2 = new AbleDataSeries[this.m_iCols + 1];
            System.arraycopy(this.m_ColArray, 0, objectArray2, 0, this.m_iCols);
            objectArray2[this.m_iCols] = (int)new AbleDataSeries(this.m_iRows, this.m_bCalcOnAdd);
            objectArray2[this.m_iCols].setName(string);
            objectArray2[this.m_iCols].setDataSeries(objectArray);
            this.m_ColArray = (AbleDataSeries[])objectArray2;
            this.setColumnTitle(this.m_iCols, string);
            ++this.m_iCols;
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "duplicateColumn(int iCol, String strNewTitle)", "Column identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public boolean duplicateColumn(String string, String string2) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.duplicateColumn(n, string2);
        }
        return false;
    }

    public Vector findRow(double d, Object object) {
        return this.findRow((int)d, object);
    }

    public synchronized Vector findRow(int n, Object object) {
        Vector<Number> vector = new Vector<Number>(this.m_iCols);
        int n2 = 0;
        if (object == null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "findRow(int iCol, Object value)", "Can't findRow using a null value.");
            }
            return new Vector(0);
        }
        if (n < 0 || n >= this.m_iCols) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "findRow(int iCol, Object value)", "Column " + n + " is not in the range [0," + this.m_iCols + "].");
            }
            return new Vector(0);
        }
        try {
            Object[] objectArray;
            if (this.getColumnClass(n) == classInteger) {
                int n3;
                objectArray = (int[])this.m_ColArray[n].getDataArray();
                if (object.getClass() == classInteger) {
                    for (n3 = 0; n3 < this.m_iRows; ++n3) {
                        if (objectArray[n3] != (Integer)object) continue;
                        n2 = n3;
                        break;
                    }
                } else if (object.getClass() == classDouble) {
                    for (n3 = 0; n3 < this.m_iRows; ++n3) {
                        if (objectArray[n3] != ((Double)object).intValue()) continue;
                        n2 = n3;
                        break;
                    }
                } else {
                    for (n3 = 0; n3 < this.m_iRows; ++n3) {
                        if (objectArray[n3] != new Integer((String)object)) continue;
                        n2 = n3;
                        break;
                    }
                }
                Integer n4 = new Integer(objectArray[n2]);
                vector.addElement(n4);
            } else if (this.getColumnClass(n) == classDouble) {
                int n5;
                objectArray = (double[])this.m_ColArray[n].getDataArray();
                if (object.getClass() == classInteger) {
                    for (n5 = 0; n5 < this.m_iRows; ++n5) {
                        if (objectArray[n5] != new Double(((Integer)object).intValue())) continue;
                        n2 = n5;
                        break;
                    }
                } else if (object.getClass() == classDouble) {
                    for (n5 = 0; n5 < this.m_iRows; ++n5) {
                        if (objectArray[n5] != (Double)object) continue;
                        n2 = n5;
                        break;
                    }
                } else {
                    for (n5 = 0; n5 < this.m_iRows; ++n5) {
                        if (objectArray[n5] != new Double((String)object)) continue;
                        n2 = n5;
                        break;
                    }
                }
                Double d = new Double(objectArray[n2]);
                vector.addElement(d);
            } else {
                objectArray = (String[])this.m_ColArray[n].getDataArray();
                if (object.getClass() == classInteger) {
                    for (int i = 0; i < this.m_iRows; ++i) {
                        if (objectArray[i].compareTo(((Integer)object).toString()) != 0) continue;
                        n2 = i;
                        break;
                    }
                } else if (object.getClass() == classDouble) {
                    for (int i = 0; i < this.m_iRows; ++i) {
                        if (objectArray[i].compareTo(((Double)object).toString()) != 0) continue;
                        n2 = i;
                        break;
                    }
                } else {
                    for (int i = 0; i < this.m_iRows; ++i) {
                        if (objectArray[i].compareTo((String)object) != 0) continue;
                        n2 = i;
                        break;
                    }
                }
            }
            for (n = 0; n < this.m_iCols; ++n) {
                if (this.getColumnClass(n) == classInteger) {
                    objectArray = (int[])this.m_ColArray[n].getDataArray();
                    Integer n6 = new Integer(objectArray[n2]);
                    vector.addElement(n6);
                    continue;
                }
                if (this.getColumnClass(n) == classDouble) {
                    objectArray = (double[])this.m_ColArray[n].getDataArray();
                    Double d = new Double(objectArray[n2]);
                    vector.addElement(d);
                    continue;
                }
                objectArray = (String[])this.m_ColArray[n].getDataArray();
                vector.addElement(objectArray[n2]);
            }
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "findRow(int iCol, Object value)", "Unable to locate " + object.toString() + " in column " + n + ". Exception: " + exception.getLocalizedMessage());
            }
            vector = new Vector();
        }
        return vector;
    }

    public Vector findRow(String string, Double d) {
        return this.findRow(string, (Object)d);
    }

    public Vector findRow(String string, Integer n) {
        return this.findRow(string, (Object)n);
    }

    public Vector findRow(String string, Object object) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.findRow(n, object);
        }
        return null;
    }

    public Vector findRow(String string, String string2) {
        return this.findRow(string, (Object)string2);
    }

    public Vector findRowInSortedColumn(double d, Object object) {
        return this.findRowInSortedColumn((int)d, object);
    }

    public synchronized Vector findRowInSortedColumn(int n, Object object) {
        Vector<int> vector = new Vector<int>(this.m_iCols);
        int n2 = 0;
        if (object == null) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "findRowInSortedColumn(int iCol, Object value)", "Can't findRowInSortedColumn using a null value.");
            }
            return new Vector();
        }
        if (n < 0 || n >= this.m_iCols) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "findRowInSortedColumn(int iCol, Object value)", "Column " + n + " is not in the range [0," + this.m_iCols + "].");
            }
            return new Vector();
        }
        try {
            Object[] objectArray;
            if (this.getColumnClass(n) == classInteger) {
                objectArray = (int[])this.m_ColArray[n].getDataArray();
                n2 = object.getClass() == classInteger ? Arrays.binarySearch(objectArray, (Integer)object) : (object.getClass() == classDouble ? Arrays.binarySearch(objectArray, ((Double)object).intValue()) : Arrays.binarySearch(objectArray, new Integer((String)object)));
            } else if (this.getColumnClass(n) == classDouble) {
                objectArray = (double[])this.m_ColArray[n].getDataArray();
                n2 = object.getClass() == classInteger ? Arrays.binarySearch((double[])objectArray, new Double(((Integer)object).intValue())) : (object.getClass() == classDouble ? Arrays.binarySearch((double[])objectArray, (Double)object) : Arrays.binarySearch((double[])objectArray, new Double((String)object)));
            } else {
                objectArray = (String[])this.m_ColArray[n].getDataArray();
                n2 = object.getClass() == classInteger ? Arrays.binarySearch(objectArray, ((Integer)object).toString()) : (object.getClass() == classDouble ? Arrays.binarySearch(objectArray, ((Double)object).toString()) : Arrays.binarySearch(objectArray, (String)object));
            }
            for (n = 0; n < this.m_iCols; ++n) {
                Number number;
                if (this.getColumnClass(n) == classInteger) {
                    objectArray = (int[])this.m_ColArray[n].getDataArray();
                    number = new Integer(objectArray[n2]);
                    vector.addElement((int)number);
                    continue;
                }
                if (this.getColumnClass(n) == classDouble) {
                    objectArray = (double[])this.m_ColArray[n].getDataArray();
                    number = new Double(objectArray[n2]);
                    vector.addElement((int)number);
                    continue;
                }
                objectArray = (String[])this.m_ColArray[n].getDataArray();
                vector.addElement(objectArray[n2]);
            }
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "findRowInSortedColumn(int iCol, Object value)", "Unable to locate " + object.toString() + " in column " + n + ". Exception: " + exception.getLocalizedMessage());
            }
            vector = new Vector();
        }
        return vector;
    }

    public Vector findRowInSortedColumn(String string, Object object) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.findRowInSortedColumn(n, object);
        }
        return null;
    }

    public boolean getCalcOnAdd() {
        return this.m_bCalcOnAdd;
    }

    public int getCapacity() {
        return this.m_iRowCapacity;
    }

    public synchronized Vector getColumn(int n) {
        Vector<Object> vector = new Vector<Integer>();
        try {
            String string = this.getColumnClass(n).getName();
            if (string.compareToIgnoreCase("java.lang.Integer") == 0) {
                int[] nArray = (int[])this.m_ColArray[n].getDataArray();
                for (int i = 0; i < this.m_iRows; ++i) {
                    vector.addElement(new Integer(nArray[i]));
                }
            } else if (string.compareToIgnoreCase("java.lang.Double") == 0) {
                double[] dArray = (double[])this.m_ColArray[n].getDataArray();
                for (int i = 0; i < this.m_iRows; ++i) {
                    vector.addElement(new Double(dArray[i]));
                }
            } else {
                String[] stringArray = (String[])this.m_ColArray[n].getDataArray();
                vector = new Vector<String>(Arrays.asList(stringArray));
            }
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public Vector getColumn(String string) {
        Vector vector = new Vector();
        int n = this.getColumnIndex(string);
        if (n != -1) {
            try {
                vector = this.getColumn(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public synchronized double[] getColumnAsDoubleArray(int n) {
        double[] dArray = new double[]{};
        try {
            if (this.getColumnClass(n) == classInteger) {
                int[] nArray = (int[])this.m_ColArray[n].getDataArray();
                int n2 = nArray.length;
                dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = nArray[i];
                }
            } else {
                dArray = this.getColumnClass(n) == classDouble ? (double[])this.m_ColArray[n].getDataArray() : new double[]{};
            }
        }
        catch (Exception exception) {
            dArray = new double[]{};
        }
        return dArray;
    }

    public double[] getColumnAsDoubleArray(String string) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.getColumnAsDoubleArray(n);
        }
        return new double[0];
    }

    public Vector getColumnAsDoubleVector(int n) {
        Vector<Double> vector = new Vector<Double>();
        try {
            vector = new Vector(this.m_iCols);
            if (this.getColumnClass(n) == classInteger) {
                int[] nArray = (int[])this.m_ColArray[n].getDataArray();
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    vector.addElement(new Double(nArray[i]));
                }
            } else if (this.getColumnClass(n) == classDouble) {
                double[] dArray = (double[])this.m_ColArray[n].getDataArray();
                int n3 = dArray.length;
                for (int i = 0; i < n3; ++i) {
                    vector.addElement(new Double(dArray[i]));
                }
            } else {
                vector = new Vector();
            }
        }
        catch (Exception exception) {
            vector = new Vector();
        }
        return vector;
    }

    public Vector getColumnAsDoubleVector(String string) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.getColumnAsDoubleVector(n);
        }
        return new Vector();
    }

    public int[] getColumnAsIntArray(int n) {
        int[] nArray = new int[]{};
        try {
            if (this.getColumnClass(n) == classDouble) {
                double[] dArray = (double[])this.m_ColArray[n].getDataArray();
                int n2 = dArray.length;
                nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = (int)dArray[i];
                }
            } else {
                nArray = this.getColumnClass(n) == classInteger ? (int[])this.m_ColArray[n].getDataArray() : new int[]{};
            }
        }
        catch (Exception exception) {
            nArray = new int[]{};
        }
        return nArray;
    }

    public int[] getColumnAsIntArray(String string) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.getColumnAsIntArray(n);
        }
        return new int[0];
    }

    public synchronized String[] getColumnAsStringArray(int n) {
        String[] stringArray = new String[]{};
        try {
            if (this.getColumnClass(n) == classDouble) {
                double[] dArray = (double[])this.m_ColArray[n].getDataArray();
                int n2 = dArray.length;
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = new Double(dArray[i]).toString();
                }
            } else if (this.getColumnClass(n) == classInteger) {
                int[] nArray = (int[])this.m_ColArray[n].getDataArray();
                int n3 = nArray.length;
                stringArray = new String[n3];
                for (int i = 0; i < n3; ++i) {
                    stringArray[i] = new Integer(nArray[i]).toString();
                }
            } else {
                stringArray = (String[])this.m_ColArray[n].getDataArray();
            }
        }
        catch (Exception exception) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String[] getColumnAsStringArray(String string) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.getColumnAsStringArray(n);
        }
        return new String[0];
    }

    public double getColumnAverage(int n) {
        double d = 0.0;
        try {
            d = this.m_ColArray[n].getAverage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public Double getColumnAverage(String string) {
        Double d = new Double(Double.MAX_VALUE);
        int n = this.getColumnIndex(string);
        if (n != -1) {
            try {
                d = new Double(this.getColumnAverage(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public Class getColumnClass(int n) {
        try {
            return this.m_ColArray[n].getSeriesValueClass();
        }
        catch (Exception exception) {
            return classClass;
        }
    }

    public Class getColumnClass(String string) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.getColumnClass(n);
        }
        return classClass;
    }

    public int getColumnCount() {
        return this.m_iCols;
    }

    public int getColumnIndex(String string) {
        int n = -1;
        Integer n2 = (Integer)this.m_ColTitles.get(string);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public double getColumnMaximum(int n) {
        double d = Double.MIN_VALUE;
        try {
            d = this.m_ColArray[n].getMaximum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double getColumnMaximum(String string) {
        Double d = new Double(Double.MIN_VALUE);
        int n = this.getColumnIndex(string);
        if (n != -1) {
            try {
                d = new Double(this.getColumnMaximum(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public double getColumnMinimum(int n) {
        double d = Double.MAX_VALUE;
        try {
            d = this.m_ColArray[n].getMinimum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double getColumnMinimum(String string) {
        Double d = new Double(Double.MAX_VALUE);
        int n = this.getColumnIndex(string);
        if (n != -1) {
            try {
                d = new Double(this.getColumnMinimum(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public double getColumnStdDeviation(int n) {
        double d = this.getColumnVariance(n);
        return Math.sqrt(d);
    }

    public double getColumnStdDeviation(String string) {
        Double d = new Double(Double.MAX_VALUE);
        int n = this.getColumnIndex(string);
        if (n != -1) {
            try {
                d = new Double(this.getColumnStdDeviation(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public double getColumnSum(int n) {
        double d = 0.0;
        try {
            d = this.m_ColArray[n].getSum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double getColumnSum(String string) {
        Double d = new Double(0.0);
        int n = this.getColumnIndex(string);
        if (n != -1) {
            try {
                d = new Double(this.getColumnSum(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public String getColumnTitle(int n) {
        String string = strUnknown;
        try {
            string = this.m_ColArray[n].getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String[] getColumnTitlesByColumn() {
        String[] stringArray = new String[this.m_iCols];
        for (int i = 0; i < this.m_iCols; ++i) {
            stringArray[i] = this.getColumnTitle(i);
        }
        return stringArray;
    }

    public String[] getColumnTitlesByName() {
        String[] stringArray = this.getColumnTitlesByColumn();
        Collections.sort(Arrays.asList(stringArray));
        return stringArray;
    }

    public double getColumnVariance(int n) {
        double d = 0.0;
        try {
            d = this.m_ColArray[n].getVariance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double getColumnVariance(String string) {
        Double d = new Double(Double.MAX_VALUE);
        int n = this.getColumnIndex(string);
        if (n != -1) {
            try {
                d = new Double(this.getColumnVariance(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public synchronized AbleDataSeries getDataSeries(int n) {
        AbleDataSeries ableDataSeries;
        block5: {
            try {
                ableDataSeries = new AbleDataSeries();
            }
            catch (Exception exception) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "getDataSeries(int iCol)", "Unable to create new AbleDataSeries. " + exception.getLocalizedMessage());
                }
                return null;
            }
            try {
                ableDataSeries = this.m_ColArray[n];
            }
            catch (Exception exception) {
                if (!this.trace.isLogging()) break block5;
                this.trace.text(262144L, (Object)this, "getDataSeries(int iCol)", "Index " + n + " unable to be retrieved. " + exception.getLocalizedMessage());
            }
        }
        return ableDataSeries;
    }

    public synchronized AbleDataSeries getDataSeries(String string) {
        AbleDataSeries ableDataSeries;
        block5: {
            try {
                ableDataSeries = new AbleDataSeries();
            }
            catch (Exception exception) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "getDataSeries(String strColumnName)", "Unable to create new AbleDataSeries. " + exception.getLocalizedMessage());
                }
                return null;
            }
            int n = this.getColumnIndex(string);
            try {
                ableDataSeries = this.m_ColArray[n];
            }
            catch (Exception exception) {
                if (!this.trace.isLogging()) break block5;
                this.trace.text(262144L, (Object)this, "getDataSeries(String strColumnName)", "Index " + n + " unable to be retrieved. " + exception.getLocalizedMessage());
            }
        }
        return ableDataSeries;
    }

    public synchronized AbleDataSeries[] getDataSeriesArray() {
        return this.m_ColArray;
    }

    public synchronized int setDataSeriesArray(AbleDataSeries[] ableDataSeriesArray) {
        if (ableDataSeriesArray == null) {
            return DATASERIES_ERROR_INVALID_ARRAY;
        }
        int n = ableDataSeriesArray.length;
        if (n < 1) {
            return DATASERIES_ERROR_INVALID_ARRAY;
        }
        AbleDataSeries ableDataSeries = ableDataSeriesArray[0];
        ableDataSeries.forceStatisticsCalculation();
        int n2 = ableDataSeries.getCount();
        int n3 = ableDataSeries.getCapacity();
        int n4 = n2;
        for (int i = 1; i < n; ++i) {
            if (ableDataSeriesArray[i].getCount() == n2 && ableDataSeriesArray[i].getCapacity() == n3) continue;
            return DATASERIES_ERROR_INCONSISTENT_SIZE;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Integer n5 = new Integer(0);
        hashtable.put(ableDataSeries.getName(), n5);
        for (int i = 1; i < n; ++i) {
            Integer n6 = new Integer(i);
            hashtable.put(ableDataSeriesArray[i].getName(), n6);
            ableDataSeriesArray[i].forceStatisticsCalculation();
        }
        this.m_iCols = n;
        this.m_iRows = n4;
        this.m_iRowCapacity = n3;
        this.m_ColTitles = hashtable;
        this.m_ColArray = ableDataSeriesArray;
        this.m_bNeedsCalc = false;
        return DATASERIES_SUCCESS;
    }

    public AbleDataTable getDataTable(boolean bl) throws RemoteException {
        AbleDataTable ableDataTable = new AbleDataTable(this.m_iCols, bl);
        ableDataTable.setColumnTitles(this.getColumnTitlesByColumn());
        int n = 0;
        int n2 = this.m_iRows;
        for (int i = 0; i < n2; ++i) {
            ableDataTable.setRow(n++, this.getRow(i));
        }
        ableDataTable.setLocked(this.isLocked());
        return ableDataTable;
    }

    public synchronized AbleDataTable getDataTable(int n, Object object, Object object2, boolean bl) throws RemoteException {
        if (n < 0 || n >= this.m_iCols) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "getDataTable(int iCol, Object from, Object thru, boolean bIsSorted)", "Column " + n + " is not in range [0," + this.m_iCols + "].)");
            }
            return new AbleDataTable(0);
        }
        AbleDataTable ableDataTable = new AbleDataTable(this.m_iCols);
        ableDataTable.setColumnTitles(this.getColumnTitlesByColumn());
        Object object3 = this.m_ColArray[n].getDataArray();
        if (bl) {
            int n2 = -1;
            int n3 = -1;
            try {
                if (this.getColumnClass(n) == classInteger) {
                    int n4 = object.getClass() == classInteger ? (Integer)object : (object.getClass() == classDouble ? ((Double)object).intValue() : new Integer((String)object).intValue());
                    n2 = Arrays.binarySearch((int[])object3, n4);
                    if (n2 < 0) {
                        n2 = -1 * n2 - 1;
                    }
                    int n5 = object2.getClass() == classInteger ? (Integer)object2 : (object2.getClass() == classDouble ? ((Double)object2).intValue() : new Integer((String)object2).intValue());
                    n3 = Arrays.binarySearch((int[])object3, n5);
                    if (n3 < 0 && (n3 = -1 * n3 - 2) < n2) {
                        n3 = n2;
                    }
                } else if (this.getColumnClass(n) == classDouble) {
                    double d = object.getClass() == classInteger ? new Double(((Integer)object).intValue()) : (object.getClass() == classDouble ? ((Double)object).doubleValue() : new Double((String)object).doubleValue());
                    n2 = Arrays.binarySearch((double[])object3, d);
                    if (n2 < 0) {
                        n2 = -1 * n2 - 1;
                    }
                    double d2 = object2.getClass() == classInteger ? new Double(((Integer)object2).intValue()) : (object2.getClass() == classDouble ? ((Double)object2).doubleValue() : new Double((String)object2).doubleValue());
                    n3 = Arrays.binarySearch((double[])object3, d2);
                    if (n3 < 0 && (n3 = -1 * n3 - 2) < n2) {
                        n3 = n2;
                    }
                } else {
                    String string = object.getClass() == classInteger ? ((Integer)object).toString() : (object.getClass() == classDouble ? ((Double)object).toString() : (String)object);
                    n2 = Arrays.binarySearch((String[])object3, string);
                    if (n2 < 0) {
                        n2 = -1 * n2 - 1;
                    }
                    String string2 = object2.getClass() == classInteger ? ((Integer)object2).toString() : (object2.getClass() == classDouble ? ((Double)object2).toString() : (String)object2);
                    n3 = Arrays.binarySearch((String[])object3, string2);
                    if (n3 < 0 && (n3 = -1 * n3 - 2) < n2) {
                        n3 = n2;
                    }
                }
                if (n2 >= this.m_iRows) {
                    return new AbleDataTable(0);
                }
                AbleDataSeries[] ableDataSeriesArray = new AbleDataSeries[this.m_iCols];
                for (int i = 0; i < this.m_iCols; ++i) {
                    AbleDataSeries ableDataSeries = new AbleDataSeries(n3 + 1 - n2, this.m_bCalcOnAdd);
                    Object[] objectArray = null;
                    objectArray = this.getColumnClass(i) == classInteger ? new int[n3 + 1 - n2] : (this.getColumnClass(i) == classDouble ? (Object[])new double[n3 + 1 - n2] : (Object[])new String[n3 + 1 - n2]);
                    System.arraycopy(this.m_ColArray[i].getDataArray(), n2, objectArray, 0, n3 + 1 - n2);
                    ableDataSeries.setDataSeries(objectArray);
                    ableDataSeries.setName(this.m_ColArray[i].getName());
                    ableDataSeriesArray[i] = ableDataSeries;
                }
                ableDataTable.replaceColArray(ableDataSeriesArray);
            }
            catch (Exception exception) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "getDataTable(int iCol, Object from, Object thru, boolean bIsSorted)", "Exception copying range from sorted column " + n + ". " + exception.getLocalizedMessage());
                }
                return new AbleDataTable(0);
            }
        }
        AbleDataSeries[] ableDataSeriesArray = new AbleDataSeries[this.m_iCols];
        int[] nArray = new int[this.m_iRows];
        int n6 = 0;
        try {
            if (this.getColumnClass(n) == classInteger) {
                int n7 = object.getClass() == classInteger ? (Integer)object : (object.getClass() == classDouble ? ((Double)object).intValue() : new Integer((String)object).intValue());
                int n8 = object2.getClass() == classInteger ? (Integer)object2 : (object2.getClass() == classDouble ? ((Double)object2).intValue() : new Integer((String)object2).intValue());
                for (int i = 0; i < this.m_iRows; ++i) {
                    if (((int[])object3)[i] < n7 || ((int[])object3)[i] > n8) continue;
                    nArray[n6++] = i;
                }
            } else if (this.getColumnClass(n) == classDouble) {
                double d = object.getClass() == classInteger ? new Double(((Integer)object).intValue()) : (object.getClass() == classDouble ? ((Double)object).doubleValue() : new Double((String)object).doubleValue());
                double d3 = object2.getClass() == classInteger ? new Double(((Integer)object2).intValue()) : (object2.getClass() == classDouble ? ((Double)object2).doubleValue() : new Double((String)object2).doubleValue());
                for (int i = 0; i < this.m_iRows; ++i) {
                    if (!(((double[])object3)[i] >= d) || !(((double[])object3)[i] <= d3)) continue;
                    nArray[n6++] = i;
                }
            } else {
                String string = object.getClass() == classInteger ? ((Integer)object).toString() : (object.getClass() == classDouble ? ((Double)object).toString() : (String)object);
                String string3 = object2.getClass() == classInteger ? ((Integer)object2).toString() : (object2.getClass() == classDouble ? ((Double)object2).toString() : (String)object2);
                for (int i = 0; i < this.m_iRows; ++i) {
                    if (((String[])object3)[i].compareTo(string) < 0 || ((String[])object3)[i].compareTo(string3) > 0) continue;
                    nArray[n6++] = i;
                }
            }
            if (n6 <= 0) {
                return new AbleDataTable(0);
            }
            for (int i = 0; i < this.m_iCols; ++i) {
                AbleDataSeries ableDataSeries = new AbleDataSeries(n6, this.m_bCalcOnAdd);
                Object[] objectArray = null;
                objectArray = this.getColumnClass(i) == classInteger ? new int[n6] : (this.getColumnClass(i) == classDouble ? (Object[])new double[n6] : (Object[])new String[n6]);
                for (int j = 0; j < n6; ++j) {
                    if (this.getColumnClass(i) == classInteger) {
                        objectArray[j] = ((int[])this.m_ColArray[i].getDataArray())[nArray[j]];
                        continue;
                    }
                    if (this.getColumnClass(i) == classDouble) {
                        ((double[])objectArray)[j] = ((double[])this.m_ColArray[i].getDataArray())[nArray[j]];
                        continue;
                    }
                    ((String[])objectArray)[j] = ((String[])this.m_ColArray[i].getDataArray())[nArray[j]];
                }
                ableDataSeries.setDataSeries(objectArray);
                ableDataSeries.setName(this.m_ColArray[i].getName());
                ableDataSeriesArray[i] = ableDataSeries;
            }
            ableDataTable.replaceColArray(ableDataSeriesArray);
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "getDataTable(int iCol, Object from, Object thru, boolean bIsSorted)", "Exception copying range from unsorted column " + n + ". " + exception.getLocalizedMessage());
            }
            return new AbleDataTable(0);
        }
        ableDataTable.setLocked(this.isLocked());
        return ableDataTable;
    }

    public AbleDataTable getDataTable(int[] nArray) throws RemoteException {
        return this.getDataTable(nArray, this.m_bCalcOnAdd);
    }

    public AbleDataTable getDataTable(int[] nArray, boolean bl) throws RemoteException {
        AbleDataTable ableDataTable = new AbleDataTable(this.m_iCols, bl);
        ableDataTable.setColumnTitles(this.getColumnTitlesByColumn());
        for (int i = 0; i < this.m_iCols; ++i) {
            ableDataTable.setColumn(i, this.m_ColArray[i].getDataSeries(nArray));
        }
        ableDataTable.setTypeClasses(this.getTypeClassesByColumn());
        ableDataTable.setLocked(this.isLocked());
        return ableDataTable;
    }

    public AbleDataTable getDataTable(Object object) throws RemoteException {
        try {
            return this.getDataTable((int[])object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public AbleDataTable getDataTable(String string, Double d, Double d2, boolean bl) throws RemoteException {
        int n = this.getColumnIndex(string);
        if (n == -1) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "getDataTable(String strColumnName, Double from, Double thru, Boolean BIsSorted)", "Column \"" + string + "\" is not found in DataTable.");
            }
            return new AbleDataTable(0);
        }
        return this.getDataTable(n, (Object)d, (Object)d2, bl);
    }

    public AbleDataTable getDataTable(String string, Object object, Object object2, boolean bl) throws RemoteException {
        int n = this.getColumnIndex(string);
        if (n == -1) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "getDataTable(String strColumnName, Object from, Object thru, boolean bIsSorted)", "Column \"" + string + "\" is not found in DataTable.");
            }
            return new AbleDataTable(0);
        }
        return this.getDataTable(n, object, object2, bl);
    }

    public AbleDataTable getDataTable(String string, String string2, String string3, boolean bl) throws RemoteException {
        int n = this.getColumnIndex(string);
        if (n == -1) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "getDataTable(String strColumnName, String from, String thru, Boolean BIsSorted)", "Column \"" + string + "\" is not found in DataTable.");
            }
            return new AbleDataTable(0);
        }
        return this.getDataTable(n, (Object)string2, (Object)string3, bl);
    }

    public synchronized Vector getRow(int n) {
        Vector<Object> vector = new Vector<Object>(this.m_iCols);
        try {
            for (int i = 0; i < this.m_iCols; ++i) {
                Number number;
                if (this.getColumnClass(i) == classInteger) {
                    number = (Integer)this.m_ColArray[i].getValue(n);
                    vector.addElement(number);
                    continue;
                }
                if (this.getColumnClass(i) == classDouble) {
                    number = (Double)this.m_ColArray[i].getValue(n);
                    vector.addElement(number);
                    continue;
                }
                vector.addElement((String)this.m_ColArray[i].getValue(n));
            }
        }
        catch (Exception exception) {
            vector = new Vector(0);
        }
        return vector;
    }

    public int getRowCount() {
        return this.m_iRows;
    }

    public Class[] getTypeClassesByColumn() {
        Class[] classArray = new Class[this.m_iCols];
        for (int i = 0; i < this.m_iCols; ++i) {
            if (this.getColumnClass(i) == null) continue;
            classArray[i] = this.getColumnClass(i);
        }
        return classArray;
    }

    public String[] getTypesByColumn() {
        String[] stringArray = new String[this.m_iCols];
        for (int i = 0; i < this.m_iCols; ++i) {
            if (this.getColumnClass(i) == null) continue;
            stringArray[i] = this.getColumnClass(i).getName();
        }
        return stringArray;
    }

    private void initContents(int n, boolean bl) {
        this.m_iCols = n;
        this.m_iRows = 0;
        this.m_ColArray = new AbleDataSeries[this.m_iCols];
        this.m_ColTitles = new Hashtable(this.m_iCols);
        for (int i = 0; i < this.m_iCols; ++i) {
            try {
                String string = new String("#" + AbleDataTable.toLeftPaddedString(i, 4, '0'));
                AbleDataSeries ableDataSeries = new AbleDataSeries(string, 0, bl);
                this.m_ColTitles.put(string, new Integer(i));
                this.m_ColArray[i] = ableDataSeries;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_bLocked = false;
        this.m_bCalcOnAdd = bl;
        this.m_bNeedsCalc = !bl;
    }

    private boolean isASCII(String string) {
        boolean bl = true;
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] == 9 || byArray[i] >= 20 && byArray[i] <= 127) && byArray[i] != 63) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isLocked() {
        return this.m_bLocked;
    }

    public AbleDataTable loadFromFile(String string) {
        AbleDataTable ableDataTable = null;
        try {
            ableDataTable = new AbleDataTable(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ableDataTable;
    }

    public AbleDataTable loadFromFile(String string, boolean bl, boolean bl2) {
        AbleDataTable ableDataTable = null;
        try {
            ableDataTable = new AbleDataTable(string, bl, bl2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ableDataTable;
    }

    public AbleDataTable loadFromFile(String string, Boolean bl, Boolean bl2) {
        if (bl == null) {
            bl = new Boolean(true);
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        AbleDataTable ableDataTable = null;
        try {
            ableDataTable = new AbleDataTable(string, (boolean)bl, (boolean)bl2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ableDataTable;
    }

    public synchronized void lock() {
        this.m_bLocked = true;
        for (int i = 0; i < this.m_iCols; ++i) {
            this.m_ColArray[i].lock();
            if (i != 0) continue;
            this.m_iRowCapacity = this.m_ColArray[i].getCapacity();
        }
    }

    private Object[] parseFields(String string) {
        if (!this.isASCII(string)) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DELIMITER_STRING);
        if (stringTokenizer == null) {
            return arrayList.toArray();
        }
        String string2 = new String();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                Number number;
                string2 = stringTokenizer.nextToken();
                Number number2 = null;
                number2 = string2.indexOf(46) == -1 ? (Number)(number = new Integer(string2)) : (Number)(number = new Double(string2));
                arrayList.add(number2);
            }
            catch (Exception exception) {
                arrayList.add(string2);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private String[] parseTitles(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_DELIMITER_STRING);
        if (stringTokenizer == null) {
            return new String[0];
        }
        String string2 = new String();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private int processRecord(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        String string = new String(byArray, 0, n);
        Object[] objectArray = null;
        if (string != null) {
            if (++n2 == 1) {
                if (bl) {
                    String[] stringArray = this.parseTitles(string);
                    this.initContents(stringArray.length, bl2);
                    this.setColumnTitles(stringArray);
                } else {
                    objectArray = this.parseFields(string);
                    if (objectArray != null) {
                        this.initContents(objectArray.length, bl2);
                        this.addRow(objectArray);
                    } else if (this.trace.isLogging()) {
                        this.trace.text(262144L, (Object)this, "processRecord(byte[] bStrBuffer, int iRecordLength, int iRowIndex, boolean bHasTitles, boolean bCalcOnAdd)", "Error on #" + n2 + ": " + string);
                    }
                }
            } else {
                objectArray = this.parseFields(string);
                if (objectArray != null) {
                    this.addRow(objectArray);
                } else if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "processRecord(byte[] bStrBuffer, int iRecordLength, int iRowIndex, boolean bHasTitles, boolean bCalcOnAdd)", "Error on #" + n2 + ": " + string);
                }
            }
        }
        return n2;
    }

    protected synchronized boolean replaceColArray(AbleDataSeries[] ableDataSeriesArray) {
        boolean bl = true;
        if (ableDataSeriesArray.length != this.m_iCols) {
            bl = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "replaceColArray(AbleDataSeries[] colArray)", "Number of DataSeries passed must be same as this DataTable's width (" + ableDataSeriesArray.length + "!=" + this.m_iCols + ").");
            }
            return bl;
        }
        int n = ableDataSeriesArray[0].getCount();
        this.m_ColArray = ableDataSeriesArray;
        this.m_iCols = ableDataSeriesArray.length;
        this.m_iRows = n;
        if (this.isLocked()) {
            this.m_iRowCapacity = this.m_iRows;
        }
        return bl;
    }

    public boolean saveToFile(String string, String string2) {
        return this.saveToFile(string, string2, true);
    }

    public synchronized boolean saveToFile(String string, String string2, boolean bl) {
        boolean bl2 = true;
        if (string2 == null) {
            string2 = new String(",");
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "saveToFile(String strFileName, String strDelimiter, boolean bOverwrite)", "Using comma as default delimiter.");
            }
        }
        if (string == null) {
            bl2 = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "saveToFile(String strFileName, String strDelimiter, boolean bOverwrite)", "Filename is null.");
            }
            return bl2;
        }
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        }
        catch (Exception exception) {
            if (bl) {
                try {
                    File file = new File(string);
                    if (file.delete()) {
                        fileOutputStream = new FileOutputStream(string);
                        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    }
                    bl2 = false;
                }
                catch (Exception exception2) {
                    bl2 = false;
                }
            }
            bl2 = false;
        }
        if (!bl2) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "saveToFile(String strFileName, String strDelimiter, boolean bOverwrite)", "Unable to open \"" + string + "\" for writing.");
            }
            return bl2;
        }
        String string3 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            String[] stringArray = this.getColumnTitlesByColumn();
            for (n = 0; n < this.m_iCols; ++n) {
                if (n != 0) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(stringArray[n]);
            }
            stringBuffer.append(string3);
            byte[] byArray = stringBuffer.toString().getBytes();
            bufferedOutputStream.write(byArray);
            for (int i = 0; i < this.m_iRows; ++i) {
                stringBuffer = new StringBuffer();
                for (n = 0; n < this.m_iCols; ++n) {
                    if (n != 0) {
                        stringBuffer.append(string2);
                    }
                    if (this.getColumnClass(n) == classInteger) {
                        stringBuffer.append((Integer)this.m_ColArray[n].getValue(i));
                        continue;
                    }
                    if (this.getColumnClass(n) == classDouble) {
                        stringBuffer.append((Double)this.m_ColArray[n].getValue(i));
                        continue;
                    }
                    stringBuffer.append((String)this.m_ColArray[n].getValue(i));
                }
                stringBuffer.append(string3);
                byArray = stringBuffer.toString().getBytes();
                bufferedOutputStream.write(byArray);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "saveToFile(String strFileName, String strDelimiter, boolean bOverwrite)", "Unable to write all records to \"" + string + "\" during writing.  Exception: " + exception.getLocalizedMessage());
            }
            bl2 = false;
        }
        return bl2;
    }

    public synchronized void setCalcOnAdd(boolean bl) {
        if (bl == this.m_bCalcOnAdd) {
            return;
        }
        for (int i = 0; i < this.m_iCols; ++i) {
            this.m_ColArray[i].setCalcOnAdd(bl);
        }
        if (!this.m_bCalcOnAdd) {
            this.m_bNeedsCalc = true;
            this.m_bCalcOnAdd = true;
        } else {
            this.m_bNeedsCalc = false;
            this.m_bCalcOnAdd = false;
        }
    }

    public synchronized void setCapacity(int n) {
        for (int i = 0; i < this.m_iCols; ++i) {
            this.m_ColArray[i].setCapacity(n);
        }
    }

    public synchronized boolean setCell(int n, int n2, Object object) {
        boolean bl = true;
        try {
            if (object.getClass() == this.getColumnClass(n2)) {
                this.m_ColArray[n2].setValue(n, object);
            } else {
                if (object.getClass() == classInteger) {
                    if (this.getColumnClass(n2) == classDouble) {
                        Double d = new Double(((Integer)object).intValue());
                        object = d;
                    } else if (this.getColumnClass(n2) == classString) {
                        String string = ((Integer)object).toString();
                        object = string;
                    }
                } else if (object.getClass() == classDouble) {
                    if (this.getColumnClass(n2) == classInteger) {
                        Integer n3 = new Integer(((Double)object).intValue());
                        object = n3;
                    } else if (this.getColumnClass(n2) == classString) {
                        String string = ((Double)object).toString();
                        object = string;
                    }
                } else if (this.getColumnClass(n2) == classInteger) {
                    Integer n4 = new Integer((String)object);
                    object = n4;
                } else if (this.getColumnClass(n2) == classDouble) {
                    Double d = new Double((String)object);
                    object = d;
                }
                this.m_ColArray[n2].setValue(n, object);
            }
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setCell(int iRow, int iCol, Object objInput)", "Input class " + object.getClass().getName() + " not compatible with column class " + this.getColumnClass(n2).getName());
            }
            bl = false;
        }
        return bl;
    }

    public synchronized boolean setColumn(int n, AbleDataSeries ableDataSeries) {
        boolean bl = true;
        try {
            this.m_ColArray[n] = ableDataSeries;
            this.m_iRows = ableDataSeries.getCount();
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setColumn(int iCol, AbleDataSeries colSeries)", "Column identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public synchronized boolean setColumn(int n, Object[] objectArray) {
        boolean bl = true;
        try {
            AbleDataSeries ableDataSeries = this.m_ColArray[n];
            int n2 = ableDataSeries.getCapacity();
            int n3 = objectArray.length;
            if (n3 > n2) {
                n3 = n2;
            }
            if (n3 < n2) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "setColumn(int iCol, Object[] colData)", "Column passed " + n3 + " values is shorter than DataTable row size " + n2 + ".");
                }
                bl = false;
                return bl;
            }
            for (int i = 0; i < n3; ++i) {
                ableDataSeries.setValue(i, objectArray[i]);
            }
            this.m_iRows = ableDataSeries.getCount();
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setColumn(int iCol, Object[] colData)", "Column identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public synchronized boolean setColumn(int n, Vector vector) {
        boolean bl = true;
        try {
            AbleDataSeries ableDataSeries = this.m_ColArray[n];
            int n2 = vector.size();
            if (n2 > ableDataSeries.getCapacity()) {
                n2 = ableDataSeries.getCapacity();
            }
            if (n2 < ableDataSeries.getCapacity()) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "setColumn(int iCol, Vector colData)", "Column passed " + n2 + " values is shorter than DataTable row size " + ableDataSeries.getCapacity() + ".");
                }
                bl = false;
                return bl;
            }
            for (int i = 0; i < n2; ++i) {
                ableDataSeries.setValue(i, vector.elementAt(i));
            }
            this.m_iRows = ableDataSeries.getCount();
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setColumn(int iCol, Vector colData)", "Column identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public synchronized boolean setColumnSelectedToValue(int n, int[] nArray, Object object) {
        boolean bl = true;
        try {
            if (nArray == null || nArray.length == 0) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "setColumnSelectedToValue(int iCol, int[] selectRows, Object colData)", "Array of rows passed is invalid.");
                }
                bl = false;
                return bl;
            }
            if (object == null) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "setColumnSelectedToValue(int iCol, int[] selectRows, Object colData)", "Column data passed is null.");
                }
                bl = false;
                return bl;
            }
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                this.setCell(nArray[i], n, object);
            }
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setColumnSelectedToValue(int iCol, int[] selectRows, Object colData)", "Column identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public boolean setColumnSelectedToValue(String string, Object object, Double d) {
        try {
            return this.setColumnSelectedToValue(string, (int[])object, d);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setColumnSelectedToValue(String string, int[] nArray, Double d) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.setColumnSelectedToValue(n, nArray, (Object)d);
        }
        return false;
    }

    public boolean setColumnSelectedToValue(String string, int[] nArray, Integer n) {
        int n2 = this.getColumnIndex(string);
        if (n2 != -1) {
            return this.setColumnSelectedToValue(n2, nArray, (Object)n);
        }
        return false;
    }

    public boolean setColumnSelectedToValue(String string, int[] nArray, Object object) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.setColumnSelectedToValue(n, nArray, object);
        }
        return false;
    }

    public boolean setColumnSelectedToValue(String string, int[] nArray, String string2) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.setColumnSelectedToValue(n, nArray, (Object)string2);
        }
        return false;
    }

    public synchronized void setColumnTitle(int n, String string) {
        try {
            this.m_ColTitles.remove(this.m_ColArray[n].getName());
            this.m_ColArray[n].setName(string);
            this.m_ColTitles.put(string, new Integer(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setColumnTitle(String string, String string2) {
        try {
            int n = this.getColumnIndex(string);
            this.m_ColTitles.remove(this.m_ColArray[n].getName());
            this.m_ColArray[n].setName(string2);
            this.m_ColTitles.put(string2, new Integer(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColumnTitles(String[] stringArray) {
        int n = stringArray.length;
        if (n > this.m_iCols) {
            n = this.m_iCols;
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.setColumnTitle(i, stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setColumnTitles(Vector vector) {
        int n = vector.size();
        if (n > this.m_iCols) {
            n = this.m_iCols;
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.setColumnTitle(i, (String)vector.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized boolean setColumnToValue(int n, Object object) {
        boolean bl = true;
        try {
            if (object == null) {
                if (this.trace.isLogging()) {
                    this.trace.text(262144L, (Object)this, "setColumnToValue(int iCol, Object colData)", "Column data passed is null.");
                }
                bl = false;
                return bl;
            }
            for (int i = 0; i < this.m_iRows; ++i) {
                this.setCell(i, n, object);
            }
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setColumnToValue(int iCol, Object colData)", "Column identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public boolean setColumnToValue(String string, Double d) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.setColumnToValue(n, (Object)d);
        }
        return false;
    }

    public boolean setColumnToValue(String string, Integer n) {
        int n2 = this.getColumnIndex(string);
        if (n2 != -1) {
            return this.setColumnToValue(n2, (Object)n);
        }
        return false;
    }

    public boolean setColumnToValue(String string, Object object) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.setColumnToValue(n, object);
        }
        return false;
    }

    public boolean setColumnToValue(String string, String string2) {
        int n = this.getColumnIndex(string);
        if (n != -1) {
            return this.setColumnToValue(n, (Object)string2);
        }
        return false;
    }

    public synchronized void setLocked(boolean bl) {
        this.m_bLocked = bl;
        for (int i = 0; i < this.m_iCols; ++i) {
            this.m_ColArray[i].setLocked(bl);
            if (i != 0) continue;
            this.m_iRowCapacity = bl ? this.m_ColArray[i].getCapacity() : Integer.MAX_VALUE;
        }
    }

    public boolean setRow(Double d, Vector vector) {
        return this.setRow(d.intValue(), vector);
    }

    public boolean setRow(int n, Vector vector) {
        boolean bl = true;
        int n2 = vector.size();
        if (n2 > this.m_iCols) {
            n2 = this.m_iCols;
        }
        if (n2 < this.m_iCols) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setRow(int iRow, Vector rowData)", "Row passed " + n2 + " values is shorter than DataTable column size " + this.m_iCols + ".");
            }
            bl = false;
            return bl;
        }
        if (n == this.m_iRows) {
            this.addRow(vector);
        } else {
            for (int i = 0; i < n2; ++i) {
                try {
                    Object e = vector.elementAt(i);
                    Class<?> clazz = e.getClass();
                    Object object = this.m_ColArray[i].getDataArray();
                    if (this.getColumnClass(i) == clazz) {
                        if (this.getColumnClass(i) == classDouble) {
                            ((double[])object)[n] = (Double)e;
                            continue;
                        }
                        if (this.getColumnClass(i) == classInteger) {
                            ((int[])object)[n] = (Integer)e;
                            continue;
                        }
                        ((String[])object)[n] = (String)e;
                        continue;
                    }
                    if (this.getColumnClass(i) == classDouble) {
                        if (clazz == classInteger) {
                            ((double[])object)[n] = ((Integer)e).intValue();
                            continue;
                        }
                        ((double[])object)[n] = new Double((String)e);
                        continue;
                    }
                    if (this.getColumnClass(i) == classInteger) {
                        if (clazz == classDouble) {
                            ((int[])object)[n] = (int)((Double)e).doubleValue();
                            continue;
                        }
                        ((int[])object)[n] = new Integer((String)e);
                        continue;
                    }
                    ((String[])object)[n] = clazz == classInteger ? ((Integer)e).toString() : ((Double)e).toString();
                    continue;
                }
                catch (Exception exception) {
                    if (this.trace.isLogging()) {
                        this.trace.text(262144L, (Object)this, "setRow(int iRow, Vector rowData)", "Row identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
                    }
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    public boolean setRow(int n, Object[] objectArray) {
        boolean bl = true;
        int n2 = objectArray.length;
        if (n2 > this.m_iCols) {
            n2 = this.m_iCols;
        }
        if (n2 < this.m_iCols) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "int iRow, Object[] rowData)", "Row passed " + n2 + " values is shorter than DataTable column size " + this.m_iCols + ".");
            }
            bl = false;
            return bl;
        }
        try {
            for (int i = 0; i < n2; ++i) {
                this.m_ColArray[i].setValue(n, objectArray[i]);
            }
        }
        catch (Exception exception) {
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "int iRow, Object[] rowData)", "Row identified by index " + n + " doesn't exist or can't accept the data passed.  Exception: " + exception.getLocalizedMessage());
            }
            bl = false;
        }
        return bl;
    }

    public synchronized boolean setTypeClasses(Class[] classArray) {
        boolean bl = true;
        if (classArray == null) {
            bl = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setTypeClasses(Class[] classTypes)", "Received null class types array parameter.");
            }
            return bl;
        }
        int n = classArray.length;
        if (n != this.m_iCols) {
            bl = false;
            if (this.trace.isLogging()) {
                this.trace.text(262144L, (Object)this, "setTypeClasses(Class[] classTypes)", "Class count (" + n + ") != column count (" + this.m_iCols + ").");
            }
            return bl;
        }
        for (int i = 0; i < this.m_iCols; ++i) {
            if (classArray[i] == null) continue;
            this.m_ColArray[i].setSeriesValueClass(classArray[i]);
        }
        return bl;
    }

    public synchronized void unlock() {
        this.m_bLocked = false;
        for (int i = 0; i < this.m_iCols; ++i) {
            this.m_ColArray[i].unlock();
        }
        this.m_iRowCapacity = Integer.MAX_VALUE;
    }
}

