/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleExport;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleFieldDefinition;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbleDataSetDefinition
implements Serializable {
    static final long serialVersionUID = -8122289427163578021L;
    protected String fileName;
    protected String dataSetDefinitionFileName;
    protected String dataFileName;
    protected boolean allNumericData = true;
    protected Vector fieldDefinitionList = new Vector();
    protected transient ResultSetMetaData metaData = null;

    public AbleDataSetDefinition() {
    }

    public AbleDataSetDefinition(ResultSetMetaData resultSetMetaData) {
        this.metaData = resultSetMetaData;
    }

    public AbleDataSetDefinition(ResultSet resultSet) throws AbleException {
        try {
            this.metaData = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            Able.MessageLog.text(4L, (Object)this, "AbleDataSetDefinition", sQLException.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "AbleDataSetDefinition", (Throwable)sQLException);
            }
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public String getDataSetDefinitionFileName() {
        return this.dataSetDefinitionFileName;
    }

    public void setDataSetDefinitionFileName(String string) {
        this.dataSetDefinitionFileName = string;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setResultSetMetaData(ResultSetMetaData resultSetMetaData) {
        this.fileName = null;
        this.metaData = resultSetMetaData;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.metaData;
    }

    public void setDataFileName(String string) {
        this.dataFileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.metaData = null;
        this.dataSetDefinitionFileName = string + ".dfn";
        this.dataFileName = string + ".dat";
    }

    public Vector getFieldDefinitionList() {
        return (Vector)this.fieldDefinitionList.clone();
    }

    public boolean isAllNumericData() {
        return this.allNumericData;
    }

    public void load() throws AbleException {
        try {
            if (this.fileName != null) {
                this.loadFromFile();
            } else {
                this.loadFromSQL();
            }
        }
        catch (Exception exception) {
            Able.MessageLog.text(4L, (Object)this, "load", exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "load", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void loadFromFile() throws FileNotFoundException, IOException {
        File file;
        boolean bl = false;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        BufferedWriter bufferedWriter2 = null;
        this.allNumericData = true;
        String string = null;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, (Object)this, "loadFromFile", "Reading file definition " + this.fileName + ".dfn");
        }
        this.fieldDefinitionList.removeAllElements();
        bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName + ".dfn")));
        int n = 0;
        StringTokenizer stringTokenizer = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            stringTokenizer = new StringTokenizer(string);
            file = null;
            if (stringTokenizer.countTokens() == 2) {
                if (!bl) {
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(262144L, (Object)this, "loadFromFile", "Warning: Old style ABLE 1.0a data definition file encountered...");
                    }
                    bl = true;
                    File file2 = new File(this.fileName + ".1a.dfn");
                    if (!file2.exists()) {
                        try {
                            bufferedWriter2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                string4 = "input";
                if (string2.equals("predicted") || string2.equals("class")) {
                    string4 = "output";
                } else if (string2.equals("ignore")) {
                    string4 = "ignore";
                }
                if (bufferedWriter2 != null) {
                    try {
                        bufferedWriter2.write(string);
                        bufferedWriter2.newLine();
                        vector.addElement(string2 + " " + string3 + " " + string4);
                    }
                    catch (Exception exception) {}
                }
            } else if (stringTokenizer.countTokens() == 3) {
                string2 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
            } else {
                if (stringTokenizer.countTokens() == 0) {
                    String string5 = Able.NlsMsg((String)"EX_DEFINITION_FILE_FORMAT", (Object[])new Object[]{new Integer(string), new Integer(n + 1), this.fileName, new Integer(0)});
                    Able.MessageLog.text(2L, (Object)this, "loadFromFile", string5);
                    ++n;
                    continue;
                }
                String string6 = Able.NlsMsg((String)"EX_DEFINITION_FILE_FORMAT", (Object[])new Object[]{new Integer(string), new Integer(n), this.fileName, new Integer(0)});
                Able.MessageLog.text(4L, (Object)this, "loadFromFile", string6);
                throw new AbleException(string6);
            }
            if ((n2 = (file = new AbleFieldDefinition(string2, string3, string4)).getDataType()) == 11 || n2 == 12 || n2 == 18 || n2 == 16) {
                this.allNumericData = false;
            }
            ++n;
            this.fieldDefinitionList.addElement(file);
        }
        try {
            if (vector.size() > 0) {
                file = new File(this.fileName + ".dfn");
                if (file.canWrite()) {
                    if (file.exists()) {
                        file.delete();
                    }
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                }
                for (int i = 0; i < vector.size(); ++i) {
                    bufferedWriter.write((String)vector.elementAt(i));
                    bufferedWriter.newLine();
                }
                if (Able.TraceLog.isLogging()) {
                    Able.TraceLog.text(262144L, (Object)this, "loadFromFile", "Warning: Data definition file converted. ABLE 1.0a version saved as '" + this.fileName + ".1a.dfn'.");
                }
                vector = null;
            }
            if (bufferedWriter2 != null) {
                bufferedWriter2.close();
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Able.MessageLog.text(2L, (Object)this, "loadFromFile", exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(524288L, (Object)this, "loadFromFile", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void loadFromSQL() throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = "input";
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(524288L, "Reading metaData");
        }
        this.fieldDefinitionList.removeAllElements();
        int n = this.metaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            AbleFieldDefinition ableFieldDefinition = null;
            string = this.metaData.getColumnName(i);
            int n2 = this.metaData.getColumnType(i);
            switch (n2) {
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string2 = AbleData.DataType((int)13);
                    break;
                }
                case -6: {
                    string2 = AbleData.DataType((int)14);
                    break;
                }
                case 1: 
                case 12: {
                    string2 = AbleData.DataType((int)12);
                    this.allNumericData = false;
                    break;
                }
                default: {
                    string2 = AbleData.DataType((int)16);
                    this.allNumericData = false;
                }
            }
            ableFieldDefinition = new AbleFieldDefinition(string, string2, string3);
            this.fieldDefinitionList.addElement(ableFieldDefinition);
        }
    }

    public void save() throws AbleException {
        AbleExport ableExport = null;
        ableExport = new AbleExport("DataSet-MetaData");
        ableExport.setDataFileName(this.dataSetDefinitionFileName);
        ableExport.init();
        ableExport.setInputBuffer(new String[3]);
        for (int i = 0; i < this.fieldDefinitionList.size(); ++i) {
            AbleFieldDefinition ableFieldDefinition = (AbleFieldDefinition)this.fieldDefinitionList.elementAt(i);
            ableExport.setInputBuffer(0, ableFieldDefinition.getName());
            ableExport.setInputBuffer(1, ableFieldDefinition.getDataTypeString());
            ableExport.setInputBuffer(1, ableFieldDefinition.getUsageString());
            ableExport.process();
        }
        ableExport.close();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

