/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleDataSetDefinition;
import com.ibm.able.beans.AbleImportData;
import com.ibm.able.data.AbleCategoricalField;
import com.ibm.able.data.AbleContinuousField;
import com.ibm.able.data.AbleDiscreteField;
import com.ibm.able.data.AbleField;
import com.ibm.able.data.AbleFieldDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbleDataSet
implements AbleImportData,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final int MAX_BUFFER_SIZE = 512000;
    protected String fileName;
    protected transient BufferedReader in = null;
    protected boolean allNumericData;
    protected Vector textData;
    protected Vector fieldList = new Vector();
    protected int bufferSize = 0;
    protected long numRecords = 0L;
    protected String delimiter = " ";
    protected boolean ready = false;
    private boolean computeStatistics = true;

    private AbleDataSet() {
        this.textData = new Vector();
    }

    public AbleDataSet(String string) {
        this();
        this.fileName = string;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void displayVariables() {
        if (this.fieldList != null) {
            Enumeration enumeration = this.fieldList.elements();
            boolean bl = Able.TraceLog.isLogging();
            while (enumeration.hasMoreElements()) {
                AbleField ableField = (AbleField)enumeration.nextElement();
                if (!bl) continue;
                Able.TraceLog.text(0x100000L, (Object)this, "displayVariables", ableField.toString());
            }
        }
    }

    protected AbleField createAbleField(AbleFieldDefinition ableFieldDefinition) throws AbleException {
        switch (ableFieldDefinition.getDataType()) {
            case 12: {
                return new AbleCategoricalField(ableFieldDefinition);
            }
            case 13: {
                return new AbleContinuousField(ableFieldDefinition);
            }
            case 14: {
                return new AbleDiscreteField(ableFieldDefinition);
            }
        }
        String string = Able.NlsMsg((String)"EX_UNSUPPORTED_FIELD", (Object[])new Object[]{ableFieldDefinition.toString()});
        Able.MessageLog.text(4L, (Object)this, "createAbleField", string);
        throw new AbleException(string, (Throwable)new IllegalArgumentException(string));
    }

    private void loadDataFileDefinition() throws AbleException {
        AbleDataSetDefinition ableDataSetDefinition = new AbleDataSetDefinition();
        ableDataSetDefinition.setFileName(this.fileName);
        ableDataSetDefinition.load();
        this.allNumericData = ableDataSetDefinition.isAllNumericData();
        Vector vector = ableDataSetDefinition.getFieldDefinitionList();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            AbleField ableField = this.createAbleField((AbleFieldDefinition)vector.elementAt(i));
            this.fieldList.addElement(ableField);
            ableField.setColumn(i);
        }
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(0x100000L, (Object)this, "loadDataFileDefinition", "Created " + this.fieldList.size() + " fields.");
        }
    }

    public int getNumFieldsPerRec() {
        if (this.fieldList == null) {
            return 0;
        }
        return this.fieldList.size();
    }

    public void open() throws AbleException {
        this.ready = false;
        this.reopen();
        if (this.fieldList.isEmpty()) {
            this.loadDataFileDefinition();
            this.computeStatistics = true;
        }
        this.loadDataFile();
        this.computeStatistics = false;
        this.ready = true;
    }

    public void reopen() throws AbleException {
        try {
            if (this.in != null) {
                this.in.close();
            }
            File file = new File(this.fileName + ".dat");
            this.in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            int n = (int)file.length();
            this.in.mark(n + 10);
        }
        catch (Exception exception) {
            Able.MessageLog.text(4L, (Object)this, "reopen", exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "reopen", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ready = false;
    }

    public void loadDataFile() throws AbleException {
        String[] stringArray = null;
        this.textData.removeAllElements();
        boolean[] blArray = new boolean[this.fieldList.size()];
        for (int i = 0; i < blArray.length; ++i) {
            String string = ((AbleField)this.fieldList.elementAt(i)).getUsageString();
            blArray[i] = string.equalsIgnoreCase("ignore");
        }
        long l = 0L;
        int n = this.fieldList.size();
        try {
            boolean bl = true;
            String string = this.in.readLine();
            do {
                StringTokenizer stringTokenizer;
                ++l;
                if (this.bufferSize != 0) {
                    boolean bl2 = bl = l <= (long)this.bufferSize;
                }
                if (n != (stringTokenizer = new StringTokenizer(string, this.delimiter)).countTokens()) {
                    String string2 = Able.NlsMsg((String)"EX_RECORD_MISMATCH", (Object[])new Object[]{new Integer(n), new Long(l), new Integer(stringTokenizer.countTokens()), string});
                    Able.MessageLog.text(4L, (Object)this, "loadDataFile", string2);
                    if (Able.TraceLog.isLogging()) {
                        Able.TraceLog.text(262144L, (Object)this, "loadDataFile", string2);
                    }
                    throw new AbleException(string2);
                }
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = stringTokenizer.nextToken();
                    if (blArray[i] || !this.computeStatistics) continue;
                    ((AbleField)this.fieldList.elementAt(i)).computeStatistics((Object)stringArray[i]);
                }
                if (!bl) continue;
                this.textData.addElement(stringArray);
            } while ((string = this.in.readLine()) != null);
            this.numRecords = l;
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(524288L, (Object)this, "loadDataFile", "Loaded " + this.textData.size() + " of " + this.numRecords + " records into memory.");
            }
            if (this.bufferSize != 0) {
                this.reopen();
                if ((long)this.bufferSize > this.numRecords) {
                    this.bufferSize = (int)this.numRecords;
                }
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.in.readLine();
                }
            }
        }
        catch (AbleException ableException) {
            throw ableException;
        }
        catch (Throwable throwable) {
            String string = throwable.getLocalizedMessage();
            Able.MessageLog.text(4L, (Object)this, "loadDataFile", string);
            throw new AbleException(string, throwable);
        }
    }

    public void readNextRecordBlock() throws AbleException {
        long l = this.bufferSize == 0 ? this.numRecords : (long)this.bufferSize;
        String[] stringArray = null;
        int n = this.fieldList.size();
        String string = null;
        StringTokenizer stringTokenizer = null;
        try {
            int n2 = 0;
            while ((long)n2 < l) {
                stringArray = (String[])this.textData.elementAt(n2);
                string = this.in.readLine();
                if (string == null) {
                    this.in.reset();
                    string = this.in.readLine();
                }
                if (string == null) {
                    throw new AbleException(Able.NlsMsg((String)"EX_NO_FILE_DATA", (Object[])new Object[]{this.fileName}));
                }
                stringTokenizer = new StringTokenizer(string, this.delimiter);
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = stringTokenizer.nextToken();
                }
                ++n2;
            }
        }
        catch (AbleException ableException) {
            throw ableException;
        }
        catch (Exception exception) {
            Able.MessageLog.text(4L, (Object)this, "readNextRecordBlock", exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "readNextRecordBlock", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public Vector getTextData() {
        return (Vector)this.textData.clone();
    }

    public boolean isAllNumericData() {
        return this.allNumericData;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Vector getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(Vector vector) {
        this.fieldList = vector;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

