/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.beans.KeyValueByValueComparator;
import com.ibm.able.beans.KeyValuePair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;

public class AbleDataAnalytics
implements Serializable {
    static String clsNm = "AbleDataAnalytics";
    static final long serialVersionUID = 2002042700000000001L;
    public static final int INVALID_INDEX = -1;
    public static final int INTERCEPT_INDEX = 1;
    public static final int SLOPE_INDEX = 0;
    public static final int EQ = 2;
    public static final int GE = 3;
    public static final int GT = 4;
    public static final int LE = 1;
    public static final int LT = 0;
    public static final int NE = 5;
    public static final int INVALID = -1;
    public static final String[] strComparisonSymbols = new String[]{"<", "<=", "==", ">=", ">", "!="};
    public static final String[] strComparisonNames = new String[]{"LT", "LE", "EQ", "GE", "GT", "NE"};

    public static int getComparisonByName(String string) {
        int n = strComparisonNames.length;
        for (int i = 0; i < n; ++i) {
            if (strComparisonNames[i].compareToIgnoreCase(string) != 0) continue;
            return i;
        }
        return -1;
    }

    public static Boolean booleanAnd(Boolean bl, Boolean bl2) {
        return new Boolean(bl != false && bl2 != false);
    }

    public static Double getArrayCount(int[] nArray) {
        if (nArray == null) {
            return new Double(-1.0);
        }
        return new Double(nArray.length);
    }

    public static Double getArrayCount(double[] dArray) {
        if (dArray == null) {
            return new Double(-1.0);
        }
        return new Double(dArray.length);
    }

    public static String arrayContentsAsString(int[] nArray) {
        return AbleDataAnalytics.arrayContentsAsString(nArray, 0);
    }

    public static String arrayContentsAsString(int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        if (nArray == null) {
            stringBuffer.append("Array is null.");
            return stringBuffer.toString();
        }
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
                if (n > 0 && i % n == 0) {
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String arrayContentsAsString(double[] dArray) {
        return AbleDataAnalytics.arrayContentsAsString(dArray, 0.0);
    }

    public static String arrayContentsAsString(double[] dArray, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        if (dArray == null) {
            stringBuffer.append("Array is null.");
            return stringBuffer.toString();
        }
        double d2 = dArray.length;
        int n = 0;
        while ((double)n < d2) {
            if (n != 0) {
                stringBuffer.append(",");
                if (d > 0.0 && (double)n % d == 0.0) {
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append(dArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Double countNonContiguousTHold(double[] dArray, Double d, String string) {
        return new Double(AbleDataAnalytics.countNonContiguousTHold(dArray, (double)d, AbleDataAnalytics.getComparisonByName(string)));
    }

    public static Double countNonContiguousTHold(double[] dArray, Double d, Double d2) {
        return new Double(AbleDataAnalytics.countNonContiguousTHold(dArray, (double)d, d2.intValue()));
    }

    public static int countNonContiguousTHold(double[] dArray, double d, int n) {
        int n2 = 0;
        if (dArray == null) {
            return 0;
        }
        int n3 = dArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3;
        for (int i = 0; i < n3; ++i) {
            if (!AbleDataAnalytics.testTHold(d, dArray[i], n)) continue;
            if (i != n4 + 1) {
                ++n2;
            }
            n4 = i;
        }
        return n2;
    }

    public static int[] findContiguousInWindow(int[] nArray, double[] dArray, Double d) {
        return AbleDataAnalytics.findContiguousInWindow(nArray, dArray, (double)d);
    }

    public static int[] findContiguousInWindow(int[] nArray, double[] dArray, double d) {
        if (nArray == null || dArray == null) {
            return new int[0];
        }
        if (nArray.length == 0 || dArray.length == 0) {
            return new int[0];
        }
        int[] nArray2 = new int[nArray.length];
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray.length;
        double d2 = 0.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            if (!((d2 = dArray[n3 = n7++] - dArray[n2]) >= d)) continue;
            n6 = n3 - 1 - n2;
            n5 = nArray[n3 - 1] - nArray[n2];
            if (n6 == n5) {
                n = AbleDataAnalytics.recordIndices(nArray2, n2, n3 - 1, n);
            }
            ++n2;
        }
        n3 = n4;
        n6 = n3 - 1 - n2;
        n5 = nArray[n3 - 1] - nArray[n2];
        if (n6 == n5) {
            n = AbleDataAnalytics.recordIndices(nArray2, n2, n3 - 1, n);
        }
        if (n == -1) {
            return new int[0];
        }
        int[] nArray3 = new int[++n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    public static int[] valueMonotonicWindowIndices(double[] dArray, double[] dArray2, Double d, Boolean bl, String string) {
        return AbleDataAnalytics.valueMonotonicWindowIndices(dArray, dArray2, (double)d, (boolean)bl, AbleDataAnalytics.getComparisonByName(string));
    }

    public static int[] valueMonotonicWindowIndices(double[] dArray, double[] dArray2, Double d, Boolean bl, Double d2) {
        return AbleDataAnalytics.valueMonotonicWindowIndices(dArray, dArray2, (double)d, (boolean)bl, d2.intValue());
    }

    public static int[] valueMonotonicWindowIndices(double[] dArray, double[] dArray2, double d, boolean bl, int n) {
        if (dArray == null || dArray2 == null) {
            return new int[0];
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            return new int[0];
        }
        if (n == -1) {
            return new int[0];
        }
        int[] nArray = new int[dArray.length];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        double d2 = 0.0;
        int n6 = 0;
        while (n6 < n5) {
            if (!((d2 = dArray2[n4 = n6++] - dArray2[n3]) >= d)) continue;
            if (AbleDataAnalytics.testMonotonic(dArray, n3, n4 - 1, n, bl)) {
                n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
            }
            ++n3;
        }
        n4 = n5;
        if (AbleDataAnalytics.testMonotonic(dArray, n3, n4 - 1, n, bl)) {
            n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
        }
        if (n2 == -1) {
            return new int[0];
        }
        int[] nArray2 = new int[++n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static int[] transitionTHoldWindowIndices(double[] dArray, double[] dArray2, Double d, Double d2) {
        double d3 = d;
        if (dArray == null || dArray2 == null) {
            return new int[0];
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            return new int[0];
        }
        double d4 = d2;
        int[] nArray = new int[dArray.length];
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = dArray.length;
        double d5 = 0.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            n3 = n8;
            n5 += AbleDataAnalytics.testTHold(d4, dArray[n8], 4) ? 1 : 0;
            n6 += AbleDataAnalytics.testTHold(d4, dArray[n8], 0) ? 1 : 0;
            n7 += AbleDataAnalytics.testTHold(d4, dArray[n8], 2) ? 1 : 0;
            d5 = dArray2[n3] - dArray2[n2];
            if (d5 >= d3) {
                n7 -= AbleDataAnalytics.testTHold(d4, dArray[n3], 2) ? 1 : 0;
                if ((n5 -= AbleDataAnalytics.testTHold(d4, dArray[n3], 4) ? 1 : 0) != 0 && (n6 -= AbleDataAnalytics.testTHold(d4, dArray[n3], 0) ? 1 : 0) != 0) {
                    n = AbleDataAnalytics.recordIndices(nArray, n2, n3 - 1, n);
                }
                n5 -= AbleDataAnalytics.testTHold(d4, dArray[n2], 4) ? 1 : 0;
                n6 -= AbleDataAnalytics.testTHold(d4, dArray[n2], 0) ? 1 : 0;
                n7 -= AbleDataAnalytics.testTHold(d4, dArray[n2], 2) ? 1 : 0;
                ++n2;
                continue;
            }
            ++n8;
        }
        if (n5 != 0 && n6 != 0) {
            n = AbleDataAnalytics.recordIndices(nArray, n2, n3 - 1, n);
        }
        if (n == -1) {
            return new int[0];
        }
        int[] nArray2 = new int[++n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static Boolean testMonotonic(int[] nArray, Double d, Double d2, String string) {
        return new Boolean(AbleDataAnalytics.testMonotonic(nArray, d.intValue(), d2.intValue(), AbleDataAnalytics.getComparisonByName(string), false));
    }

    public static Boolean testMonotonic(int[] nArray, Double d, Double d2, Double d3) {
        return new Boolean(AbleDataAnalytics.testMonotonic(nArray, d.intValue(), d2.intValue(), d3.intValue(), false));
    }

    public static Boolean testMonotonic(int[] nArray, Double d, Double d2, String string, Boolean bl) {
        return new Boolean(AbleDataAnalytics.testMonotonic(nArray, d.intValue(), d2.intValue(), AbleDataAnalytics.getComparisonByName(string), (boolean)bl));
    }

    public static Boolean testMonotonic(int[] nArray, Double d, Double d2, Double d3, Boolean bl) {
        return new Boolean(AbleDataAnalytics.testMonotonic(nArray, d.intValue(), d2.intValue(), d3.intValue(), (boolean)bl));
    }

    public static boolean testMonotonic(int[] nArray, int n, int n2, int n3, boolean bl) {
        boolean bl2 = true;
        if (nArray == null) {
            bl2 = false;
            return bl2;
        }
        if (nArray.length == 0) {
            bl2 = false;
            return bl2;
        }
        int n4 = n2 + 1 - n;
        if (n4 < 2) {
            bl2 = false;
            return bl2;
        }
        int n5 = n + 1;
        boolean bl3 = true;
        boolean bl4 = false;
        while (!bl4 && n5 < n2 + 1) {
            if (bl) {
                boolean bl5 = false;
                switch (n3) {
                    case 3: {
                        if (nArray[n5] >= nArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    case 4: {
                        if (nArray[n5] > nArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    case 2: {
                        if (nArray[n5] == nArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    case 0: {
                        if (nArray[n5] < nArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    case 1: {
                        if (nArray[n5] <= nArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    case 5: {
                        if (nArray[n5] != nArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    default: {
                        bl5 = true;
                    }
                }
                if (bl5) {
                    ++n5;
                    continue;
                }
            }
            if (bl3 && nArray[n5] != nArray[n5 - 1]) {
                bl3 = false;
            }
            switch (n3) {
                case 3: {
                    if (nArray[n5] >= nArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 4: {
                    if (nArray[n5] > nArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 1: {
                    if (nArray[n5] <= nArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 0: {
                    if (nArray[n5] < nArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 2: {
                    if (nArray[n5] == nArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 5: {
                    if (nArray[n5] != nArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                default: {
                    bl2 = false;
                    bl4 = true;
                }
            }
            ++n5;
        }
        if (bl3 && n3 != 2) {
            bl2 = false;
        }
        return bl2;
    }

    public static Boolean testMonotonic(double[] dArray, Double d, Double d2, String string) {
        return new Boolean(AbleDataAnalytics.testMonotonic(dArray, d.intValue(), d2.intValue(), AbleDataAnalytics.getComparisonByName(string), false));
    }

    public static Boolean testMonotonic(double[] dArray, Double d, Double d2, Double d3) {
        return new Boolean(AbleDataAnalytics.testMonotonic(dArray, d.intValue(), d2.intValue(), d3.intValue(), false));
    }

    public static Boolean testMonotonic(double[] dArray, Double d, Double d2, String string, Boolean bl) {
        return new Boolean(AbleDataAnalytics.testMonotonic(dArray, d.intValue(), d2.intValue(), AbleDataAnalytics.getComparisonByName(string), (boolean)bl));
    }

    public static Boolean testMonotonic(double[] dArray, Double d, Double d2, Double d3, Boolean bl) {
        return new Boolean(AbleDataAnalytics.testMonotonic(dArray, d.intValue(), d2.intValue(), d3.intValue(), (boolean)bl));
    }

    public static boolean testMonotonic(double[] dArray, int n, int n2, int n3, boolean bl) {
        boolean bl2 = true;
        if (dArray == null) {
            bl2 = false;
            return bl2;
        }
        if (dArray.length == 0) {
            bl2 = false;
            return bl2;
        }
        int n4 = n2 + 1 - n;
        if (n4 < 2) {
            bl2 = false;
            return bl2;
        }
        int n5 = n + 1;
        boolean bl3 = true;
        boolean bl4 = false;
        while (!bl4 && n5 < n2 + 1) {
            if (bl) {
                boolean bl5 = false;
                switch (n3) {
                    case 3: {
                        if (!(dArray[n5] < dArray[n5 - 1])) break;
                        bl5 = true;
                        break;
                    }
                    case 4: {
                        if (!(dArray[n5] <= dArray[n5 - 1])) break;
                        bl5 = true;
                        break;
                    }
                    case 2: {
                        if (dArray[n5] == dArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    case 0: {
                        if (!(dArray[n5] >= dArray[n5 - 1])) break;
                        bl5 = true;
                        break;
                    }
                    case 1: {
                        if (!(dArray[n5] > dArray[n5 - 1])) break;
                        bl5 = true;
                        break;
                    }
                    case 5: {
                        if (dArray[n5] != dArray[n5 - 1]) break;
                        bl5 = true;
                        break;
                    }
                    default: {
                        bl5 = true;
                    }
                }
                if (bl5) {
                    ++n5;
                    continue;
                }
            }
            if (bl3 && dArray[n5] != dArray[n5 - 1]) {
                bl3 = false;
            }
            switch (n3) {
                case 3: {
                    if (!(dArray[n5] < dArray[n5 - 1])) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 4: {
                    if (!(dArray[n5] <= dArray[n5 - 1])) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 1: {
                    if (!(dArray[n5] > dArray[n5 - 1])) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 0: {
                    if (!(dArray[n5] >= dArray[n5 - 1])) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 2: {
                    if (dArray[n5] == dArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                case 5: {
                    if (dArray[n5] != dArray[n5 - 1]) break;
                    bl2 = false;
                    bl4 = true;
                    break;
                }
                default: {
                    bl2 = false;
                    bl4 = true;
                }
            }
            ++n5;
        }
        if (bl3 && n3 != 2) {
            bl2 = false;
        }
        return bl2;
    }

    public static int[] sortedArrayIntersection(Vector vector) {
        if (vector == null) {
            return new int[0];
        }
        if (vector.size() == 0) {
            return new int[0];
        }
        int[][] nArrayArray = new int[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            nArrayArray[i] = (int[])vector.elementAt(i);
        }
        return AbleDataAnalytics.sortedArrayIntersection(nArrayArray);
    }

    public static int[] sortedArrayIntersection(int[][] nArray) {
        int n;
        if (nArray == null) {
            return new int[0];
        }
        if (nArray.length == 0) {
            return new int[0];
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] == null) {
                return new int[0];
            }
            if (nArray[i].length == 0) {
                return new int[0];
            }
            nArray2[i] = nArray[i].length;
            if (nArray2[i] >= n2) continue;
            n2 = nArray2[i];
        }
        ArrayList<KeyValuePair> arrayList = new ArrayList<KeyValuePair>(n3);
        for (n = 0; n < n3; ++n) {
            KeyValuePair keyValuePair = new KeyValuePair(n, nArray2[n]);
            arrayList.add(keyValuePair);
        }
        Collections.sort(arrayList, new KeyValueByValueComparator());
        for (n = 0; n < n3; ++n) {
            nArray3[n] = ((KeyValuePair)arrayList.get(n)).getKey();
        }
        int[] nArray5 = new int[n2];
        int n4 = 0;
        int n5 = nArray3[0];
        int[] nArray6 = nArray[n5];
        int[] nArray7 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = true;
        int n9 = 1;
        while (n9 < n3) {
            n8 = nArray3[n9];
            nArray7 = nArray[n8];
            n6 = nArray6[nArray4[n5]];
            n7 = nArray7[nArray4[n8]];
            while (n7 < n6) {
                if (nArray4[n8] >= nArray2[n8] - 1) {
                    bl = false;
                    break;
                }
                nArray4[n8] = nArray4[n8] + 1;
                n7 = nArray7[nArray4[n8]];
            }
            if (bl && n7 > n6) {
                bl = false;
            }
            if (!bl) {
                nArray4[n5] = nArray4[n5] + 1;
                if (nArray4[n5] >= nArray2[n5]) break;
                n9 = 1;
                bl = true;
                continue;
            }
            if (!bl || ++n9 < n3) continue;
            nArray5[n4] = n6;
            ++n4;
            n9 = 1;
            nArray4[n5] = nArray4[n5] + 1;
            if (nArray4[n5] < nArray2[n5]) continue;
        }
        int[] nArray8 = new int[n4];
        System.arraycopy(nArray5, 0, nArray8, 0, n4);
        return nArray8;
    }

    public static int[] sortedArrayUnion(Vector vector) {
        if (vector == null) {
            return new int[0];
        }
        if (vector.size() == 0) {
            return new int[0];
        }
        int[][] nArrayArray = new int[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            nArrayArray[i] = (int[])vector.elementAt(i);
        }
        return AbleDataAnalytics.sortedArrayUnion(nArrayArray);
    }

    public static int[] sortedArrayUnion(int[][] nArray) {
        int n;
        if (nArray == null) {
            return new int[0];
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == null) {
                return new int[0];
            }
            int n3 = nArray[i].length;
            for (n = 0; n < n3; ++n) {
                hashSet.add(new Integer(nArray[i][n]));
            }
        }
        Object[] objectArray = hashSet.toArray();
        Arrays.sort(objectArray);
        n2 = objectArray.length;
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = (Integer)objectArray[n];
        }
        return nArray2;
    }

    public static Double recordIndices(int[] nArray, Double d, Double d2, Double d3) {
        return new Double(AbleDataAnalytics.recordIndices(nArray, d.intValue(), d2.intValue(), d3.intValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int recordIndices(int[] nArray, int n, int n2, int n3) {
        int n4;
        if (nArray == null) {
            return -1;
        }
        if (nArray.length == 0) {
            return -1;
        }
        if (n3 != -1) {
            n4 = nArray[n3];
            if (n4 >= n) {
                if (n4 >= n2) return n3;
                n = n4 + 1;
            }
        } else {
            n3 = -1;
        }
        n4 = n;
        while (n4 <= n2) {
            nArray[++n3] = n4++;
        }
        return n3;
    }

    public static int[] meanTHoldWindowIndices(double[] dArray, double[] dArray2, Double d, Double d2, String string) {
        return AbleDataAnalytics.meanTHoldWindowIndices(dArray, dArray2, (double)d, (double)d2, AbleDataAnalytics.getComparisonByName(string));
    }

    public static int[] meanTHoldWindowIndices(double[] dArray, double[] dArray2, Double d, Double d2, Double d3) {
        return AbleDataAnalytics.meanTHoldWindowIndices(dArray, dArray2, (double)d, (double)d2, d3.intValue());
    }

    public static int[] meanTHoldWindowIndices(double[] dArray, double[] dArray2, double d, double d2, int n) {
        if (dArray == null || dArray2 == null) {
            return new int[0];
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            return new int[0];
        }
        int[] nArray = new int[dArray.length];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n6 = 0;
        while (n6 < n5) {
            n4 = n6;
            d4 += dArray[n6];
            d3 = dArray2[n4] - dArray2[n3];
            if (d3 >= d) {
                d5 = (d4 -= dArray[n4]) / (double)(n4 - n3);
                if (AbleDataAnalytics.testTHold(d2, d5, n)) {
                    n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
                }
                d4 -= dArray[n3];
                ++n3;
                continue;
            }
            ++n6;
        }
        n4 = n5;
        d5 = d4 / (double)(n4 - n3);
        if (AbleDataAnalytics.testTHold(d2, d5, n)) {
            n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
        }
        if (n2 == -1) {
            return new int[0];
        }
        int[] nArray2 = new int[++n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static int[] valueTHoldWindowIndices(double[] dArray, double[] dArray2, Double d, Double d2, String string) {
        return AbleDataAnalytics.valueTHoldWindowIndices(dArray, dArray2, (double)d, (double)d2, AbleDataAnalytics.getComparisonByName(string));
    }

    public static boolean testTHold(Double d, Double d2, String string) {
        return AbleDataAnalytics.testTHold((double)d, (double)d2, AbleDataAnalytics.getComparisonByName(string));
    }

    public static boolean testTHold(Double d, Double d2, Double d3) {
        return AbleDataAnalytics.testTHold((double)d, (double)d2, d3.intValue());
    }

    public static boolean testTHold(double d, double d2, int n) {
        boolean bl = false;
        switch (n) {
            case 4: {
                if (!(d2 > d)) break;
                bl = true;
                break;
            }
            case 3: {
                if (!(d2 >= d)) break;
                bl = true;
                break;
            }
            case 2: {
                if (d2 != d) break;
                bl = true;
                break;
            }
            case 1: {
                if (!(d2 <= d)) break;
                bl = true;
                break;
            }
            case 0: {
                if (!(d2 < d)) break;
                bl = true;
                break;
            }
            case -1: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static int[] valueTHoldWindowIndices(double[] dArray, double[] dArray2, double d, double d2, int n) {
        if (dArray == null || dArray2 == null) {
            return new int[0];
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            return new int[0];
        }
        int[] nArray = new int[dArray.length];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        double d3 = 0.0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            n4 = n7;
            n6 += AbleDataAnalytics.testTHold(d2, dArray[n7], n) ? 0 : 1;
            d3 = dArray2[n4] - dArray2[n3];
            if (d3 >= d) {
                if ((n6 -= AbleDataAnalytics.testTHold(d2, dArray[n4], n) ? 0 : 1) == 0) {
                    n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
                }
                n6 -= AbleDataAnalytics.testTHold(d2, dArray[n3], n) ? 0 : 1;
                ++n3;
                continue;
            }
            ++n7;
        }
        if (n6 == 0) {
            n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
        }
        if (n2 == -1) {
            return new int[0];
        }
        int[] nArray2 = new int[++n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static Boolean meanTHoldWindow(double[] dArray, double[] dArray2, Double d, Double d2, String string) {
        int n = AbleDataAnalytics.getComparisonByName(string);
        if (n != -1) {
            return AbleDataAnalytics.meanTHoldWindow(dArray, dArray2, d, d2, new Double(n));
        }
        return Boolean.FALSE;
    }

    public static int[] slopeTHoldWindowIndices(double[] dArray, double[] dArray2, Double d, Double d2, String string, Boolean bl) {
        int n = AbleDataAnalytics.getComparisonByName(string);
        int[] nArray = new int[]{};
        if (n >= 0) {
            try {
                nArray = AbleDataAnalytics.slopeTHoldWindowIndices(dArray, dArray2, (double)d, (double)d2, n, (boolean)bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nArray;
    }

    public static int[] slopeTHoldWindowIndices(double[] dArray, double[] dArray2, double d, double d2, int n, boolean bl) {
        if (dArray == null || dArray2 == null) {
            return new int[0];
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            return new int[0];
        }
        int[] nArray = new int[dArray.length];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        double d3 = 0.0;
        int n6 = 0;
        int n7 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray3 = new double[2];
        while (n6 < n5) {
            n4 = n6;
            d4 += dArray2[n6];
            d5 += dArray[n6];
            d3 = dArray2[n4] - dArray2[n3];
            if (d3 >= d) {
                d4 -= dArray2[n4];
                d5 -= dArray[n4];
                n7 = n4 - n3;
                if (n7 > 1) {
                    d6 = d4 / (double)n7;
                    d7 = d5 / (double)n7;
                    dArray3 = AbleDataAnalytics.linearRegression(dArray2, dArray, d6, d7, n3, n4);
                    if (bl) {
                        if (AbleDataAnalytics.testTHold(d2, Math.abs(dArray3[0]), n)) {
                            n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
                        }
                    } else if (AbleDataAnalytics.testTHold(d2, dArray3[0], n)) {
                        n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
                    }
                }
                d4 -= dArray2[n3];
                d5 -= dArray[n3];
                ++n3;
                continue;
            }
            ++n6;
        }
        n4 = n6;
        n7 = n4 - n3;
        if (n7 > 1) {
            d6 = d4 / (double)n7;
            d7 = d5 / (double)n7;
            dArray3 = AbleDataAnalytics.linearRegression(dArray2, dArray, d6, d7, n3, n4);
            if (bl) {
                if (AbleDataAnalytics.testTHold(d2, Math.abs(dArray3[0]), n)) {
                    n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
                }
            } else if (AbleDataAnalytics.testTHold(d2, dArray3[0], n)) {
                n2 = AbleDataAnalytics.recordIndices(nArray, n3, n4 - 1, n2);
            }
        }
        if (n2 == -1) {
            return new int[0];
        }
        int[] nArray2 = new int[++n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static Boolean meanTHoldWindow(double[] dArray, double[] dArray2, Double d, Double d2, Double d3) {
        double d4 = d;
        double d5 = d2;
        int n = d3.intValue();
        Boolean bl = Boolean.FALSE;
        if (dArray == null || dArray2 == null) {
            return bl;
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            return bl;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = dArray.length;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n5 = 0;
        while (n5 < n4) {
            n3 = n5;
            d7 += dArray[n5];
            d6 = dArray2[n3] - dArray2[n2];
            if (d6 >= d4) {
                d8 = (d7 -= dArray[n3]) / (double)(n3 - n2);
                if (AbleDataAnalytics.testTHold(d5, d8, n)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                d7 -= dArray[n2];
                ++n2;
                continue;
            }
            ++n5;
        }
        n3 = n4;
        d8 = d7 / (double)(n3 - n2);
        if (AbleDataAnalytics.testTHold(d5, d8, n)) {
            bl = Boolean.TRUE;
            return bl;
        }
        return bl;
    }

    public static Boolean meanBoundedWindow(double[] dArray, double[] dArray2, Double d, Double d2, String string, Double d3, String string2) {
        int n = AbleDataAnalytics.getComparisonByName(string);
        int n2 = AbleDataAnalytics.getComparisonByName(string2);
        if (n != -1 && n2 != -1) {
            return AbleDataAnalytics.meanBoundedWindow(dArray, dArray2, d, d2, new Double(n), d3, new Double(n2));
        }
        return Boolean.FALSE;
    }

    public static Boolean meanBoundedWindow(double[] dArray, double[] dArray2, Double d, Double d2, Double d3, Double d4, Double d5) {
        Boolean bl = Boolean.FALSE;
        if (d2 == null || d4 == null || d == null || d3 == null || d5 == null) {
            return bl;
        }
        double d6 = d;
        double d7 = d2;
        double d8 = d4;
        int n = d3.intValue();
        int n2 = d5.intValue();
        if (dArray == null || dArray2 == null) {
            return bl;
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            return bl;
        }
        if (d7 < d8) {
            return bl;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n6 < n5) {
            n4 = n6;
            d10 += dArray[n6];
            d9 = dArray2[n4] - dArray2[n3];
            if (d9 >= d6) {
                d11 = (d10 -= dArray[n4]) / (double)(n4 - n3);
                bl2 = AbleDataAnalytics.testTHold(d7, d11, n);
                bl3 = AbleDataAnalytics.testTHold(d8, d11, n2);
                switch (n) {
                    case 3: 
                    case 4: {
                        if (!bl2 && !bl3) break;
                        bl = Boolean.TRUE;
                        return bl;
                    }
                    case 0: 
                    case 1: {
                        if (!bl2 || !bl3) break;
                        bl = Boolean.TRUE;
                        return bl;
                    }
                    case 2: {
                        if (!bl2) break;
                        bl = Boolean.TRUE;
                        return bl;
                    }
                    case 5: {
                        if (!bl2 || !bl3) break;
                        bl = Boolean.TRUE;
                        return bl;
                    }
                }
                d10 -= dArray[n3];
                ++n3;
                continue;
            }
            ++n6;
        }
        n4 = n5;
        d11 = d10 / (double)(n4 - n3);
        bl2 = AbleDataAnalytics.testTHold(d7, d11, n);
        bl3 = AbleDataAnalytics.testTHold(d8, d11, n2);
        switch (n) {
            case 3: 
            case 4: {
                if (!bl2 && !bl3) break;
                bl = Boolean.TRUE;
                return bl;
            }
            case 0: 
            case 1: {
                if (!bl2 || !bl3) break;
                bl = Boolean.TRUE;
                return bl;
            }
            case 2: {
                if (!bl2) break;
                bl = Boolean.TRUE;
                return bl;
            }
            case 5: {
                if (!bl2 || !bl3) break;
                bl = Boolean.TRUE;
                return bl;
            }
        }
        return bl;
    }

    public static int getOppositeComparator(int n) {
        int n2 = -1;
        switch (n) {
            case 3: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 5: {
                n2 = 2;
            }
        }
        return n2;
    }

    public static int getNegativeComparator(int n) {
        int n2 = -1;
        switch (n) {
            case 3: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 5: {
                n2 = 2;
            }
        }
        return n2;
    }

    public static double mean(double[] dArray) {
        double d = 0.0;
        if (dArray == null) {
            return d;
        }
        if (dArray.length == 0) {
            return d;
        }
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d /= (double)n;
    }

    public static Vector linearRegressionToList(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return new Vector();
        }
        if (vector.size() == 0 || vector2.size() == 0) {
            return new Vector();
        }
        int n = vector.size();
        if (vector2.size() < n) {
            n = vector2.size();
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (Double)vector.elementAt(i);
            dArray2[i] = (Double)vector2.elementAt(i);
        }
        return AbleDataAnalytics.linearRegressionToList(dArray, dArray2);
    }

    public static Vector linearRegressionToList(double[] dArray, double[] dArray2) {
        Vector<Double> vector = new Vector<Double>(2);
        double[] dArray3 = AbleDataAnalytics.linearRegression(dArray, dArray2);
        int n = dArray3.length;
        for (int i = 0; i < n; ++i) {
            vector.addElement(new Double(dArray3[i]));
        }
        return vector;
    }

    public static double[] linearRegression(double[] dArray, double[] dArray2) {
        Double d = new Double(AbleDataAnalytics.mean(dArray));
        Double d2 = new Double(AbleDataAnalytics.mean(dArray2));
        return AbleDataAnalytics.linearRegression(dArray, dArray2, d, d2);
    }

    public static double[] linearRegression(double[] dArray, double[] dArray2, Double d, Double d2) {
        double[] dArray3 = new double[]{0.0, 1.0};
        if (dArray == null || dArray2 == null) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return dArray3;
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return dArray3;
        }
        double d3 = d;
        double d4 = d2;
        int n = dArray.length;
        int n2 = dArray2.length;
        if (n != n2) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return dArray3;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 = dArray[i] - d3;
            d6 = dArray2[i] - d4;
            d7 += d5 * d6;
            d8 += d5 * d5;
        }
        try {
            dArray3[0] = d7 / d8;
            dArray3[1] = d4 - dArray3[0] * d3;
        }
        catch (Exception exception) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return dArray3;
        }
        return dArray3;
    }

    public static double[] linearRegression(double[] dArray, double[] dArray2, double d, double d2, int n, int n2) {
        double[] dArray3 = new double[]{0.0, 1.0};
        if (dArray == null || dArray2 == null) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return dArray3;
        }
        int n3 = dArray.length;
        int n4 = dArray2.length;
        if (n3 == 0 || n4 == 0 || n3 < n || n3 < n2 || n4 < n || n4 < n2 || n >= n2 || n3 != n4) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return dArray3;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = n; i < n2; ++i) {
            d3 = dArray[i] - d;
            d4 = dArray2[i] - d2;
            d5 += d3 * d4;
            d6 += d3 * d3;
        }
        try {
            dArray3[0] = d5 / d6;
            dArray3[1] = d2 - dArray3[0] * d;
        }
        catch (Exception exception) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return dArray3;
        }
        return dArray3;
    }

    public Double setValue(String string, Double d) {
        Double d2 = d;
        try {
            d2 = new Double(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d2;
    }

    public Boolean setValue(String string, Boolean bl) {
        Boolean bl2 = bl;
        try {
            bl2 = new Boolean(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

