/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleDataSetDefinition;
import com.ibm.able.beans.AbleImportData;
import com.ibm.able.data.AbleCategoricalField;
import com.ibm.able.data.AbleContinuousField;
import com.ibm.able.data.AbleDiscreteField;
import com.ibm.able.data.AbleField;
import com.ibm.able.data.AbleFieldDefinition;
import com.ibm.able.data.AbleGenericField;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class AbleDBTable
implements AbleImportData,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    protected String query;
    protected transient ResultSet resultSet = null;
    private transient Statement statement = null;
    protected Vector textData;
    protected Vector fieldList = new Vector();
    protected int bufferSize = 0;
    protected long numRecords = 0L;
    protected boolean ready = false;
    protected boolean allNumericData = false;
    private boolean computeStatistics = true;

    private AbleDBTable() {
        this.textData = new Vector();
    }

    public AbleDBTable(Connection connection, String string) throws AbleException {
        this();
        try {
            this.statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            Able.MessageLog.text(4L, (Object)this, "AbleDBTable", sQLException.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "AbleDBTable", (Throwable)sQLException);
            }
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
        this.query = string;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void displayVariables() {
        if (this.fieldList != null) {
            Enumeration enumeration = this.fieldList.elements();
            boolean bl = Able.TraceLog.isLogging();
            while (enumeration.hasMoreElements()) {
                AbleField ableField = (AbleField)enumeration.nextElement();
                if (!bl) continue;
                Able.TraceLog.text(0x100000L, Able.LS + ableField.toString());
            }
        }
    }

    protected AbleField createAbleField(AbleFieldDefinition ableFieldDefinition) throws AbleException {
        switch (ableFieldDefinition.getDataType()) {
            case 12: {
                return new AbleCategoricalField(ableFieldDefinition);
            }
            case 13: {
                return new AbleContinuousField(ableFieldDefinition);
            }
            case 14: {
                return new AbleDiscreteField(ableFieldDefinition);
            }
            case 16: {
                return new AbleGenericField(ableFieldDefinition);
            }
        }
        String string = Able.NlsMsg((String)"EX_UNSUPPORTED_FIELD", (Object[])new Object[]{ableFieldDefinition.toString()});
        Able.MessageLog.text(4L, (Object)this, "createAbleField", string);
        throw new AbleException(string, (Throwable)new IllegalArgumentException(string));
    }

    public void loadMetaDataDefinition() throws AbleException {
        AbleDataSetDefinition ableDataSetDefinition = new AbleDataSetDefinition(this.resultSet);
        ableDataSetDefinition.load();
        this.allNumericData = ableDataSetDefinition.isAllNumericData();
        Vector vector = ableDataSetDefinition.getFieldDefinitionList();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            AbleField ableField = this.createAbleField((AbleFieldDefinition)vector.elementAt(i));
            this.fieldList.addElement(ableField);
            ableField.setColumn(i);
        }
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(0x100000L, (Object)this, "", "Created " + this.fieldList.size() + " fields.");
        }
    }

    public int getNumFieldsPerRec() {
        if (this.fieldList == null) {
            return 0;
        }
        return this.fieldList.size();
    }

    public void open() throws AbleException {
        this.ready = false;
        this.reopen();
        if (this.fieldList.isEmpty()) {
            this.loadMetaDataDefinition();
            this.computeStatistics = true;
        }
        this.loadDataFile();
        this.computeStatistics = false;
        this.ready = true;
    }

    public void reopen() throws AbleException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            this.resultSet = this.statement.executeQuery(this.query);
        }
        catch (Exception exception) {
            Able.MessageLog.text(4L, (Object)this, "reopen", exception.getLocalizedMessage());
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "reopen", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage());
        }
    }

    public void close() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ready = false;
    }

    public void loadDataFile() throws AbleException {
        Object[] objectArray = null;
        this.textData.removeAllElements();
        boolean[] blArray = new boolean[this.fieldList.size()];
        for (int i = 0; i < blArray.length; ++i) {
            String string = ((AbleField)this.fieldList.elementAt(i)).getUsageString();
            blArray[i] = string.equalsIgnoreCase("ignore");
        }
        long l = 0L;
        int n = this.fieldList.size();
        try {
            int n2;
            if (n != this.resultSet.getMetaData().getColumnCount()) {
                String string = Able.NlsMsg((String)"EX_RECORD_MISMATCH", (Object[])new Object[]{new Integer(n), new Long(l), new Integer(this.resultSet.getMetaData().getColumnCount()), ""});
                Able.MessageLog.text(4L, (Object)this, "loadDataFile", string);
                throw new AbleException(string);
            }
            boolean bl = true;
            while (this.resultSet.next()) {
                ++l;
                if (this.bufferSize != 0) {
                    bl = l <= (long)this.bufferSize;
                }
                objectArray = new Object[n];
                for (n2 = 0; n2 < n; ++n2) {
                    objectArray[n2] = this.resultSet.getObject(n2 + 1);
                    if (objectArray[n2] == null) {
                        objectArray[n2] = "SQL_NULL_SQL";
                    }
                    if (blArray[n2] || !this.computeStatistics) continue;
                    ((AbleField)this.fieldList.elementAt(n2)).computeStatistics(objectArray[n2]);
                }
                if (!bl) continue;
                this.textData.addElement(objectArray);
            }
            this.numRecords = l;
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(524288L, (Object)this, "loadDataFile", "Loaded " + this.textData.size() + " of " + this.numRecords + " records into memory");
            }
            if (this.bufferSize != 0) {
                this.reopen();
                if ((long)this.bufferSize > this.numRecords) {
                    this.bufferSize = (int)this.numRecords;
                }
                for (n2 = 0; n2 < this.bufferSize; ++n2) {
                    this.resultSet.next();
                }
            }
        }
        catch (SQLException sQLException) {
            String string = sQLException.getLocalizedMessage();
            Able.TraceLog.exception(4L, (Object)this, "loadDataFile", (Throwable)sQLException);
            throw new AbleException(string, (Throwable)sQLException);
        }
    }

    public void readNextRecordBlock() throws AbleException {
        long l = this.bufferSize == 0 ? this.numRecords : (long)this.bufferSize;
        String[] stringArray = null;
        int n = this.fieldList.size();
        try {
            int n2 = 0;
            while ((long)n2 < l) {
                stringArray = (String[])this.textData.elementAt(n2);
                this.resultSet.next();
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = this.resultSet.getString(i + 1);
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            Able.MessageLog.text(4L, (Object)this, "readNextRecordBlock", sQLException.getLocalizedMessage());
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public Vector getTextData() {
        return (Vector)this.textData.clone();
    }

    public boolean isAllNumericData() {
        return this.allNumericData;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Vector getFieldList() {
        return this.fieldList;
    }

    public ResultSet getResultSet() throws AbleException {
        return this.resultSet;
    }

    public Statement getStatement() throws AbleException {
        return this.statement;
    }

    public void setFieldList(Vector vector) {
        this.fieldList = vector;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("query = " + this.query + Able.LS);
        stringBuffer.append("numRecords = " + this.numRecords + Able.LS);
        stringBuffer.append("allNumericData = " + this.isAllNumericData() + Able.LS);
        stringBuffer.append("bufferSize = " + this.bufferSize + Able.LS);
        stringBuffer.append("numFieldsPerRec = " + this.getNumFieldsPerRec() + Able.LS);
        return stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

