/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleAbstractImport;
import com.ibm.able.beans.AbleDBTable;
import com.ibm.able.data.AbleField;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AbleDBImport
extends AbleAbstractImport
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_DBImport");
    private String driver = "COM.ibm.db2.jdbc.app.DB2Driver";
    private String protocol = "jdbc";
    private String subprotocol = "db2";
    private String database = null;
    private String options = null;
    private String userid = null;
    private transient String password = null;
    protected String schema = null;
    protected String table = null;
    protected transient Connection connection = null;
    protected String selectionColumns = "*";
    protected String selectionWhere = "";
    protected String schemaSeparator = ".";

    public AbleDBImport() throws AbleException {
        super(defaultName);
    }

    public AbleDBImport(String string) throws AbleException {
        super(string);
    }

    public void open() throws AbleException {
        Vector vector = null;
        if (this.importData != null) {
            this.importData.close();
        }
        vector = (Vector)this.fieldList.clone();
        String string = "SELECT " + this.selectionColumns + " FROM ";
        if (this.schema != null && this.schema.trim().length() > 0) {
            string = string + this.schema + this.schemaSeparator;
        }
        string = string + this.table;
        if (this.selectionWhere != null && !this.selectionWhere.trim().equals("")) {
            string = string + " where " + this.selectionWhere;
        }
        this.importData = new AbleDBTable(this.connection, string);
        super.open();
        this.updateFieldUsage(vector);
    }

    protected void updateFieldUsage(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = this.fieldList.size();
        block0: for (int i = 0; i < n; ++i) {
            AbleField ableField = (AbleField)this.fieldList.elementAt(i);
            int n2 = vector.size();
            for (int j = 0; j < n2; ++j) {
                AbleField ableField2 = (AbleField)vector.elementAt(j);
                if (!ableField2.getName().equals(ableField.getName())) continue;
                ableField.setUsage(ableField2.getUsageString());
                continue block0;
            }
        }
    }

    public void init() throws AbleException {
        try {
            this.connect();
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            Able.MessageLog.text(4L, (Object)this, "init", string);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "init", string);
            }
            throw new AbleException(string, (Throwable)exception);
        }
        super.init();
    }

    private void connect() throws AbleException {
        try {
            Class.forName(this.driver).newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.logger.text(4L, (Object)this, "connect", instantiationException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "readObject", (Throwable)instantiationException);
            }
            throw new AbleException(instantiationException.getLocalizedMessage(), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.text(4L, (Object)this, "connect", illegalAccessException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "readObject", (Throwable)illegalAccessException);
            }
            throw new AbleException(illegalAccessException.getLocalizedMessage(), (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.text(4L, (Object)this, "connect", classNotFoundException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "readObject", (Throwable)classNotFoundException);
            }
            throw new AbleException(classNotFoundException.getLocalizedMessage(), (Throwable)classNotFoundException);
        }
        try {
            this.connection = this.userid != null && this.userid.trim().length() > 0 ? DriverManager.getConnection(this.getProtocolURL(), this.userid, this.password) : DriverManager.getConnection(this.getProtocolURL());
            this.schemaSeparator = this.connection.getMetaData().getCatalogSeparator();
        }
        catch (SQLException sQLException) {
            this.logger.text(4L, (Object)this, "connect", sQLException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "readObject", (Throwable)sQLException);
            }
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public String getSchemaTable() {
        StringBuffer stringBuffer = new StringBuffer(this.table);
        if (this.schema != null && this.schema.trim().length() > 0) {
            stringBuffer.insert(0, this.schemaSeparator);
            stringBuffer.insert(0, this.schema);
        }
        return stringBuffer.toString();
    }

    public void close() throws AbleException {
        block3: {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                super.close();
            }
            catch (SQLException sQLException) {
                if (!Able.TraceLog.isLogging()) break block3;
                Able.TraceLog.exception(262144L, (Object)this, "close", (Throwable)sQLException);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        boolean bl = this.dataFlowEnabled;
        objectInputStream.defaultReadObject();
        if (this.importData != null) {
            try {
                this.connect();
                this.open();
            }
            catch (AbleException ableException) {
                this.logger.text(4L, (Object)this, "readObject", ableException.getLocalizedMessage());
                if (this.trace.isLogging()) {
                    this.trace.exception(262144L, (Object)this, "readObject", (Throwable)ableException);
                }
                this.setState(1020);
            }
        }
        if (bl != this.dataFlowEnabled) {
            this.dataFlowEnabled = bl;
        }
        if (this.options == null) {
            this.options = "";
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Driver: \t" + this.driver);
        stringBuffer.append("Protocol: \t" + this.protocol);
        stringBuffer.append("Subprotocol: \t" + this.subprotocol);
        stringBuffer.append("Database: \t" + this.database);
        if (this.userid != null) {
            stringBuffer.append("Userid: \t" + this.userid);
        }
        stringBuffer.append("Table name: \t" + this.table);
        stringBuffer.append("Schema name: \t" + this.schema);
        stringBuffer.append("Connection: \t" + (this.connection == null ? "none" : "exists"));
        stringBuffer.append("SelectionColumn: \t" + this.selectionColumns);
        stringBuffer.append("SelectionWhere: \t" + this.selectionWhere);
        if (this.importData != null) {
            stringBuffer.append(this.importData.toString());
        }
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }

    public void setSubprotocol(String string) {
        this.subprotocol = string;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getConnectionOptions() {
        return this.options;
    }

    public void setConnectionOptions(String string) {
        this.options = string;
    }

    public String getProtocolURL() {
        String string = this.protocol + ":" + this.subprotocol + ":" + this.database;
        if (this.options != null && this.options.length() != 0) {
            string = string + ";" + this.options;
        }
        return string;
    }

    public void setProtocolURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        if (n >= 1) {
            this.protocol = (String)stringTokenizer.nextElement();
        }
        if (n >= 2) {
            this.subprotocol = (String)stringTokenizer.nextElement();
        }
        String string2 = "";
        if (n >= 3) {
            string2 = (String)stringTokenizer.nextElement();
        }
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + ":" + stringTokenizer.nextElement();
        }
        int n2 = string2.indexOf(";");
        if (n2 == -1) {
            this.database = string2;
            this.options = "";
        } else {
            this.database = string2.substring(0, n2);
            this.options = string2.length() > n2 + 1 ? string2.substring(n2 + 1) : "";
        }
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String string) {
        this.userid = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public String getSelectionColumns() {
        return this.selectionColumns;
    }

    public void setSelectionColumns(String string) {
        this.selectionColumns = string;
    }

    public String getSelectionWhere() {
        return this.selectionWhere;
    }

    public void setSelectionWhere(String string) {
        this.selectionWhere = string;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

