/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleDataSink;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleState;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class AbleDBExport
extends AbleObject
implements AbleDataSink,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_DBExport");
    private String driver = "COM.ibm.db2.jdbc.app.DB2Driver";
    private String protocol = "jdbc";
    private String subprotocol = "db2";
    private String database = null;
    private String options = null;
    private String userid = null;
    private transient String password = null;
    private String schema = null;
    private String table = null;
    private int numFieldsPerRecord;
    private transient Connection connection = null;
    private transient PreparedStatement insertStatement = null;
    private transient PreparedStatement updateStatement = null;
    private transient String[] columnNames = null;
    private transient int[] columnTypes = null;
    private String schemaSeparator = ".";
    private boolean creatable = false;
    private boolean creatableDB = false;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public AbleDBExport() throws AbleException {
        super(defaultName);
    }

    public AbleDBExport(String string) throws AbleException {
        super(string == null ? defaultName : string);
    }

    public void open() throws AbleException {
        block17: {
            boolean bl = false;
            try {
                if (this.connection != null) {
                    try {
                        this.close();
                    }
                    catch (AbleException ableException) {
                        // empty catch block
                    }
                }
                try {
                    Class.forName(this.driver).newInstance();
                    if (this.trace.isLogging()) {
                        this.trace.text(524288L, (Object)this, "open", "Driver class '" + this.driver + "' loaded.");
                    }
                }
                catch (Exception exception) {
                    String string = exception.getLocalizedMessage();
                    this.logger.text(4L, (Object)this, "open", string);
                    if (this.trace.isLogging()) {
                        this.trace.exception(262144L, (Object)this, "open", (Throwable)exception);
                    }
                    throw new AbleException(string, (Throwable)exception);
                }
                String string = this.getProtocolURL() + (this.creatableDB && (this.options == null || this.options.length() == 0) ? ";create=true" : "");
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, (Object)this, "open", "Getting connection using protocol:subprotocol:subname '" + string + "'.");
                }
                try {
                    this.connection = this.userid != null && this.userid.trim().length() > 0 ? DriverManager.getConnection(string, this.userid, this.password) : DriverManager.getConnection(string);
                }
                catch (SQLException sQLException) {
                    String string2 = "Unable to create connection for '" + string + "'; reason '" + sQLException.getLocalizedMessage() + "'.  Try adding '-Djdbc.drivers=" + this.driver + "' to JDK VM arguments.";
                    this.logger.text(4L, (Object)this, "open", string2);
                    AbleException ableException = new AbleException(string2, (Throwable)sQLException);
                    if (this.trace.isLogging()) {
                        this.trace.exception(262144L, (Object)this, "open", (Throwable)ableException);
                    }
                    throw ableException;
                }
                if (!this.creatable) {
                    String string3 = this.schema != null ? this.schema : this.connection.getMetaData().getUserName();
                    ResultSet resultSet = this.connection.getMetaData().getTables(null, string3, this.table, null);
                    if (!resultSet.next()) {
                        throw new SQLException(Able.NlsMsg((String)"Ex_BeanCreateTableNotAllowed", (Object[])new Object[]{this.getSchemaTable()}));
                    }
                }
                if (this.creatable) {
                    bl = true;
                }
                this.calculateColumnData();
            }
            catch (SQLException sQLException) {
                String string = sQLException.getLocalizedMessage();
                for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
                    String string4 = sQLException2.getLocalizedMessage();
                    this.logger.text(bl ? 2L : 4L, (Object)this, "init", string4);
                    if (!this.trace.isLogging()) continue;
                    this.trace.exception(bl ? 524288L : 262144L, (Object)this, "init", (Throwable)sQLException2);
                }
                if (bl) break block17;
                throw new AbleException(string, (Throwable)sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Object object) throws SQLException {
        ResultSet resultSet;
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        String string = this.schema;
        if (this.schema == null) {
            string = databaseMetaData.getUserName();
        }
        if ((resultSet = databaseMetaData.getTables(null, string, this.table, null)).next()) {
            resultSet.getMetaData();
        } else {
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "createTable", "No existing table <" + this.table + "> for schema <" + string + ">.");
            }
            if (this.creatable) {
                String string2 = null;
                if (object.getClass() == (array$D == null ? (array$D = AbleDBExport.class$("[D")) : array$D)) {
                    string2 = this.getCreateStatement((double[])object);
                } else if (object.getClass() == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleDBExport.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                    string2 = this.getCreateStatement((String[])object);
                } else if (object.getClass().isArray() && this.connection.getMetaData().supportsANSI92FullSQL()) {
                    string2 = this.getCreateStatement((Object[])object);
                } else {
                    throw new SQLException(Able.NlsMsg((String)"Ex_BeanCreateTableFromBuffer", (Object[])new Object[]{this.getSchemaTable(), object.getClass().getName()}));
                }
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, string2.toString());
                }
                Statement statement = this.connection.createStatement();
                try {
                    statement.executeUpdate(string2);
                }
                finally {
                    statement.close();
                }
            }
        }
    }

    private void calculateColumnData() throws SQLException {
        if (this.connection != null) {
            int n;
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            this.schemaSeparator = databaseMetaData.getCatalogSeparator();
            String string = this.schema;
            if (this.schema == null) {
                string = databaseMetaData.getUserName();
            }
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.getSchemaTable());
            ResultSet resultSet2 = this.connection.getMetaData().getColumns(null, string, this.table, null);
            this.numFieldsPerRecord = resultSet.getMetaData().getColumnCount();
            this.columnNames = new String[this.numFieldsPerRecord];
            this.columnTypes = new int[this.numFieldsPerRecord];
            for (n = 0; n < this.numFieldsPerRecord && resultSet2.next(); ++n) {
                this.columnNames[n] = resultSet2.getString("COLUMN_NAME");
                this.columnTypes[n] = resultSet2.getType();
            }
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "calculateColumnData", "Table " + this.table);
                for (n = 0; n < this.numFieldsPerRecord; ++n) {
                    this.trace.text(524288L, n + 1 + ": " + this.columnNames[n]);
                }
            }
            statement.close();
        }
    }

    private String getCreateStatement(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + this.getSchemaTable() + " (");
        int n = Array.getLength(dArray);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" COL_" + (i + 1) + " DOUBLE");
            if (n > i + 1) {
                stringBuffer.append(",");
                continue;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getCreateStatement(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + this.getSchemaTable() + " (");
        int n = Array.getLength(stringArray);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" COL_" + (i + 1) + " VARCHAR(132)");
            if (n > i + 1) {
                stringBuffer.append(",");
                continue;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getCreateStatement(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + this.getSchemaTable() + " (");
        int n = Array.getLength(objectArray);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" COL_" + (i + 1) + " JAVA_OBJECT");
            if (n > i + 1) {
                stringBuffer.append(",");
                continue;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private String getCreateStatement(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + this.getSchemaTable() + " (");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i] + " " + stringArray2[i]);
            if (n > i + 1) {
                stringBuffer.append(",");
                continue;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     */
    public void createTable(String[] stringArray, String[] stringArray2) throws AbleException {
        block10: {
            String string = this.getCreateStatement(stringArray, stringArray2);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, string.toString());
            }
            Statement statement = null;
            statement = this.connection.createStatement();
            statement.executeUpdate(string);
            Object var7_5 = null;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                this.logger.text(1L, (Object)this, "createTable", sQLException.getLocalizedMessage());
                if (this.trace.isLogging()) {
                    this.trace.exception(0x100000L, (Object)this, "createTable", (Throwable)sQLException);
                }
                break block10;
            }
            {
                catch (SQLException sQLException) {
                    this.logger.text(4L, (Object)this, "createTable", sQLException.getLocalizedMessage());
                    if (this.trace.isLogging()) {
                        this.trace.exception(262144L, (Object)this, "createTable", (Throwable)sQLException);
                    }
                    throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block11: {
                    Object var7_6 = null;
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        this.logger.text(1L, (Object)this, "createTable", sQLException.getLocalizedMessage());
                        if (!this.trace.isLogging()) break block11;
                        this.trace.exception(0x100000L, (Object)this, "createTable", (Throwable)sQLException);
                    }
                }
                throw throwable;
            }
        }
    }

    public void init() throws AbleException {
        this.open();
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws AbleException {
        try {
            if (this.insertStatement != null) {
                this.insertStatement.close();
            }
            if (this.updateStatement != null) {
                this.updateStatement.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.exception(262144L, (Object)this, "close", (Throwable)sQLException);
            }
        }
        finally {
            this.setDataFlowEnabled(false);
            this.setState(1026);
        }
    }

    public int getNumberOfInputFields() {
        return this.numFieldsPerRecord;
    }

    public void setNumberOfInputs(int n) {
        this.numFieldsPerRecord = n;
    }

    public void process() throws AbleException {
        this.processBufferConnections();
        this.process(this.inputBuffer);
        this.dataChanged(this.inputBuffer);
    }

    public Object process(Object object) throws AbleException {
        int n = 0;
        if (this.connection == null) {
            return new Integer(n);
        }
        try {
            Object object2;
            if (this.insertStatement == null) {
                object2 = this.schema != null ? this.schema : this.connection.getMetaData().getUserName();
                ResultSet resultSet = this.connection.getMetaData().getTables(null, (String)object2, this.name, null);
                if (!resultSet.next()) {
                    this.createTable(object);
                }
                this.calculateColumnData();
            }
            if ((object2 = object.getClass()) == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbleDBExport.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                this.prepareInsertStatement((String[])object);
            } else if (object2 == (array$D == null ? (array$D = AbleDBExport.class$("[D")) : array$D)) {
                this.prepareInsertStatement((double[])object);
            } else if (object2 == (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbleDBExport.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
                this.prepareInsertStatement((Object[])object);
            } else if (object instanceof Collection) {
                this.prepareInsertStatement((Collection)object);
            } else {
                this.prepareInsertStatement(object);
            }
            n = this.insertStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            String string = sQLException.getLocalizedMessage();
            Able.MessageLog.text(4L, (Object)this, "process", string);
            if (Able.TraceLog.isLogging()) {
                while (sQLException2 != null) {
                    Able.TraceLog.exception(262144L, (Object)this, "process", (Throwable)sQLException2);
                    sQLException2 = sQLException2.getNextException();
                }
            }
            throw new AbleException(string, (Throwable)sQLException2);
        }
        return new Integer(n);
    }

    private void prepareInsertStatement(String[] stringArray) throws SQLException {
        if (this.insertStatement == null) {
            this.createInsertStatement(stringArray.length);
        }
        for (int i = 0; i < this.numFieldsPerRecord; ++i) {
            this.insertStatement.setString(i + 1, stringArray[i]);
        }
    }

    private void prepareInsertStatement(double[] dArray) throws SQLException {
        if (this.insertStatement == null) {
            this.createInsertStatement(dArray.length);
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.insertStatement.setDouble(i + 1, dArray[i]);
        }
    }

    private void prepareInsertStatement(Object[] objectArray) throws SQLException {
        if (this.insertStatement == null) {
            this.createInsertStatement(objectArray.length);
        }
        for (int i = 0; i < this.numFieldsPerRecord; ++i) {
            this.insertStatement.setObject(i + 1, objectArray[i]);
        }
    }

    private void prepareInsertStatement(Collection collection) throws SQLException {
        if (this.insertStatement == null) {
            this.createInsertStatement(collection.size());
        }
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext() && n < this.numFieldsPerRecord) {
            this.insertStatement.setObject(++n, iterator.next());
        }
    }

    private void prepareInsertStatement(Object object) throws SQLException {
        if (Able.TraceLog.isLogging()) {
            Able.TraceLog.text(262144L, (Object)this, "prepareInsertStatement(Object buffer)", "Don't know how to handle a buffer of type " + object.getClass().getName());
        }
        throw new SQLException(object.getClass().getName());
    }

    private void createInsertStatement(int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO " + this.getSchemaTable());
        stringBuffer.append(" VALUES (");
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("?,");
        }
        stringBuffer.append("?)");
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "createInsertStatement", stringBuffer.toString());
        }
        this.insertStatement = this.connection.prepareStatement(stringBuffer.toString());
    }

    private void createUpdateStatement(int n, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.getSchemaTable() + " SET ");
        ResultSet resultSet = this.connection.getMetaData().getColumns(null, this.schema, this.table, null);
        while (resultSet.next()) {
            stringBuffer.append(resultSet.getString("COLUMN_NAME") + "=?,");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        if (string != null) {
            stringBuffer.append(" WHERE " + string);
        }
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "createUpdateStatement", stringBuffer.toString());
        }
        this.updateStatement = this.connection.prepareStatement(stringBuffer.toString());
        resultSet.close();
    }

    public String getSchemaTable() {
        StringBuffer stringBuffer = new StringBuffer(this.table);
        if (this.schema != null && this.schema.trim().length() > 0) {
            stringBuffer.insert(0, this.schemaSeparator);
            stringBuffer.insert(0, this.schema);
        }
        return stringBuffer.toString();
    }

    public void quitAll() throws AbleException {
        super.quitAll();
        this.close();
    }

    public int delete(String string) throws AbleException {
        try {
            if (this.connection != null) {
                Statement statement = this.connection.createStatement();
                String string2 = string == null || string.equals("") || string.equals("*") ? "" : " WHERE " + string;
                int n = statement.executeUpdate("DELETE FROM " + this.getSchemaTable() + string2);
                statement.close();
                return n;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.logger.text(4L, (Object)this, "delete", sQLException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "delete", (Throwable)sQLException);
            }
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public int delete(Map map) throws AbleException {
        try {
            if (this.connection != null) {
                int n;
                StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.getSchemaTable() + " WHERE ");
                Iterator iterator = map.keySet().iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    if (bl) {
                        stringBuffer.append("and ");
                    }
                    stringBuffer.append(iterator.next() + "= ? ");
                    bl = true;
                }
                PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuffer.toString());
                iterator = map.keySet().iterator();
                for (n = 0; n < map.size(); ++n) {
                    preparedStatement.setObject(n + 1, map.get(iterator.next()));
                }
                n = preparedStatement.executeUpdate();
                preparedStatement.close();
                return n;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.logger.text(4L, (Object)this, "delete", sQLException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "delete", (Throwable)sQLException);
            }
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public int update(String[] stringArray, String string) throws AbleException {
        int n = 0;
        if (this.connection == null) {
            return n;
        }
        try {
            this.createUpdateStatement(stringArray.length, string);
            for (int i = 0; i < this.numFieldsPerRecord; ++i) {
                this.updateStatement.setString(i + 1, stringArray[i]);
            }
            n = this.updateStatement.executeUpdate();
            this.updateStatement.close();
        }
        catch (SQLException sQLException) {
            String string2 = sQLException.getLocalizedMessage();
            Able.MessageLog.text(4L, (Object)this, "update", string2);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "update", string2);
            }
            throw new AbleException(string2, (Throwable)sQLException);
        }
        return n;
    }

    public int update(double[] dArray, String string) throws AbleException {
        int n = 0;
        if (this.connection == null) {
            return n;
        }
        try {
            this.createUpdateStatement(dArray.length, string);
            for (int i = 0; i < dArray.length; ++i) {
                this.updateStatement.setDouble(i + 1, dArray[i]);
            }
            n = this.updateStatement.executeUpdate();
            this.updateStatement.close();
        }
        catch (SQLException sQLException) {
            String string2 = sQLException.getLocalizedMessage();
            Able.MessageLog.text(4L, (Object)this, "update", string2);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "update", string2);
            }
            throw new AbleException(string2, (Throwable)sQLException);
        }
        return n;
    }

    public int update(Object[] objectArray, String string) throws AbleException {
        int n = 0;
        if (this.connection == null) {
            return n;
        }
        try {
            this.createUpdateStatement(objectArray.length, string);
            for (int i = 0; i < this.numFieldsPerRecord; ++i) {
                this.updateStatement.setObject(i + 1, objectArray[i]);
            }
            n = this.updateStatement.executeUpdate();
            this.updateStatement.close();
        }
        catch (SQLException sQLException) {
            String string2 = sQLException.getLocalizedMessage();
            Able.MessageLog.text(4L, (Object)this, "update", string2);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "update", string2);
            }
            throw new AbleException(string2, (Throwable)sQLException);
        }
        return n;
    }

    public int update(Collection collection, String string) throws AbleException {
        int n = 0;
        if (this.connection == null) {
            return n;
        }
        try {
            this.createUpdateStatement(collection.size(), string);
            Iterator iterator = collection.iterator();
            int n2 = 0;
            while (iterator.hasNext() && n2 < this.numFieldsPerRecord) {
                this.updateStatement.setObject(++n2, iterator.next());
            }
            n = this.updateStatement.executeUpdate();
            this.updateStatement.close();
        }
        catch (SQLException sQLException) {
            String string2 = sQLException.getLocalizedMessage();
            Able.MessageLog.text(4L, (Object)this, "update", string2);
            if (Able.TraceLog.isLogging()) {
                Able.TraceLog.text(262144L, (Object)this, "update", string2);
            }
            throw new AbleException(string2, (Throwable)sQLException);
        }
        return n;
    }

    public int update(Map map, Map map2) throws AbleException {
        try {
            if (this.connection != null) {
                int n;
                StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.getSchemaTable() + " SET ");
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next() + "= ?");
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                if (map2 != null && map2.size() > 0) {
                    stringBuffer.append(" WHERE ");
                    iterator = map2.keySet().iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(iterator.next() + "= ?");
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(" AND ");
                    }
                }
                PreparedStatement preparedStatement = this.connection.prepareStatement(stringBuffer.toString());
                Map map3 = map;
                iterator = map3.keySet().iterator();
                int n2 = map.size();
                int n3 = n2 + map2.size();
                for (n = 0; n < n3; ++n) {
                    preparedStatement.setObject(n + 1, map3.get(iterator.next()));
                    if (n2 != n + 1) continue;
                    map3 = map2;
                    iterator = map3.keySet().iterator();
                }
                n = preparedStatement.executeUpdate();
                preparedStatement.close();
                return n;
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.logger.text(4L, (Object)this, "update", sQLException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "update", (Throwable)sQLException);
            }
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public void erase() throws AbleException {
        try {
            if (this.connection != null) {
                Statement statement = this.connection.createStatement();
                statement.execute("DROP TABLE " + this.getSchemaTable());
            }
        }
        catch (SQLException sQLException) {
            this.logger.text(4L, (Object)this, "erase", sQLException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "erase", (Throwable)sQLException);
            }
            throw new AbleException(sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
        this.close();
    }

    public void reset() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.init();
    }

    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (this.connection == null) {
            return;
        }
        this.process(ableEvent.getArgObject());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        boolean bl = this.dataFlowEnabled;
        objectInputStream.defaultReadObject();
        try {
            int n = this.getState();
            if (n == 1021 || n == 1025) {
                this.open();
            }
        }
        catch (AbleException ableException) {
            this.logger.text(4L, (Object)this, "readObject", ableException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "readObject", (Throwable)ableException);
            }
            this.setState(1020);
        }
        if (bl != this.dataFlowEnabled) {
            this.dataFlowEnabled = bl;
        }
        if (this.options == null) {
            this.options = "";
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }

    public void setSubprotocol(String string) {
        this.subprotocol = string;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getConnectionOptions() {
        return this.options;
    }

    public void setConnectionOptions(String string) {
        this.options = string;
    }

    public String getProtocolURL() {
        String string = this.protocol + ":" + this.subprotocol + ":" + this.database;
        if (this.options != null && this.options.length() != 0) {
            string = string + ";" + this.options;
        }
        return string;
    }

    public void setProtocolURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        if (n >= 1) {
            this.protocol = (String)stringTokenizer.nextElement();
        }
        if (n >= 2) {
            this.subprotocol = (String)stringTokenizer.nextElement();
        }
        String string2 = "";
        if (n >= 3) {
            string2 = (String)stringTokenizer.nextElement();
        }
        while (stringTokenizer.hasMoreElements()) {
            string2 = string2 + ":" + stringTokenizer.nextElement();
        }
        int n2 = string2.indexOf(";");
        if (n2 == -1) {
            this.database = string2;
            this.options = "";
        } else {
            this.database = string2.substring(0, n2);
            this.options = string2.length() > n2 + 1 ? string2.substring(n2 + 1) : "";
        }
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String string) {
        this.userid = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public void setCreatable(boolean bl) {
        this.creatable = bl;
    }

    public boolean isCreatableDB() {
        return this.creatableDB;
    }

    public void setCreatableDB(boolean bl) {
        this.creatableDB = bl;
    }

    public boolean isReady() throws AbleException {
        return AbleState.isReady((int)this.getState());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("driver = " + this.driver + Able.LS);
        stringBuffer.append("protocol = " + this.protocol + Able.LS);
        stringBuffer.append("subprotocol = " + this.subprotocol + Able.LS);
        stringBuffer.append("database = " + this.database + Able.LS);
        stringBuffer.append("options = " + this.options + Able.LS);
        stringBuffer.append("userid = " + this.userid + Able.LS);
        stringBuffer.append("password = " + this.password + Able.LS);
        stringBuffer.append("schema = " + this.schema + Able.LS);
        stringBuffer.append("table = " + this.table + Able.LS);
        stringBuffer.append("numFieldsPerRecord= " + this.numFieldsPerRecord + Able.LS);
        if (this.connection != null) {
            stringBuffer.append("connection = " + this.connection.toString() + Able.LS);
        }
        if (this.insertStatement != null) {
            stringBuffer.append("insertStatement = " + this.insertStatement.toString() + Able.LS);
        }
        if (this.updateStatement != null) {
            stringBuffer.append("updateStatement = " + this.updateStatement.toString() + Able.LS);
        }
        if (this.columnNames != null) {
            stringBuffer.append("columnNames = " + this.columnNames + Able.LS);
        }
        if (this.columnTypes != null) {
            stringBuffer.append("columnTypes = " + this.columnTypes + Able.LS);
        }
        if (this.schemaSeparator != null) {
            stringBuffer.append("schemaSeparator = " + this.schemaSeparator + Able.LS);
        }
        return super.toString() + Able.LS + stringBuffer.toString();
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

