/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleDataSource;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.AbleObject;
import com.ibm.able.beans.AbleImportData;
import com.ibm.able.data.AbleField;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public abstract class AbleAbstractImport
extends AbleObject
implements AbleDataSource,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    private static Random randomizer = new Random();
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_Import");
    protected int numFieldsPerRecord = 0;
    protected int bufferSize = 0;
    protected long numRecords = 0L;
    protected long recordsRead = 0L;
    protected long numEpochs = 0L;
    protected AbleImportData importData = null;
    protected boolean randomizeData = false;
    protected int[] randomIndices;
    protected boolean computeStatistics = true;
    protected Vector fieldList = new Vector();
    protected transient Vector textData;
    protected transient Vector numericData;
    protected long recordIndex = -1L;
    protected int bufferRecordIndex = -1;
    protected boolean eof = false;
    protected double cycleSize = 1.0;
    protected boolean cycleRelative = true;
    public transient double[] outNum = null;
    public transient Object[] outSym = null;

    public AbleAbstractImport() throws AbleException {
        this(defaultName);
    }

    public AbleAbstractImport(String string) throws AbleException {
        super(string);
        this.setDefaults();
    }

    public void init() throws AbleException {
        this.open();
        super.init();
    }

    public void open() throws AbleException {
        if (this.importData != null) {
            this.importData.setBufferSize(this.bufferSize);
            if (this.computeStatistics) {
                this.fieldList.removeAllElements();
                this.importData.setFieldList(this.fieldList);
                this.importData.open();
                this.fieldList = this.importData.getFieldList();
                this.computeStatistics = false;
            } else {
                this.fieldList = this.getAgentFieldList();
                this.importData.open();
                this.importData.setFieldList(this.fieldList);
            }
            this.numRecords = this.importData.getNumRecords();
            this.numFieldsPerRecord = this.importData.getNumFieldsPerRec();
            this.bufferSize = this.importData.getBufferSize();
            this.generateRandomIndices(this.bufferSize);
            this.textData = this.importData.getTextData();
            if (this.importData.isAllNumericData()) {
                this.outputBuffer = new double[this.numFieldsPerRecord];
                this.generateNumericData();
            } else {
                this.outputBuffer = new Object[this.numFieldsPerRecord];
                for (int i = 0; i < this.numFieldsPerRecord; ++i) {
                    ((Object[])this.outputBuffer)[i] = "null";
                }
            }
            this.recordsRead = 0L;
            this.recordIndex = -1L;
            this.bufferRecordIndex = -1;
        }
        if (!this.dataFlowEnabled) {
            this.setDataFlowEnabled(true);
        }
        this.chgSupport.firePropertyChange("dataSource", null, null);
        this.dataChanged(this.outputBuffer);
    }

    protected Vector getAgentFieldList() throws AbleException {
        if (this.parent == null) {
            return this.fieldList;
        }
        AbleDataSource ableDataSource = ((AbleDefaultAgent)this.parent).getDataSource();
        if (ableDataSource == null) {
            return this.fieldList;
        }
        Vector vector = ableDataSource.getFieldList();
        if (!vector.isEmpty()) {
            return vector;
        }
        Vector vector2 = ((AbleAgent)this.parent).getProcessList();
        if (vector2 != null) {
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AbleDataSource) || (vector = ((AbleDataSource)e).getFieldList()).isEmpty()) continue;
                return vector;
            }
        }
        return this.fieldList;
    }

    public void process() throws AbleException {
        if (this.importData == null || !this.importData.isReady()) {
            return;
        }
        if (this.importData.isAllNumericData()) {
            this.outNum = this.getNextNumericRecord();
            this.outputBuffer = this.outNum;
        } else {
            this.outputBuffer = this.outSym = this.getNextTextRecord();
        }
        this.dataChanged(this.outputBuffer);
        ++this.recordsRead;
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "process", "Processed record <" + this.recordIndex + "> of <" + this.numRecords + ">; <" + this.recordsRead + "> records read; total epochs <" + this.numEpochs + ">.");
        }
        if (this.recordsRead >= this.numRecords) {
            this.recordsRead = 0L;
            this.endOfFile();
        }
    }

    public void processTimerEvent() throws AbleException {
        this.process();
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "processTimerEvent " + this.name);
        }
    }

    public void reset() throws AbleException {
        this.setDefaults();
        this.init();
    }

    protected void setDefaults() throws AbleException {
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(true);
        this.recordsRead = 0L;
        this.numEpochs = 0L;
    }

    public void quitAll() throws AbleException {
        super.quitAll();
        this.close();
    }

    public void close() throws AbleException {
        block3: {
            try {
                if (this.importData != null) {
                    this.importData.close();
                }
                this.setDataFlowEnabled(false);
                this.setState(1026);
            }
            catch (AbleException ableException) {
                this.logger.text(2L, (Object)this, "close", ableException.getLocalizedMessage());
                if (!this.trace.isLogging()) break block3;
                this.trace.exception(524288L, (Object)this, "close", (Throwable)ableException);
            }
        }
    }

    public int getNumberOfOutputFields() {
        return this.numFieldsPerRecord;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public long getRecordIndex() {
        return this.recordIndex;
    }

    public void setRecordIndex(long l) {
        this.recordIndex = l;
    }

    private double[] getNumericRecord(int n) throws AbleException {
        try {
            return (double[])this.numericData.elementAt(n);
        }
        catch (Exception exception) {
            this.logger.text(2L, (Object)this, "getNumericRecord", exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(524288L, (Object)this, "getNumericRecord", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private double[] getNextNumericRecord() throws AbleException {
        int n = this.getNextRecordIndex();
        try {
            return (double[])this.numericData.elementAt(n);
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "getNextNumericRecord", exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "getNextNumericRecord", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private int getNextRecordIndex() throws AbleException {
        int n = 0;
        this.recordIndex = this.recordIndex >= this.numRecords - 1L ? 0L : ++this.recordIndex;
        boolean bl = this.eof = this.recordIndex >= this.numRecords - 1L;
        if (this.bufferSize != 0) {
            if (this.bufferRecordIndex >= this.bufferSize - 1) {
                this.getNextRecordBlock();
            } else {
                ++this.bufferRecordIndex;
            }
            n = this.bufferRecordIndex;
        } else {
            n = (int)this.recordIndex;
        }
        if (this.randomizeData) {
            n = this.randomIndices[n];
        }
        return n;
    }

    public void getNextRecordBlock() throws AbleException {
        this.importData.readNextRecordBlock();
        this.textData = this.importData.getTextData();
        if (this.importData.isAllNumericData()) {
            this.generateNumericData();
        }
        if (this.randomizeData) {
            this.generateRandomIndices(this.textData.size());
        }
        this.bufferRecordIndex = 0;
    }

    private void generateNumericData() throws AbleException {
        try {
            int n = this.textData.size();
            this.numericData = new Vector(n);
            for (int i = 0; i < n; ++i) {
                double[] dArray = new double[this.numFieldsPerRecord];
                for (int j = 0; j < this.numFieldsPerRecord; ++j) {
                    AbleField ableField = (AbleField)this.fieldList.elementAt(j);
                    dArray[j] = ableField.getNumericValue(((Object[])this.textData.elementAt(i))[j]);
                }
                this.numericData.insertElementAt(dArray, i);
            }
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "generateNumericData", exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "generateNumericData", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected Object[] getNextTextRecord() throws AbleException {
        int n = this.getNextRecordIndex();
        try {
            return (Object[])this.textData.elementAt(n);
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "getNextTextRecord", exception.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "getNextTextRecord", (Throwable)exception);
            }
            throw new AbleException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void setBufferSize(int n) throws AbleException {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }

    public long getCurrentRecordIndex() {
        if (this.recordsRead == -1L) {
            return -1L;
        }
        if (this.bufferSize == 0) {
            if (this.randomizeData) {
                return this.randomIndices[(int)this.recordIndex];
            }
            return this.recordIndex;
        }
        int n = this.bufferSize * (int)((this.recordsRead - 1L) / (long)this.bufferSize);
        int n2 = (int)(this.recordsRead - (long)n - 1L);
        if (this.randomizeData) {
            return n + this.randomIndices[n2];
        }
        return n + n2;
    }

    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        super.processAbleEvent(ableEvent);
    }

    public long getNumEpochs() {
        return this.numEpochs;
    }

    public Vector getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(Vector vector) {
        this.fieldList = vector;
    }

    public Vector getFieldList(String string) throws AbleException {
        Vector<AbleField> vector = new Vector<AbleField>();
        Iterator iterator = this.fieldList.iterator();
        while (iterator.hasNext()) {
            AbleField ableField = (AbleField)iterator.next();
            if (!ableField.getUsageString().equalsIgnoreCase(string)) continue;
            vector.add(ableField);
        }
        return vector;
    }

    public int getNormalizedRecordSize() throws AbleException {
        int n = 0;
        if (this.importData == null) {
            return 0;
        }
        Enumeration enumeration = this.fieldList.elements();
        while (enumeration.hasMoreElements()) {
            AbleField ableField = (AbleField)enumeration.nextElement();
            n += ableField.getNormalizedSize();
        }
        return n;
    }

    public boolean isAllNumericData() {
        if (this.importData == null) {
            return false;
        }
        return this.importData.isAllNumericData();
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean isReady() throws AbleException {
        if (this.importData == null) {
            return false;
        }
        return this.importData.isReady();
    }

    public void endOfFile() {
        block3: {
            ++this.numEpochs;
            if (this.listeners.size() > 0) {
                AbleEvent ableEvent = new AbleEvent((Object)this, null, 2);
                try {
                    this.notifyAbleEventListeners(ableEvent);
                }
                catch (AbleException ableException) {
                    if (!this.trace.isLogging()) break block3;
                    this.trace.exception(262144L, (Object)this, "endOfFile", (Throwable)ableException);
                }
            }
        }
    }

    protected void generateRandomIndices(int n) {
        int n2;
        int n3 = n == 0 ? (int)this.numRecords : n;
        this.randomIndices = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.randomIndices[n2] = n2;
        }
        for (n2 = 0; n2 < n3 && n3 > 1; ++n2) {
            int n4 = randomizer.nextInt(n3 - 1);
            int n5 = randomizer.nextInt(n3 - 1);
            int n6 = this.randomIndices[n4];
            this.randomIndices[n4] = this.randomIndices[n5];
            this.randomIndices[n5] = n6;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.importData != null) {
            this.textData = this.importData.getTextData();
            if (this.importData.isAllNumericData()) {
                this.generateNumericData();
            }
        }
        this.addPropertyChangeListener((PropertyChangeListener)this.parent);
    }

    public void setRandomizeData(boolean bl) {
        if (!this.randomizeData && bl) {
            this.generateRandomIndices(this.bufferSize);
        }
        this.randomizeData = bl;
    }

    public boolean isRandomizeData() {
        return this.randomizeData;
    }

    public double getCycleSize() {
        return this.cycleSize;
    }

    public String getCycleSizeAsString() {
        if (this.cycleRelative) {
            return Double.toString(this.cycleSize);
        }
        return Long.toString((long)this.cycleSize);
    }

    public boolean isCycleRelative() {
        return this.cycleRelative;
    }

    public long getStepsPerCycle() {
        if (!this.cycleRelative) {
            return (long)this.cycleSize;
        }
        return (long)(this.cycleSize * (double)this.getNumRecords());
    }

    public void setCycleSize(double d, boolean bl) {
        this.cycleSize = d;
        this.cycleRelative = bl;
    }

    public boolean getComputeStatistics() {
        return this.computeStatistics;
    }

    public void setComputeStatistics(boolean bl) {
        this.computeStatistics = bl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

