/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleException;
import com.ibm.able.rules.AbleRuleSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class AbleRuleAgent
extends AbleDefaultAgent {
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_RuleAgent");
    protected static final long serialVersionUID = 2001100500100300000L;
    protected AbleRuleSet behaviorRuleSet = null;
    protected String behaviorRuleSetFileName = null;

    public AbleRuleAgent() throws AbleException {
        this(defaultName);
    }

    public AbleRuleAgent(String string) throws AbleException {
        super(string);
        this.setDefaults();
    }

    public void setBehaviorRuleSetFileName(String string) {
        this.behaviorRuleSetFileName = string;
    }

    public String getBehaviorRuleSetFileName() {
        return this.behaviorRuleSetFileName;
    }

    public AbleRuleSet getBehaviorRuleSet() {
        return this.behaviorRuleSet;
    }

    public void setBehaviorRuleSet(AbleRuleSet ableRuleSet) {
        this.behaviorRuleSet = ableRuleSet;
        this.behaviorRuleSetFileName = ableRuleSet.getSrcFileName();
    }

    public void init() throws AbleException {
        this.removeAllBeans();
        this.behaviorRuleSet = new AbleRuleSet();
        this.addBean((AbleBean)this.behaviorRuleSet);
        if (this.behaviorRuleSetFileName.trim().length() > 0) {
            this.behaviorRuleSet.parseFromARL(this.behaviorRuleSetFileName);
            this.behaviorRuleSet.init();
            this.inputBuffer = this.behaviorRuleSet.getInputBuffer();
            this.outputBuffer = this.behaviorRuleSet.getOutputBuffer();
        }
        this.setDataFlowEnabled(true);
        super.init();
    }

    public void reset() throws AbleException {
        this.setDefaults();
        try {
            if (this.behaviorRuleSet != null) {
                this.behaviorRuleSet.reset();
            }
        }
        catch (AbleException ableException) {
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "reset", (Throwable)ableException);
            }
            this.logger.text(2L, (Object)this, "reset", ableException.getLocalizedMessage());
        }
    }

    protected void setDefaults() throws AbleException {
        this.setSleepTime(1000L);
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(true);
    }

    public void process() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "process");
        }
        this.processBufferConnections();
        if (this.behaviorRuleSet != null) {
            if (this.dataFlowEnabled) {
                this.behaviorRuleSet.setInputBuffer(this.inputBuffer);
            }
            this.behaviorRuleSet.process();
            if (this.dataFlowEnabled) {
                this.outputBuffer = this.behaviorRuleSet.getOutputBuffer();
            }
            this.dataChanged((Object)this);
        }
    }

    public Object process(Object object) throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "process");
        }
        if (this.behaviorRuleSet != null) {
            return this.behaviorRuleSet.process(object);
        }
        return null;
    }

    public void processTimerEvent() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "processTimerEvent");
        }
        if (this.behaviorRuleSet != null) {
            this.behaviorRuleSet.processTimerEvent();
            this.dataChanged((Object)this);
        }
    }

    public void processAbleEvent(AbleEvent ableEvent) throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.entry(524288L, (Object)this, "processAbleEvent(arg) " + this.name, new Object[]{ableEvent});
        }
        if (this.behaviorRuleSet != null) {
            this.behaviorRuleSet.processAbleEvent(ableEvent);
        }
    }

    public void quitAll() throws AbleException {
        if (this.behaviorRuleSet != null) {
            this.behaviorRuleSet.quitAll();
        }
        this.quitEnabledEventProcessing();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.behaviorRuleSetFileName = Able.getSerializablePath((String)this.behaviorRuleSetFileName);
        objectOutputStream.defaultWriteObject();
        this.behaviorRuleSetFileName = Able.getLocalPath((String)this.behaviorRuleSetFileName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.behaviorRuleSetFileName = Able.getLocalPath((String)this.behaviorRuleSetFileName);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

