/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleBackPropagation;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.AbleTimeSeriesFilter;
import com.ibm.able.beans.filter.AbleFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AbleNeuralPredictionAgent
extends AbleDefaultAgent
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_NeuralPredictionAgent");
    protected String dataFileName;
    protected String testDataFileName;
    protected int bufferSize = 0;
    protected int maxNumPasses = 100;
    protected double maxRMSError = 0.1;
    protected String netArch = "0 0 0";
    protected int feedbackType = 0;
    protected AbleImport imp1;
    protected AbleImport imp2;
    protected AbleFilter filt1;
    protected AbleFilter filt2;
    protected AbleTimeSeriesFilter tsFilter;
    protected AbleBackPropagation net;
    public double avgRMSError = Double.MAX_VALUE;
    public int numPasses = 0;
    protected boolean training = false;
    protected boolean explicitErrorMode = false;
    protected int lastNumPasses = 0;
    protected int trainToTestRatio = 10;
    protected boolean trainOK = false;
    protected int windowSize = 1;
    protected int horizon = 0;
    protected boolean firstPass = true;

    public AbleNeuralPredictionAgent() throws AbleException {
        this(defaultName);
    }

    public AbleNeuralPredictionAgent(String string) throws AbleException {
        super(string);
        this.setDefaults();
    }

    public void reset() throws AbleException {
        this.setDefaults();
        if (this.imp1 != null) {
            this.imp1.reset();
        }
        if (this.imp2 != null) {
            this.imp2.reset();
        }
        if (this.net != null) {
            this.net.reset();
        }
    }

    protected void setDefaults() throws AbleException {
        this.avgRMSError = Double.MAX_VALUE;
        this.numPasses = 0;
        this.setSleepTime(10L);
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.firstPass = true;
    }

    public void init() throws AbleException {
        if (this.dataFileName == null || this.dataFileName.equals("")) {
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "init()", "Neural Classifier Agent " + this.name + " not initialized due to lack of dataFileName.");
            }
            return;
        }
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "init()", "Configuring Neural Prediction Agent " + this.name);
        }
        AbleDefaultAgent.removeBeans((AbleBeanContainer)this, (AbleBean[])new AbleBean[]{this.imp1, this.imp2, this.filt1, this.filt2, this.net, this.tsFilter});
        this.imp1 = new AbleImport();
        this.addBean((AbleBean)this.imp1);
        this.imp1.setBufferSize(this.bufferSize);
        this.imp1.setDataFileName(this.dataFileName);
        this.imp1.init();
        this.imp2 = new AbleImport(Able.NlsMsg((String)"DFLT_NAME_TestImport"));
        this.addBean((AbleBean)this.imp2);
        this.imp2.setBufferSize(this.bufferSize);
        this.imp2.setComputeStatistics(false);
        if (this.testDataFileName != null && this.testDataFileName.length() != 0) {
            this.imp2.setDataFileName(this.testDataFileName);
            this.imp2.init();
        }
        this.net = new AbleBackPropagation();
        this.net.setExplicitErrorMode(this.explicitErrorMode);
        this.addBean((AbleBean)this.net);
        this.filt1 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        this.addBean((AbleBean)this.filt1);
        this.filt2 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
        this.addBean((AbleBean)this.filt2);
        this.net.generateTranslateTemplates(this.filt1, this.filt2, this.imp1.getFieldList());
        int n = this.filt1.getNumInUnits();
        int n2 = this.filt1.getNumOutUnits();
        int n3 = n;
        if (this.windowSize > 1 || this.horizon > 0) {
            n = this.windowSize * n;
            this.tsFilter = new AbleTimeSeriesFilter();
            this.tsFilter.setWindowSize(this.windowSize);
            this.tsFilter.setHorizon(this.horizon);
            this.tsFilter.setNumInUnits(n3);
            this.tsFilter.setNumOutUnits(n2);
            this.tsFilter.init();
            this.addBean((AbleBean)this.tsFilter);
        }
        String string = n + " " + this.netArch + " " + n2 + " " + this.feedbackType;
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "init()", this.name + " agent, network arch = " + string);
        }
        this.net.setNetArchitecture(string);
        new AbleBufferConnection((AbleBean)this.imp1, (AbleBean)this.filt1);
        new AbleBufferConnection((AbleBean)this.imp2, (AbleBean)this.filt1);
        if (this.windowSize > 1 || this.horizon > 0) {
            new AbleBufferConnection((AbleBean)this.filt1, (AbleBean)this.tsFilter);
            new AbleBufferConnection((AbleBean)this.tsFilter, (AbleBean)this.net);
            new AbleBufferConnection((AbleBean)this.net, (AbleBean)this.filt2);
        } else {
            new AbleBufferConnection((AbleBean)this.filt1, (AbleBean)this.net);
            new AbleBufferConnection((AbleBean)this.net, (AbleBean)this.filt2);
        }
        this.inputBuffer = this.filt1.getInputBuffer();
        this.outputBuffer = this.filt2.getOutputBuffer();
        this.imp1.setDataFlowEnabled(true);
        this.imp2.setDataFlowEnabled(false);
        this.filt1.setDataFlowEnabled(true);
        this.filt2.setDataFlowEnabled(true);
        if (this.tsFilter != null) {
            this.tsFilter.setDataFlowEnabled(true);
        }
        this.net.setDataFlowEnabled(true);
        super.init();
    }

    public void process() throws AbleException {
        AbleImport ableImport = (AbleImport)this.getDataSource();
        int n = this.windowSize + this.horizon - 1;
        if (ableImport.eof() && n > 0 || this.firstPass) {
            this.firstPass = false;
            this.net.setDataFlowEnabled(false);
            int n2 = this.windowSize + this.horizon - 1;
            for (int i = 0; i < n2; ++i) {
                super.process();
            }
            this.net.setDataFlowEnabled(true);
            super.process();
        } else {
            super.process();
        }
    }

    public void processTimerEvent() throws AbleException {
        boolean bl = false;
        if (this.training) {
            this.process();
            this.numPasses = (int)this.net.getNetEpoch();
            this.avgRMSError = this.net.getAvgRMSError();
            this.dataChanged(this);
            if (this.net.getNetRecInx() == 0L) {
                int n = this.net.getNetMode();
                if (n == 0) {
                    this.trainOK = false;
                }
                if (this.avgRMSError <= this.maxRMSError) {
                    if (n == 0) {
                        this.trainOK = true;
                    }
                    if (n == 1) {
                        bl = true;
                    }
                    if (this.trainOK && bl) {
                        String string = Able.NlsMsg((String)"INF_NN_PREDICTION_COMPLETE", (Object[])new Object[]{this.name, new Double(this.avgRMSError), new Double(this.maxRMSError)});
                        if (this.trace.isLogging()) {
                            this.trace.text(524288L, (Object)this, "processTimerEvent()", string);
                        }
                        this.logger.text(1L, (Object)this, "processTimerEvent()", string);
                        this.stopTraining();
                    }
                } else if (this.numPasses >= this.maxNumPasses) {
                    String string = Able.NlsMsg((String)"INF_MAX_PASSES_REACHED", (Object[])new Object[]{this.name, new Integer(this.numPasses)});
                    if (this.trace.isLogging()) {
                        this.trace.text(524288L, (Object)this, "processTimerEvent()", string);
                    }
                    this.logger.text(2L, (Object)this, "processTimerEvent()", string);
                    this.stopTraining();
                }
                if (this.training) {
                    this.autoTrain(this.numPasses);
                }
            }
        }
    }

    protected void autoTrain(int n) {
        try {
            int n2 = this.net.getNetMode();
            if (this.trainOK && n2 != 1 && n % this.trainToTestRatio == 0) {
                this.setMode(1);
            } else if (n2 != 0) {
                this.setMode(0);
            }
        }
        catch (AbleException ableException) {
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "autoTrain", (Throwable)ableException);
            }
            this.logger.text(4L, (Object)this, "autoTrain", ableException.getLocalizedMessage());
        }
    }

    public void setDataFileName(String string) throws AbleException {
        if (this.imp1 != null) {
            String string2 = this.imp1.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp1.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp1.setDataFileName(string);
            }
        }
        this.dataFileName = string;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setTestDataFileName(String string) throws AbleException {
        if (this.imp2 != null) {
            String string2 = this.imp2.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp2.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp2.setDataFileName(string);
            }
        }
        this.testDataFileName = string;
    }

    public String getTestDataFileName() {
        return this.testDataFileName;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public AbleBackPropagation getNetwork() {
        return this.net;
    }

    public int getNumPasses() {
        return this.numPasses;
    }

    public void setNumPasses(int n) {
    }

    public void setMaxNumPasses(int n) {
        this.maxNumPasses = n;
    }

    public int getMaxNumPasses() {
        return this.maxNumPasses;
    }

    public void setMaxRMSError(double d) {
        this.maxRMSError = d;
    }

    public double getMaxRMSError() {
        return this.maxRMSError;
    }

    public double getAvgRMSError() {
        return this.avgRMSError;
    }

    public void setNetArch(String string) throws AbleException {
        this.netArch = string;
    }

    public void setFeedbackType(int n) throws AbleException {
        this.feedbackType = n;
    }

    public void setTrainToTestRatio(int n) {
        this.trainToTestRatio = n;
    }

    public int getTrainToTestRatio() {
        return this.trainToTestRatio;
    }

    public String getNetArch() {
        return this.netArch;
    }

    public String getNetArchitecture() {
        if (this.net == null) {
            return "0 " + this.netArch + " 0 " + this.feedbackType;
        }
        return this.net.getNetArchitecture();
    }

    public void setExplicitErrorMode(boolean bl) {
        this.explicitErrorMode = bl;
    }

    public boolean getExplicitErrorMode() {
        return this.explicitErrorMode;
    }

    public void setTolerance(double d) {
        if (this.net != null) {
            this.net.setTolerance(d);
        }
    }

    public double getTolerance() {
        if (this.net != null) {
            return this.net.getTolerance();
        }
        return 0.0;
    }

    public void setWindowSize(int n) {
        if (n < 1) {
            return;
        }
        this.windowSize = n;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setHorizon(int n) {
        if (n < 0) {
            return;
        }
        this.horizon = n;
    }

    public int getHorizon() {
        return this.horizon;
    }

    public void setMode(int n) throws AbleException {
        int n2 = this.getState();
        if (n2 == 1026 || n2 == 1020) {
            return;
        }
        if (n == 0) {
            this.imp1.setDataFlowEnabled(true);
            this.imp2.setDataFlowEnabled(false);
            this.setDataFlowEnabled(false);
            this.net.setNetMode(0);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "Switching neural prediction agent to TRAIN mode");
            }
        }
        if (n == 1) {
            if (this.imp2.getState() != 1026) {
                this.imp1.setDataFlowEnabled(false);
                this.imp2.setDataFlowEnabled(true);
                this.setDataFlowEnabled(false);
            }
            this.net.setNetMode(1);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "Switching neural prediction agent to TEST mode");
            }
        }
        if (n == 2) {
            this.imp1.setDataFlowEnabled(false);
            this.imp2.setDataFlowEnabled(false);
            this.setDataFlowEnabled(true);
            this.net.setNetMode(2);
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "setMode()", "Switching neural prediction agent to RUN mode");
            }
        }
    }

    public int getMode() throws AbleException {
        if (this.net == null) {
            return 0;
        }
        return this.net.getNetMode();
    }

    public boolean isTraining() throws AbleException {
        return this.training;
    }

    public void startTraining() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "startTraining()", "Training was started: " + this.name);
        }
        this.setTimerEventProcessingEnabled(true);
        this.setDataFlowEnabled(false);
        this.startEnabledEventProcessing();
        boolean bl = this.training;
        this.training = true;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.training));
    }

    public void stopTraining() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "stopTraining()", "Training was stopped: " + this.name);
        }
        this.setTimerEventProcessingEnabled(false);
        this.setDataFlowEnabled(true);
        boolean bl = this.training;
        this.training = false;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.training));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.dataFileName = Able.getSerializablePath((String)this.dataFileName);
        this.testDataFileName = Able.getSerializablePath((String)this.testDataFileName);
        objectOutputStream.defaultWriteObject();
        this.dataFileName = Able.getLocalPath((String)this.dataFileName);
        this.testDataFileName = Able.getLocalPath((String)this.testDataFileName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.dataFileName = Able.getLocalPath((String)this.dataFileName);
        this.testDataFileName = Able.getLocalPath((String)this.testDataFileName);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

