/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.AbleSelfOrganizingMap;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.data.AbleDataException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class AbleNeuralClusteringAgent
extends AbleDefaultAgent
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_NeuralClusteringAgent");
    protected String dataFileName;
    protected String testDataFileName;
    protected int bufferSize = 0;
    protected int maxNumPasses = 20;
    protected double confidence = 0.0;
    protected int numRows = 4;
    protected int numCols = 4;
    protected AbleImport imp1;
    protected AbleImport imp2;
    protected AbleFilter filt1;
    protected AbleSelfOrganizingMap net;
    protected int winner;
    protected int numPasses = 0;
    protected boolean training = false;
    protected boolean autoTrain = true;
    protected double[] inNum = null;
    protected double[] outNum = null;
    protected String[] inSym = null;
    protected String[] outSym = null;

    public AbleNeuralClusteringAgent() throws AbleException {
        this(defaultName);
    }

    public AbleNeuralClusteringAgent(String string) throws AbleException {
        super(string);
        this.setDefaults();
    }

    public void reset() throws AbleException {
        this.setDefaults();
        if (this.imp1 != null) {
            this.imp1.reset();
        }
        if (this.imp2 != null) {
            this.imp2.reset();
        }
        if (this.net != null) {
            this.net.reset();
        }
    }

    protected void setDefaults() throws AbleException {
        this.numPasses = 0;
        this.setSleepTime(10L);
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
    }

    public void init() throws AbleException {
        if (this.dataFileName == null || this.dataFileName.equals("")) {
            if (this.trace.isLogging()) {
                this.trace.text(524288L, (Object)this, "init()", "Neural Classifier Agent " + this.name + " not initialized due to lack of dataFileName.");
            }
            return;
        }
        AbleDefaultAgent.removeBeans((AbleBeanContainer)this, (AbleBean[])new AbleBean[]{this.imp1, this.imp2, this.filt1, this.net});
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "init()", "Configuring Neural Clustering Agent " + this.name);
        }
        this.imp1 = new AbleImport();
        this.addBean((AbleBean)this.imp1);
        this.imp1.setBufferSize(this.bufferSize);
        this.imp1.setDataFileName(this.dataFileName);
        this.imp1.init();
        this.imp2 = new AbleImport(Able.NlsMsg((String)"DFLT_NAME_TestImport"));
        this.addBean((AbleBean)this.imp2);
        this.imp2.setBufferSize(this.bufferSize);
        this.imp2.setComputeStatistics(false);
        if (this.testDataFileName != null && this.testDataFileName.length() != 0) {
            this.imp2.setDataFileName(this.testDataFileName);
            this.imp2.init();
        }
        this.net = new AbleSelfOrganizingMap();
        this.addBean((AbleBean)this.net);
        this.filt1 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
        this.addBean((AbleBean)this.filt1);
        this.net.generateTranslateTemplates(this.filt1, null, this.imp1.getFieldList());
        int n = this.filt1.getNumInUnits();
        String string = n + " " + this.numRows + " " + this.numCols;
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "init()", this.name + " agent, network arch = " + string);
        }
        this.net.setNetArchitecture(string);
        new AbleBufferConnection((AbleBean)this.imp1, (AbleBean)this.filt1);
        new AbleBufferConnection((AbleBean)this.imp2, (AbleBean)this.filt1);
        new AbleBufferConnection((AbleBean)this.filt1, (AbleBean)this.net);
        this.inputBuffer = this.filt1.getInputBuffer();
        this.outputBuffer = this.net.getOutputBuffer();
        this.imp1.setDataFlowEnabled(true);
        this.imp2.setDataFlowEnabled(false);
        this.filt1.setDataFlowEnabled(true);
        this.net.setDataFlowEnabled(true);
        super.init();
    }

    public void processTimerEvent() throws AbleException {
        if (this.training) {
            this.process();
            this.numPasses = (int)this.net.getNetEpoch();
            this.dataChanged(this);
            if (this.numPasses >= this.maxNumPasses) {
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, (Object)this, "processTimerEvent()", "Training complete");
                }
                this.stopTraining();
            }
        }
    }

    public void setDataFileName(String string) throws AbleException {
        if (this.imp1 != null) {
            String string2 = this.imp1.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp1.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp1.setDataFileName(string);
            }
        }
        this.dataFileName = string;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setTestDataFileName(String string) throws AbleException {
        if (this.imp2 != null) {
            String string2 = this.imp2.getDataFileName();
            if (string2 == null) {
                if (string != null) {
                    this.imp2.setDataFileName(string);
                }
            } else if (!string2.equals(string)) {
                this.imp2.setDataFileName(string);
            }
        }
        this.testDataFileName = string;
    }

    public String getTestDataFileName() {
        return this.testDataFileName;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public AbleSelfOrganizingMap getNetwork() {
        return this.net;
    }

    public int getNumPasses() {
        return this.numPasses;
    }

    public void setNumPasses(int n) {
    }

    public void setMaxNumPasses(int n) {
        this.maxNumPasses = n;
    }

    public int getMaxNumPasses() {
        return this.maxNumPasses;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getWinner() {
        return this.winner;
    }

    public void setNumRows(int n) {
        this.numRows = n;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumCols(int n) {
        this.numCols = n;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public void setAutoTrain(boolean bl) {
        this.autoTrain = bl;
    }

    public boolean getAutoTrain() {
        return this.autoTrain;
    }

    public void setMode(int n) throws AbleException {
        int n2 = this.getState();
        if (n2 == 1026 || n2 == 1020) {
            return;
        }
        if (n == 0) {
            this.imp1.setDataFlowEnabled(true);
            this.imp2.setDataFlowEnabled(false);
            this.setDataFlowEnabled(false);
            this.net.setNetMode(0);
        }
        if (n == 1) {
            if (this.imp2.getState() != 1026) {
                this.imp1.setDataFlowEnabled(false);
                this.imp2.setDataFlowEnabled(true);
                this.setDataFlowEnabled(false);
            }
            this.net.setNetMode(1);
        }
        if (n == 2) {
            this.imp1.setDataFlowEnabled(false);
            this.imp2.setDataFlowEnabled(false);
            this.setDataFlowEnabled(true);
            this.net.setNetMode(2);
        }
    }

    public int getMode() throws AbleException {
        if (this.net == null) {
            return 0;
        }
        return this.net.getNetMode();
    }

    public String getNetArchitecture() throws AbleException {
        if (this.net == null) {
            return "0 " + this.numRows + " " + this.numCols;
        }
        return this.net.getNetArchitecture();
    }

    public boolean isTraining() throws AbleException {
        return this.training;
    }

    public void startTraining() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "startTraining()", "Training was started: " + this.name);
        }
        this.setTimerEventProcessingEnabled(true);
        this.setDataFlowEnabled(false);
        this.startEnabledEventProcessing();
        boolean bl = this.training;
        this.training = true;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.training));
    }

    public void stopTraining() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(524288L, (Object)this, "stopTraining()", "Training was stopped: " + this.name);
        }
        this.setTimerEventProcessingEnabled(false);
        this.setDataFlowEnabled(true);
        boolean bl = this.training;
        this.training = false;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.training));
    }

    public String getClusterLabel(int n) {
        if (this.net != null) {
            return this.net.getClusterLabel(n);
        }
        return "";
    }

    public void setClusterLabel(int n, String string) {
        if (this.net != null) {
            this.net.setClusterLabel(n, string);
        }
    }

    public String[] getClusterLabels() {
        if (this.net != null) {
            return this.net.getClusterLabels();
        }
        return null;
    }

    public String getClusterCategory(int n) {
        if (this.net != null) {
            return this.net.getClusterCategory(n);
        }
        return "";
    }

    public String getWinnerCategory() {
        if (this.net != null) {
            return this.net.getWinnerCategory();
        }
        return "";
    }

    public String getWinnerLabel() {
        if (this.net != null) {
            return this.net.getWinnerLabel();
        }
        return "";
    }

    public void setClusterCategory(int n, String string) throws AbleDataException {
        if (this.net != null) {
            this.net.setClusterCategory(n, string);
        }
    }

    public String[] getClusterCategories() {
        if (this.net != null) {
            return this.net.getClusterCategories();
        }
        return null;
    }

    public Vector getClusterCategoryValues() {
        if (this.net != null) {
            return this.net.getClusterCategoryValues();
        }
        return new Vector();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.dataFileName = Able.getSerializablePath((String)this.dataFileName);
        this.testDataFileName = Able.getSerializablePath((String)this.testDataFileName);
        objectOutputStream.defaultWriteObject();
        this.dataFileName = Able.getLocalPath((String)this.dataFileName);
        this.testDataFileName = Able.getLocalPath((String)this.testDataFileName);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.dataFileName = Able.getLocalPath((String)this.dataFileName);
        this.testDataFileName = Able.getLocalPath((String)this.testDataFileName);
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

