/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleGeneticObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class AbleGeneticSearchAgent
extends AbleDefaultAgent
implements Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final String defaultName = Able.NlsMsg((String)"DFLT_NAME_GeneticSearchAgent");
    public static final int REPLACE_ALL = 0;
    public static final int REPLACE_SOME = 1;
    protected String sourceFileName;
    protected int reproductionTechnique = 0;
    protected Class geneticObjectClass;
    protected Vector population = new Vector();
    protected Hashtable chromosomeList = new Hashtable();
    protected Hashtable operatorFitness = null;
    protected int chromosomeLength = 10;
    protected String vocabulary = "01";
    protected String geneticObjectClassName = "com.ibm.able.examples.genetic.TstGeneticFunction1";
    protected int maxNumPasses = 100;
    protected double fitnessThreshold = 100000.0;
    protected int populationSize = 100;
    protected int replacementSize = 100;
    protected double crossoverRate = 0.65;
    protected double mutationRate = 0.008;
    protected boolean noDuplicatesAllowed = false;
    protected boolean useNormalizedFitness = false;
    protected boolean autoEvolve = true;
    protected double maxFitness = 0.0;
    protected double minFitness = 0.0;
    protected double avgFitness = 0.0;
    protected double totalFitness = 0.0;
    protected double totalNormalizedFitness = 0.0;
    protected double[] summedFitness;
    protected int numPasses = 0;
    protected boolean evolving = false;
    AbleAgent evaluationAgent = null;

    public AbleGeneticSearchAgent() throws AbleException {
        this(defaultName);
    }

    public AbleGeneticSearchAgent(String string) throws AbleException {
        super(string);
        this.setDefaults();
    }

    public void reset() throws AbleException {
        super.reset();
        this.setSleepTime(100L);
        this.setTimerEventProcessingEnabled(false);
        this.setAbleEventProcessingEnabled(0);
        this.setDataFlowEnabled(false);
        this.setDefaults();
        this.dataChanged(this);
    }

    private void setDefaults() throws AbleException {
        this.numPasses = 0;
        this.maxFitness = 0.0;
        this.minFitness = 0.0;
        this.avgFitness = 0.0;
        this.totalFitness = 0.0;
        this.totalNormalizedFitness = 0.0;
        this.population.removeAllElements();
    }

    public void init() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "init", "Configuring Genetic Search Agent " + this.name);
        }
        this.setDefaults();
        this.summedFitness = new double[this.populationSize + 1];
        this.chromosomeList.clear();
        if (this.replacementSize <= 0) {
            this.replacementSize = 2;
        }
        if (this.replacementSize > this.populationSize) {
            this.replacementSize = this.populationSize;
        }
        this.reproductionTechnique = this.populationSize == this.replacementSize ? 0 : 1;
        try {
            this.removeAllBeans();
            this.geneticObjectClass = Class.forName(this.geneticObjectClassName);
            AbleGeneticObject ableGeneticObject = (AbleGeneticObject)this.geneticObjectClass.newInstance();
            this.evaluationAgent = ableGeneticObject.initEvaluationAgent();
            if (this.evaluationAgent != null) {
                this.addBean((AbleBean)this.evaluationAgent);
            }
            ableGeneticObject.registerOperators((AbleAgent)this);
            this.operatorFitness = ableGeneticObject.getOperatorFitness();
            this.chromosomeLength = ableGeneticObject.getChromosomeLength();
            this.vocabulary = ableGeneticObject.getVocabulary();
            while (this.population.size() < this.populationSize) {
                Object object = ableGeneticObject.getRandomChromosome();
                AbleGeneticObject ableGeneticObject2 = this.createChild(object);
                if (ableGeneticObject2 == null) continue;
                this.insertIntoPopulation(ableGeneticObject2, this.population);
            }
        }
        catch (AbleException ableException) {
            throw ableException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.text(4L, (Object)this, "init()", classNotFoundException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "init()", (Throwable)classNotFoundException);
            }
            throw new AbleException(classNotFoundException.getLocalizedMessage(), (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            this.logger.text(4L, (Object)this, "init()", instantiationException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "init()", (Throwable)instantiationException);
            }
            throw new AbleException(instantiationException.getLocalizedMessage(), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.text(4L, (Object)this, "init()", illegalAccessException.getLocalizedMessage());
            if (this.trace.isLogging()) {
                this.trace.exception(262144L, (Object)this, "init()", (Throwable)illegalAccessException);
            }
            throw new AbleException(illegalAccessException.getLocalizedMessage(), (Throwable)illegalAccessException);
        }
        super.init();
    }

    public void process() throws AbleException {
        if (this.population == null || this.population.size() == 0) {
            this.init();
        }
        this.evaluatePopulation();
        Vector vector = this.createNewMembers();
        this.integratePopulation(vector);
        ++this.numPasses;
        this.dataChanged(this);
    }

    public void processTimerEvent() throws AbleException {
        if (this.evolving) {
            this.process();
            if (this.maxFitness >= this.fitnessThreshold) {
                String string = Able.NlsMsg((String)"INF_EVOLUTION_COMPLETE", (Object[])new Object[]{this.name, new Double(this.maxFitness)});
                this.logger.text(1L, (Object)this, "processTimerEvent", string);
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, (Object)this, "processTimerEvent", string);
                }
                this.stopEvolving();
            } else if (this.numPasses >= this.maxNumPasses) {
                String string = Able.NlsMsg((String)"INF_MAX_PASSES_REACHED", (Object[])new Object[]{this.name, new Integer(this.numPasses)});
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, (Object)this, "processTimerEvent()", string);
                }
                this.logger.text(2L, (Object)this, "processTimerEvent()", string);
                this.stopEvolving();
            }
        }
    }

    public void setSourceFileName(String string) {
        this.sourceFileName = string;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setGeneticObjectClassName(String string) {
        this.geneticObjectClassName = string;
    }

    public String getGeneticObjectClassName() {
        return this.geneticObjectClassName;
    }

    public void setPopulationSize(int n) {
        this.populationSize = n;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public Vector getPopulation() {
        if (this.population == null) {
            return null;
        }
        return (Vector)this.population.clone();
    }

    public void setReplacementSize(int n) {
        this.replacementSize = n;
    }

    public int getReplacementSize() {
        return this.replacementSize;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public int getNumPasses() {
        return this.numPasses;
    }

    public void setMaxNumPasses(int n) {
        this.maxNumPasses = n;
    }

    public int getMaxNumPasses() {
        return this.maxNumPasses;
    }

    public void setFitnessThreshold(double d) {
        this.fitnessThreshold = d;
    }

    public double getFitnessThreshold() {
        return this.fitnessThreshold;
    }

    public void setCrossoverRate(double d) {
        this.crossoverRate = d;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public void setMutationRate(double d) {
        this.mutationRate = d;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public double getAvgFitness() {
        return this.avgFitness;
    }

    public double getMinFitness() {
        return this.minFitness;
    }

    public double getMaxFitness() {
        return this.maxFitness;
    }

    public int getChromosomeLength() {
        return this.chromosomeLength;
    }

    public void setAutoEvolve(boolean bl) {
        this.autoEvolve = bl;
    }

    public boolean getAutoEvolve() {
        return this.autoEvolve;
    }

    public void setNoDuplicatesAllowed(boolean bl) {
        this.noDuplicatesAllowed = bl;
    }

    public boolean isNoDuplicatesAllowed() {
        return this.noDuplicatesAllowed;
    }

    public void setUseNormalizedFitness(boolean bl) {
        this.useNormalizedFitness = bl;
    }

    public boolean isUseNormalizedFitness() {
        return this.useNormalizedFitness;
    }

    public void setOperatorFitness(Hashtable hashtable) {
        this.operatorFitness = hashtable;
    }

    public Hashtable getOperatorFitness() {
        return this.operatorFitness;
    }

    public void setMode(int n) {
        if (n == 0) {
            // empty if block
        }
        if (n == 1) {
            // empty if block
        }
    }

    public AbleGeneticObject[] createChildren(Object[] objectArray) {
        AbleGeneticObject ableGeneticObject;
        AbleGeneticObject[] ableGeneticObjectArray = new AbleGeneticObject[objectArray.length];
        ableGeneticObjectArray[0] = ableGeneticObject = this.createChild(objectArray[0]);
        if (objectArray.length == 2) {
            AbleGeneticObject ableGeneticObject2;
            ableGeneticObjectArray[1] = ableGeneticObject2 = this.createChild(objectArray[1]);
        }
        return ableGeneticObjectArray;
    }

    public AbleGeneticObject createChild(Object object) {
        AbleGeneticObject ableGeneticObject;
        block5: {
            ableGeneticObject = null;
            if (this.noDuplicatesAllowed && this.chromosomeList.containsKey(object)) {
                if (this.trace.isLogging()) {
                    this.trace.text(524288L, (Object)this, "createChild", "Found a duplicate: ignored");
                }
                return null;
            }
            try {
                ableGeneticObject = (AbleGeneticObject)this.geneticObjectClass.newInstance();
                ableGeneticObject.setEvaluationAgent(this.evaluationAgent);
                ableGeneticObject.setChromosome(object);
                ableGeneticObject.setCrossoverRate(this.crossoverRate);
                ableGeneticObject.setMutationRate(this.crossoverRate);
            }
            catch (Exception exception) {
                this.logger.text(4L, (Object)this, "createChild", exception.getLocalizedMessage());
                if (!this.trace.isLogging()) break block5;
                this.trace.exception(262144L, (Object)this, "createChild", (Throwable)exception);
            }
        }
        if (this.noDuplicatesAllowed) {
            this.chromosomeList.put(object, ableGeneticObject);
        }
        return ableGeneticObject;
    }

    protected void evaluatePopulation() {
        double d;
        block9: {
            d = 0.0;
            this.totalFitness = 0.0;
            try {
                if (this.evaluationAgent != null) {
                    this.evaluationAgent.process();
                }
            }
            catch (AbleException ableException) {
                this.logger.text(4L, (Object)this, "evaluatePopulation", ableException.getLocalizedMessage());
                if (!this.trace.isLogging()) break block9;
                this.trace.exception(262144L, (Object)this, "evaluatePopulation", (Throwable)ableException);
            }
        }
        int n = this.population.size();
        for (int i = 0; i < n; ++i) {
            d = ((AbleGeneticObject)this.population.elementAt(i)).computeFitness();
            if (i == 0) {
                this.summedFitness[0] = d;
            } else {
                this.summedFitness[i] = d + this.summedFitness[i - 1];
            }
            if (d < this.minFitness) {
                this.minFitness = d;
            }
            if (d > this.maxFitness) {
                this.maxFitness = d;
            }
            this.totalFitness += d;
        }
        this.avgFitness = this.totalFitness / (double)this.populationSize;
        if (this.useNormalizedFitness) {
            this.normalizeFitness();
        }
    }

    protected void normalizeFitness() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 2.0 * this.avgFitness / this.maxFitness;
        int n = 0;
        Enumeration enumeration = this.population.elements();
        while (enumeration.hasMoreElements()) {
            AbleGeneticObject ableGeneticObject = (AbleGeneticObject)enumeration.nextElement();
            d = ableGeneticObject.getFitness();
            d2 = d3 * d;
            ableGeneticObject.setNormalizedFitness(d2);
            if (n == 0) {
                this.summedFitness[0] = d2;
            } else {
                this.summedFitness[n] = d2 + this.summedFitness[n - 1];
            }
            ++n;
        }
    }

    protected Vector createNewMembers() {
        Vector vector;
        block6: {
            vector = new Vector();
            if (this.reproductionTechnique == 0) {
                vector.addElement(this.population.elementAt(0));
            }
            try {
                while (vector.size() < this.replacementSize) {
                    AbleGeneticObject[] ableGeneticObjectArray = this.selectParents();
                    Object[] objectArray = null;
                    Object[] objectArray2 = new Object[]{ableGeneticObjectArray[0].getChromosome(), ableGeneticObjectArray[1].getChromosome()};
                    String string = this.selectOperator();
                    objectArray = (Object[])this.invokeUserDefinedFunction(string, new Object[]{objectArray2});
                    if (objectArray == null) continue;
                    AbleGeneticObject[] ableGeneticObjectArray2 = this.createChildren(objectArray);
                    int n = ableGeneticObjectArray2.length;
                    if (n >= 1 && ableGeneticObjectArray2[0] != null) {
                        this.insertIntoPopulation(ableGeneticObjectArray2[0], vector);
                    }
                    if (n < 2 || ableGeneticObjectArray2[1] == null) continue;
                    this.insertIntoPopulation(ableGeneticObjectArray2[1], vector);
                }
            }
            catch (Exception exception) {
                this.logger.text(4L, (Object)this, "createNewMembers", exception.getLocalizedMessage());
                if (!this.trace.isLogging()) break block6;
                this.trace.exception(262144L, (Object)this, "createNewMembers", (Throwable)exception);
            }
        }
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, "Created " + vector.size() + " new members.");
        }
        return vector;
    }

    protected void integratePopulation(Vector vector) throws AbleException {
        boolean bl = this.trace.isLogging();
        if (this.reproductionTechnique == 0) {
            this.population = vector;
        } else {
            if (bl) {
                this.trace.text(0x100000L, "Integrating " + vector.size() + " members.");
                this.trace.text(0x100000L, "Population has " + this.population.size() + " members.");
            }
            this.removeLastNFromPopulation(this.replacementSize);
            if (bl) {
                this.trace.text(0x100000L, "Population now " + this.population.size() + " members.");
            }
            for (int i = 0; i < this.replacementSize; ++i) {
                AbleGeneticObject ableGeneticObject = (AbleGeneticObject)vector.elementAt(i);
                this.insertIntoPopulation(ableGeneticObject, this.population);
            }
            if (bl) {
                this.trace.text(0x100000L, "Final Population " + this.population.size() + " members.");
            }
        }
    }

    protected void insertIntoPopulation(AbleGeneticObject ableGeneticObject, Vector vector) {
        block6: {
            try {
                boolean bl = false;
                int n = vector.size();
                double d = ableGeneticObject.getFitness();
                if (n == 0) {
                    vector.addElement(ableGeneticObject);
                } else {
                    for (int i = 0; i < n; ++i) {
                        AbleGeneticObject ableGeneticObject2 = (AbleGeneticObject)vector.elementAt(i);
                        if (!(d > ableGeneticObject2.getFitness())) continue;
                        vector.insertElementAt(ableGeneticObject, i);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        vector.addElement(ableGeneticObject);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.text(4L, (Object)this, "insertIntoPopulation", exception.getLocalizedMessage());
                if (!this.trace.isLogging()) break block6;
                this.trace.exception(262144L, (Object)this, "insertIntoPopulation", (Throwable)exception);
            }
        }
    }

    protected void removeLastNFromPopulation(int n) throws AbleException {
        int n2 = this.population.size();
        int n3 = n2 - n;
        Iterator iterator = this.population.iterator();
        for (int i = 0; iterator.hasNext() && i < n3; ++i) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            AbleGeneticObject ableGeneticObject = (AbleGeneticObject)iterator.next();
            iterator.remove();
            ableGeneticObject.removeBean();
            if (!this.noDuplicatesAllowed || !this.chromosomeList.containsKey(ableGeneticObject.getChromosome())) continue;
            this.chromosomeList.remove(ableGeneticObject.getChromosome());
        }
    }

    public AbleGeneticObject[] selectParents() {
        AbleGeneticObject[] ableGeneticObjectArray = new AbleGeneticObject[]{this.rouletteWheelSelection(), this.rouletteWheelSelection()};
        return ableGeneticObjectArray;
    }

    public String selectOperator() {
        double d = Math.random() * 100.0;
        Enumeration enumeration = this.operatorFitness.keys();
        double d2 = 0.0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Double d3 = (Double)this.operatorFitness.get(string);
            double d4 = d3;
            if (!((d2 += d4) >= d)) continue;
            return string;
        }
        return null;
    }

    public AbleGeneticObject rouletteWheelSelection() {
        double d = 0.0;
        d = this.useNormalizedFitness ? Math.random() * this.totalNormalizedFitness : Math.random() * this.totalFitness;
        for (int i = 0; i < this.summedFitness.length; ++i) {
            if (!(this.summedFitness[i] >= d)) continue;
            AbleGeneticObject ableGeneticObject = (AbleGeneticObject)this.population.elementAt(i);
            return ableGeneticObject;
        }
        return null;
    }

    public boolean isEvolving() throws AbleException {
        return this.evolving;
    }

    public void evolve() {
        if (this.evolving) {
            this.evolving = false;
            if (this.trace.isLogging()) {
                this.trace.text(0x100000L, (Object)this, "evolve", "Genetic search was halted");
            }
            return;
        }
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "evolve", "Starting genetic search " + this.name);
        }
        this.evolving = true;
    }

    public void startEvolving() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "startEvolving", "Evolution started " + this.name);
        }
        this.setTimerEventProcessingEnabled(true);
        this.startEnabledEventProcessing();
        boolean bl = this.evolving;
        this.evolving = true;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.evolving));
    }

    public void stopEvolving() throws AbleException {
        if (this.trace.isLogging()) {
            this.trace.text(0x100000L, (Object)this, "stopEvolving", "Evolution was stopped " + this.name);
        }
        this.setTimerEventProcessingEnabled(false);
        boolean bl = this.evolving;
        this.evolving = false;
        this.firePropertyChange("training", new Boolean(bl), new Boolean(this.evolving));
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = new Hashtable();
        Set set = this.operatorFitness.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.endsWith("/1")) {
                hashtable = this.operatorFitness;
                break;
            }
            hashtable.put(string.substring(0, string.length() - 2), this.operatorFitness.get(string));
        }
        this.operatorFitness = hashtable;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

