/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral.able;

import com.ibm.bilateral.Buyer;
import com.ibm.bilateral.BuyerStrategy;
import com.ibm.bilateral.ClArgs;
import com.ibm.bilateral.InitParams;
import com.ibm.bilateral.InitParamsImp;
import com.ibm.bilateral.Seller;
import com.ibm.bilateral.SellerStrategy;
import com.ibm.bilateral.TradingPartnerImp;
import com.ibm.bilateral.Utility;
import java.io.IOException;
import java.io.Serializable;

public class ControlFile
implements Serializable {
    private static final int INIT_CASH = 1000000;
    private static final int INIT_QUANT = 10000;
    private int n_buyers;
    private int n_sellers;
    private InitParamsImp[] bparams;
    private InitParamsImp[] sparams;

    public int numBuyers() {
        return this.n_buyers;
    }

    public int numSellers() {
        return this.n_sellers;
    }

    public InitParams getBuyerParam(int n) {
        return this.bparams[n];
    }

    public InitParams getSellerParam(int n) {
        return this.sparams[n];
    }

    public Seller[] createSellers(int n, int n2, ClArgs clArgs) throws IOException {
        Seller[] sellerArray = new Seller[n];
        int n3 = 0;
        while (n3 < n) {
            InitParams initParams = this.getSellerParam(n3);
            Utility utility = initParams.getSellerUtility();
            SellerStrategy sellerStrategy = initParams.getSellerStrategy(clArgs);
            sellerArray[n3] = new Seller(clArgs, new TradingPartnerImp(n2 + n3), sellerStrategy, utility, 10000);
            ++n3;
        }
        return sellerArray;
    }

    public Buyer[] createBuyers(int n, int n2, ClArgs clArgs) throws IOException {
        Buyer[] buyerArray = new Buyer[n];
        int n3 = 0;
        while (n3 < n) {
            InitParams initParams = this.getBuyerParam(n3);
            Utility utility = initParams.getBuyerUtility();
            BuyerStrategy buyerStrategy = initParams.getBuyerStrategy(clArgs);
            buyerArray[n3] = new Buyer(clArgs, new TradingPartnerImp(n2 + n3), buyerStrategy, utility, 1000000);
            ++n3;
        }
        return buyerArray;
    }

    public void initSellers(int n, int n2, String string, int n3, int n4, String string2) {
        this.sparams = new InitParamsImp[n];
        int n5 = 0;
        while (n5 < n) {
            try {
                this.sparams[n5] = new InitParamsImp(n2, string, n3, n4, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n5;
        }
    }

    public void initBuyers(int n, int n2, String string, int n3, int n4, String string2) {
        this.bparams = new InitParamsImp[n];
        int n5 = 0;
        while (n5 < n) {
            try {
                this.bparams[n5] = new InitParamsImp(n2, string, n3, n4, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n5;
        }
    }
}

