/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.ClArgs;
import com.ibm.bilateral.NegotiationState;
import com.ibm.bilateral.OfferIV;
import com.ibm.bilateral.OfferSet;
import com.ibm.bilateral.RandomBN;
import com.ibm.bilateral.ScaledAttributes;
import com.ibm.bilateral.SellerStrategy;
import com.ibm.bilateral.SessionHistory;
import com.ibm.bilateral.Utility;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class ZiSellerStrategy
implements SellerStrategy,
Serializable {
    private final boolean OPTIMIZE_SPEED = true;
    protected final ZI_Seller_SParams zis_params;
    protected int max_offers;
    protected int max_rounds;
    protected final ScaledAttributes[] scaled_attributes;

    protected ZiSellerStrategy(ScaledAttributes[] scaledAttributesArray) {
        this.scaled_attributes = scaledAttributesArray;
        this.zis_params = new ZI_Seller_SParams();
    }

    public ZiSellerStrategy(ScaledAttributes[] scaledAttributesArray, String string, ClArgs clArgs) throws IOException {
        this(scaledAttributesArray);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        if (this.getNonCommentLine(bufferedReader) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            this.max_offers = Integer.parseInt(stringTokenizer.nextToken());
            this.max_rounds = Integer.parseInt(stringTokenizer.nextToken());
            this.zis_params.max_tries = Integer.parseInt(stringTokenizer.nextToken());
            this.zis_params.offer_revision_radius = Float.parseFloat(stringTokenizer.nextToken());
        }
        if (clArgs.isVerbose()) {
            System.out.print(" params: mt ");
            System.out.print(this.zis_params.max_tries);
            System.out.print(" orr ");
            System.out.print(this.zis_params.offer_revision_radius);
            System.out.print(" ");
        }
        bufferedReader.close();
        if (this.max_rounds > clArgs.numRounds()) {
            this.max_rounds = clArgs.numRounds();
        }
        if (this.max_offers > clArgs.numOffersPerRound()) {
            this.max_offers = clArgs.numOffersPerRound();
        }
        if (clArgs.isVerbose()) {
            System.out.print("max_rounds ");
            System.out.print(this.max_rounds);
            System.out.print(" max_offers ");
            System.out.println(this.max_offers);
        }
    }

    public void initNegotiation() {
    }

    public OfferSet makeOffer(NegotiationState negotiationState, Utility utility) {
        OfferSet offerSet;
        block13: {
            int[] nArray;
            int[] nArray2;
            int n;
            int n2;
            boolean bl;
            block12: {
                if (negotiationState.current_round >= this.maxRounds()) {
                    negotiationState.quit = true;
                    return OfferSet.createQuitNoOffers();
                }
                bl = true;
                n2 = 0;
                n = 0;
                nArray2 = new int[2];
                offerSet = new OfferSet(this.max_offers);
                int n3 = 0;
                while (n3 < nArray2.length) {
                    nArray2[n3] = (int)(this.scaled_attributes[n3].norm * this.zis_params.offer_revision_radius);
                    ++n3;
                }
                nArray = new int[2];
                if (negotiationState.nAO != 0) break block12;
                while (bl) {
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        nArray[n4] = (int)(this.scaled_attributes[n4].min + this.scaled_attributes[n4].norm * RandomBN.uni());
                        ++n4;
                    }
                    OfferIV offerIV = new OfferIV(nArray);
                    double d = utility.computeUtility(offerIV);
                    if (d <= 0.0) {
                        ++n;
                    } else {
                        offerSet.addOffer(offerIV);
                        ++n2;
                        n = 0;
                    }
                    if (n < this.zis_params.max_tries && n2 < this.max_offers) continue;
                    bl = false;
                }
                break block13;
            }
            if (negotiationState.nAO <= 0) break block13;
            double d = negotiationState.currentAOvalue;
            while (bl) {
                OfferIV offerIV = (OfferIV)negotiationState.currentAO;
                offerIV.getAllAttributes(nArray);
                int n5 = 0;
                while (n5 < nArray.length) {
                    int n6 = n5;
                    nArray[n6] = (int)((double)nArray[n6] + (double)nArray2[n5] * (2.0 * RandomBN.uni() - 1.0));
                    if ((double)nArray[n5] < this.scaled_attributes[n5].min) {
                        nArray[n5] = (int)this.scaled_attributes[n5].min;
                    }
                    if ((double)nArray[n5] > this.scaled_attributes[n5].max) {
                        nArray[n5] = (int)this.scaled_attributes[n5].max;
                    }
                    ++n5;
                }
                OfferIV offerIV2 = new OfferIV(nArray);
                double d2 = utility.computeUtility(offerIV2);
                if (d2 <= d) {
                    ++n;
                } else {
                    offerSet.addOffer(offerIV2);
                    ++n2;
                    n = 0;
                }
                if (n < this.zis_params.max_tries && n2 < this.max_offers) continue;
                bl = false;
            }
        }
        return offerSet;
    }

    public int maxRounds() {
        return this.max_rounds;
    }

    public int maxOffers() {
        return this.max_offers;
    }

    public SessionHistory createHistory() {
        return new SessionHistory(this.maxRounds());
    }

    private int getNonCommentLine(BufferedReader bufferedReader) throws IOException {
        while (true) {
            int n = 32;
            while (Character.isWhitespace((char)n)) {
                bufferedReader.mark(1);
                n = bufferedReader.read();
                if (n != -1) continue;
                return -1;
            }
            if (n != 35) break;
            bufferedReader.readLine();
        }
        bufferedReader.reset();
        return 0;
    }

    static class ZI_Seller_SParams
    implements Serializable {
        double offer_revision_radius;
        int max_tries;

        ZI_Seller_SParams() {
        }
    }
}

