/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.BuyerCesUtility;
import com.ibm.bilateral.CesUtility;
import com.ibm.bilateral.ScaledAttributes;
import com.ibm.bilateral.SellerCesUtility;
import com.ibm.bilateral.Utility;
import java.io.IOException;
import java.io.Serializable;

public class UtilityParams
implements Serializable {
    public static final int UTILITY_TYPE_CES = 0;
    public static final int UTILITY_PARAMS_TYPE_RANDOM = 0;
    public static final int UTILITY_PARAMS_TYPE_FIXED = 1;
    private final int utility_type;
    public final ScaledAttributes[] scaled_attributes = new ScaledAttributes[2];
    private CesUtility ces;

    public UtilityParams(int n, int n2, String string) throws IOException {
        int n3 = 0;
        while (n3 < this.scaled_attributes.length) {
            this.scaled_attributes[n3] = new ScaledAttributes();
            ++n3;
        }
        this.utility_type = n;
        if (this.utility_type == 0) {
            boolean bl = string.equalsIgnoreCase("NULL");
            if (n2 == 0) {
                this.ces = bl ? CesUtility.createRandom(2) : CesUtility.createFromFileRandom(string, 2);
            } else if (n2 == 1) {
                this.ces = bl ? CesUtility.createFixed(2) : CesUtility.createFromFileFixed(string, 2);
            }
        }
    }

    public Utility getBuyerUtility() {
        if (this.utility_type == 0) {
            return new BuyerCesUtility(this.ces, this.scaled_attributes);
        }
        throw new IllegalStateException("Unknown utility type: " + this.utility_type);
    }

    public Utility getSellerUtility() {
        if (this.utility_type == 0) {
            return new SellerCesUtility(this.ces, this.scaled_attributes);
        }
        throw new IllegalStateException("Unknown utility type: " + this.utility_type);
    }
}

