/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bilateral;

import com.ibm.bilateral.NegotiationState;
import com.ibm.bilateral.Offer;
import com.ibm.bilateral.OfferSet;
import com.ibm.bilateral.Response;
import com.ibm.bilateral.Round;
import com.ibm.bilateral.TradingPartner;
import java.io.Serializable;

public class Session
implements Serializable {
    private TradingPartner partnerID = null;
    private int n_rounds = 0;
    private final Round[] round;
    private int nAO;
    private Offer finalAO;
    private Offer initAO;
    private double initAOvalue;
    private double finalAOvalue;

    public Session(int n) {
        this.round = new Round[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            this.round[n2] = new Round();
            ++n2;
        }
        this.nAO = 0;
    }

    void UpdateSessionHistory(int n, OfferSet offerSet, Response response) {
        if (n >= this.round.length) {
            throw new IllegalArgumentException("Illegal round: " + n);
        }
        this.round[n].UpdateSessionHistory(offerSet, response);
    }

    public void sessionInit(TradingPartner tradingPartner) {
        this.n_rounds = 0;
        this.nAO = 0;
        int n = 0;
        while (n < this.round.length) {
            if (this.round[n] != null) {
                this.round[n].freeOffers();
            }
            ++n;
        }
    }

    public void sessionUpdate(NegotiationState negotiationState) {
        this.n_rounds = negotiationState.current_round + 1;
        this.nAO = negotiationState.nAO;
        this.initAO = negotiationState.initAO;
        this.initAOvalue = negotiationState.initAOvalue;
        this.finalAO = negotiationState.currentAO;
    }

    public void finalUpdate(double d) {
        this.finalAOvalue = d;
    }
}

